/*
 * Decompiled with CFR 0.152.
 */
package jd.captcha.specials;

import java.util.Collections;
import java.util.Vector;
import jd.captcha.pixelgrid.Captcha;
import jd.captcha.pixelgrid.Letter;
import jd.captcha.pixelgrid.PixelGrid;
import jd.captcha.pixelobject.PixelObject;
import jd.captcha.specials.EasyCaptcha;
import jd.nutils.Colors;

public class HstjNt {
    static void clearlines(Captcha captcha) {
        int[][] grid = PixelGrid.getGridCopy(captcha.grid);
        for (int x = 1; x < captcha.getWidth() - 1; ++x) {
            for (int y = 1; y < captcha.getHeight() - 1; ++y) {
                if (captcha.grid[x][y] != 0) continue;
                int w = captcha.grid[x + 1][y] == 0 ? 1 : 0;
                w += captcha.grid[x + 1][y + 1] == 0 ? 1 : 0;
                w += captcha.grid[x][y + 1] == 0 ? 1 : 0;
                w += captcha.grid[x - 1][y + 1] == 0 ? 1 : 0;
                w += captcha.grid[x - 1][y - 1] == 0 ? 1 : 0;
                w += captcha.grid[x + 1][y - 1] == 0 ? 1 : 0;
                w += captcha.grid[x - 1][y] == 0 ? 1 : 0;
                if ((w += captcha.grid[x][y - 1] == 0 ? 1 : 0) < 2) {
                    grid[x][y] = 0xFFFFFF;
                    continue;
                }
                if (w >= 3 || captcha.grid[x + 1][y] != 0 || captcha.grid[x - 1][y] != 0) continue;
                grid[x][y] = 0xFFFFFF;
            }
        }
        captcha.grid = grid;
    }

    static void toBlack(Captcha captcha) {
        try {
            int color = captcha.getAverage();
            for (int x = 0; x < captcha.getWidth(); ++x) {
                for (int y = 0; y < captcha.getHeight(); ++y) {
                    captcha.grid[x][y] = Colors.getRGBColorDifference2((int)captcha.grid[x][y], (int)color) > 25.0 ? 0 : 0xFFFFFF;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void blurIt(Captcha captcha, int factor) {
        int[][] grid = PixelGrid.getGridCopy(captcha.grid);
        for (int x = 0; x < captcha.getWidth(); ++x) {
            for (int y = 0; y < captcha.getHeight(); ++y) {
                if (captcha.grid[x][y] != 0) continue;
                for (int i = 0; i < factor && x + i < captcha.getWidth(); ++i) {
                    for (int j = 0; j < factor && y + j < captcha.getHeight(); ++j) {
                        grid[x + i][y + j] = 0;
                        if (x - i < 0 || y - j < 0) continue;
                        grid[x - i][y - j] = 0;
                    }
                }
            }
        }
        captcha.grid = grid;
    }

    public static Letter[] getLetters(Captcha captcha) throws InterruptedException {
        HstjNt.toBlack(captcha);
        captcha.crop(2, 2, 2, 2);
        HstjNt.clearlines(captcha);
        captcha.removeSmallObjects(0.7, 0.7, 95);
        HstjNt.blurIt(captcha, 3);
        Vector<PixelObject> os = captcha.getObjects(0.5, 0.5);
        Collections.sort(os);
        Letter[] lets = new Letter[os.size()];
        if (os.size() == 4) {
            for (int i = 0; i < lets.length; ++i) {
                lets[i] = os.get(i).toLetter();
                lets[i].resizetoHeight(35);
            }
        } else {
            for (Letter letter : lets = EasyCaptcha.getLetters(captcha)) {
                letter.resizetoHeight(35);
            }
        }
        return lets;
    }
}

