/*
 * Decompiled with CFR 0.152.
 */
package jd.captcha.specials;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import jd.captcha.easy.BackGroundImageManager;
import jd.captcha.pixelgrid.Captcha;
import jd.captcha.pixelgrid.Letter;
import jd.captcha.pixelgrid.PixelGrid;
import jd.captcha.pixelobject.PixelObject;
import jd.captcha.specials.EasyCaptcha;
import jd.nutils.Colors;

public class PpscnRg {
    static void clearlines(Captcha captcha) {
        for (int x = 0; x < captcha.getWidth(); ++x) {
            for (int y = 0; y < captcha.getHeight(); ++y) {
                if (Colors.rgb2hsv((int)captcha.grid[x][y])[2] <= 40) continue;
                captcha.grid[x][y] = 0xFFFFFF;
            }
        }
        int[][] grid = PixelGrid.getGridCopy(captcha.grid);
        for (int x = 1; x < captcha.getWidth() - 1; ++x) {
            for (int y = 1; y < captcha.getHeight() - 1; ++y) {
                if (captcha.grid[x][y] == 0xFFFFFF || Colors.rgb2hsv((int)captcha.grid[x][y])[2] <= 38) continue;
                int c = captcha.grid[x][y];
                int w = captcha.grid[x + 1][y] == c ? 1 : 0;
                w += captcha.grid[x + 1][y + 1] == c ? 2 : 0;
                w += captcha.grid[x][y + 1] == c ? 2 : 0;
                w += captcha.grid[x - 1][y + 1] == c ? 2 : 0;
                w += captcha.grid[x - 1][y - 1] == c ? 2 : 0;
                w += captcha.grid[x + 1][y - 1] == c ? 2 : 0;
                w += captcha.grid[x - 1][y] == c ? 1 : 0;
                if ((w += captcha.grid[x][y - 1] == c ? 2 : 0) >= 6) continue;
                grid[x][y] = 0xFFFFFF;
            }
        }
        captcha.grid = grid;
    }

    static void clearlines2(Captcha captcha) {
        int[][] grid = PixelGrid.getGridCopy(captcha.grid);
        for (int x = 1; x < captcha.getWidth() - 1; ++x) {
            for (int y = 1; y < captcha.getHeight() - 1; ++y) {
                if (captcha.grid[x][y] == 0xFFFFFF) continue;
                int w = captcha.grid[x + 1][y] != 0xFFFFFF ? 1 : 0;
                w += captcha.grid[x + 1][y + 1] != 0xFFFFFF ? 2 : 0;
                w += captcha.grid[x][y + 1] != 0xFFFFFF ? 2 : 0;
                w += captcha.grid[x - 1][y + 1] != 0xFFFFFF ? 2 : 0;
                w += captcha.grid[x - 1][y - 1] != 0xFFFFFF ? 2 : 0;
                w += captcha.grid[x + 1][y - 1] != 0xFFFFFF ? 2 : 0;
                w += captcha.grid[x - 1][y] != 0xFFFFFF ? 1 : 0;
                if ((w += captcha.grid[x][y - 1] != 0xFFFFFF ? 2 : 0) >= 2) continue;
                grid[x][y] = 0xFFFFFF;
            }
        }
        captcha.grid = grid;
    }

    private static void toBlack(PixelGrid captcha) {
        for (int x = 1; x < captcha.getWidth() - 1; ++x) {
            for (int y = 1; y < captcha.getHeight() - 1; ++y) {
                if (captcha.grid[x][y] == 0xFFFFFF) continue;
                captcha.grid[x][y] = 0;
            }
        }
    }

    public static List<PixelObject> getObjects(PixelGrid grid, int neighbourradius) {
        ArrayList<PixelObject> ret = new ArrayList<PixelObject>();
        for (int x = 0; x < grid.getWidth(); ++x) {
            for (int y = 0; y < grid.getHeight(); ++y) {
                int c = grid.grid[x][y];
                if (c == 0xFFFFFF) continue;
                PixelObject n = new PixelObject(grid);
                n.add(x, y, c);
                ArrayList<PixelObject> merge = new ArrayList<PixelObject>();
                for (PixelObject o : ret) {
                    if (c != o.getMostcolor() || !o.isTouching(x, y, true, neighbourradius, neighbourradius)) continue;
                    merge.add(o);
                }
                if (merge.size() == 0) {
                    ret.add(n);
                    continue;
                }
                if (merge.size() == 1) {
                    ((PixelObject)merge.get(0)).add(n);
                    continue;
                }
                for (PixelObject po : merge) {
                    ret.remove(po);
                    n.add(po);
                }
                ret.add(n);
            }
        }
        return ret;
    }

    private static void merge(List<PixelObject> os) {
        if (os.size() == 4) {
            return;
        }
        PixelObject aos = null;
        Iterator<PixelObject> iterator = os.iterator();
        while (iterator.hasNext()) {
            PixelObject pixelObject = iterator.next();
            if (pixelObject.getSize() >= 2) continue;
            iterator.remove();
        }
        int mergeos = Integer.MAX_VALUE;
        for (PixelObject pixelObject : os) {
            int mg = pixelObject.getSize();
            if (mergeos <= mg) continue;
            mergeos = mg;
            aos = pixelObject;
        }
        EasyCaptcha.mergeos(aos, os);
        PpscnRg.merge(os);
    }

    public static Letter[] getLetters(Captcha captcha) throws InterruptedException {
        BackGroundImageManager bgit = new BackGroundImageManager(captcha);
        bgit.setBackGroundImageListFileName("bgimages2.xml");
        bgit.clearCaptchaAll();
        PpscnRg.clearlines(captcha);
        captcha.crop(0, 2, 0, 20);
        List<PixelObject> os = PpscnRg.getObjects(captcha, 2);
        PpscnRg.merge(os);
        Collections.sort(os);
        Letter[] letters = new Letter[os.size()];
        for (int i = 0; i < letters.length; ++i) {
            letters[i] = os.get(i).toLetter();
            PpscnRg.toBlack(letters[i]);
            letters[i].autoAlign();
            letters[i].resizetoHeight(25);
        }
        return letters;
    }
}

