/*
 * Decompiled with CFR 0.152.
 */
package net.sf.image4j.codec.ico;

import java.awt.image.BufferedImage;
import java.awt.image.IndexColorModel;
import java.awt.image.WritableRaster;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriter;
import javax.imageio.stream.ImageOutputStream;
import net.sf.image4j.codec.bmp.BMPEncoder;
import net.sf.image4j.codec.bmp.InfoHeader;
import net.sf.image4j.codec.ico.IconEntry;
import net.sf.image4j.io.LittleEndianOutputStream;
import net.sf.image4j.util.ConvertUtil;

public class ICOEncoder {
    private ICOEncoder() {
    }

    public static void write(BufferedImage bufferedImage, File file) throws IOException {
        ICOEncoder.write(bufferedImage, -1, file);
    }

    public static void write(BufferedImage bufferedImage, OutputStream outputStream) throws IOException {
        ICOEncoder.write(bufferedImage, -1, outputStream);
    }

    public static void write(List<BufferedImage> list, OutputStream outputStream) throws IOException {
        ICOEncoder.write(list, null, null, outputStream);
    }

    public static void write(List<BufferedImage> list, File file) throws IOException {
        ICOEncoder.write(list, null, file);
    }

    public static void write(List<BufferedImage> list, int[] nArray, File file) throws IOException {
        ICOEncoder.write(list, nArray, (OutputStream)new FileOutputStream(file));
    }

    public static void write(List<BufferedImage> list, int[] nArray, boolean[] blArray, File file) throws IOException {
        ICOEncoder.write(list, nArray, blArray, new FileOutputStream(file));
    }

    public static void write(BufferedImage bufferedImage, int n, File file) throws IOException {
        ICOEncoder.write(bufferedImage, n, (OutputStream)new FileOutputStream(file));
    }

    public static void write(BufferedImage bufferedImage, int n, OutputStream outputStream) throws IOException {
        ArrayList<BufferedImage> arrayList = new ArrayList<BufferedImage>(1);
        arrayList.add(bufferedImage);
        ICOEncoder.write(arrayList, new int[]{n}, new boolean[]{false}, outputStream);
    }

    public static void write(List<BufferedImage> list, int[] nArray, OutputStream outputStream) throws IOException {
        ICOEncoder.write(list, nArray, null, outputStream);
    }

    public static void write(List<BufferedImage> list, int[] nArray, boolean[] blArray, OutputStream outputStream) throws IOException {
        Object object;
        Object object2;
        BufferedImage bufferedImage;
        int n;
        LittleEndianOutputStream littleEndianOutputStream = new LittleEndianOutputStream(outputStream);
        int n2 = list.size();
        ICOEncoder.writeFileHeader(n2, 1, littleEndianOutputStream);
        int n3 = 6 + n2 * 16;
        ArrayList<Object> arrayList = new ArrayList<Object>(n2);
        ArrayList<BufferedImage> arrayList2 = new ArrayList<BufferedImage>(n2);
        ArrayList<byte[]> arrayList3 = null;
        if (blArray != null) {
            arrayList3 = new ArrayList<byte[]>(n2);
        }
        ImageWriter imageWriter = null;
        for (n = 0; n < n2; ++n) {
            bufferedImage = list.get(n);
            int n4 = nArray == null ? -1 : nArray[n];
            object2 = n4 == -1 ? bufferedImage : ICOEncoder.convert(bufferedImage, n4);
            arrayList2.add((BufferedImage)object2);
            object = BMPEncoder.createInfoHeader((BufferedImage)object2);
            IconEntry iconEntry = ICOEncoder.createIconEntry((InfoHeader)object);
            if (blArray != null) {
                if (blArray[n]) {
                    if (imageWriter == null) {
                        imageWriter = ICOEncoder.getPNGImageWriter();
                    }
                    byte[] byArray = ICOEncoder.encodePNG(imageWriter, (BufferedImage)object2);
                    arrayList3.add(byArray);
                    iconEntry.iSizeInBytes = byArray.length;
                } else {
                    arrayList3.add(null);
                }
            }
            ((InfoHeader)object).iHeight *= 2;
            iconEntry.iFileOffset = n3;
            n3 += iconEntry.iSizeInBytes;
            iconEntry.write(littleEndianOutputStream);
            arrayList.add(object);
        }
        for (n = 0; n < n2; ++n) {
            bufferedImage = list.get(n);
            BufferedImage bufferedImage2 = (BufferedImage)arrayList2.get(n);
            if (blArray == null || !blArray[n]) {
                object2 = (InfoHeader)arrayList.get(n);
                ((InfoHeader)object2).write(littleEndianOutputStream);
                if (((InfoHeader)object2).sBitCount <= 8) {
                    object = (IndexColorModel)bufferedImage2.getColorModel();
                    BMPEncoder.writeColorMap((IndexColorModel)object, littleEndianOutputStream);
                }
                ICOEncoder.writeXorBitmap(bufferedImage2, (InfoHeader)object2, littleEndianOutputStream);
                ICOEncoder.writeAndBitmap(bufferedImage, littleEndianOutputStream);
                continue;
            }
            object2 = (byte[])arrayList3.get(n);
            littleEndianOutputStream.write((byte[])object2);
        }
    }

    public static void writeFileHeader(int n, int n2, LittleEndianOutputStream littleEndianOutputStream) throws IOException {
        littleEndianOutputStream.writeShortLE((short)0);
        littleEndianOutputStream.writeShortLE((short)n2);
        littleEndianOutputStream.writeShortLE((short)n);
    }

    public static IconEntry createIconEntry(InfoHeader infoHeader) {
        int n;
        IconEntry iconEntry = new IconEntry();
        iconEntry.bWidth = infoHeader.iWidth == 256 ? 0 : infoHeader.iWidth;
        iconEntry.bHeight = infoHeader.iHeight == 256 ? 0 : infoHeader.iHeight;
        iconEntry.bColorCount = infoHeader.iNumColors >= 256 ? 0 : infoHeader.iNumColors;
        iconEntry.bReserved = 0;
        iconEntry.sPlanes = 1;
        iconEntry.sBitCount = infoHeader.sBitCount;
        int n2 = BMPEncoder.getColorMapSize(infoHeader.sBitCount);
        int n3 = BMPEncoder.getBitmapSize(infoHeader.iWidth, infoHeader.iHeight, infoHeader.sBitCount);
        int n4 = BMPEncoder.getBitmapSize(infoHeader.iWidth, infoHeader.iHeight, 1);
        iconEntry.iSizeInBytes = n = infoHeader.iSize + n2 + n3 + n4;
        iconEntry.iFileOffset = 0;
        return iconEntry;
    }

    public static void writeAndBitmap(BufferedImage bufferedImage, LittleEndianOutputStream littleEndianOutputStream) throws IOException {
        WritableRaster writableRaster = bufferedImage.getAlphaRaster();
        if (bufferedImage.getColorModel() instanceof IndexColorModel && bufferedImage.getColorModel().hasAlpha()) {
            int n = bufferedImage.getWidth();
            int n2 = bufferedImage.getHeight();
            int n3 = BMPEncoder.getBytesPerLine1(n);
            byte[] byArray = new byte[n3];
            IndexColorModel indexColorModel = (IndexColorModel)bufferedImage.getColorModel();
            WritableRaster writableRaster2 = bufferedImage.getRaster();
            for (int i = n2 - 1; i >= 0; --i) {
                for (int j = 0; j < n; ++j) {
                    int n4 = j / 8;
                    int n5 = j % 8;
                    int n6 = writableRaster2.getSample(j, i, 0);
                    int n7 = indexColorModel.getAlpha(n6);
                    int n8 = ~n7 & 1;
                    byArray[n4] = ICOEncoder.setBit(byArray[n4], n5, n8);
                }
                littleEndianOutputStream.write(byArray);
            }
        } else if (writableRaster == null) {
            int n;
            int n9 = bufferedImage.getHeight();
            int n10 = bufferedImage.getWidth();
            int n11 = BMPEncoder.getBytesPerLine1(n10);
            byte[] byArray = new byte[n11];
            for (n = 0; n < n11; ++n) {
                byArray[n] = 0;
            }
            for (n = n9 - 1; n >= 0; --n) {
                littleEndianOutputStream.write(byArray);
            }
        } else {
            int n = bufferedImage.getWidth();
            int n12 = bufferedImage.getHeight();
            int n13 = BMPEncoder.getBytesPerLine1(n);
            byte[] byArray = new byte[n13];
            for (int i = n12 - 1; i >= 0; --i) {
                for (int j = 0; j < n; ++j) {
                    int n14 = j / 8;
                    int n15 = j % 8;
                    int n16 = writableRaster.getSample(j, i, 0);
                    int n17 = ~n16 & 1;
                    byArray[n14] = ICOEncoder.setBit(byArray[n14], n15, n17);
                }
                littleEndianOutputStream.write(byArray);
            }
        }
    }

    private static byte setBit(byte by, int n, int n2) {
        int n3 = 1 << 7 - n;
        by = (byte)(by & ~n3);
        by = (byte)(by | n2 << 7 - n);
        return by;
    }

    private static void writeXorBitmap(BufferedImage bufferedImage, InfoHeader infoHeader, LittleEndianOutputStream littleEndianOutputStream) throws IOException {
        WritableRaster writableRaster = bufferedImage.getRaster();
        switch (infoHeader.sBitCount) {
            case 1: {
                BMPEncoder.write1(writableRaster, littleEndianOutputStream);
                break;
            }
            case 4: {
                BMPEncoder.write4(writableRaster, littleEndianOutputStream);
                break;
            }
            case 8: {
                BMPEncoder.write8(writableRaster, littleEndianOutputStream);
                break;
            }
            case 24: {
                BMPEncoder.write24(writableRaster, littleEndianOutputStream);
                break;
            }
            case 32: {
                WritableRaster writableRaster2 = bufferedImage.getAlphaRaster();
                BMPEncoder.write32(writableRaster, writableRaster2, littleEndianOutputStream);
            }
        }
    }

    public static BufferedImage convert(BufferedImage bufferedImage, int n) {
        BufferedImage bufferedImage2 = null;
        switch (n) {
            case 1: {
                bufferedImage2 = ConvertUtil.convert1(bufferedImage);
                break;
            }
            case 4: {
                bufferedImage2 = ConvertUtil.convert4(bufferedImage);
                break;
            }
            case 8: {
                bufferedImage2 = ConvertUtil.convert8(bufferedImage);
                break;
            }
            case 24: {
                int n2 = bufferedImage.getColorModel().getPixelSize();
                if (n2 == 24 || n2 == 32) {
                    bufferedImage2 = bufferedImage;
                    break;
                }
                bufferedImage2 = ConvertUtil.convert24(bufferedImage);
                break;
            }
            case 32: {
                int n3 = bufferedImage.getColorModel().getPixelSize();
                bufferedImage2 = n3 == 24 || n3 == 32 ? bufferedImage : ConvertUtil.convert32(bufferedImage);
            }
        }
        return bufferedImage2;
    }

    private static ImageWriter getPNGImageWriter() {
        ImageWriter imageWriter = null;
        Iterator<ImageWriter> iterator = ImageIO.getImageWritersByFormatName("png");
        if (iterator.hasNext()) {
            imageWriter = iterator.next();
        }
        return imageWriter;
    }

    private static byte[] encodePNG(ImageWriter imageWriter, BufferedImage bufferedImage) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ImageOutputStream imageOutputStream = ImageIO.createImageOutputStream(byteArrayOutputStream);
        imageWriter.setOutput(imageOutputStream);
        imageWriter.write(bufferedImage);
        byteArrayOutputStream.flush();
        byte[] byArray = byteArrayOutputStream.toByteArray();
        return byArray;
    }
}

