/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jsse.provider;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;
import org.bouncycastle.jsse.BCX509ExtendedKeyManager;
import org.bouncycastle.jsse.BCX509ExtendedTrustManager;
import org.bouncycastle.jsse.java.security.BCAlgorithmConstraints;
import org.bouncycastle.jsse.java.security.BCCryptoPrimitive;
import org.bouncycastle.jsse.provider.CipherSuiteInfo;
import org.bouncycastle.jsse.provider.JsseUtils;
import org.bouncycastle.jsse.provider.NamedGroupInfo;
import org.bouncycastle.jsse.provider.PropertyUtils;
import org.bouncycastle.jsse.provider.ProvSSLContextSpi;
import org.bouncycastle.jsse.provider.ProvSSLParameters;
import org.bouncycastle.jsse.provider.ProvSSLSessionContext;
import org.bouncycastle.jsse.provider.SignatureSchemeInfo;
import org.bouncycastle.tls.ProtocolVersion;
import org.bouncycastle.tls.SignatureAndHashAlgorithm;
import org.bouncycastle.tls.TlsUtils;
import org.bouncycastle.tls.crypto.impl.jcajce.JcaTlsCrypto;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ContextData {
    private static final Set<BCCryptoPrimitive> TLS_CRYPTO_PRIMITIVES_BC = JsseUtils.KEY_AGREEMENT_CRYPTO_PRIMITIVES_BC;
    private final boolean fipsMode;
    private final JcaTlsCrypto crypto;
    private final BCX509ExtendedKeyManager x509KeyManager;
    private final BCX509ExtendedTrustManager x509TrustManager;
    private final Map<String, CipherSuiteInfo> supportedCipherSuites;
    private final Map<String, ProtocolVersion> supportedProtocols;
    private final String[] defaultCipherSuitesClient;
    private final String[] defaultCipherSuitesServer;
    private final String[] defaultProtocolsClient;
    private final String[] defaultProtocolsServer;
    private final ProvSSLSessionContext clientSessionContext;
    private final ProvSSLSessionContext serverSessionContext;
    private final NamedGroupInfo.PerContext namedGroups;
    private final SignatureSchemeInfo.PerContext signatureSchemes;
    private final int maxHandshakeMessageSize;

    ContextData(boolean bl, JcaTlsCrypto jcaTlsCrypto, BCX509ExtendedKeyManager bCX509ExtendedKeyManager, BCX509ExtendedTrustManager bCX509ExtendedTrustManager, Map<String, CipherSuiteInfo> map, Map<String, ProtocolVersion> map2, String[] stringArray, String[] stringArray2, String[] stringArray3, String[] stringArray4) {
        this.fipsMode = bl;
        this.crypto = jcaTlsCrypto;
        this.x509KeyManager = bCX509ExtendedKeyManager;
        this.x509TrustManager = bCX509ExtendedTrustManager;
        this.supportedCipherSuites = map;
        this.supportedProtocols = map2;
        this.defaultCipherSuitesClient = stringArray;
        this.defaultCipherSuitesServer = stringArray2;
        this.defaultProtocolsClient = stringArray3;
        this.defaultProtocolsServer = stringArray4;
        this.clientSessionContext = new ProvSSLSessionContext(this);
        this.serverSessionContext = new ProvSSLSessionContext(this);
        this.namedGroups = NamedGroupInfo.createPerContext(bl, jcaTlsCrypto);
        this.signatureSchemes = SignatureSchemeInfo.createPerContext(bl, jcaTlsCrypto, this.namedGroups);
        this.maxHandshakeMessageSize = PropertyUtils.getIntegerSystemProperty("jdk.tls.maxHandshakeMessageSize", 32768, 1024, Integer.MAX_VALUE);
    }

    int[] getActiveCipherSuites(JcaTlsCrypto jcaTlsCrypto, ProvSSLParameters provSSLParameters, ProtocolVersion[] protocolVersionArray) {
        String[] stringArray = provSSLParameters.getCipherSuitesArray();
        BCAlgorithmConstraints bCAlgorithmConstraints = provSSLParameters.getAlgorithmConstraints();
        ProtocolVersion protocolVersion = ProtocolVersion.getLatestTLS(protocolVersionArray);
        ProtocolVersion protocolVersion2 = ProtocolVersion.getEarliestTLS(protocolVersionArray);
        boolean bl = TlsUtils.isTLSv13(protocolVersion);
        boolean bl2 = !TlsUtils.isTLSv13(protocolVersion2);
        int[] nArray = new int[stringArray.length];
        int n = 0;
        for (String string : stringArray) {
            CipherSuiteInfo cipherSuiteInfo = this.supportedCipherSuites.get(string);
            if (null == cipherSuiteInfo || (!cipherSuiteInfo.isTLSv13() ? !bl2 : !bl) || !bCAlgorithmConstraints.permits(TLS_CRYPTO_PRIMITIVES_BC, string, null)) continue;
            nArray[n++] = cipherSuiteInfo.getCipherSuite();
        }
        int[] nArray2 = TlsUtils.getSupportedCipherSuites(jcaTlsCrypto, nArray, 0, n);
        if (nArray2.length < 1) {
            throw new IllegalStateException("No usable cipher suites enabled");
        }
        return nArray2;
    }

    ProtocolVersion[] getActiveProtocolVersions(ProvSSLParameters provSSLParameters) {
        String[] stringArray = provSSLParameters.getProtocolsArray();
        BCAlgorithmConstraints bCAlgorithmConstraints = provSSLParameters.getAlgorithmConstraints();
        TreeSet<ProtocolVersion> treeSet = new TreeSet<ProtocolVersion>(new Comparator<ProtocolVersion>(){

            @Override
            public int compare(ProtocolVersion protocolVersion, ProtocolVersion protocolVersion2) {
                return protocolVersion.isLaterVersionOf(protocolVersion2) ? -1 : (protocolVersion2.isLaterVersionOf(protocolVersion) ? 1 : 0);
            }
        });
        for (String string : stringArray) {
            ProtocolVersion protocolVersion = this.supportedProtocols.get(string);
            if (null == protocolVersion || !bCAlgorithmConstraints.permits(TLS_CRYPTO_PRIMITIVES_BC, string, null)) continue;
            treeSet.add(protocolVersion);
        }
        if (treeSet.isEmpty()) {
            throw new IllegalStateException("No usable protocols enabled");
        }
        return treeSet.toArray(new ProtocolVersion[treeSet.size()]);
    }

    ProvSSLSessionContext getClientSessionContext() {
        return this.clientSessionContext;
    }

    JcaTlsCrypto getCrypto() {
        return this.crypto;
    }

    String[] getDefaultCipherSuites(boolean bl) {
        return (String[])this.implGetDefaultCipherSuites(bl).clone();
    }

    String[] getDefaultProtocols(boolean bl) {
        return (String[])this.implGetDefaultProtocols(bl).clone();
    }

    ProvSSLParameters getDefaultSSLParameters(boolean bl) {
        return new ProvSSLParameters(this, this.implGetDefaultCipherSuites(bl), this.implGetDefaultProtocols(bl));
    }

    int getMaxHandshakeMessageSize() {
        return this.maxHandshakeMessageSize;
    }

    NamedGroupInfo.PerConnection getNamedGroupsClient(ProvSSLParameters provSSLParameters, ProtocolVersion[] protocolVersionArray) {
        return NamedGroupInfo.createPerConnectionClient(this.namedGroups, provSSLParameters, protocolVersionArray);
    }

    NamedGroupInfo.PerConnection getNamedGroupsServer(ProvSSLParameters provSSLParameters, ProtocolVersion protocolVersion) {
        return NamedGroupInfo.createPerConnectionServer(this.namedGroups, provSSLParameters, protocolVersion);
    }

    ProvSSLSessionContext getServerSessionContext() {
        return this.serverSessionContext;
    }

    List<SignatureSchemeInfo> getSignatureSchemes(Vector<SignatureAndHashAlgorithm> vector) {
        return SignatureSchemeInfo.getSignatureSchemes(this.signatureSchemes, vector);
    }

    SignatureSchemeInfo.PerConnection getSignatureSchemesClient(ProvSSLParameters provSSLParameters, ProtocolVersion[] protocolVersionArray, NamedGroupInfo.PerConnection perConnection) {
        return SignatureSchemeInfo.createPerConnectionClient(this.signatureSchemes, provSSLParameters, protocolVersionArray, perConnection);
    }

    SignatureSchemeInfo.PerConnection getSignatureSchemesServer(ProvSSLParameters provSSLParameters, ProtocolVersion protocolVersion, NamedGroupInfo.PerConnection perConnection) {
        return SignatureSchemeInfo.createPerConnectionServer(this.signatureSchemes, provSSLParameters, protocolVersion, perConnection);
    }

    String[] getSupportedCipherSuites() {
        return JsseUtils.getKeysArray(this.supportedCipherSuites);
    }

    String[] getSupportedCipherSuites(String[] stringArray) {
        if (null == stringArray) {
            throw new NullPointerException("'cipherSuites' cannot be null");
        }
        ArrayList<String> arrayList = new ArrayList<String>(stringArray.length);
        for (String string : stringArray) {
            if (TlsUtils.isNullOrEmpty(string)) {
                throw new IllegalArgumentException("'cipherSuites' cannot contain null or empty string elements");
            }
            if (!this.supportedCipherSuites.containsKey(string)) continue;
            arrayList.add(string);
        }
        return JsseUtils.getArray(arrayList);
    }

    String[] getSupportedProtocols() {
        return JsseUtils.getKeysArray(this.supportedProtocols);
    }

    ProvSSLParameters getSupportedSSLParameters(boolean bl) {
        return new ProvSSLParameters(this, this.getSupportedCipherSuites(), this.getSupportedProtocols());
    }

    BCX509ExtendedKeyManager getX509KeyManager() {
        return this.x509KeyManager;
    }

    BCX509ExtendedTrustManager getX509TrustManager() {
        return this.x509TrustManager;
    }

    boolean isFipsMode() {
        return this.fipsMode;
    }

    boolean isSupportedProtocols(String[] stringArray) {
        if (stringArray == null) {
            return false;
        }
        for (String string : stringArray) {
            if (string != null && this.supportedProtocols.containsKey(string)) continue;
            return false;
        }
        return true;
    }

    void updateDefaultSSLParameters(ProvSSLParameters provSSLParameters, boolean bl) {
        if (provSSLParameters.getCipherSuitesArray() == this.implGetDefaultCipherSuites(!bl)) {
            provSSLParameters.setCipherSuitesArray(this.implGetDefaultCipherSuites(bl));
        }
        if (provSSLParameters.getProtocolsArray() == this.implGetDefaultProtocols(!bl)) {
            provSSLParameters.setProtocolsArray(this.implGetDefaultProtocols(bl));
        }
    }

    String validateNegotiatedCipherSuite(ProvSSLParameters provSSLParameters, int n) {
        String string = ProvSSLContextSpi.getCipherSuiteName(n);
        if (!(null != string && JsseUtils.contains(provSSLParameters.getCipherSuitesArray(), string) && provSSLParameters.getAlgorithmConstraints().permits(TLS_CRYPTO_PRIMITIVES_BC, string, null) && this.supportedCipherSuites.containsKey(string))) {
            throw new IllegalStateException("SSL connection negotiated unsupported ciphersuite: " + n);
        }
        return string;
    }

    String validateNegotiatedProtocol(ProvSSLParameters provSSLParameters, ProtocolVersion protocolVersion) {
        String string = ProvSSLContextSpi.getProtocolVersionName(protocolVersion);
        if (!(null != string && JsseUtils.contains(provSSLParameters.getProtocolsArray(), string) && provSSLParameters.getAlgorithmConstraints().permits(TLS_CRYPTO_PRIMITIVES_BC, string, null) && this.supportedProtocols.containsKey(string))) {
            throw new IllegalStateException("SSL connection negotiated unsupported protocol: " + protocolVersion);
        }
        return string;
    }

    private String[] implGetDefaultCipherSuites(boolean bl) {
        return bl ? this.defaultCipherSuitesClient : this.defaultCipherSuitesServer;
    }

    private String[] implGetDefaultProtocols(boolean bl) {
        return bl ? this.defaultProtocolsClient : this.defaultProtocolsServer;
    }
}

