/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.dbus;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.freedesktop.DBus;
import org.freedesktop.dbus.AbstractConnection;
import org.freedesktop.dbus.Error;
import org.freedesktop.dbus.Gettext;
import org.freedesktop.dbus.Message;
import org.freedesktop.dbus.MethodCall;
import org.freedesktop.dbus.MethodReturn;
import org.freedesktop.dbus.RemoteInvocationHandler;
import org.freedesktop.dbus.exceptions.DBusException;
import org.freedesktop.dbus.exceptions.DBusExecutionException;

public class DBusAsyncReply<ReturnType> {
    private ReturnType rval = null;
    private DBusExecutionException error = null;
    private MethodCall mc;
    private Method me;
    private AbstractConnection conn;

    public static Collection<DBusAsyncReply<? extends Object>> hasReply(Collection<DBusAsyncReply<? extends Object>> collection) {
        ArrayList<DBusAsyncReply<? extends Object>> arrayList = new ArrayList<DBusAsyncReply<? extends Object>>(collection);
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            if (((DBusAsyncReply)iterator.next()).hasReply()) continue;
            iterator.remove();
        }
        return arrayList;
    }

    DBusAsyncReply(MethodCall methodCall, Method method, AbstractConnection abstractConnection) {
        this.mc = methodCall;
        this.me = method;
        this.conn = abstractConnection;
    }

    private synchronized void checkReply() {
        if (this.mc.hasReply()) {
            Message message = this.mc.getReply();
            if (message instanceof Error) {
                this.error = ((Error)message).getException();
            } else if (message instanceof MethodReturn) {
                try {
                    this.rval = RemoteInvocationHandler.convertRV(message.getSig(), message.getParameters(), this.me, this.conn);
                }
                catch (DBusExecutionException dBusExecutionException) {
                    this.error = dBusExecutionException;
                }
                catch (DBusException dBusException) {
                    if (AbstractConnection.EXCEPTION_DEBUG) {
                        // empty if block
                    }
                    this.error = new DBusExecutionException(dBusException.getMessage());
                }
            }
        }
    }

    public boolean hasReply() {
        if (null != this.rval || null != this.error) {
            return true;
        }
        this.checkReply();
        return null != this.rval || null != this.error;
    }

    public ReturnType getReply() throws DBusExecutionException {
        if (null != this.rval) {
            return this.rval;
        }
        if (null != this.error) {
            throw this.error;
        }
        this.checkReply();
        if (null != this.rval) {
            return this.rval;
        }
        if (null != this.error) {
            throw this.error;
        }
        throw new DBus.Error.NoReply(Gettext._("Async call has not had a reply"));
    }

    public String toString() {
        return Gettext._("Waiting for: ") + this.mc;
    }

    Method getMethod() {
        return this.me;
    }

    AbstractConnection getConnection() {
        return this.conn;
    }

    MethodCall getCall() {
        return this.mc;
    }
}

