/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.app.launcher.parameterparser;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import org.appwork.app.launcher.parameterparser.AmbigiousArgumentsException;
import org.appwork.app.launcher.parameterparser.CommandSwitch;
import org.appwork.utils.IO;
import org.appwork.utils.StringUtils;
import org.appwork.utils.parser.ShellParser;

public class ParameterParser {
    private String[] rawArguments;
    private HashMap<String, CommandSwitch> map;
    private ArrayList<CommandSwitch> list;

    public ParameterParser(String[] args) {
        this.rawArguments = args;
    }

    public CommandSwitch getCommandSwitch(String string) {
        return this.getMap().get(StringUtils.toLowerCaseOrNull(string));
    }

    public String[] getRawArguments() {
        return this.rawArguments;
    }

    @Deprecated
    public void setRawArguments(String[] rawArguments) {
        this.rawArguments = rawArguments;
    }

    public boolean hasAnyCommandSwitch(String ... string) {
        for (String s : string) {
            if (!this.hasCommandSwitch(s)) continue;
            return true;
        }
        return false;
    }

    public boolean hasCommandSwitch(String string) {
        return this.getMap().containsKey(StringUtils.toLowerCaseOrNull(string));
    }

    public HashMap<String, CommandSwitch> getMap() {
        return this.map;
    }

    public ParameterParser parse() {
        this.map = new HashMap();
        this.list = new ArrayList();
        this.parse(this.getRawArguments());
        return this;
    }

    public ParameterParser parse(File file) throws IOException {
        this.parse();
        if (file != null && file.isFile()) {
            this.parse(ShellParser.splitCommandString(IO.readFileToString(file).replaceAll("[\r\n]", " ")).toArray(new String[0]));
        }
        return this;
    }

    private void parse(String[] startArguments) {
        String switchCommand = null;
        ArrayList<String> params = new ArrayList<String>();
        for (String var : startArguments) {
            if (var.startsWith("-")) {
                while (var.length() > 0 && var.startsWith("-")) {
                    var = var.substring(1);
                }
                if (switchCommand != null || params.size() > 0) {
                    CommandSwitch commandSwitch = new CommandSwitch(switchCommand, params.toArray(new String[0]));
                    this.map.put(commandSwitch.getCaseInsensitiveSwitchCommand(), commandSwitch);
                    this.list.add(commandSwitch);
                }
                switchCommand = var;
                params.clear();
                continue;
            }
            params.add(var);
        }
        if (switchCommand != null || params.size() > 0) {
            CommandSwitch commandSwitch = new CommandSwitch(switchCommand, params.toArray(new String[0]));
            this.map.put(commandSwitch.getCaseInsensitiveSwitchCommand(), commandSwitch);
            this.list.add(commandSwitch);
        }
    }

    public ArrayList<CommandSwitch> getList() {
        return this.list;
    }

    public boolean hasCommandSwitch(String string, int minParameters, int maxParameters) {
        CommandSwitch s = this.getCommandSwitch(string);
        return s != null && s.getParameters().length >= minParameters && s.getParameters().length <= maxParameters;
    }

    public String getParameter(String key, int index, String def) {
        CommandSwitch s = this.getCommandSwitch(key);
        if (s == null) {
            return def;
        }
        if (s.getParameters().length <= index) {
            return def;
        }
        return s.getParameters()[index];
    }

    public CommandSwitch getCommandByKeyOrSynonyms(String ... synonyms) throws AmbigiousArgumentsException {
        CommandSwitch ret = null;
        for (String key : synonyms) {
            CommandSwitch cmd = this.getCommandSwitch(key);
            if (cmd == null) continue;
            if (ret != null) {
                throw new AmbigiousArgumentsException("These switches are pseudonymes. Use them only once: " + Arrays.asList(synonyms));
            }
            ret = cmd;
        }
        return ret;
    }
}

