/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.remoteapi.upload;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.net.URL;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import org.appwork.remoteapi.upload.UploadHashException;
import org.appwork.utils.IO;
import org.appwork.utils.Regex;
import org.appwork.utils.StringUtils;
import org.appwork.utils.formatter.HexFormatter;
import org.appwork.utils.net.BasicHTTP.BasicHTTP;
import org.appwork.utils.net.BasicHTTP.BasicHTTPException;
import org.appwork.utils.net.LimitedInputStream;
import org.appwork.utils.net.UploadProgress;
import org.appwork.utils.net.httpconnection.HTTPConnection;

public abstract class Upload {
    protected String eTag = null;
    protected final File file;
    protected long uploadChunkSize = -1L;
    protected long remoteSize = -1L;
    protected long knownErrorFreeRemoteSize = 0L;

    public Upload(File file) {
        this(file, null);
    }

    public Upload(File file, String eTag) {
        this.file = file;
        String ret = new Regex(eTag, "\"(.*?)\"").getMatch(0);
        this.eTag = ret == null ? eTag : ret;
    }

    protected void checkInterrupted() throws InterruptedException {
        if (Thread.currentThread().isInterrupted()) {
            try {
                this.getBasicHTTP().getConnection().disconnect();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            throw new InterruptedException();
        }
    }

    public abstract BasicHTTP getBasicHTTP();

    public String getETag() {
        String ret = new Regex(this.eTag, "\"(.*?)\"").getMatch(0);
        if (ret != null) {
            return ret;
        }
        return this.eTag;
    }

    public File getFile() {
        return this.file;
    }

    public long getKnownErrorFreeRemoteSize() {
        return this.knownErrorFreeRemoteSize;
    }

    public long getLocalSize() {
        return this.getFile().length();
    }

    protected String getQuotedEtag() {
        String ret = this.getETag();
        if (ret == null) {
            return null;
        }
        return "\"" + ret + "\"";
    }

    protected void checkLocal() throws IOException {
        File file = this.getFile();
        if (!file.exists()) {
            throw new FileNotFoundException("Local file does not exist: " + file);
        }
    }

    public long getRemoteSize(boolean fetchOnline) throws IOException, EtagNotAvailableAtTheServer, InterruptedException {
        try {
            return this.getRemoteSizeIntern(fetchOnline);
        }
        catch (EtagNotAvailableAtTheServer e) {
            this.setETag(null);
            return this.getRemoteSizeIntern(fetchOnline);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long getRemoteSizeIntern(boolean fetchOnline) throws IOException, InterruptedException, BasicHTTPException {
        if (!fetchOnline && this.remoteSize > 0L) {
            return this.remoteSize;
        }
        HTTPConnection con = null;
        try {
            HashMap<String, String> header = new HashMap<String, String>();
            String eTag = this.getQuotedEtag();
            if (eTag != null) {
                header.put("If-Match", eTag);
            }
            header.put("Content-Type", "application/octet-stream");
            this.checkLocal();
            header.put("Content-Range", "bytes */" + this.getLocalSize());
            this.checkInterrupted();
            URL url = this.getUploadURL();
            ByteArrayInputStream is = new ByteArrayInputStream(new byte[0]);
            con = this.post(header, url, is, 0L, null);
            this.parseResponse(con);
            long l = this.remoteSize;
            return l;
        }
        finally {
            try {
                con.disconnect();
            }
            catch (Throwable throwable) {}
        }
    }

    protected HTTPConnection post(HashMap<String, String> header, URL url, InputStream is, long uploadSize, UploadProgress uploadProgress) throws BasicHTTPException, InterruptedException {
        BasicHTTP shttp = this.getBasicHTTP();
        HTTPConnection con = shttp.openPostConnection(url, uploadProgress, is, header, uploadSize);
        return con;
    }

    public long getUploadChunkSize() {
        return this.uploadChunkSize;
    }

    public UploadProgress getUploadProgress() {
        return null;
    }

    protected abstract URL getUploadURL() throws IOException;

    public boolean isUploadComplete() throws FileNotFoundException {
        if (this.remoteSize <= 0L) {
            return false;
        }
        long localSize = this.getLocalSize();
        if (this.remoteSize > localSize) {
            throw new FileNotFoundException("RemoteSize=" + this.remoteSize + " > LocalSize=" + localSize);
        }
        return localSize == this.remoteSize;
    }

    protected void parseResponse(HTTPConnection con) throws IOException {
        if (con.getResponseCode() == 404) {
            throw new EtagNotAvailableAtTheServer("Remote file does not exist: " + this.eTag);
        }
        if (con.getResponseCode() == 308 || con.getResponseCode() == 200) {
            this.eTag = con.getHeaderField("ETag");
            if (StringUtils.isEmpty(this.eTag)) {
                throw new IOException("No ETag!");
            }
            if (con.getResponseCode() == 308) {
                this.remoteSize = 0L;
                String range = con.getHeaderField("Range");
                if (range != null) {
                    String remoteSize = new Regex(range, "\\d+\\s*?-\\s*?(\\d+)").getMatch(0);
                    this.remoteSize = Long.parseLong(remoteSize) + 1L;
                }
            } else {
                this.remoteSize = this.getLocalSize();
            }
            return;
        }
        throw new IOException("Unknown responsecode " + con.getResponseCode());
    }

    public void setETag(String eTag) {
        if (StringUtils.isEmpty(eTag)) {
            this.eTag = null;
            return;
        }
        String ret = new Regex(eTag, "\"(.*?)\"").getMatch(0);
        this.eTag = ret == null ? eTag : ret;
    }

    public void setKnownErrorFreeRemoteSize(long knownErrorFreeRemoteSize) {
        this.knownErrorFreeRemoteSize = knownErrorFreeRemoteSize;
    }

    public void setUploadChunkSize(long uploadChunkSize) {
        this.uploadChunkSize = uploadChunkSize;
    }

    protected MessageDigest getMessageDigest() throws NoSuchAlgorithmException {
        return MessageDigest.getInstance("SHA-1");
    }

    protected InputStream openInputStream() throws IOException {
        final RandomAccessFile raf = new RandomAccessFile(this.getFile(), "r");
        return new InputStream(){

            @Override
            public int read() throws IOException {
                return raf.read();
            }

            @Override
            public int available() throws IOException {
                long available = raf.length() - raf.getFilePointer();
                if (available > Integer.MAX_VALUE) {
                    return Integer.MAX_VALUE;
                }
                return (int)available;
            }

            @Override
            public long skip(long skip) throws IOException {
                long left;
                int skipped;
                for (left = skip; left > 0L; left -= (long)skipped) {
                    skipped = left > Integer.MAX_VALUE ? raf.skipBytes(Integer.MAX_VALUE) : raf.skipBytes((int)left);
                    if (skipped != 0) continue;
                    break;
                }
                return skip - left;
            }

            @Override
            public void close() throws IOException {
                raf.close();
            }

            @Override
            public int read(byte[] b) throws IOException {
                return raf.read(b);
            }

            @Override
            public int read(byte[] b, int off, int len) throws IOException {
                return raf.read(b, off, len);
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean uploadChunk() throws FileNotFoundException, IOException, InterruptedException, NoSuchAlgorithmException {
        long maxChunkSize;
        long existingRemoteSize;
        long remoteSize;
        InputStream is = null;
        HTTPConnection con = null;
        UploadProgress uploadProgress = this.getUploadProgress();
        HashMap<String, String> header = new HashMap<String, String>();
        is = this.openInputStream();
        long uploadSize = this.getLocalSize();
        if (uploadProgress != null) {
            uploadProgress.setTotal(uploadSize);
        }
        if ((remoteSize = Math.min(existingRemoteSize = this.getRemoteSize(true), this.getKnownErrorFreeRemoteSize())) < 0L) {
            remoteSize = 0L;
        }
        if (uploadProgress != null) {
            uploadProgress.setUploaded(remoteSize);
        }
        if (existingRemoteSize > uploadSize || remoteSize > uploadSize) {
            throw new FileNotFoundException("RemoteSize > UploadSize");
        }
        if (remoteSize == uploadSize) {
            boolean bl = true;
            return bl;
        }
        if (remoteSize > 0L) {
            long skipped = is.skip(remoteSize);
            uploadSize = this.getLocalSize() - skipped;
        }
        if ((maxChunkSize = this.getUploadChunkSize()) > 1024L) {
            uploadSize = Math.min(maxChunkSize, uploadSize);
        }
        this.checkInterrupted();
        long rangeEnd = remoteSize + uploadSize - 1L;
        MessageDigest md = this.getMessageDigest();
        DigestInputStream dis = new DigestInputStream(new LimitedInputStream(is, uploadSize), md);
        header.put("If-Match", this.getQuotedEtag());
        header.put("Content-Type", "application/octet-stream");
        header.put("Content-Range", "bytes " + remoteSize + "-" + rangeEnd + "/" + this.getLocalSize());
        this.checkInterrupted();
        URL url = this.getUploadURL();
        con = this.post(header, url, dis, uploadSize, uploadProgress);
        this.parseResponse(con);
        String remoteHash = new String(IO.readStream(1024, con.getInputStream()), "UTF-8");
        String localHash = HexFormatter.byteArrayToHex(dis.getMessageDigest().digest());
        if (!localHash.equalsIgnoreCase(remoteHash)) {
            throw new UploadHashException("Upload error: hash missmatch");
        }
        this.setKnownErrorFreeRemoteSize(remoteSize + uploadSize);
        if (uploadProgress != null) {
            uploadProgress.setUploaded(remoteSize + uploadSize);
        }
        boolean bl = this.isUploadComplete();
        return bl;
        finally {
            try {
                is.close();
            }
            catch (Throwable throwable) {}
            try {
                con.disconnect();
            }
            catch (Throwable throwable) {}
        }
    }

    public class EtagNotAvailableAtTheServer
    extends FileNotFoundException {
        public EtagNotAvailableAtTheServer(String s) {
            super(s);
        }
    }
}

