/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.remoteapi.upload;

import java.io.File;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.appwork.storage.Storable;
import org.appwork.storage.StorableAllowPrivateAccessModifier;
import org.appwork.storage.StorableValidatorIgnoresMissingSetter;
import org.appwork.utils.Hash;

@StorableValidatorIgnoresMissingSetter
public class UploadUnit
implements Storable {
    private static AtomicLong COUNTER = new AtomicLong(0L);
    private final String eTag;
    private File fileLocation;
    private final AtomicLong lastAccess = new AtomicLong(-1L);
    private final long expectedFinalSize;
    private final AtomicBoolean isUploading = new AtomicBoolean(false);

    @StorableAllowPrivateAccessModifier
    private UploadUnit() {
        this(-1L);
    }

    public UploadUnit(long expectedFinalSize) {
        this(expectedFinalSize, COUNTER.incrementAndGet() + Hash.getSHA1("" + System.currentTimeMillis() + COUNTER.incrementAndGet()));
    }

    public UploadUnit(long expectedFinalSize, String eTag) {
        this.eTag = eTag;
        this.expectedFinalSize = expectedFinalSize;
    }

    public File _getFile() {
        return this.fileLocation;
    }

    public String _getQuotedETag() {
        return "\"" + this.eTag + "\"";
    }

    public void _setFile(File file) {
        this.fileLocation = file;
    }

    public String getETag() {
        return this.eTag;
    }

    public long getExpectedFinalSize() {
        return this.expectedFinalSize;
    }

    public long getLastAccess() {
        return this.lastAccess.get();
    }

    public long getSize() {
        return this._getFile().length();
    }

    public boolean isComplete() {
        return this._getFile().length() == this.getExpectedFinalSize();
    }

    public boolean isUploading() {
        return this.isUploading.get();
    }

    public void setUploading(boolean b) {
        this.isUploading.set(b);
    }

    public void setLastAccess(long lastAccess) {
        this.lastAccess.set(lastAccess);
    }

    public String toString() {
        return "UploadUnit [eTag=" + this.eTag + ", fileLocation=" + this.fileLocation + ", lastAccess=" + this.lastAccess + ", expectedFinalSize=" + this.expectedFinalSize + ", isUploading=" + this.isUploading + "]";
    }
}

