/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.storage;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.appwork.exceptions.WTFException;
import org.appwork.storage.DeSerializerInput;
import org.appwork.storage.JSonMapperException;
import org.appwork.storage.JsonDeSerializer;
import org.appwork.storage.JsonSerializer;
import org.appwork.storage.SimpleTypeRef;
import org.appwork.storage.TypeRef;
import org.appwork.storage.converter.ConverterInput;
import org.appwork.storage.converter.JsonConverterForDeserialization;
import org.appwork.storage.converter.JsonConverterForSerialization;
import org.appwork.storage.flexijson.FlexiJSONParser;
import org.appwork.storage.flexijson.FlexiJSonNode;
import org.appwork.storage.flexijson.FlexiParserException;
import org.appwork.storage.flexijson.mapper.FlexiJSonMapper;
import org.appwork.storage.flexijson.mapper.FlexiMapperException;
import org.appwork.storage.flexijson.stringify.FlexiJSonPrettyStringify;
import org.appwork.storage.flexijson.stringify.FlexiJSonStringBuilder;
import org.appwork.storage.mapper.AbstractJsonMapper;
import org.appwork.storage.simplejson.ParserException;
import org.appwork.storage.simplejson.mapper.Getter;
import org.appwork.storage.simplejson.mapper.Setter;
import org.appwork.utils.Exceptions;
import org.appwork.utils.reflection.CompiledType;

public class FlexiJSonBridge
extends AbstractJsonMapper {
    public final ExtFlexiJsonMapper mapper = new ExtFlexiJsonMapper();
    private boolean prettyPrintEnabled = true;

    public boolean isPrettyPrintEnabled() {
        return this.prettyPrintEnabled;
    }

    public void setPrettyPrintEnabled(boolean prettyPrintEnabled) {
        this.prettyPrintEnabled = prettyPrintEnabled;
    }

    @Override
    public String objectToString(Object value) throws JSonMapperException {
        try {
            FlexiJSonNode node = this.mapper.objectToJsonNode(value);
            if (this.isPrettyPrintEnabled()) {
                return new FlexiJSonPrettyStringify().toJSONString(node);
            }
            return new FlexiJSonStringBuilder().toJSONString(node);
        }
        catch (FlexiMapperException e) {
            throw new JSonMapperException(e);
        }
    }

    @Override
    public <T> T stringToObject(String jsonString, Class<T> clazz) throws JSonMapperException {
        try {
            FlexiJSonNode node = this.createParser(jsonString).parse();
            return (T)this.mapper.jsonToObject(node, CompiledType.create(clazz));
        }
        catch (ParserException e) {
            throw new JSonMapperException(e);
        }
        catch (FlexiMapperException e) {
            throw new JSonMapperException(e);
        }
    }

    protected FlexiJSONParser createParser(String jsonString) {
        return new FlexiJSONParser(jsonString);
    }

    @Override
    public <T> T stringToObject(String jsonString, TypeRef<T> type) throws JSonMapperException {
        try {
            FlexiJSonNode node = this.createParser(jsonString).parse();
            return this.mapper.jsonToObject(node, type);
        }
        catch (ParserException e) {
            throw new JSonMapperException(e);
        }
        catch (FlexiMapperException e) {
            throw new JSonMapperException(e);
        }
    }

    @Override
    public <T> T convert(Object object, TypeRef<T> type) throws JSonMapperException {
        try {
            FlexiJSonNode node = this.mapper.objectToJsonNode(object);
            return this.mapper.jsonToObject(node, type);
        }
        catch (FlexiMapperException e) {
            throw new JSonMapperException(e);
        }
    }

    @Override
    public byte[] objectToByteArray(Object value) throws JSonMapperException {
        try {
            FlexiJSonNode node = this.mapper.objectToJsonNode(value);
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            new FlexiJSonStringBuilder().toJSONString(node, out, new LinkedList<String>());
            return out.toByteArray();
        }
        catch (FlexiMapperException e) {
            throw new JSonMapperException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeObject(OutputStream outputStream, Object value) throws JSonMapperException {
        try {
            try {
                FlexiJSonNode node = this.mapper.objectToJsonNode(value);
                new FlexiJSonStringBuilder().toJSONString(node, outputStream, new LinkedList<String>());
            }
            finally {
                if (outputStream != null) {
                    try {
                        outputStream.close();
                    }
                    catch (IOException e) {
                        throw new JSonMapperException(e);
                    }
                }
            }
        }
        catch (FlexiMapperException e) {
            throw new JSonMapperException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public <T> T inputStreamToObject(InputStream inputStream, TypeRef<T> type) throws JSonMapperException {
        try {
            try {
                FlexiJSonNode node = new FlexiJSONParser(inputStream).parse();
                T t = this.mapper.jsonToObject(node, type);
                return t;
            }
            finally {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
        }
        catch (FlexiParserException e) {
            throw new JSonMapperException(e);
        }
        catch (IOException e) {
            throw new JSonMapperException(e);
        }
        catch (FlexiMapperException e) {
            throw new JSonMapperException(e);
        }
    }

    @Override
    public <T> T byteArrayToObject(byte[] byteArray, Class<T> clazz) throws JSonMapperException {
        try {
            FlexiJSonNode node = new FlexiJSONParser(new ByteArrayInputStream(byteArray)).parse();
            return (T)this.mapper.jsonToObject(node, CompiledType.create(clazz));
        }
        catch (ParserException e) {
            throw new JSonMapperException(e);
        }
        catch (FlexiMapperException e) {
            throw new JSonMapperException(e);
        }
    }

    @Override
    public <T> T inputStreamToObject(InputStream inputStream, Class<T> clazz) throws JSonMapperException {
        try {
            FlexiJSonNode node = new FlexiJSONParser(inputStream).parse();
            return (T)this.mapper.jsonToObject(node, CompiledType.create(clazz));
        }
        catch (ParserException e) {
            throw new JSonMapperException(e);
        }
        catch (FlexiMapperException e) {
            throw new JSonMapperException(e);
        }
    }

    public class ExtFlexiJsonMapper
    extends FlexiJSonMapper {
        private ThreadLocal<HashSet<Object>> bypass = new ThreadLocal();

        @Override
        protected Object handleMapperJsonNodeToObject(final FlexiJSonNode json, CompiledType type, Setter setter) throws FlexiMapperException {
            try {
                HashSet<Object> byp = this.bypass.get();
                if (byp == null || !byp.contains(json)) {
                    Object ret;
                    Object input;
                    Class raw = FlexiJSonBridge.this.getRawTypeForDeserialization(type.type);
                    SimpleTypeRef typeRef = null;
                    List matches = FlexiJSonBridge.this.findBestTypeMatch(raw, FlexiJSonBridge.this.convertForDeserialization, JsonConverterForDeserialization.class);
                    if (matches != null && matches.size() > 0) {
                        input = new ConverterInput(json){

                            @Override
                            protected Object lazyGenericRepresentationInit() {
                                try {
                                    return ExtFlexiJsonMapper.this.jsonToObjectBypass(json, CompiledType.OBJECT);
                                }
                                catch (FlexiMapperException e) {
                                    throw new WTFException(e);
                                }
                            }
                        };
                        if (typeRef == null) {
                            typeRef = new SimpleTypeRef(type.type);
                        }
                        if ((ret = FlexiJSonBridge.this.handleDeserializationConverterMatches((ConverterInput)input, typeRef, matches)) != input) {
                            return ret;
                        }
                    }
                    if ((matches = FlexiJSonBridge.this.findBestTypeMatch(raw, FlexiJSonBridge.this.deSerializer, JsonDeSerializer.class)) != null && matches.size() > 0) {
                        input = new DeSerializerInput(json){

                            @Override
                            protected String lazyJSONRepresentationInit() {
                                return new FlexiJSonStringBuilder().toJSONString(json);
                            }
                        };
                        if (typeRef == null) {
                            typeRef = new SimpleTypeRef(type.type);
                        }
                        if ((ret = FlexiJSonBridge.this.handleDeserializationMatches((DeSerializerInput)input, typeRef, matches)) != input) {
                            return ret;
                        }
                    }
                }
                return super.handleMapperJsonNodeToObject(json, type, setter);
            }
            catch (WTFException e) {
                FlexiMapperException hidden = Exceptions.getInstanceof(e, FlexiMapperException.class);
                if (hidden != null) {
                    throw hidden;
                }
                throw e;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Object jsonToObjectBypass(FlexiJSonNode json, CompiledType type) throws FlexiMapperException {
            HashSet<Object> set = this.bypass.get();
            if (set == null) {
                set = new HashSet();
                this.bypass.set(set);
            }
            set.add(json);
            try {
                Object object = this.jsonToObject(json, type);
                return object;
            }
            finally {
                set.remove(json);
            }
        }

        @Override
        protected FlexiJSonNode handleMapperObjectToJsonNode(Getter reference, Object obj, LinkedList<CompiledType> typeHirarchy) throws FlexiMapperException {
            Object ret;
            boolean mapped = false;
            List matches = FlexiJSonBridge.this.findBestTypeMatch(obj == null ? null : obj.getClass(), FlexiJSonBridge.this.convertForSerialization, JsonConverterForSerialization.class);
            if (matches != null && matches.size() > 0 && (ret = FlexiJSonBridge.this.handleSerializationConverterMatches(obj, matches)) != JsonConverterForSerialization.SKIP && ret != obj) {
                obj = ret;
                mapped = true;
            }
            if ((matches = FlexiJSonBridge.this.findBestTypeMatch(obj == null ? null : obj.getClass(), FlexiJSonBridge.this.serializer, JsonSerializer.class)) != null && matches.size() > 0 && (ret = FlexiJSonBridge.this.handleSerializationMatches(obj, matches)) != JsonSerializer.SKIP) {
                try {
                    return new FlexiJSONParser((String)ret).parse();
                }
                catch (FlexiParserException e) {
                    throw new FlexiMapperException(null, CompiledType.create(obj.getClass()), e);
                }
            }
            if (mapped) {
                return FlexiJSonBridge.this.mapper.objectToJsonNode(obj);
            }
            return super.handleMapperObjectToJsonNode(reference, obj, typeHirarchy);
        }
    }
}

