/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.storage.config.handler;

import java.io.File;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.net.URL;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.appwork.exceptions.WTFException;
import org.appwork.loggingv3.LogV3;
import org.appwork.storage.JSonStorage;
import org.appwork.storage.Storage;
import org.appwork.storage.TypeRef;
import org.appwork.storage.config.MinTimeWeakReference;
import org.appwork.storage.config.annotations.CryptedStorage;
import org.appwork.storage.config.annotations.DisableObjectCache;
import org.appwork.storage.config.annotations.PlainStorage;
import org.appwork.storage.config.handler.KeyHandler;
import org.appwork.storage.config.handler.StorageHandler;
import org.appwork.utils.Application;
import org.appwork.utils.IO;
import org.appwork.utils.ReflectionUtils;
import org.appwork.utils.reflection.Clazz;
import org.appwork.utils.reflection.CompiledType;

public class ListHandler<T>
extends KeyHandler<T> {
    public static final int MIN_LIFETIME = 10000;
    private volatile ListHandlerCache<Object> cache;
    private final Type type;
    private static final Object NULL = new Object();
    private File path;
    private URL url;
    private boolean useObjectCache = false;
    private byte[] cryptKey = null;
    private final Class<? extends Annotation> defaultAnnotation;

    public ListHandler(StorageHandler<?> storageHandler, String key, Type type) {
        this(storageHandler, key, type, null);
    }

    public ListHandler(StorageHandler<?> storageHandler, String key, Type type, Class<? extends Annotation> defaultAnnotation) {
        super(storageHandler, key);
        this.type = type;
        this.defaultAnnotation = defaultAnnotation;
    }

    @Override
    protected Class<? extends Annotation> getDefaultAnnotation() {
        return this.defaultAnnotation;
    }

    @Override
    public Type getRawType() {
        return this.type;
    }

    @Override
    protected boolean equals(Object x, Object y) {
        if (x == null) {
            return y == null;
        }
        if (y == null) {
            return false;
        }
        CompiledType cc = CompiledType.create(this.getRawType());
        if (cc.isArray() || cc.isList()) {
            Class<?> elemType = cc.getComponentType().raw;
            if (Clazz.isPrimitive(elemType) || Clazz.isString(elemType) || Clazz.isEnum(elemType)) {
                List<?> xList = ReflectionUtils.wrapList(x, false, elemType);
                List<?> yList = ReflectionUtils.wrapList(y, false, elemType);
                return xList != null && xList.equals(yList);
            }
            return false;
        }
        return false;
    }

    @Override
    protected Class<? extends Annotation>[] getAllowedAnnotations() {
        return new Class[]{DisableObjectCache.class};
    }

    protected Object getCachedValue() {
        ListHandlerCache<Object> lCache;
        if (this.isCachingAllowed() && (lCache = this.cache) != null) {
            return lCache.get();
        }
        return null;
    }

    protected boolean isCachingAllowed() {
        return this.useObjectCache && this.getStorageHandler().isObjectCacheEnabled();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T getValue() {
        ListHandler listHandler = this;
        synchronized (listHandler) {
            Object value = this.getCachedValue();
            if (value == null) {
                try {
                    value = this.read();
                }
                catch (Throwable e) {
                    throw new WTFException(e);
                }
                this.putCachedValue(value);
            }
            if (NULL == value) {
                value = null;
            }
            if (value == null && this.isDefaultOnNull()) {
                value = this.getDefaultValue();
            }
            value = this.applyCustomValueGetter(value);
            return (T)value;
        }
    }

    @Override
    protected void initDefaults() throws Throwable {
    }

    @Override
    protected void initHandler() throws Throwable {
        Storage storage;
        this.setStorageSyncMode(this.getDefaultStorageSyncMode());
        CryptedStorage cryptedStorage = this.getAnnotation(CryptedStorage.class);
        this.cryptKey = cryptedStorage != null ? cryptedStorage.key() : (byte[])(this.getAnnotation(PlainStorage.class) == null ? ((storage = this.storageHandler.getPrimitiveStorage(this)) != null ? storage.getCryptKey() : null) : null);
        File storageHandlerPath = this.storageHandler.getPath();
        this.path = storageHandlerPath != null ? new File(storageHandlerPath + "." + this.getKey() + "." + (this.getCryptKey() != null ? "ejs" : "json")) : null;
        String relativeClassPath = this.storageHandler.getRelativCPPath();
        if (!(relativeClassPath == null || this.path != null && this.path.exists())) {
            String ressource = relativeClassPath + "." + this.getKey() + "." + (this.getCryptKey() != null ? "ejs" : "json");
            this.url = Application.class.getClassLoader().getResource(ressource);
        } else {
            this.url = null;
        }
        this.useObjectCache = this.getAnnotation(DisableObjectCache.class) == null;
    }

    @Override
    public File getPath() {
        return this.path;
    }

    public URL getURL() {
        return this.url;
    }

    @Override
    public byte[] getCryptKey() {
        return this.cryptKey;
    }

    protected void putCachedValue(Object value) {
        final Object finalValue = value == null ? NULL : value;
        this.cache = this.getStorageHandler().isDelayedWriteAllowed(this) ? new ListHandlerCache<Object>(){

            @Override
            public Object get() {
                return finalValue;
            }
        } : (this.isCachingAllowed() ? new ListHandlerCache<Object>(){
            final MinTimeWeakReference<Object> minTimeWeakReference;
            {
                this.minTimeWeakReference = new MinTimeWeakReference<Object>(finalValue, 10000L, "Storage " + ListHandler.this.getKey());
            }

            @Override
            public Object get() {
                return this.minTimeWeakReference.get();
            }
        } : null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void putValue(T value) {
        ListHandler listHandler = this;
        synchronized (listHandler) {
            this.putCachedValue(value);
            this.write(value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean setValueEqualsGetValue(T newValue) {
        ListHandler listHandler = this;
        synchronized (listHandler) {
            Object value = this.getCachedValue();
            if (value != null) {
                if (value == newValue) {
                    return false;
                }
                return super.setValueEqualsGetValue(newValue);
            }
        }
        return false;
    }

    protected Object readObject(Object dummyObject, AtomicBoolean readFlag) throws InstantiationException, IllegalAccessException, IOException {
        Object readObject = this.getStorageHandler().readObject(this, readFlag);
        if (!readFlag.get()) {
            URL jsonURL;
            TypeRef<Object> typeRef = new TypeRef<Object>(this.getTypeRef().getType()){};
            File jsonPath = this.getPath();
            byte[] cryptKey = this.getCryptKey();
            if (jsonPath != null && jsonPath.isFile()) {
                LogV3.finer("Read Config(File): " + jsonPath.getAbsolutePath());
                readObject = JSonStorage.restoreFrom(jsonPath, cryptKey == null, cryptKey, typeRef, dummyObject);
                readFlag.set(jsonPath.isFile());
            }
            if (!(readObject != dummyObject && readFlag.get() || (jsonURL = this.getURL()) == null)) {
                LogV3.finer("Read Config(URL): " + jsonURL);
                readObject = JSonStorage.restoreFromByteArray(IO.readURL(jsonURL), cryptKey == null, cryptKey, typeRef, dummyObject);
                readFlag.set(true);
            }
        }
        return readObject;
    }

    /*
     * Exception decompiling
     */
    protected Object read() throws InstantiationException, IllegalAccessException, IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [8[CATCHBLOCK]], but top level block is 6[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    protected void validateValue(T object) throws Throwable {
    }

    protected void write(T object) {
        this.getStorageHandler().writeObject(this, object);
        this.url = null;
    }

    private static interface ListHandlerCache<T> {
        public T get();
    }
}

