/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.storage.flexijson;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import org.appwork.storage.flexijson.FlexiComment;
import org.appwork.storage.flexijson.FlexiCommentJsonNode;
import org.appwork.storage.flexijson.FlexiJSonNode;
import org.appwork.storage.flexijson.JSPath;
import org.appwork.storage.flexijson.mapper.FlexiMapperTags;
import org.appwork.storage.flexijson.stringify.FlexiJSonStringBuilder;

public class FlexiJSonComments
extends ArrayList<FlexiCommentJsonNode>
implements FlexiJSonNode {
    private static final long serialVersionUID = 1L;
    private FlexiJSonNode parent;
    private HashSet<FlexiMapperTags> tags;

    public FlexiJSonComments() {
        super(1);
    }

    public FlexiJSonComments(FlexiCommentJsonNode ... comments) {
        super(Arrays.asList(comments));
    }

    @Override
    public boolean add(FlexiCommentJsonNode e) {
        e.setParent(this);
        return super.add(e);
    }

    @Override
    public void add(int index, FlexiCommentJsonNode element) {
        element.setParent(this);
        super.add(index, element);
    }

    @Override
    public boolean addAll(Collection<? extends FlexiCommentJsonNode> c) {
        if (c == null) {
            return false;
        }
        for (FlexiCommentJsonNode flexiCommentJsonNode : c) {
            flexiCommentJsonNode.setParent(this);
        }
        return super.addAll(c);
    }

    @Override
    public boolean addAll(int index, Collection<? extends FlexiCommentJsonNode> c) {
        if (c == null) {
            return false;
        }
        for (FlexiCommentJsonNode flexiCommentJsonNode : c) {
            flexiCommentJsonNode.setParent(this);
        }
        return super.addAll(index, c);
    }

    @Override
    public String toString() {
        return new FlexiJSonStringBuilder().toJSONString(this);
    }

    @Override
    public void setCommentsAfter(FlexiJSonComments commentsAfter) {
    }

    @Override
    public FlexiJSonComments getCommentsAfter() {
        return null;
    }

    @Override
    public FlexiJSonNode resolvePath(JSPath parent) {
        return null;
    }

    @Override
    public void setCommentsBefore(FlexiJSonComments commentsBefore) {
    }

    @Override
    public FlexiJSonComments getCommentsBefore() {
        return null;
    }

    @Override
    public void addCommentsBefore(FlexiJSonComments comments) {
    }

    @Override
    public void addCommentsAfter(FlexiJSonComments comments) {
    }

    @Override
    public void setParent(FlexiJSonNode parent) {
        this.parent = parent;
    }

    @Override
    public FlexiJSonNode getParent() {
        return this.parent;
    }

    @Override
    public boolean hasComments() {
        return false;
    }

    @Override
    public void writeToStream(FlexiJSonStringBuilder stringifier, FlexiJSonStringBuilder.JSONBuilderOutputStream out, int layer, LinkedList<String> path) throws IOException {
        stringifier.appendComments(this, out, layer, path);
    }

    @Override
    public void tag(FlexiMapperTags tag) {
        if (this.tags == null) {
            this.tags = new HashSet();
        }
        if (tag != null) {
            this.tags.add(tag);
        }
    }

    @Override
    public Set<FlexiMapperTags> getTags() {
        return this.tags;
    }

    public void merge(boolean mergeDifferentTypes) {
        ArrayList<FlexiCommentJsonNode> newList = new ArrayList<FlexiCommentJsonNode>();
        StringBuilder sb = new StringBuilder();
        FlexiCommentJsonNode last = null;
        HashSet<FlexiMapperTags> tags = new HashSet<FlexiMapperTags>();
        for (FlexiCommentJsonNode c : this) {
            FlexiComment com;
            if (c instanceof FlexiComment) {
                if (last != null && !mergeDifferentTypes && ((FlexiComment)c).getType() != ((FlexiComment)last).getType() && sb.length() > 0) {
                    com = new FlexiComment(sb.toString(), ((FlexiComment)last).getType(), tags);
                    com.setLocation(last.getLocation());
                    com.setParent(this);
                    newList.add(com);
                    sb.setLength(0);
                    tags.clear();
                }
                if (sb.length() > 0) {
                    sb.append("\r\n");
                }
                sb.append(((FlexiComment)c).getText());
                if (c.getTags() != null) {
                    tags.addAll(c.getTags());
                }
                last = c;
                continue;
            }
            if (sb.length() > 0) {
                com = new FlexiComment(sb.toString(), ((FlexiComment)last).getType(), FlexiMapperTags.UNKNOWN);
                com.setLocation(last.getLocation());
                com.setParent(this);
                newList.add(com);
                sb.setLength(0);
            }
            newList.add(c);
            last = null;
        }
        if (sb.length() > 0) {
            FlexiComment com = new FlexiComment(sb.toString(), ((FlexiComment)last).getType(), tags);
            com.setLocation(last.getLocation());
            com.setParent(this);
            newList.add(com);
            sb.setLength(0);
        }
        this.clear();
        this.addAll((Collection<? extends FlexiCommentJsonNode>)newList);
    }

    public void cleanUpDupes() {
        HashSet<String> dupe = new HashSet<String>();
        Iterator it = this.iterator();
        while (it.hasNext()) {
            FlexiCommentJsonNode next = (FlexiCommentJsonNode)it.next();
            if (!(next instanceof FlexiComment) || dupe.add(((FlexiComment)next).getText().replaceAll("[\r\n\\s]+", ""))) continue;
            it.remove();
        }
    }

    @Override
    public boolean remove(FlexiJSonNode node) {
        return this.remove((Object)node);
    }
}

