/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.storage.flexijson;

import java.io.IOException;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import org.appwork.storage.flexijson.FlexiCommentJsonNode;
import org.appwork.storage.flexijson.FlexiJSonComments;
import org.appwork.storage.flexijson.FlexiJSonNode;
import org.appwork.storage.flexijson.FlexiJSonObject;
import org.appwork.storage.flexijson.JSPath;
import org.appwork.storage.flexijson.KeyValueElement;
import org.appwork.storage.flexijson.mapper.FlexiMapperTags;
import org.appwork.storage.flexijson.stringify.FlexiJSonStringBuilder;
import org.appwork.storage.simplejson.ValueType;
import org.appwork.utils.ReflectionUtils;
import org.appwork.utils.StringUtils;
import org.appwork.utils.reflection.Clazz;

public class FlexiJSonValue
implements FlexiJSonNode {
    protected Object value;
    protected ValueType type;
    private FlexiJSonComments commentsBefore;
    private HashSet<FlexiMapperTags> tags;
    private FlexiJSonComments commentsAfter;
    private FlexiJSonNode parent;

    public void setValue(Object value) {
        this.value = value;
    }

    public String getStringValue() {
        return StringUtils.valueOfOrNull(this.value);
    }

    public void setType(ValueType type) {
        this.type = type;
    }

    public ValueType getType() {
        return this.type;
    }

    public Object getValue() {
        return this.value;
    }

    @Override
    public FlexiJSonComments getCommentsBefore() {
        return this.commentsBefore;
    }

    @Override
    public void tag(FlexiMapperTags tag) {
        if (this.tags == null) {
            this.tags = new HashSet();
        }
        if (tag != null) {
            this.tags.add(tag);
        }
    }

    public int hashCode() {
        return FlexiJSonValue.class.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !(obj instanceof FlexiJSonValue)) {
            return false;
        }
        FlexiJSonStringBuilder stringify = new FlexiJSonStringBuilder();
        return stringify.toJSONString((FlexiJSonValue)obj).equals(stringify.toJSONString(this));
    }

    @Override
    public Set<FlexiMapperTags> getTags() {
        return this.tags;
    }

    @Override
    public void setCommentsBefore(FlexiJSonComments commentsBefore) {
        if (commentsBefore != null) {
            commentsBefore.setParent(this);
            for (FlexiCommentJsonNode comment : commentsBefore) {
                comment.setLocation(FlexiCommentJsonNode.AttachLocation.BEFORE_VALUE);
            }
        }
        this.commentsBefore = commentsBefore;
    }

    @Override
    public FlexiJSonComments getCommentsAfter() {
        return this.commentsAfter;
    }

    @Override
    public boolean hasComments() {
        if (this.getCommentsAfter() != null && this.getCommentsAfter().size() > 0) {
            return true;
        }
        return this.getCommentsBefore() != null && this.getCommentsBefore().size() > 0;
    }

    @Override
    public void setCommentsAfter(FlexiJSonComments commentsAfter) {
        this.commentsAfter = commentsAfter;
        if (commentsAfter != null) {
            commentsAfter.setParent(this);
            for (FlexiCommentJsonNode comment : commentsAfter) {
                comment.setLocation(FlexiCommentJsonNode.AttachLocation.AFTER_VALUE);
            }
        }
    }

    @Override
    public void addCommentsBefore(FlexiJSonComments comments) {
        if (comments == null) {
            return;
        }
        comments.setParent(this);
        for (FlexiCommentJsonNode comment : comments) {
            comment.setLocation(FlexiCommentJsonNode.AttachLocation.BEFORE_VALUE);
        }
        if (this.commentsBefore == null) {
            this.commentsBefore = comments;
        } else {
            this.commentsBefore.addAll(comments);
        }
    }

    @Override
    public void addCommentsAfter(FlexiJSonComments comments) {
        if (comments == null) {
            return;
        }
        comments.setParent(this);
        for (FlexiCommentJsonNode comment : comments) {
            comment.setLocation(FlexiCommentJsonNode.AttachLocation.AFTER_VALUE);
        }
        if (this.commentsAfter == null) {
            this.commentsAfter = comments;
        } else {
            this.commentsAfter.addAll(comments);
        }
    }

    public FlexiJSonValue() {
        this.value = null;
        this.setType(ValueType.UNDEFINED);
    }

    public FlexiJSonValue(boolean b) {
        this.value = b;
        this.type = ValueType.BOOLEAN;
    }

    public String toString() {
        return this.getClass().getSimpleName() + ": " + new FlexiJSonStringBuilder().toJSONString(this);
    }

    public FlexiJSonValue(Number number) {
        this.value = number;
        this.type = Clazz.isFloatingPointNumber(number.getClass()) ? ValueType.DOUBLE : ValueType.LONG;
    }

    public FlexiJSonValue(String str) {
        if (str == null) {
            this.value = null;
            this.type = ValueType.NULL;
        } else {
            this.value = str;
            this.type = ValueType.STRING;
        }
    }

    @Override
    public void writeToStream(FlexiJSonStringBuilder stringifier, FlexiJSonStringBuilder.JSONBuilderOutputStream out, int layer, LinkedList<String> path) throws IOException {
        stringifier.appendPrimitiveValue(this, out, layer, path);
    }

    @Override
    public void setParent(FlexiJSonNode parent) {
        this.parent = parent;
    }

    @Override
    public FlexiJSonNode getParent() {
        return this.parent;
    }

    @Override
    public boolean remove(FlexiJSonNode node) {
        return FlexiJSonValue.removeCommentsFromNode(node, this);
    }

    protected static boolean removeCommentsFromNode(FlexiJSonNode toRemove, FlexiJSonNode removeFrom) {
        if (toRemove instanceof FlexiJSonComments) {
            if (toRemove == removeFrom.getCommentsAfter()) {
                removeFrom.setCommentsAfter(null);
                return true;
            }
            if (toRemove == removeFrom.getCommentsBefore()) {
                removeFrom.setCommentsBefore(null);
                return true;
            }
            FlexiJSonNode par = removeFrom.getParent();
            if (par instanceof FlexiJSonObject) {
                KeyValueElement element = ((FlexiJSonObject)par).getElementByNode(removeFrom);
                if (toRemove == element.getCommentsAfterKey()) {
                    element.setCommentsAfterKey(null);
                    return true;
                }
                if (toRemove == element.getCommentsBeforeKey()) {
                    element.setCommentsBeforeKey(null);
                    return true;
                }
            }
        }
        return false;
    }

    public <T> T getValue(Class<T> type) {
        Object v = this.getValue();
        if (Clazz.objectIsTypeOf(v, type)) {
            return (T)v;
        }
        return (T)ReflectionUtils.cast(v, type);
    }

    @Override
    public FlexiJSonNode resolvePath(JSPath parent) {
        return null;
    }
}

