/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.storage.flexijson.config;

import java.io.File;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.lang.reflect.Proxy;
import java.net.URL;
import org.appwork.exceptions.WTFException;
import org.appwork.loggingv3.LogV3;
import org.appwork.scheduler.DelayedRunnable;
import org.appwork.shutdown.ShutdownController;
import org.appwork.shutdown.ShutdownEvent;
import org.appwork.shutdown.ShutdownRequest;
import org.appwork.storage.SimpleTypeRef;
import org.appwork.storage.flexijson.FlexiJSONParser;
import org.appwork.storage.flexijson.FlexiJSonArray;
import org.appwork.storage.flexijson.FlexiJSonNode;
import org.appwork.storage.flexijson.FlexiJSonObject;
import org.appwork.storage.flexijson.FlexiParserException;
import org.appwork.storage.flexijson.config.FlexiConfigListener;
import org.appwork.storage.flexijson.mapper.FlexiJSonMapper;
import org.appwork.storage.flexijson.mapper.FlexiMapperException;
import org.appwork.storage.flexijson.mapper.interfacestorage.FlexiStorableInterface;
import org.appwork.storage.flexijson.mapper.interfacestorage.InterfaceStorage;
import org.appwork.storage.flexijson.mapper.interfacestorage.InterfaceStorageListener;
import org.appwork.storage.flexijson.stringify.FlexiJSonPrettyStringify;
import org.appwork.utils.Application;
import org.appwork.utils.DebugMode;
import org.appwork.utils.Files;
import org.appwork.utils.IO;
import org.appwork.utils.event.basic.CoreDelegate;
import org.appwork.utils.event.basic.CoreEventSender;
import org.appwork.utils.os.CrossSystem;
import org.appwork.utils.reflection.CompiledType;

public class FlexiConfigBuilder<T>
implements InterfaceStorageListener<Object> {
    protected Source source;
    protected Source[] readSources = Source.values();
    protected final Class<T> targetInterface;
    protected final File targetPath;
    protected File[] fallbacks;
    private int delayedWriteIfNoChangeFor = 2000;
    private int delayedWriteInAnyCaseAfter = 10000;
    private boolean autoWriteEnabled = true;
    private CoreEventSender<FlexiConfigListener> eventSender;
    private volatile boolean writeRequired;
    private boolean deleteFallbacksOnWrite = true;
    private boolean keepUnknownProperties = true;
    private boolean saveOnShutdownEnabled = true;
    protected T storage;
    private DelayedRunnable delayedSave;
    protected FlexiJSonMapper mapper;

    public Source getSource() {
        return this.source;
    }

    public Source[] getReadSources() {
        return this.readSources;
    }

    public FlexiConfigBuilder<T> setReadSources(Source ... readSources) {
        this.readSources = readSources;
        return this;
    }

    public File getTargetPath() {
        return this.targetPath;
    }

    public FlexiConfigBuilder(Class<T> class1, File target, File ... fallbacks) {
        if (!FlexiStorableInterface.class.isAssignableFrom(class1)) {
            LogV3.warning("WARNING: " + class1.getName() + " does not extend from " + FlexiStorableInterface.class.getName() + ". This is recommended");
        }
        if (!target.getName().endsWith(".json")) {
            throw new IllegalArgumentException(target + " must end with .json");
        }
        if (fallbacks != null) {
            for (File file : fallbacks) {
                if (file.getName().endsWith(".json")) continue;
                throw new IllegalArgumentException(file + " fallback must end with .json");
            }
        }
        this.targetInterface = class1;
        this.targetPath = target;
        this.fallbacks = fallbacks;
    }

    public int getDelayedWriteIfNoChangeFor() {
        return this.delayedWriteIfNoChangeFor;
    }

    public FlexiConfigBuilder<T> setDelayedWriteIfNoChangeFor(int delayedWriteIfNoChangeFor) {
        this.delayedWriteIfNoChangeFor = delayedWriteIfNoChangeFor;
        return this;
    }

    public int getDelayedWriteInAnyCaseAfter() {
        return this.delayedWriteInAnyCaseAfter;
    }

    public FlexiConfigBuilder<T> setDelayedWriteInAnyCaseAfter(int delayedWriteInAnyCaseAfter) {
        this.delayedWriteInAnyCaseAfter = delayedWriteInAnyCaseAfter;
        return this;
    }

    public void onShutdown() {
        if (this.isSaveOnShutdownEnabled() && this.isAutoWriteEnabled()) {
            try {
                this.writeToDisk();
            }
            catch (FlexiMapperException e) {
                this.onAutoWriteException(e);
            }
            catch (IOException e) {
                this.onAutoWriteException(e);
            }
        }
    }

    public boolean isAutoWriteEnabled() {
        return this.autoWriteEnabled;
    }

    public FlexiConfigBuilder<T> setAutoWriteEnabled(boolean autoWriteEnabled) {
        this.autoWriteEnabled = autoWriteEnabled;
        return this;
    }

    protected boolean isWriteRequired() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CoreEventSender<FlexiConfigListener> getEventSender() {
        FlexiConfigBuilder flexiConfigBuilder = this;
        synchronized (flexiConfigBuilder) {
            if (this.eventSender == null) {
                this.eventSender = new CoreEventSender();
            }
            return this.eventSender;
        }
    }

    @Override
    public void onInterfaceValueSet(final Object storage, final String key, final Object oldValue, final Object newValue) {
        InterfaceStorage<Object> handler;
        if (oldValue != null && Proxy.isProxyClass(oldValue.getClass()) && (handler = InterfaceStorage.get(oldValue)) != null) {
            handler.getEventSender().removeListener(this);
        }
        if (newValue != null && Proxy.isProxyClass(newValue.getClass()) && (handler = InterfaceStorage.get(newValue)) != null) {
            handler.getEventSender().addListener(this);
        }
        if (this.eventSender != null) {
            this.eventSender.fireEvent(new CoreDelegate<FlexiConfigListener>(){

                @Override
                protected void fireTo(FlexiConfigListener listener) {
                    listener.onValueModified(FlexiConfigBuilder.this, storage, key, oldValue, newValue);
                }
            });
        }
        this.writeRequired = true;
        if (!this.isAutoWriteEnabled()) {
            return;
        }
        if (this.getDelayedWriteInAnyCaseAfter() <= 0) {
            try {
                this.writeToDisk();
            }
            catch (FlexiMapperException e) {
                this.onAutoWriteException(e);
            }
            catch (IOException e) {
                this.onAutoWriteException(e);
            }
            return;
        }
        if (this.delayedSave == null || this.delayedSave.getMaximumDelay() != (long)this.getDelayedWriteInAnyCaseAfter() || this.delayedSave.getMinimumDelay() != (long)this.getDelayedWriteIfNoChangeFor()) {
            this.delayedSave = new DelayedRunnable((long)this.getDelayedWriteIfNoChangeFor(), (long)this.getDelayedWriteInAnyCaseAfter()){

                @Override
                public void delayedrun() {
                    try {
                        FlexiConfigBuilder.this.writeToDisk();
                    }
                    catch (FlexiMapperException e) {
                        FlexiConfigBuilder.this.onAutoWriteException(e);
                    }
                    catch (IOException e) {
                        FlexiConfigBuilder.this.onAutoWriteException(e);
                    }
                }
            };
        }
        this.delayedSave.resetAndStart();
    }

    protected void onAutoWriteException(Exception e) {
    }

    public boolean isDeleteFallbacksOnWrite() {
        return this.deleteFallbacksOnWrite;
    }

    public void setDeleteFallbacksOnWrite(boolean deleteFallbacksOnWrite) {
        this.deleteFallbacksOnWrite = deleteFallbacksOnWrite;
    }

    public synchronized void writeToDisk() throws FlexiMapperException, IOException {
        if (!this.isWriteRequired()) {
            return;
        }
        this.updateNode();
        String json = this.toJSONString();
        LogV3.info("Store FlexiConfig to disk:" + this.targetPath + "\r\n" + json);
        this.targetPath.getParentFile().mkdirs();
        IO.secureWrite(this.targetPath, json, IO.SYNC.META_AND_DATA);
        if (this.getSource() == Source.DISK && this.isDeleteFallbacksOnWrite() && this.fallbacks != null) {
            for (File fb : this.fallbacks) {
                if (!fb.isFile()) continue;
                LogV3.info("Delete Fallback file after writing to keep:" + this.targetPath + " delete:" + fb);
                fb.delete();
            }
        }
    }

    public void merge(FlexiJSonNode a, FlexiJSonNode b) {
        block7: {
            block6: {
                if (!(b instanceof FlexiJSonArray)) break block6;
                if (!(a instanceof FlexiJSonArray)) {
                    return;
                }
                if (((FlexiJSonArray)b).size() != ((FlexiJSonArray)a).size()) {
                    return;
                }
                for (int i = 0; i < ((FlexiJSonArray)a).size(); ++i) {
                    this.merge((FlexiJSonNode)((FlexiJSonArray)a).get(i), (FlexiJSonNode)((FlexiJSonArray)b).get(i));
                }
                break block7;
            }
            if (!(b instanceof FlexiJSonObject)) break block7;
            if (!(a instanceof FlexiJSonObject)) {
                return;
            }
            for (String key : ((FlexiJSonObject)b).getKeys()) {
                if (!((FlexiJSonObject)a).containsKey(key)) {
                    ((FlexiJSonObject)a).add(((FlexiJSonObject)b).getElement(key));
                    continue;
                }
                this.merge(((FlexiJSonObject)a).getNode(key), ((FlexiJSonObject)b).getNode(key));
            }
        }
    }

    protected String toJSONString() throws FlexiMapperException {
        return new FlexiJSonPrettyStringify().toJSONString(this.getBackendNode());
    }

    protected FlexiJSonNode getBackendNode() {
        return InterfaceStorage.get(this.storage).getBackendNode();
    }

    protected void updateNode() throws FlexiMapperException {
        FlexiJSonObject newNode = (FlexiJSonObject)this.mapper.objectToJsonNode(this.storage);
        this.keepUnknownProperties(newNode);
        InterfaceStorage.get(this.storage).setBackendNode(newNode);
    }

    protected void keepUnknownProperties(FlexiJSonNode newNode) {
        if (this.isKeepUnknownProperties()) {
            InterfaceStorage<T> handler = InterfaceStorage.get(this.storage);
            FlexiJSonObject jsonData = handler.getBackendNode();
            this.merge(newNode, jsonData);
        }
    }

    public boolean isKeepUnknownProperties() {
        return this.keepUnknownProperties;
    }

    public void setKeepUnknownProperties(boolean keepUnknownProperties) {
        this.keepUnknownProperties = keepUnknownProperties;
    }

    public boolean isSaveOnShutdownEnabled() {
        return this.saveOnShutdownEnabled;
    }

    public FlexiConfigBuilder<T> setSaveOnShutdownEnabled(boolean saveOnShutdown) {
        this.saveOnShutdownEnabled = saveOnShutdown;
        return this;
    }

    public T getStorageOrDefault(T defaultValue) {
        try {
            return this.getStorage();
        }
        catch (Exception e) {
            LogV3.log(e);
            if (e instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            return defaultValue;
        }
    }

    public T getStorage() throws FlexiParserException, IOException, FlexiMapperException {
        if (this.storage != null) {
            return this.storage;
        }
        FlexiJSonObject node = this.getFlexiObject();
        if (node == null) {
            node = new FlexiJSonObject();
        }
        this.mapper = this.createMapper(node);
        this.storage = this.mapper.jsonToObject((FlexiJSonNode)node, new SimpleTypeRef(this.targetInterface));
        ShutdownController.getInstance().addShutdownEvent(new ShutdownHook(this));
        return this.storage;
    }

    protected FlexiJSonObject getFlexiObject() throws FlexiParserException, IOException {
        File file = new File(this.targetPath.getAbsolutePath().replaceAll((CrossSystem.isWindows() ? "(?i)" : "") + "\\.json$", ""));
        Source[] sourceArray = this.getReadSources();
        int n = sourceArray.length;
        block5: for (int i = 0; i < n; ++i) {
            Source source;
            this.source = source = sourceArray[i];
            switch (source) {
                case CLASSPATH_ROOT: {
                    String path = Files.getRelativePath(Application.getResource(""), file);
                    URL url = this.targetInterface.getClassLoader().getResource(path + ".json");
                    if (url != null) {
                        return this.resourceToObject(file, source);
                    }
                    if (this.fallbacks == null) continue block5;
                    for (File f : this.fallbacks) {
                        path = Files.getRelativePath(Application.getResource(""), f).replaceAll((CrossSystem.isWindows() ? "(?i)" : "") + "\\.json$", "");
                        url = this.targetInterface.getClassLoader().getResource(path + ".json");
                        if (url == null) continue;
                        return this.resourceToObject(file, source);
                    }
                    continue block5;
                }
                case CLASSPATH_RELATIVE: {
                    String path = Files.getRelativePath(Application.getResource(""), file);
                    URL url = this.targetInterface.getResource(path + ".json");
                    if (url != null) {
                        return this.resourceToObject(file, source);
                    }
                    if (this.fallbacks == null) continue block5;
                    for (File f : this.fallbacks) {
                        path = Files.getRelativePath(Application.getResource(""), f).replaceAll((CrossSystem.isWindows() ? "(?i)" : "") + "\\.json$", "");
                        url = this.targetInterface.getResource(path + ".json");
                        if (url == null) continue;
                        return this.resourceToObject(file, source);
                    }
                    continue block5;
                }
                case DISK: {
                    if (new File(file.getAbsolutePath() + ".json").isFile() || this.fallbacks == null) {
                        return this.resourceToObject(file, source);
                    }
                    if (this.fallbacks == null) continue block5;
                    for (File f : this.fallbacks) {
                        File fallback = new File(f.getAbsolutePath().replaceAll((CrossSystem.isWindows() ? "(?i)" : "") + "\\.json$", ""));
                        if (!new File(fallback.getAbsolutePath() + ".json").isFile()) continue;
                        return this.resourceToObject(fallback, source);
                    }
                    continue block5;
                }
                default: {
                    DebugMode.throwInIDEElse(new WTFException("All option should be handled here"));
                }
            }
        }
        return null;
    }

    protected FlexiJSonObject resourceToObject(File resource, Source source) throws IOException, FlexiParserException {
        switch (source) {
            case CLASSPATH_ROOT: {
                String rel = Files.getRelativePath(Application.getResource(""), resource);
                String path = rel + ".json";
                URL url = this.targetInterface.getClassLoader().getResource(path);
                if (url != null) {
                    String json = IO.readURLToString(url);
                    return (FlexiJSonObject)this.createParser(json).parse();
                }
            }
            case CLASSPATH_RELATIVE: {
                String rel = Files.getRelativePath(Application.getResource(""), resource);
                String path = rel + ".json";
                URL url = this.targetInterface.getResource(path);
                if (url == null) break;
                String json = IO.readURLToString(url);
                return (FlexiJSonObject)this.createParser(json).parse();
            }
            case DISK: {
                File file = new File(resource.getAbsolutePath() + ".json");
                if (!file.isFile()) break;
                String json = IO.readFileToString(file);
                return (FlexiJSonObject)this.createParser(json).parse();
            }
            default: {
                DebugMode.throwInIDEElse(new WTFException("All option should be handled here"));
            }
        }
        return null;
    }

    public FlexiJSONParser createParser(String json) {
        return new FlexiJSONParser(json);
    }

    protected FlexiJSonMapper createMapper(FlexiJSonObject root) {
        return new FlexiJSonMapper(){

            @Override
            protected Object createProxy(CompiledType cType, FlexiJSonObject obj) throws IllegalArgumentException, SecurityException, NoSuchMethodException {
                Object proxy = super.createProxy(cType, obj);
                InterfaceStorage.get(proxy).getEventSender().addListener(FlexiConfigBuilder.this);
                return proxy;
            }

            @Override
            protected InterfaceStorage<Object> createInterfaceInvocationHandler(CompiledType type, FlexiJSonObject obj) throws SecurityException, NoSuchMethodException {
                return super.createInterfaceInvocationHandler(type, obj);
            }
        };
    }

    public static FlexiConfigBuilder<?> get(FlexiStorableInterface storage) {
        InterfaceStorage handler = FlexiConfigBuilder.getStorage(storage);
        if (handler == null) {
            return null;
        }
        for (Object l : handler.getEventSender().getListener()) {
            if (!(l instanceof FlexiConfigBuilder)) continue;
            return (FlexiConfigBuilder)l;
        }
        return null;
    }

    public static InterfaceStorage getStorage(FlexiStorableInterface storage) {
        return InterfaceStorage.get(storage);
    }

    public static enum Source {
        DISK,
        CLASSPATH_ROOT,
        CLASSPATH_RELATIVE;

    }

    public static class ShutdownHook
    extends ShutdownEvent {
        private WeakReference<FlexiConfigBuilder> builder;

        public ShutdownHook(FlexiConfigBuilder builder) {
            this.builder = new WeakReference<FlexiConfigBuilder>(builder);
        }

        @Override
        public long getMaxDuration() {
            return 0L;
        }

        @Override
        public int getHookPriority() {
            return 0;
        }

        @Override
        public void onShutdown(ShutdownRequest shutdownRequest) {
            FlexiConfigBuilder actualStorage = (FlexiConfigBuilder)this.builder.get();
            if (actualStorage != null) {
                actualStorage.onShutdown();
            }
        }

        @Override
        public String toString() {
            return "ShutdownEvent: Save FlexiConfig.";
        }
    }
}

