/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.storage.flexijson.mapper.interfacestorage;

import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.util.ArrayList;
import java.util.List;
import org.appwork.storage.flexijson.mapper.interfacestorage.InterfaceStorage;
import org.appwork.storage.flexijson.mapper.interfacestorage.KeyHandlerException;
import org.appwork.storage.flexijson.mapper.interfacestorage.PropertyHandler;
import org.appwork.storage.flexijson.mapper.interfacestorage.PropertyHandlerListener;
import org.appwork.storage.simplejson.mapper.Getter;
import org.appwork.storage.simplejson.mapper.Setter;
import org.appwork.utils.event.basic.CoreDelegate;
import org.appwork.utils.event.basic.CoreEventSender;

public class PropertyHandlerImpl<InterfaceType, ReturnType>
implements PropertyHandler<InterfaceType, ReturnType> {
    private static final Object[] EMPTY = new Object[0];
    public final InterfaceStorage<InterfaceType> handler;
    public final String key;
    public final Class<ReturnType> clazz;
    private Getter getterMethod;
    private Setter setterMethod;
    private CoreEventSender<PropertyHandlerListener<InterfaceType, ReturnType>> eventSender;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CoreEventSender<PropertyHandlerListener<InterfaceType, ReturnType>> getEventSender() {
        PropertyHandlerImpl propertyHandlerImpl = this;
        synchronized (propertyHandlerImpl) {
            if (this.eventSender == null) {
                this.eventSender = new CoreEventSender();
            }
            return this.eventSender;
        }
    }

    public PropertyHandlerImpl(InterfaceStorage<InterfaceType> handler, String key, Class<ReturnType> clazz) {
        this.handler = handler;
        this.key = key;
        this.clazz = clazz;
        this.getterMethod = handler.cType.getClassCache().getGetter(key);
        this.setterMethod = handler.cType.getClassCache().getSetter(key);
    }

    @Override
    public ReturnType get() {
        try {
            if (this.getterMethod == null) {
                throw new IllegalStateException("No " + this.key + "-Getter Method available in " + this.handler.cType);
            }
            return (ReturnType)this.handler.invoke(null, this.getterMethod.getMethod(), EMPTY);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new KeyHandlerException(e);
        }
        catch (Throwable e) {
            throw new KeyHandlerException(e);
        }
    }

    @Override
    public void fireEventSet(final ReturnType oldValue, final ReturnType newValue) {
        CoreEventSender<PropertyHandlerListener<InterfaceType, ReturnType>> es = this.eventSender;
        if (es != null) {
            es.fireEvent(new CoreDelegate<PropertyHandlerListener<InterfaceType, ReturnType>>(){

                @Override
                protected void fireTo(PropertyHandlerListener<InterfaceType, ReturnType> listener) {
                    listener.onInterfaceValueSet(PropertyHandlerImpl.this.handler.getStorage(), PropertyHandlerImpl.this, oldValue, newValue);
                }
            });
        }
    }

    @Override
    public void set(ReturnType value) {
        try {
            if (this.setterMethod == null) {
                throw new IllegalStateException("No " + this.key + "-Setter Method available in " + this.handler.cType);
            }
            this.handler.invoke(null, this.setterMethod.getMethod(), new Object[]{value});
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new KeyHandlerException(e);
        }
        catch (Throwable e) {
            throw new KeyHandlerException(e);
        }
    }

    @Override
    public InterfaceType getStorage() {
        return this.handler.getStorage();
    }

    @Override
    public <AnnoType extends Annotation> List<AnnoType> getAnnotations(Class<AnnoType> type) {
        Annotation[] annos;
        ArrayList ret = new ArrayList();
        AccessibleObject field = null;
        if (this.getterMethod != null) {
            annos = this.getterMethod.getMethod().getAnnotations();
            this.collect(type, ret, annos);
            field = this.getterMethod.field;
        }
        if (this.setterMethod != null) {
            annos = this.setterMethod.getMethod().getAnnotations();
            this.collect(type, ret, annos);
            if (field == null) {
                field = this.setterMethod.field;
            }
        }
        if (field != null) {
            annos = field.getAnnotations();
            this.collect(type, ret, annos);
        }
        return ret;
    }

    public <AnnoType extends Annotation> void collect(Class<AnnoType> type, ArrayList<AnnoType> ret, Annotation[] annos) {
        if (annos != null) {
            for (Annotation a : annos) {
                if (!type.isAssignableFrom(a.getClass())) continue;
                ret.add(a);
            }
        }
    }

    @Override
    public String getKey() {
        return this.key;
    }
}

