/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.storage.flexijson.stringify;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.appwork.exceptions.WTFException;
import org.appwork.storage.flexijson.FlexiComment;
import org.appwork.storage.flexijson.FlexiCommentJsonNode;
import org.appwork.storage.flexijson.FlexiJSonArray;
import org.appwork.storage.flexijson.FlexiJSonComments;
import org.appwork.storage.flexijson.FlexiJSonNode;
import org.appwork.storage.flexijson.FlexiJSonObject;
import org.appwork.storage.flexijson.FlexiJSonValue;
import org.appwork.storage.flexijson.KeyValueElement;
import org.appwork.storage.flexijson.mapper.FlexiMapperTags;
import org.appwork.storage.flexijson.stringify.FlexiJSonStringBuilder;
import org.appwork.utils.ReusableByteArrayOutputStream;
import org.appwork.utils.StringUtils;

public class FlexiJSonPrettyStringify
extends FlexiJSonStringBuilder {
    private static final int COMPACT_ARRAY_THRESHOLD = 40;

    @Override
    protected void initTags(Charset charset) {
        super.initTags(charset);
        this.lineCommentStart = "// ".getBytes(charset);
        this.inlineCommentStart = "/* ".getBytes(charset);
        this.inlineCommendEnd = " */".getBytes(charset);
    }

    @Override
    public String toJSONString(FlexiJSonNode node, LinkedList<String> path) {
        return super.toJSONString(node, path);
    }

    @Override
    public void appendObject(FlexiJSonObject object, FlexiJSonStringBuilder.JSONBuilderOutputStream out, int layer, LinkedList<String> path) throws IOException {
        FlexiJSonComments b = object.getCommentsBefore();
        FlexiJSonComments a = object.getCommentsAfter();
        if (b != null && b.size() > 0) {
            b.writeToStream(this, out, layer, path);
            this.newLineIfRequired(out, layer);
        }
        this.writeIfNotEOL(out);
        if (this.lastWasNewlineOrIndent(out)) {
            this.spaces(out, layer);
        }
        if (object.getElements().size() == 0) {
            out.write(this.objectOpenTag);
            if (object.getCommentsInside() != null && object.getCommentsInside().size() > 0) {
                this.newLineIfRequired(out, layer + this.getLayerIndent());
                boolean firstComment = true;
                for (FlexiCommentJsonNode c : object.getCommentsInside()) {
                    if (firstComment) {
                        firstComment = false;
                    } else {
                        out.write(this.newLineRN);
                    }
                    c.writeToStream(this, out, layer + this.getLayerIndent(), path);
                }
                this.newLineIfRequired(out, layer);
            }
            out.write(this.objectCloseTag);
        } else {
            out.write(this.objectOpenTag);
            if (object.getCommentsInside() != null && object.getCommentsInside().size() > 0) {
                boolean firstComment = true;
                for (FlexiCommentJsonNode c : object.getCommentsInside()) {
                    if (firstComment) {
                        firstComment = false;
                    } else {
                        out.write(this.newLineRN);
                    }
                    c.writeToStream(this, out, layer + 1, path);
                }
            }
            boolean singleLine = true;
            boolean firstElement = true;
            boolean afterKeyValueEntry = false;
            int i = -1;
            for (KeyValueElement es : object.getElements()) {
                if (this.skipElement(object, es)) continue;
                ++i;
                this.writeIfNotEOL(out);
                if (firstElement) {
                    firstElement = false;
                    boolean bl = singleLine = object.size() <= 1 && es.getValue() instanceof FlexiJSonValue;
                    if (object.hasCommentsInside()) {
                        singleLine = false;
                    }
                    if (es.getValue().hasComments()) {
                        singleLine = false;
                    }
                    if (es.hasComments()) {
                        singleLine = false;
                    }
                } else {
                    if (out.getLastByteFromBackBuffer() == 123) {
                        this.newLineIfRequired(out, layer);
                        if (out.getLastByteFromBackBuffer() != 123) {
                            singleLine = false;
                        }
                    }
                    if (afterKeyValueEntry) {
                        if (this.lastWasNewlineOrIndent(out)) {
                            if (out.lastWasNewline()) {
                                this.spaces(out, layer + this.getLayerIndent());
                            }
                            out.write(this.commaString);
                        } else {
                            out.write(this.commaString);
                        }
                        afterKeyValueEntry = false;
                    }
                }
                afterKeyValueEntry = true;
                if (es.getCommentsBeforeKey() != null && es.getCommentsBeforeKey().size() > 0) {
                    this.newLineIfRequired(out, layer + this.getLayerIndent());
                    es.getCommentsBeforeKey().writeToStream(this, out, layer + this.getLayerIndent(), path);
                }
                if (es.getKey() == null) continue;
                this.writeIfNotEOL(out);
                if (!singleLine) {
                    this.newLineIfRequired(out, layer + this.getLayerIndent());
                }
                Set<FlexiMapperTags> tags = es.getValue().getTags();
                if (this.isWriteDefaultValuesAsComment(object, es.getValue(), path) && tags != null && tags.contains((Object)FlexiMapperTags.DEFAULT_VALUE)) {
                    ReusableByteArrayOutputStream baos = new ReusableByteArrayOutputStream(60);
                    FlexiJSonStringBuilder.JSONBuilderOutputStream tmp = new FlexiJSonStringBuilder.JSONBuilderOutputStream(baos, out.charset);
                    this.appendString(tmp, es.getKey());
                    if (es.getCommentsAfterKey() != null && es.getCommentsAfterKey().size() > 0) {
                        es.getCommentsAfterKey().writeToStream(this, tmp, 1, path);
                    }
                    if (this.writeIfNotEOL(tmp)) {
                        this.newLineIfRequired(tmp, this.getLayerIndent());
                    }
                    tmp.write(this.collonString);
                    es.getValue().writeToStream(this, tmp, this.getLayerIndent(), path);
                    boolean thereIsAnotherKeyValueEntry = false;
                    for (int forward = i + 1; forward < object.getElements().size(); ++forward) {
                        KeyValueElement el = object.getElements().get(forward);
                        if (el.getKey() == null) continue;
                        thereIsAnotherKeyValueEntry = true;
                        break;
                    }
                    if (thereIsAnotherKeyValueEntry) {
                        tmp.write(this.commaString);
                        afterKeyValueEntry = false;
                    }
                    FlexiComment dummyComment = new FlexiComment(new String(baos.toByteArray(), out.charset), FlexiComment.Type.LINE, FlexiMapperTags.DEFAULT_VALUE);
                    dummyComment.setLocation(FlexiCommentJsonNode.AttachLocation.INSIDE_OBJECT);
                    dummyComment.writeToStream(this, out, layer, path);
                    continue;
                }
                this.appendString(out, es.getKey());
                if (es.getCommentsAfterKey() != null && es.getCommentsAfterKey().size() > 0) {
                    es.getCommentsAfterKey().writeToStream(this, out, layer + 1, path);
                }
                if (this.writeIfNotEOL(out)) {
                    this.newLineIfRequired(out, layer + this.getLayerIndent());
                }
                out.write(this.collonString);
                es.getValue().writeToStream(this, out, layer + this.getLayerIndent(), path);
            }
            if (!singleLine || out.lastWasNewline()) {
                this.newLineIfRequired(out, layer);
            }
            out.write(this.objectCloseTag);
        }
        if (a != null && a.size() > 0) {
            a.writeToStream(this, out, layer, path);
        }
    }

    protected boolean skipElement(FlexiJSonObject object, KeyValueElement es) {
        return false;
    }

    protected boolean skipElement(FlexiJSonArray array, int i) {
        return false;
    }

    public boolean isWriteDefaultValuesAsComment(FlexiJSonObject object, FlexiJSonNode value, LinkedList<String> path) {
        return false;
    }

    protected boolean lastWasNewlineOrIndent(FlexiJSonStringBuilder.JSONBuilderOutputStream out) {
        return out.getLastNewLineIndex() >= 0L;
    }

    protected int getLayerIndent() {
        return 2;
    }

    private int spaces(FlexiJSonStringBuilder.JSONBuilderOutputStream out, int layer) throws IOException {
        if (layer > 0) {
            this.writeIfNotEOL(out);
        }
        for (int i = 0; i < layer; ++i) {
            out.write(this.spaceString);
        }
        return layer;
    }

    @Override
    protected void appendPrimitiveValueWithoutComments(FlexiJSonValue value, FlexiJSonStringBuilder.JSONBuilderOutputStream out, LinkedList<String> path, int layer) throws IOException {
        this.writeIfNotEOL(out);
        if (out.lastWasNewline()) {
            this.spaces(out, layer);
        }
        super.appendPrimitiveValueWithoutComments(value, out, path, layer);
    }

    @Override
    public void appendPrimitiveValue(FlexiJSonValue value, FlexiJSonStringBuilder.JSONBuilderOutputStream out, int layer, LinkedList<String> path) throws IOException {
        this.writeIfNotEOL(out);
        FlexiJSonComments b = value.getCommentsBefore();
        FlexiJSonComments a = value.getCommentsAfter();
        if (b != null && b.size() > 0) {
            b.writeToStream(this, out, layer, path);
            if (value.getParent() instanceof FlexiJSonArray && !out.compactArrayMode) {
                this.newLineIfRequired(out, layer);
            }
        }
        this.appendPrimitiveValueWithoutComments(value, out, path, layer);
        if (a != null && a.size() > 0) {
            a.writeToStream(this, out, layer, path);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void appendArray(FlexiJSonArray array, FlexiJSonStringBuilder.JSONBuilderOutputStream out, int layer, LinkedList<String> path) throws IOException {
        try {
            ReusableByteArrayOutputStream baos = new ReusableByteArrayOutputStream(60);
            FlexiJSonStringBuilder.JSONBuilderOutputStream tmp = new FlexiJSonStringBuilder.JSONBuilderOutputStream(baos, this.charset);
            tmp.compactArrayMode = true;
            out.compactArrayMode = true;
            FlexiJSonComments b = array.getCommentsBefore();
            FlexiJSonComments a = array.getCommentsAfter();
            boolean singleLine = array.size() <= 1;
            block6: for (int t = 0; t < 2; ++t) {
                if (b != null && b.size() > 0) {
                    b.writeToStream(this, tmp == null ? out : tmp, layer, path);
                    this.writeIfNotEOL(tmp == null ? out : tmp);
                    if (tmp == null && !this.lastWasNewlineOrIndent(tmp == null ? out : tmp)) {
                        (tmp == null ? out : tmp).write(this.newLineRN);
                    }
                }
                if (this.lastWasNewlineOrIndent(out) || tmp != null && this.lastWasNewlineOrIndent(tmp)) {
                    this.spaces(tmp == null ? out : tmp, layer);
                }
                (tmp == null ? out : tmp).write(this.arrayOpenTag);
                boolean firstElement = true;
                for (int i = 0; i < array.size(); ++i) {
                    if (this.skipElement(array, i)) continue;
                    try {
                        path.add("[" + i + "]");
                        FlexiJSonNode n = (FlexiJSonNode)array.get(i);
                        if (firstElement) {
                            firstElement = false;
                            if (!(tmp == null ? out : tmp).compactArrayMode && !singleLine) {
                                (tmp == null ? out : tmp).write(this.newLineRN);
                            }
                        } else {
                            FlexiJSonStringBuilder.JSONBuilderOutputStream os = tmp == null ? out : tmp;
                            os.write(this.commaString);
                            if (out.compactArrayMode || singleLine) {
                                os.write(this.spaceString);
                            } else {
                                os.write(this.newLineRN);
                            }
                        }
                        if (tmp != null && !(n instanceof FlexiJSonValue)) {
                            tmp.close();
                            baos = null;
                            tmp = null;
                            out.compactArrayMode = false;
                            continue block6;
                        }
                        if (out.compactArrayMode) {
                            n.writeToStream(this, tmp == null ? out : tmp, 0, path);
                        } else {
                            n.writeToStream(this, tmp == null ? out : tmp, layer + (singleLine ? 0 : this.getLayerIndent()), path);
                        }
                        if (tmp == null || tmp.transferedBytes() <= 40L) continue;
                        tmp.close();
                        baos = null;
                        tmp = null;
                        out.compactArrayMode = false;
                        continue block6;
                    }
                    finally {
                        path.removeLast();
                    }
                }
                if (array.getCommentsInside() != null && array.getCommentsInside().size() > 0) {
                    if (!firstElement) {
                        FlexiJSonStringBuilder.JSONBuilderOutputStream os = tmp == null ? out : tmp;
                        os.write(this.commaString);
                        os.write(this.spaceString);
                    }
                    array.getCommentsInside().writeToStream(this, tmp == null ? out : tmp, layer + this.getLayerIndent(), path);
                }
                if (out.compactArrayMode) {
                    if (this.lastWasNewlineOrIndent(tmp == null ? out : tmp)) {
                        this.spaces(tmp == null ? out : tmp, layer);
                    }
                    (tmp == null ? out : tmp).write(this.arrayCloseTag);
                } else {
                    if ((tmp == null ? out : tmp).getLastByteFromBackBuffer() != 91 && !singleLine) {
                        this.newLineIfRequired(tmp == null ? out : tmp, layer);
                    }
                    (tmp == null ? out : tmp).write(this.arrayCloseTag);
                }
                if (a != null && a.size() > 0) {
                    if (tmp == null) {
                        out.write(this.newLineRN);
                    }
                    a.writeToStream(this, tmp == null ? out : tmp, layer, path);
                }
                if (tmp == null) break;
                if (tmp != null && tmp.transferedBytes() > 40L || this.hasNewline(baos)) {
                    tmp.close();
                    baos = null;
                    tmp = null;
                    out.compactArrayMode = false;
                    continue;
                }
                if (tmp == null) continue;
                tmp.close();
                out.write(baos.toByteArray());
                break;
            }
            out.compactArrayMode = false;
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw new WTFException(e);
        }
    }

    private boolean hasNewline(ByteArrayOutputStream baos) {
        block6: {
            if (baos.size() < this.newLineRN.length) break block6;
            if (baos instanceof ReusableByteArrayOutputStream) {
                byte[] bytes = ((ReusableByteArrayOutputStream)baos).getInternalBuffer();
                block0: for (int i = 0; i < baos.size() - this.newLineRN.length + 1; ++i) {
                    for (int check = 0; check < this.newLineRN.length; ++check) {
                        if (bytes[i + check] != this.newLineRN[check]) continue block0;
                    }
                    return true;
                }
            } else {
                byte[] bytes = baos.toByteArray();
                block2: for (int i = 0; i < bytes.length - this.newLineRN.length + 1; ++i) {
                    for (int check = 0; check < this.newLineRN.length; ++check) {
                        if (bytes[i + check] != this.newLineRN[check]) continue block2;
                    }
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public void appendComment(FlexiComment comment, FlexiJSonStringBuilder.JSONBuilderOutputStream out, int layer, LinkedList<String> path) throws IOException {
        this.writeIfNotEOL(out);
        if (comment.getType() == FlexiComment.Type.LINE) {
            if (out.lastWasNewline()) {
                this.spaces(out, layer);
            }
            String[] lines = this.getCommentLines(comment);
            for (int i = 0; i < lines.length; ++i) {
                if (i > 0) {
                    this.newLineIfRequired(out, layer);
                }
                this.writeIfNotEOL(out);
                this.bytesToStream(out, this.lineCommentStart);
                this.stringToStream(out, lines[i]);
                this.ifNotEOL = this.lineCommentEnd;
            }
        } else {
            this.writeIfNotEOL(out);
            String[] lines = this.getCommentLines(comment);
            if (lines.length > 1) {
                this.newLineIfRequired(out, layer);
                this.stringToStream(out, "/*");
                for (int i = 0; i < lines.length; ++i) {
                    this.stringToStream(out, "\r\n");
                    this.spaces(out, layer + 1);
                    this.stringToStream(out, "* ");
                    this.stringToStream(out, lines[i]);
                }
                this.stringToStream(out, "\r\n");
                this.spaces(out, layer + 1);
                this.stringToStream(out, "*/");
                this.ifNotEOL = this.lineCommentEnd;
            } else {
                boolean newline;
                boolean bl = newline = !out.compactArrayMode;
                if (comment.getLocation() == null) {
                    throw new WTFException();
                }
                switch (comment.getLocation()) {
                    case AFTER_KEY: 
                    case BEFORE_VALUE: 
                    case AFTER_VALUE: {
                        newline = false;
                        break;
                    }
                }
                if (newline) {
                    this.newLineIfRequired(out, layer);
                } else if (out.lastWasNewline()) {
                    this.spaces(out, layer);
                }
                this.stringToStream(out, "/* ");
                this.stringToStream(out, comment.getText().trim());
                this.stringToStream(out, " */");
            }
        }
    }

    protected String[] getCommentLines(FlexiComment comment) {
        ArrayList<String> ret = new ArrayList<String>();
        int max = 200;
        for (String line : comment.getText().split("[\r\n]{1,2}")) {
            int end;
            int offset = 0;
            int lastAssign = -1;
            do {
                if ((end = line.length()) - offset > max) {
                    end = offset + max;
                }
                if (offset > 0) {
                    if (lastAssign < 0) {
                        Pattern assignPattern = Pattern.compile("(^\\s*[\\w\\d]+: )");
                        Matcher matcher = assignPattern.matcher(line);
                        lastAssign = matcher.find() ? matcher.group(1).length() : 0;
                    }
                    if (end - offset + lastAssign > max) {
                        end -= lastAssign;
                    }
                }
                ret.add(StringUtils.fillPost("", " ", lastAssign) + line.substring(offset, end));
                offset = end;
            } while (end != line.length());
        }
        return ret.toArray(new String[0]);
    }

    protected void newLineIfRequired(FlexiJSonStringBuilder.JSONBuilderOutputStream out, int layer) throws IOException {
        this.writeIfNotEOL(out);
        if (!out.lastWasNewline() && out.transferedBytes() > 0L) {
            if (this.lastWasNewlineOrIndent(out)) {
                return;
            }
            this.stringToStream(out, "\r\n");
            this.spaces(out, layer);
        } else {
            this.spaces(out, layer);
        }
    }

    @Override
    public void appendComments(FlexiJSonComments comments, FlexiJSonStringBuilder.JSONBuilderOutputStream out, int layer, LinkedList<String> path) throws IOException {
        for (FlexiCommentJsonNode c : comments) {
            FlexiJSonNode p = comments.getParent();
            c.writeToStream(this, out, layer, path);
        }
    }
}

