/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.storage.flexijson.tests;

import java.lang.reflect.Type;
import org.appwork.storage.SimpleTypeRef;
import org.appwork.storage.flexijson.FlexiJSONParser;
import org.appwork.storage.flexijson.FlexiJSonNode;
import org.appwork.storage.flexijson.FlexiUtils;
import org.appwork.storage.flexijson.mapper.FlexiJSonMapper;
import org.appwork.storage.flexijson.parserextension.TimeSpanParserExtension;
import org.appwork.storage.flexijson.stringify.FlexiJSonStringBuilder;
import org.appwork.storage.flexijson.tests.ObjectContainsAll;
import org.appwork.testframework.AWTest;
import org.appwork.utils.duration.TimeSpan;
import org.appwork.utils.reflection.CompiledType;

public class FlexiBasicFieldTypesTest
extends AWTest {
    @Override
    public void runTest() throws Exception {
        FlexiJSonMapper mapper = new FlexiJSonMapper();
        FlexiJSONParser parser = new FlexiJSONParser("{\"timespan\":1Y!365}");
        parser.addExtension(new TimeSpanParserExtension());
        ObjectContainsAll restored = (ObjectContainsAll)mapper.jsonToObject(parser.parse(), CompiledType.create(ObjectContainsAll.class));
        FlexiBasicFieldTypesTest.assertThat(restored.getTimespan()).is(TimeSpan.parse("1Y!365"));
        ObjectContainsAll ie = new ObjectContainsAll();
        FlexiJSonNode node = mapper.objectToJsonNode(ie);
        String serialized = new FlexiJSonStringBuilder().toJSONString(node);
        String expected = "{\"arrayList\":[\"eins\",\"drei\"],\"booleanWrapper\":true,\"booleanWrapperNull\":null,\"bytePrimitive\":127,\"byteWrapper\":-128,\"byteWrapperNull\":null,\"charPrimitive\":65535,\"character\":0,\"characterNull\":null,\"charsequence\":\"char seq\",\"charsequenceNull\":null,\"date\":\"2022-01-02T01:02:03 CET\",\"doublePrimitive\":1.7976931348623157E308,\"doubleWrapper\":4.9E-324,\"doubleWrapperNull\":null,\"enumField\":\"DIR\",\"enumFieldNull\":null,\"floatPrimitive\":3.4028235E38,\"floatWrapper\":1.4E-45,\"floatWrapperNull\":null,\"hashMap\":{\"eins\":1,\"zwei\":2},\"hashSet\":[1,4,7],\"intArray\":[1,2,3],\"intPrimitive\":2147483647,\"intWrapper\":-2147483648,\"intWrapperNull\":null,\"integerArray\":[1,null,3],\"interfaceField\":{\"bool\":true},\"list\":[\"eins\",\"drei\"],\"listWithoutGen\":[\"eins\",\"drei\"],\"longPrimitive\":-9223372036854775808,\"longWrapper\":9223372036854775807,\"longWrapperNull\":null,\"map\":{\"eins\":1,\"zwei\":2},\"mapWithoutGen\":{\"eins\":1,\"zwei\":2},\"nullList\":null,\"nullMap\":null,\"nullSet\":null,\"objectHashSet\":[1,4,7],\"objectWithByte\":127,\"objectWithFloat\":1.4E-45,\"set\":[1,4,7],\"setWithoutGen\":[1,4,7],\"shortNull\":null,\"shortPrimitive\":32767,\"shortWrapper\":-32768,\"stringField\":\"fsdajbfdshbdfs98h\",\"stringFieldNull\":null,\"timespan\":\"10h15m\",\"booleanPrimitive\":false}";
        FlexiBasicFieldTypesTest.assertEquals(serialized, expected);
        FlexiJSonNode restoredNode = new FlexiJSONParser(serialized).parse();
        FlexiBasicFieldTypesTest.assertEquals(serialized, new FlexiJSonStringBuilder().toJSONString(restoredNode));
        ObjectContainsAll restoredIE = (ObjectContainsAll)mapper.jsonToObject(restoredNode, new SimpleTypeRef((Type)((Object)ObjectContainsAll.class)));
        System.out.println(FlexiUtils.serializeToPrettyJson(restoredIE));
        System.out.println(FlexiUtils.serializeToPrettyJson(ie));
        this.assertEqualsDeepNot(restoredIE, ie);
        FlexiJSonNode node2 = mapper.objectToJsonNode(restoredIE);
        String serialized2 = new FlexiJSonStringBuilder().toJSONString(node2);
        FlexiBasicFieldTypesTest.assertEquals(serialized, serialized2);
    }

    public static void main(String[] args) {
        FlexiBasicFieldTypesTest.run();
    }
}

