/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.storage.simplejson.mapper;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import org.appwork.storage.simplejson.mapper.ClassCache;
import org.appwork.storage.simplejson.mapper.Getter;
import org.appwork.storage.simplejson.mapper.Setter;
import org.appwork.utils.reflection.CompiledType;

public class Property {
    public final String key;
    public final CompiledType type;
    public final Getter getter;
    public final Setter setter;

    public Property(String key, CompiledType type, Getter getter, Setter setter) {
        this.key = key;
        this.type = type;
        this.getter = getter;
        this.setter = setter;
    }

    public int hashCode() {
        return this.type.hashCode() + this.key.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof Property) {
            Property other = (Property)obj;
            if (this.type.equals(other.type) && this.key.equals(other.key) && this.getGetterMethod() == other.getGetterMethod() && this.getSetterMethod() == other.getSetterMethod()) {
                return true;
            }
        }
        return false;
    }

    public Method getSetterMethod() {
        return this.setter == null ? null : this.setter.getMethod();
    }

    public Method getGetterMethod() {
        return this.getter == null ? null : this.getter.getMethod();
    }

    public ClassCache getClassCache() {
        if (this.getter != null) {
            return this.getter.classCache;
        }
        return null;
    }

    public Type getGenericType() {
        Method method;
        Field field = null;
        if (this.getter != null) {
            method = this.getter.getMethod();
            if (method != null) {
                return method.getGenericReturnType();
            }
            field = this.getter.getField();
        }
        if (this.setter != null) {
            method = this.setter.getMethod();
            if (method != null) {
                return method.getGenericParameterTypes()[0];
            }
            if (field == null) {
                field = this.setter.getField();
            }
        }
        if (field != null) {
            return field.getGenericType();
        }
        return null;
    }
}

