/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.storage.tests;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.appwork.exceptions.WTFException;
import org.appwork.loggingv3.LogV3;
import org.appwork.remoteapi.annotations.AllowNonStorableObjects;
import org.appwork.storage.InvalidTypeException;
import org.appwork.storage.JSonStorage;
import org.appwork.storage.MapperType;
import org.appwork.storage.Storable;
import org.appwork.storage.StorableAllowPrivateAccessModifier;
import org.appwork.storage.StorableAllowProtectedAccessModifier;
import org.appwork.storage.StorableSupportedMappers;
import org.appwork.storage.StorableValidatorIgnoresMissingGetter;
import org.appwork.storage.StorableValidatorIgnoresMissingSetter;
import org.appwork.storage.TypeRef;
import org.appwork.storage.config.annotations.DefaultEnumArrayValue;
import org.appwork.storage.config.annotations.DefaultEnumValue;
import org.appwork.storage.config.annotations.DefaultJsonObject;
import org.appwork.storage.config.test.BadTestObject;
import org.appwork.storage.flexijson.mapper.interfacestorage.FlexiStorableInterface;
import org.appwork.storage.simplejson.mapper.ClassCache;
import org.appwork.storage.simplejson.mapper.Getter;
import org.appwork.storage.simplejson.mapper.Setter;
import org.appwork.storage.simplejson.mapper.test.TestClass;
import org.appwork.storage.tests.BadCollectionExtends;
import org.appwork.storage.tests.BadMapExtends;
import org.appwork.storage.tests.ClassPathScanner;
import org.appwork.testframework.AWTest;
import org.appwork.testframework.IgnoreInAWTest;
import org.appwork.utils.ReflectionUtils;
import org.appwork.utils.duration.TimeSpan;
import org.appwork.utils.reflection.Clazz;
import org.appwork.utils.reflection.CompiledType;

public class StorableValidatorTest
extends AWTest {
    public static void main(String[] args) {
        StorableValidatorTest.run();
    }

    @Override
    public void runTest() throws Exception {
        new ClassPathScanner<Exception>(){

            @Override
            public void handle(Class<?> cls) throws Exception {
                if (Storable.class.isAssignableFrom(cls) && Storable.class != cls) {
                    if (cls == BadCollectionExtends.class) {
                        try {
                            StorableValidatorTest.this.validateClass(cls);
                            throw new Exception("Expected Validation Exception");
                        }
                        catch (Exception e) {
                            String message = e.getMessage();
                            if (!"WARNING: package org.appwork.storage.tests(BadCollectionExtends.java:1) is a List and will not de/serialize setters or getters".equals(message)) {
                                throw new Exception("Expected a differend message", e);
                            }
                            return;
                        }
                    }
                    if (cls == BadMapExtends.class) {
                        try {
                            StorableValidatorTest.this.validateClass(cls);
                            throw new Exception("Expected Validation Exception");
                        }
                        catch (Exception e) {
                            String message = e.getMessage();
                            if (!"WARNING: package org.appwork.storage.tests(BadMapExtends.java:1) is a Map and will not de/serialize setters or getters".equals(message)) {
                                throw new Exception("Expected a differend message", e);
                            }
                            return;
                        }
                    }
                    StorableValidatorTest.this.validateClass(cls);
                }
            }
        }.run();
    }

    protected boolean skipValidation(Class<?> cls) throws Exception {
        if (cls == null) {
            return false;
        }
        try {
            List<IgnoreInAWTest> ignore = ClassCache.getClassCache(cls).getAnnotations(null, IgnoreInAWTest.class);
            if (ignore.size() > 0) {
                return true;
            }
            List<StorableSupportedMappers> annotations = ClassCache.getClassCache(cls).getAnnotations(null, StorableSupportedMappers.class);
            if (annotations != null) {
                for (StorableSupportedMappers a : annotations) {
                    if (Arrays.asList(a.value()).contains((Object)MapperType.AW_SIMPLE)) continue;
                    return true;
                }
            }
            if (BadTestObject.class == cls) {
                return true;
            }
            if (TestClass.class == cls) {
                return true;
            }
            if (cls.getAnnotation(IgnoreInAWTest.class) != null) {
                return true;
            }
            return cls.isInterface() || Modifier.isAbstract(cls.getModifiers());
        }
        catch (Throwable e) {
            throw new WTFException("Error in " + cls, e);
        }
    }

    protected void checkMissingConstructor(Class<?> cls) throws Exception {
        if (!cls.isAnonymousClass()) {
            try {
                Constructor<?> c = cls.getDeclaredConstructor(new Class[0]);
                if (Modifier.isPrivate(c.getModifiers()) && c.getAnnotation(StorableAllowPrivateAccessModifier.class) == null) {
                    throw new Exception("Found private constructor. Change modifier or add @StorableAllowPrivateAccessModifier Annotation: " + c);
                }
                if (!Modifier.isPrivate(c.getModifiers()) && !Modifier.isPublic(c.getModifiers()) && c.getAnnotation(StorableAllowProtectedAccessModifier.class) == null) {
                    throw new Exception("Found protected constructor. Change modifier or add @StorableAllowProtectedAccessModifier Annotation: " + c);
                }
            }
            catch (NoSuchMethodException e) {
                throw new Exception("Empty Constructor missing in " + cls.getPackage().toString() + " (" + cls.getSimpleName() + ".java:1)");
            }
        }
    }

    protected ClassCache createClassCache(Class<?> cls) throws Exception {
        return ClassCache.create(cls, new ClassCache.Rules());
    }

    protected void checkNoGetterSetter(ClassCache classCache, Class<?> cls) throws Exception {
        if (classCache.getKeys().size() == 0) {
            throw new Exception("The Storable " + this.link(cls) + " has no getters or setters!");
        }
    }

    protected void checkAnnotations(ClassCache classCache, Class<?> cls, Method method) throws Exception {
        Class<?> retClazz;
        Type rawType = method.getReturnType();
        if (Void.TYPE.equals(rawType)) {
            rawType = method.getGenericParameterTypes()[0];
        }
        if ((retClazz = ReflectionUtils.getRaw(rawType)) == null) {
            return;
        }
        DefaultJsonObject dfJSONObject = method.getAnnotation(DefaultJsonObject.class);
        if (dfJSONObject != null) {
            try {
                Object defaultValue = JSonStorage.getMapper().stringToObject(dfJSONObject.value(), new TypeRef(rawType){});
                if ("null".equals(dfJSONObject.value()) && defaultValue != null) {
                    throw new Exception("unexpected not null default object!");
                }
                if (defaultValue == null && !"null".equals(dfJSONObject.value())) {
                    throw new Exception("unexpected null default object!");
                }
                if (defaultValue == null || !Boolean.class.equals(defaultValue.getClass()) || !Boolean.TYPE.equals(retClazz)) {
                    retClazz.cast(defaultValue);
                }
            }
            catch (Exception e) {
                throw new Exception("here:" + cls + "|method:" + method, e);
            }
        }
        if (Clazz.isEnum(retClazz)) {
            DefaultEnumValue dfEnumValue = method.getAnnotation(DefaultEnumValue.class);
            if (dfEnumValue != null) {
                try {
                    Enum.valueOf(retClazz, dfEnumValue.value());
                }
                catch (Exception e) {
                    throw new Exception("here:" + cls + "|method:" + method, e);
                }
            }
        } else if (Enum[].class.isAssignableFrom(retClazz)) {
            Class<?> arrayEnumType = retClazz.getComponentType();
            DefaultEnumArrayValue dfEnumArrayValue = method.getAnnotation(DefaultEnumArrayValue.class);
            if (dfEnumArrayValue != null && dfEnumArrayValue.value() != null) {
                for (String dfEnumValue : dfEnumArrayValue.value()) {
                    try {
                        int index = dfEnumValue.lastIndexOf(".");
                        String enumValue = dfEnumValue.substring(index + 1);
                        String enumClazz = dfEnumValue.substring(0, index);
                        Object value = Enum.valueOf(Class.forName(enumClazz), enumValue);
                        arrayEnumType.cast(value);
                    }
                    catch (Exception e) {
                        throw new Exception("here:" + cls + "|method:" + method, e);
                    }
                }
            }
        }
    }

    public void validateClass(Class<?> cls) throws Exception {
        if (this.skipValidation(cls)) {
            return;
        }
        this.checkMissingConstructor(cls);
        ClassCache classCache = this.createClassCache(cls);
        if (Map.class.isAssignableFrom(cls)) {
            if (classCache.getKeys().size() > 0) {
                throw new Exception("WARNING: " + this.link(cls) + " is a Map and will not de/serialize setters or getters");
            }
            return;
        }
        if (Set.class.isAssignableFrom(cls)) {
            if (classCache.getKeys().size() > 0) {
                throw new Exception("WARNING: " + this.link(cls) + " is a Set and will not de/serialize setters or getters");
            }
            return;
        }
        if (Collection.class.isAssignableFrom(cls)) {
            if (classCache.getKeys().size() > 0) {
                throw new Exception("WARNING: " + this.link(cls) + " is a List and will not de/serialize setters or getters");
            }
            return;
        }
        for (Method m : CompiledType.create(cls).listMethods()) {
            if (Modifier.isStatic(m.getModifiers()) || !m.getName().startsWith("get") && !m.getName().startsWith("is") && !m.getName().startsWith("set")) continue;
            if (Modifier.isPrivate(m.getModifiers()) && m.getAnnotation(StorableAllowPrivateAccessModifier.class) == null) {
                throw new Exception(m.getDeclaringClass() + " Found private getter or stetter without @StorableAllowPrivateAccessModifier Annotation " + m);
            }
            if (Modifier.isPrivate(m.getModifiers()) || Modifier.isPublic(m.getModifiers()) || m.getAnnotation(StorableAllowProtectedAccessModifier.class) != null) continue;
            throw new Exception(m.getDeclaringClass() + " Found protected private getter or stetter without @StorableAllowProtectedAccessModifier Annotation " + m);
        }
        this.checkNoGetterSetter(classCache, cls);
        for (String key : classCache.getKeys()) {
            URL url;
            Getter g = classCache.getGetter(key);
            Setter s = classCache.getSetter(key);
            if (g != null && g.getMethod() != null && g.getMethod().getDeclaringClass().getAnnotation(IgnoreInAWTest.class) != null || s != null && s.getMethod() != null && s.getMethod().getDeclaringClass().getAnnotation(IgnoreInAWTest.class) != null) continue;
            boolean i = false;
            for (Class<?> layer = cls; layer != null; layer = layer.getSuperclass()) {
                if (layer.getAnnotation(IgnoreInAWTest.class) != null) continue;
                for (Method m : cls.getDeclaredMethods()) {
                    if (Modifier.isStatic(m.getModifiers()) || !key.equals(ClassCache.createKey(m)) || g != null && g.getMethod().equals(m) || s != null && s.getMethod().equals(m) || (g == null || s == null) && Modifier.isProtected(m.getModifiers()) || (g == null || s == null) && Modifier.isPrivate(m.getModifiers())) continue;
                    throw new Exception("Method with name " + m + " exists multiple times with different parameters! " + cls);
                }
            }
            if (s == null && !this.hasAnnotation(classCache, key, StorableValidatorIgnoresMissingSetter.class)) {
                url = cls.getClassLoader().getResource(cls.getName().replace(".", "/") + ".class");
                throw new Exception("setter " + cls.getName() + "." + key + " is missing - (" + g.getMethod().getDeclaringClass().getSimpleName() + ".java:1) " + url);
            }
            if (g == null && !this.hasAnnotation(classCache, key, StorableValidatorIgnoresMissingGetter.class)) {
                url = cls.getClassLoader().getResource(cls.getName().replace(".", "/") + ".class");
                throw new Exception("getter " + cls.getName() + "." + key + " is missing - (" + s.getMethod().getDeclaringClass().getSimpleName() + ".java:1) " + url);
            }
            if (g != null) {
                if (g.getMethod() == null) {
                    throw new Exception("Missing public getter " + cls + "." + key + " method. public field?");
                }
                if (!Modifier.isPublic(g.getMethod().getModifiers())) {
                    // empty if block
                }
                this.checkAnnotations(classCache, cls, g.getMethod());
                try {
                    this.canStore(classCache, cls, g.getMethod(), g.getMethod().getGenericReturnType());
                }
                catch (InvalidTypeException e) {
                    LogV3.log(e);
                    throw new Exception("getter (" + g.getMethod().getDeclaringClass().getSimpleName() + ".java:1)." + g.key + " returns a non-storable object " + g.getMethod().getGenericReturnType());
                }
            }
            if (s != null) {
                if (s.getMethod() == null) {
                    throw new Exception("Missing public getter " + cls + "." + g.key + " method. public field?");
                }
                if (!Modifier.isPublic(s.getMethod().getModifiers())) {
                    throw new Exception("setter " + g.getMethod().getDeclaringClass().getName() + "." + g.key + " is not public " + cls);
                }
                this.checkAnnotations(classCache, cls, s.getMethod());
                try {
                    this.canStore(classCache, cls, s.getMethod(), s.getMethod().getGenericParameterTypes()[0]);
                }
                catch (InvalidTypeException e) {
                    LogV3.log(e);
                    throw new Exception("setter " + g.getMethod().getDeclaringClass().getName() + "." + g.key + " has a non-storable parameter " + cls);
                }
            }
            if (g == null || s == null) continue;
            try {
                if (!Clazz.equalsIgnorePrimitive(g.type, s.type)) {
                    throw new Exception("setter and getter is different file types " + g.getMethod().getDeclaringClass().getName() + "." + g.key + " " + cls);
                }
                if (g.getMethod().getGenericReturnType().equals(s.getMethod().getGenericParameterTypes()[0])) continue;
                StorableValidatorTest.logInfoAnyway("[WARNING] Primitive/Wrapper missmatch in " + s.getMethod() + "/" + g.getMethod());
            }
            catch (NullPointerException e) {
                e.printStackTrace();
            }
        }
    }

    private String link(Class<?> cls) {
        return cls.getPackage().toString() + "(" + cls.getSimpleName() + ".java:1)";
    }

    protected void canStore(ClassCache classCache, final Class<?> cls, Method method, Type type) throws InvalidTypeException {
        StorableValidatorTest.canStoreIntern(type, "", new CanStoreRules(){

            @Override
            public boolean isFollowSuperClass(Type sc) {
                return false;
            }

            @Override
            public boolean isTypeWithlisted(Type gType, Method method) {
                Class<?> raw = ReflectionUtils.getRaw(gType);
                try {
                    if (StorableValidatorTest.this.skipValidation(raw)) {
                        return true;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (ReflectionUtils.getAnnotation(gType, IgnoreInAWTest.class) != null) {
                    return true;
                }
                AllowNonStorableObjects allowNonStorable = ReflectionUtils.getAnnotation(gType, AllowNonStorableObjects.class);
                if (raw != null && allowNonStorable != null && Arrays.asList(allowNonStorable.value()).contains(raw)) {
                    return true;
                }
                if (method.getDeclaringClass().getAnnotation(IgnoreInAWTest.class) != null) {
                    // empty if block
                }
                for (Class layer = cls; layer != null; layer = layer.getSuperclass()) {
                    try {
                        ClassCache layerCC = ClassCache.getClassCache(layer);
                        if (ReflectionUtils.getAnnotation(layer, IgnoreInAWTest.class) != null) {
                            return true;
                        }
                        allowNonStorable = ReflectionUtils.getAnnotation(layer, AllowNonStorableObjects.class);
                        if (raw != null && allowNonStorable != null && Arrays.asList(allowNonStorable.value()).contains(raw)) {
                            return true;
                        }
                        if (layerCC.getAnnotations(ClassCache.createKey(method), IgnoreInAWTest.class).size() > 0) {
                            return true;
                        }
                        for (AllowNonStorableObjects anno : layerCC.getAnnotations(ClassCache.createKey(method), AllowNonStorableObjects.class)) {
                            if (raw == null || anno == null || !Arrays.asList(anno.value()).contains(raw)) continue;
                            return true;
                        }
                        continue;
                    }
                    catch (NoSuchMethodException layerCC) {
                        continue;
                    }
                    catch (SecurityException layerCC) {
                        // empty catch block
                    }
                }
                if (method != null) {
                    try {
                        ClassCache cc = ClassCache.getClassCache(method.getDeclaringClass());
                        if (cc.getAnnotations(ClassCache.createKey(method), IgnoreInAWTest.class).size() > 0) {
                            return true;
                        }
                        if (cc.getAnnotations(null, IgnoreInAWTest.class).size() > 0) {
                            return true;
                        }
                        for (AllowNonStorableObjects anno : cc.getAnnotations(ClassCache.createKey(method), AllowNonStorableObjects.class)) {
                            if (!Arrays.asList(anno.value()).contains(raw)) continue;
                            return true;
                        }
                        for (AllowNonStorableObjects anno : cc.getAnnotations(null, AllowNonStorableObjects.class)) {
                            if (!Arrays.asList(anno.value()).contains(raw)) continue;
                            return true;
                        }
                    }
                    catch (SecurityException securityException) {
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        // empty catch block
                    }
                    if (method.getAnnotation(IgnoreInAWTest.class) != null) {
                        return true;
                    }
                    allowNonStorable = method.getAnnotation(AllowNonStorableObjects.class);
                    if (allowNonStorable != null && Arrays.asList(allowNonStorable.value()).contains(raw)) {
                        return true;
                    }
                }
                return false;
            }
        }, new HashSet<Object>(), method);
    }

    private boolean hasAnnotation(ClassCache classCache, String key, Class<? extends Annotation> annotationClass) {
        if (classCache.getAnnotations(key, annotationClass).size() > 0) {
            return true;
        }
        return classCache.getAnnotations(null, annotationClass).size() > 0;
    }

    public static String sourceMethodToString(Method method) {
        if (method == null) {
            return "Unknown Source";
        }
        return method.getDeclaringClass().getSimpleName() + "." + method.getName();
    }

    public static void canStoreIntern(Type gType, String path, CanStoreRules rules, HashSet<Object> dupeID, Method method) throws InvalidTypeException {
        if (gType instanceof GenericArrayType) {
            throw new WTFException("Generic Array Type not supported: " + gType);
        }
        if (!dupeID.add(gType)) {
            return;
        }
        if (rules.isTypeWithlisted(gType, method)) {
            return;
        }
        if (gType == Object.class) {
            if (rules.isTypeWithlisted(gType, method)) {
                return;
            }
            throw new InvalidTypeException(gType, "Cannot store Object: " + path + "/" + gType + " " + StorableValidatorTest.sourceMethodToString(method));
        }
        if (gType instanceof Class) {
            Class type = (Class)gType;
            if (type == Void.TYPE) {
                throw new InvalidTypeException(gType, "Void is not accepted: " + path + "/" + gType + " " + StorableValidatorTest.sourceMethodToString(method));
            }
            if (type.isPrimitive()) {
                return;
            }
            if (Date.class.isAssignableFrom(type)) {
                return;
            }
            if (TimeSpan.class.isAssignableFrom(type)) {
                return;
            }
            if (type == Boolean.class || type == Long.class || type == Integer.class || type == Byte.class || type == Double.class || type == Float.class || type == String.class || type == Short.class || type == Character.class || type == CharSequence.class) {
                return;
            }
            if (type.isEnum()) {
                return;
            }
            if (type.isArray()) {
                Class<?> arrayType = type.getComponentType();
                StorableValidatorTest.canStoreIntern(arrayType, path + "[" + arrayType + "]", rules, dupeID, method);
                return;
            }
            if (List.class.isAssignableFrom(type)) {
                return;
            }
            if (Map.class.isAssignableFrom(type)) {
                return;
            }
            if (Set.class.isAssignableFrom(type)) {
                return;
            }
            if (Storable.class.isAssignableFrom(type) || FlexiStorableInterface.class.isAssignableFrom(type)) {
                try {
                    if (!FlexiStorableInterface.class.isAssignableFrom(type)) {
                        type.getDeclaredConstructor(new Class[0]);
                    }
                    for (Class layer = type; layer != null && layer != Object.class; layer = layer.getSuperclass()) {
                        for (Method m : layer.getDeclaredMethods()) {
                            if (Modifier.isStatic(m.getModifiers())) continue;
                            if (m.getName().startsWith("get")) {
                                if (m.getParameterTypes().length > 0) {
                                    throw new InvalidTypeException(gType, "Getter " + path + "." + m + " has parameters. " + StorableValidatorTest.sourceMethodToString(method));
                                }
                                StorableValidatorTest.canStoreIntern(m.getGenericReturnType(), path + "->" + m.getGenericReturnType(), rules, dupeID, m);
                                continue;
                            }
                            if (m.getName().startsWith("set")) {
                                if (m.getParameterTypes().length != 1) {
                                    throw new InvalidTypeException(gType, "Setter " + path + "." + m + " has != 1 Parameters. " + StorableValidatorTest.sourceMethodToString(method));
                                }
                                StorableValidatorTest.canStoreIntern(m.getGenericParameterTypes()[0], path + "->" + m.getGenericParameterTypes()[0], rules, dupeID, m);
                                continue;
                            }
                            if (!m.getName().startsWith("is")) continue;
                            if (m.getParameterTypes().length > 0) {
                                throw new InvalidTypeException(gType, "Getter " + path + "." + m + " has parameters. " + StorableValidatorTest.sourceMethodToString(method));
                            }
                            StorableValidatorTest.canStoreIntern(m.getGenericReturnType(), path + "->" + m.getGenericReturnType(), rules, dupeID, m);
                        }
                    }
                    Type sc = type.getGenericSuperclass();
                    if (sc != null && rules.isFollowSuperClass(sc)) {
                        StorableValidatorTest.canStoreIntern(sc, path + "<<<" + sc, rules, dupeID, method);
                    }
                    return;
                }
                catch (NoSuchMethodException e) {
                    throw new InvalidTypeException(gType, "Storable " + path + " has no empty Constructor " + StorableValidatorTest.sourceMethodToString(method));
                }
            }
        } else {
            if (gType instanceof ParameterizedType) {
                ParameterizedType ptype = (ParameterizedType)gType;
                Type raw = ptype.getRawType();
                StorableValidatorTest.canStoreIntern(raw, path, rules, dupeID, method);
                for (Type t : ptype.getActualTypeArguments()) {
                    StorableValidatorTest.canStoreIntern(t, path + "(" + t + ")", rules, dupeID, method);
                }
                return;
            }
            if (gType instanceof GenericArrayType) {
                GenericArrayType atype = (GenericArrayType)gType;
                Type t = atype.getGenericComponentType();
                StorableValidatorTest.canStoreIntern(t, path + "[" + t + "]", rules, dupeID, method);
                return;
            }
            if (gType instanceof TypeVariable) {
                return;
            }
            throw new InvalidTypeException(gType, "Generic Type Structure not implemented: " + gType.getClass() + " in " + path + " " + StorableValidatorTest.sourceMethodToString(method));
        }
        throw new InvalidTypeException(gType, "Type " + path + "/" + gType + " is not supported. " + StorableValidatorTest.sourceMethodToString(method));
    }

    public static interface CanStoreRules {
        public boolean isTypeWithlisted(Type var1, Method var2);

        public boolean isFollowSuperClass(Type var1);
    }
}

