/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.swing.components;

import java.awt.event.MouseListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;

public class ExtSpinner
extends JSpinner {
    private static final long serialVersionUID = -885721913501063289L;

    @Override
    public boolean hasFocus() {
        JFormattedTextField tf;
        JComponent ed = this.getEditor();
        if (ed != null && ed instanceof JSpinner.DefaultEditor && (tf = ((JSpinner.DefaultEditor)ed).getTextField()) != null) {
            return tf.hasFocus();
        }
        return super.hasFocus();
    }

    public ExtSpinner(SpinnerNumberModel spinnerNumberModel) {
        super(spinnerNumberModel);
        this.addMouseWheelListener(new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent e) {
                if (ExtSpinner.this.isFocusOwner()) {
                    e.consume();
                    if (e.getPreciseWheelRotation() <= 0.0) {
                        Object newValue = ExtSpinner.this.getNextValue();
                        if (newValue != null) {
                            ExtSpinner.this.setValue(newValue);
                        }
                    } else {
                        Object newValue = ExtSpinner.this.getPreviousValue();
                        if (newValue != null) {
                            ExtSpinner.this.setValue(newValue);
                        }
                    }
                } else {
                    ExtSpinner.this.getParent().dispatchEvent(e);
                }
            }
        });
    }

    @Override
    public synchronized void addMouseListener(MouseListener l) {
        super.addMouseListener(l);
        ((JSpinner.DefaultEditor)this.getEditor()).getTextField().addMouseListener(l);
    }

    @Override
    public Object getNextValue() {
        return super.getNextValue();
    }

    public int getIntValue() {
        return ((Number)this.getValue()).intValue();
    }

    public long getLongValue() {
        return ((Number)this.getValue()).longValue();
    }
}

