/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.updatesys.transport.exchange;

import java.util.List;
import java.util.regex.Pattern;
import org.appwork.utils.StringUtils;

public enum CONDITION {
    BETWEEN,
    BETWEENEQ,
    NOTBETWEEN,
    NOTBETWEENEQ,
    GREATER,
    GREATEREQ,
    LESS,
    LESSEQ,
    NEQ,
    EQ,
    CONTAINS,
    CONTAINSNOT,
    MATCHES,
    MATCHESNOT,
    FINDS,
    FINDSNOT;


    public boolean matches(long value, long x, long y) {
        switch (this) {
            case BETWEEN: {
                return value > x && value < y;
            }
            case BETWEENEQ: {
                return value > x && value < y || value == x || value == y;
            }
            case NOTBETWEEN: {
                return value < x || value > y;
            }
            case NOTBETWEENEQ: {
                return (value < x || value > y) && value != x && value != y;
            }
            case GREATER: {
                return value > x;
            }
            case GREATEREQ: {
                return value >= x;
            }
            case EQ: {
                return value == x;
            }
            case LESS: {
                return value < x;
            }
            case LESSEQ: {
                return value <= x;
            }
            case NEQ: {
                return value != x;
            }
        }
        return false;
    }

    public boolean matches(String value, String matcher) {
        switch (this) {
            case CONTAINSNOT: {
                return value != null && matcher != null && !value.contains(matcher);
            }
            case CONTAINS: {
                return value != null && matcher != null && value.contains(matcher);
            }
            case MATCHES: {
                return StringUtils.isNotEmpty(matcher) && Pattern.compile(matcher).matcher(value).matches();
            }
            case MATCHESNOT: {
                return StringUtils.isNotEmpty(matcher) && !Pattern.compile(matcher).matcher(value).matches();
            }
            case FINDS: {
                return StringUtils.isNotEmpty(matcher) && Pattern.compile(matcher).matcher(value).find();
            }
            case FINDSNOT: {
                return StringUtils.isNotEmpty(matcher) && !Pattern.compile(matcher).matcher(value).find();
            }
            case EQ: {
                if (value == null && matcher == null) {
                    return true;
                }
                if (value == null && matcher != null) {
                    return false;
                }
                if (value != null && matcher == null) {
                    return false;
                }
                return value.equals(matcher);
            }
            case NEQ: {
                if (value == null && matcher == null) {
                    return false;
                }
                if (value != null && matcher == null) {
                    return true;
                }
                if (value == null && matcher != null) {
                    return true;
                }
                return !value.equals(matcher);
            }
        }
        return false;
    }

    public boolean matches(List<String> matcher, String value) {
        if (matcher == null) {
            return false;
        }
        switch (this) {
            case MATCHES: {
                for (String pattern : matcher) {
                    if (!StringUtils.isNotEmpty(pattern) || !Pattern.compile(pattern).matcher(value).matches()) continue;
                    return true;
                }
                return false;
            }
            case MATCHESNOT: {
                for (String pattern : matcher) {
                    if (!StringUtils.isNotEmpty(pattern) || Pattern.compile(pattern).matcher(value).matches()) continue;
                    return true;
                }
                return false;
            }
            case FINDS: {
                for (String pattern : matcher) {
                    if (!StringUtils.isNotEmpty(pattern) || !Pattern.compile(pattern).matcher(value).find()) continue;
                    return true;
                }
                return false;
            }
            case FINDSNOT: {
                for (String pattern : matcher) {
                    if (!StringUtils.isNotEmpty(pattern) || Pattern.compile(pattern).matcher(value).find()) continue;
                    return true;
                }
                return false;
            }
            case EQ: {
                return matcher.size() == 1 && matcher.contains(value);
            }
            case NEQ: {
                return matcher.size() == 1 && !matcher.contains(value);
            }
            case CONTAINS: {
                return matcher.contains(value);
            }
            case CONTAINSNOT: {
                return !matcher.contains(value);
            }
        }
        return true;
    }
}

