/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.updatesys.transport.exchange;

import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.List;
import org.appwork.updatesys.transport.exchange.DownloadMirror;
import org.appwork.utils.StringUtils;

public class DownloadUrlList
extends ArrayList<DownloadMirror> {
    private static final long serialVersionUID = 1L;

    public static DownloadUrlList create(List<String> downloadLocations) {
        DownloadUrlList ret = new DownloadUrlList();
        for (String s : downloadLocations) {
            if (s == null) continue;
            ret.add(new DownloadMirror(100, s));
        }
        return ret;
    }

    @Override
    public DownloadUrlList clone() {
        return this.clone(null);
    }

    public DownloadUrlList clone(String append) {
        DownloadUrlList ret = new DownloadUrlList();
        if (StringUtils.isEmpty(append)) {
            for (DownloadMirror downloadMirror : this) {
                if (downloadMirror.getUrl() == null) continue;
                ret.add(new DownloadMirror(downloadMirror.getPriority(), downloadMirror.getUrl()));
            }
        } else {
            for (DownloadMirror downloadMirror : this) {
                if (downloadMirror.getUrl() == null) continue;
                ret.add(new DownloadMirror(downloadMirror.getPriority(), downloadMirror.getUrl() + append));
            }
        }
        return ret;
    }

    public static DownloadUrlList parse(String[] copyOfRange) throws NumberFormatException, MalformedURLException {
        DownloadUrlList ret = new DownloadUrlList();
        for (String s : copyOfRange) {
            if (StringUtils.isEmpty(s)) continue;
            int i = s.indexOf(",");
            ret.add(new DownloadMirror(Integer.parseInt(s.substring(0, i)), s.substring(i + 1)));
        }
        return ret;
    }
}

