/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.updatesys.transport.exchange;

import java.io.IOException;
import java.nio.charset.Charset;
import java.util.List;
import org.appwork.updatesys.transport.exchange.ResponseStatus;
import org.appwork.updatesys.transport.exchange.interfaces.ServerResponseInterface;
import org.appwork.updatesys.transport.exchange.json.ServerJsonResponse;

public abstract class ServerResponse
implements ServerResponseInterface {
    public static final Charset UTF8 = Charset.forName("UTF-8");
    public static final String NL = "\r\n";
    private ResponseStatus status;

    public ServerResponse(ResponseStatus status) {
        this.status = status;
    }

    public abstract ServerJsonResponse toJsonVariant();

    public byte[] getBytes() throws IOException {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getStatus().name());
        Object[] fields = this.getFields();
        if (fields != null) {
            for (Object o : fields) {
                if (o instanceof Boolean) {
                    sb.append(NL);
                    if (Boolean.TRUE.equals(o)) {
                        sb.append("1");
                        continue;
                    }
                    sb.append("0");
                    continue;
                }
                if (o instanceof List) {
                    for (Object x : (List)o) {
                        sb.append(NL);
                        sb.append(x);
                    }
                    continue;
                }
                sb.append(NL);
                sb.append(o);
            }
        }
        return sb.toString().getBytes(UTF8);
    }

    public abstract Object[] getFields();

    @Override
    public ResponseStatus getStatus() {
        return this.status;
    }

    protected void setStatus(ResponseStatus status) {
        this.status = status;
    }

    public int _getBatchRequiredProtocolVersion() {
        return 9;
    }
}

