/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import java.util.jar.JarEntry;
import org.appwork.utils.StringUtils;
import sun.net.www.ParseUtil;
import sun.net.www.protocol.jar.Handler;
import sun.net.www.protocol.jar.JarURLConnection;

public class OracleWorkaroundJarHandler
extends Handler {
    @Override
    protected URLConnection openConnection(URL url) throws IOException {
        try {
            String path = url.getFile();
            URL jarFileURL = null;
            int lastIndex = 0;
            if (StringUtils.startsWithCaseInsensitive(path, "file:")) {
                int indexOf;
                while ((indexOf = path.indexOf(".jar", lastIndex)) > 0) {
                    File jarFile;
                    URL jarURL;
                    int index;
                    lastIndex = index = indexOf + 4;
                    String jarFileName = path.substring(0, index);
                    if (!jarFileName.contains("!/")) continue;
                    try {
                        jarURL = new URL(jarFileName);
                        jarFile = new File(jarURL.toURI());
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        continue;
                    }
                    if (!jarFile.exists() || !jarFile.isFile()) continue;
                    jarFileURL = jarURL;
                    break;
                }
            }
            if (jarFileURL != null) {
                String entryName;
                ++lastIndex;
                final URL finalJarFileURL = jarFileURL;
                if (++lastIndex != path.length()) {
                    String tempEntryName = path.substring(lastIndex, path.length());
                    entryName = ParseUtil.decode(tempEntryName);
                } else {
                    entryName = null;
                }
                System.out.println("Workaround for URL.openConnection:" + finalJarFileURL + " Entry:" + entryName);
                return new JarURLConnection(url, this){

                    @Override
                    public URL getJarFileURL() {
                        return finalJarFileURL;
                    }

                    @Override
                    public JarEntry getJarEntry() throws IOException {
                        return this.getJarFile().getJarEntry(this.getEntryName());
                    }

                    @Override
                    public String getEntryName() {
                        return entryName;
                    }
                };
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        return super.openConnection(url);
    }
}

