/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils.io.streamingio;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.util.concurrent.atomic.AtomicLong;

public class StreamingChunk {
    protected RandomAccessFile chunkFile = null;
    protected volatile boolean canGrow = false;
    protected AtomicLong writes = new AtomicLong(0L);
    protected AtomicLong currentChunkSize = new AtomicLong(0L);
    protected final long chunkStartPosition;

    public StreamingChunk(File file, long chunkStartPosition) throws FileNotFoundException {
        this.chunkFile = new RandomAccessFile(file, "rw");
        this.currentChunkSize.set(file.length());
        this.chunkStartPosition = chunkStartPosition;
    }

    private synchronized int _read(byte[] b, int off, int len, long position) throws IOException {
        if ((position -= this.chunkStartPosition) < this.currentChunkSize.get()) {
            this.chunkFile.seek(position);
            return this.chunkFile.read(b, off, (int)Math.min((long)len, this.currentChunkSize.get() - position));
        }
        if (!this.canGrow) {
            return -1;
        }
        return 0;
    }

    public boolean canGrow() {
        return this.canGrow;
    }

    public void close() {
        try {
            this.chunkFile.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public long getAvailableChunkSize() {
        return this.currentChunkSize.get();
    }

    public long getChunkStartPosition() {
        return this.chunkStartPosition;
    }

    public int read(byte[] b, int off, int len, long position) throws IOException, InterruptedException {
        if (position < 0L) {
            throw new IOException("invalid position " + position);
        }
        long lastWrites = this.writes.get();
        int ret = this._read(b, off, len, position);
        if (ret > 0 || ret == -1) {
            return ret;
        }
        do {
            Thread.sleep(50L);
            if (lastWrites == this.writes.get() || (ret = this._read(b, off, len, position)) <= 0 && ret != -1) continue;
            return ret;
        } while (this.canGrow);
        return -1;
    }

    public void setCanGrow(boolean b) {
        this.canGrow = b;
    }

    public synchronized void sync() {
        try {
            this.chunkFile.getFD().sync();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public synchronized void write(byte[] b, int off, int len) throws IOException {
        if (this.chunkFile.getFilePointer() != this.chunkFile.length()) {
            this.chunkFile.seek(this.chunkFile.length());
        }
        this.chunkFile.write(b, off, len);
        this.currentChunkSize.addAndGet(len);
        this.writes.incrementAndGet();
    }

    public InputStream getInputStream(final long startPosition, long end) {
        return new InputStream(){
            long currentPosition;
            byte[] bufferByte;
            {
                this.currentPosition = startPosition;
                this.bufferByte = new byte[1];
            }

            @Override
            public int read() throws IOException {
                if (this.currentPosition != 0L && this.currentPosition > StreamingChunk.this.getAvailableChunkSize()) {
                    return -1;
                }
                int ret = this.read(this.bufferByte, 0, 1);
                if (ret == 1) {
                    return this.bufferByte[1];
                }
                return -1;
            }

            @Override
            public void close() throws IOException {
                super.close();
            }

            @Override
            public int read(byte[] b, int off, int len) throws IOException {
                if (this.currentPosition != 0L && this.currentPosition > StreamingChunk.this.getAvailableChunkSize()) {
                    System.out.println("-1 answer");
                    return -1;
                }
                try {
                    int ret = StreamingChunk.this.read(b, off, len, this.currentPosition);
                    if (ret >= 0) {
                        this.currentPosition += (long)ret;
                    }
                    return ret;
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                    return -1;
                }
            }

            @Override
            public boolean markSupported() {
                return false;
            }
        };
    }
}

