/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils.net.httpconnection;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.URL;
import org.appwork.utils.Time;
import org.appwork.utils.net.httpconnection.HTTPConnectionImpl;
import org.appwork.utils.net.httpconnection.HTTPConnectionUtils;
import org.appwork.utils.net.httpconnection.HTTPProxy;
import org.appwork.utils.net.httpconnection.HTTPProxyException;
import org.appwork.utils.net.httpconnection.ProxyConnectException;
import org.appwork.utils.net.httpconnection.SocketStreamInterface;
import org.appwork.utils.net.socketconnection.SocketConnection;
import org.appwork.utils.net.socketconnection.SocksSocketConnection;

public abstract class AbstractSocksHTTPConnection
extends HTTPConnectionImpl {
    protected SocketStreamInterface sockssocket = null;
    protected StringBuffer proxyRequest = null;
    protected final SocksSocketConnection.DESTTYPE destType;
    protected volatile InetSocketAddress endPointInetSocketAddress = null;
    protected volatile InetAddress customEndPointInetAddress = null;

    public AbstractSocksHTTPConnection(URL url, HTTPProxy proxy) {
        this(url, proxy, SocksSocketConnection.DESTTYPE.AUTO);
    }

    public AbstractSocksHTTPConnection(URL url, HTTPProxy proxy, SocksSocketConnection.DESTTYPE destType) {
        super(url, proxy);
        this.destType = destType != null ? destType : SocksSocketConnection.DESTTYPE.AUTO;
        this.buildSocksSocketConnection();
    }

    public SocksSocketConnection.DESTTYPE getDestType() {
        return this.destType;
    }

    @Override
    protected HTTPProxy isProxySupported(HTTPProxy proxy) {
        if (proxy != null && proxy.getType() != null) {
            switch (proxy.getType()) {
                case SOCKS4: 
                case SOCKS4A: 
                case SOCKS5: {
                    return proxy;
                }
            }
        }
        throw new IllegalArgumentException("proxy type incompatible:" + proxy);
    }

    protected abstract SocksSocketConnection buildSocksSocketConnection();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public void connect() throws IOException {
        profiler = this.getProfiler();
        if (profiler != null) {
            profiler.onConnect(this);
        }
        if (!this.isHostnameResolved()) {
            this.setHostname(this.resolveHostname(this.httpURL.getHost()));
        }
        sslSocketStreamOptions = null;
        factory = null;
        port = this.getConnectEndpointPort();
        while (true) {
            if (this.isConnectionSocketValid()) {
                return;
            }
            this.resetConnection();
            this.proxyRequest = new StringBuffer();
            try {
                startTime = Time.systemIndependentCurrentJVMTimeMillis();
                this.sockssocket = this.createConnectionSocket(null);
                this.sockssocket = this.connect(this.sockssocket);
                if (this.httpURL.getProtocol().startsWith("https")) {
                    try {
                        hostName = this.getHostname();
                        if (sslSocketStreamOptions == null) {
                            sslSocketStreamOptions = this.getSSLSocketStreamOptions(hostName, port, this.isSSLTrustALL());
                        }
                        factory = this.getSSLSocketStreamFactory(sslSocketStreamOptions);
                        this.connectionSocket = factory.create(this.sockssocket, hostName, port, true, sslSocketStreamOptions);
                    }
                    catch (IOException e) {
                        try {
                            if (sslSocketStreamOptions != null) {
                                sslSocketStreamOptions = sslSocketStreamOptions.clone();
                                v0 = sslSocketStreamOptions.retry(factory, e);
                            } else {
                                v0 = null;
                            }
                            retrySSL = v0;
                            this.setSSLSocketStreamOptions(sslSocketStreamOptions);
                            this.connectExceptions.add(this.sockssocket + "|" + this.getExceptionMessage(e) + "|retrySSL:" + retrySSL);
                        }
                        finally {
                            this.disconnect();
                        }
                        if (retrySSL != null) continue;
                        throw new ProxyConnectException(e, this.proxy);
                    }
                }
                this.connectionSocket = this.sockssocket;
                this.httpResponseCode = -1;
                this.connectTime = Time.systemIndependentCurrentJVMTimeMillis() - startTime;
                if (profiler != null) {
                    profiler.onConnected(this);
                }
                this.sendRequest();
                return;
            }
            catch (IOException e) {
                try {
                    if (sslSocketStreamOptions != null) {
                        sslSocketStreamOptions = sslSocketStreamOptions.clone();
                        v1 = sslSocketStreamOptions.retry(factory, e);
                    } else {
                        v1 = null;
                    }
                    retrySSL = v1;
                    this.setSSLSocketStreamOptions(sslSocketStreamOptions);
                    this.connectExceptions.add("Socks(" + this.getProxy().getType() + ")" + SocketConnection.getRootEndPointSocketAddress(this.sockssocket) + "|EndPoint:" + this.getEndPointInetSocketAddress() + "|Exception:" + this.getExceptionMessage(e) + "|retrySSL:" + retrySSL);
                }
                finally {
                    this.disconnect();
                }
                if (retrySSL == null) ** break;
                continue;
                if (e instanceof HTTPProxyException) {
                    throw e;
                }
                throw new ProxyConnectException(e, this.proxy);
            }
            break;
        }
    }

    @Override
    public void setReadTimeout(int readTimeout) {
        try {
            Socket socket;
            this.readTimeout = Math.max(0, readTimeout);
            SocketStreamInterface sockssocket = this.getSocksSocket();
            if (sockssocket != null && (socket = sockssocket.getSocket()) != null) {
                socket.setSoTimeout(this.readTimeout);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    protected boolean isKeepAlivedEnabled() {
        return false;
    }

    @Override
    public void disconnect() {
        try {
            super.disconnect();
        }
        finally {
            SocketStreamInterface sockssocket = this.getSocksSocket();
            try {
                if (sockssocket != null) {
                    sockssocket.close();
                }
            }
            catch (Throwable e) {
                this.sockssocket = null;
            }
        }
    }

    protected SocketStreamInterface getSocksSocket() {
        return this.sockssocket;
    }

    protected int getConnectEndpointPort() {
        int ret = this.httpURL.getPort();
        if (ret == -1) {
            return this.httpURL.getDefaultPort();
        }
        return ret;
    }

    protected boolean resolveConnectEndPoint(SocksSocketConnection socksSocketConnection) {
        return this.proxy != null && this.proxy.isResolveHostname() || !socksSocketConnection.isSupported(SocksSocketConnection.DESTTYPE.DOMAIN);
    }

    protected abstract HTTPConnectionUtils.IPVERSION getEndPointIPVersion();

    protected InetSocketAddress getEndPointInetSocketAddress() {
        return this.endPointInetSocketAddress;
    }

    protected InetAddress getCustomEndPointInetAddress() {
        return this.customEndPointInetAddress;
    }

    protected void setCustomEndPointInetAddress(InetAddress customEndPointInetAddress) {
        this.customEndPointInetAddress = customEndPointInetAddress;
    }

    protected InetSocketAddress buildConnectEndPointSocketAddress(SocksSocketConnection socksSocketConnection) throws IOException {
        InetAddress customEndPointInetAddress = this.getCustomEndPointInetAddress();
        if (customEndPointInetAddress != null) {
            return new InetSocketAddress(customEndPointInetAddress, this.getConnectEndpointPort());
        }
        try {
            InetAddress[] ret = AbstractSocksHTTPConnection.resolveLiteralIP(this.getHostname());
            if (ret != null && ret.length > 0) {
                return new InetSocketAddress(ret[0], this.getConnectEndpointPort());
            }
        }
        catch (IOException e) {
            this.connectExceptions.add(this.getExceptionMessage(e));
        }
        if (this.resolveConnectEndPoint(socksSocketConnection) && (socksSocketConnection.isSupported(SocksSocketConnection.DESTTYPE.IPV4) || socksSocketConnection.isSupported(SocksSocketConnection.DESTTYPE.IPV6))) {
            try {
                HTTPConnectionUtils.IPVERSION version = this.getEndPointIPVersion();
                if (!socksSocketConnection.isSupported(SocksSocketConnection.DESTTYPE.IPV6)) {
                    version = HTTPConnectionUtils.IPVERSION.IPV4_ONLY;
                } else if (!socksSocketConnection.isSupported(SocksSocketConnection.DESTTYPE.IPV4) || SocksSocketConnection.DESTTYPE.IPV6.equals((Object)socksSocketConnection.getDestType(null))) {
                    version = HTTPConnectionUtils.IPVERSION.IPV6_IPV4;
                }
                InetAddress[] inetAddress = HTTPConnectionUtils.resolvHostIP(this.getHostname(), version);
                if (inetAddress != null && inetAddress.length > 0) {
                    return new InetSocketAddress(inetAddress[0], this.getConnectEndpointPort());
                }
            }
            catch (IOException e) {
                this.connectExceptions.add(this.getExceptionMessage(e));
            }
        }
        return InetSocketAddress.createUnresolved(this.getHostname(), this.getConnectEndpointPort());
    }

    protected abstract SocketStreamInterface connect(SocketStreamInterface var1) throws IOException;

    @Override
    protected String getRequestInfo() {
        if (this.proxyRequest != null) {
            InetAddress customEndPointInetAddress;
            StringBuilder sb = new StringBuilder();
            String type = this.proxy.getType().name();
            SocketAddress socketAddress = SocketConnection.getRootEndPointSocketAddress(this.getSocksSocket());
            if (socketAddress != null) {
                sb.append("-->" + type + ":");
                sb.append(socketAddress);
                sb.append("\r\n");
            }
            if ((customEndPointInetAddress = this.getCustomEndPointInetAddress()) != null) {
                sb.append("-->CustomEndPointInetAddress:").append(customEndPointInetAddress).append("\r\n");
            }
            sb.append("----------------CONNECTRequest(" + type + ")----------\r\n");
            sb.append(this.proxyRequest.toString());
            sb.append("------------------------------------------------\r\n");
            sb.append(super.getRequestInfo());
            return sb.toString();
        }
        return super.getRequestInfo();
    }
}

