/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils.net.httpconnection;

import java.net.URL;
import org.appwork.utils.net.httpconnection.HTTPConnection;
import org.appwork.utils.net.httpconnection.HTTPConnectionImpl;
import org.appwork.utils.net.httpconnection.HTTPProxy;
import org.appwork.utils.net.httpconnection.HTTPProxyHTTPConnectionImpl;
import org.appwork.utils.net.httpconnection.NativeHTTPConnectionImpl;
import org.appwork.utils.net.httpconnection.Socks4HTTPConnectionImpl;
import org.appwork.utils.net.httpconnection.Socks5HTTPConnectionImpl;

public class HTTPConnectionFactory {
    public static HTTPConnection createHTTPConnection(URL url, HTTPProxy proxy) {
        if (proxy == null) {
            return new HTTPConnectionImpl(url);
        }
        if (proxy.isPreferNativeImplementation()) {
            return new NativeHTTPConnectionImpl(url, proxy);
        }
        switch (proxy.getType()) {
            case NONE: 
            case DIRECT: {
                return new HTTPConnectionImpl(url, proxy);
            }
            case HTTP: 
            case HTTPS: {
                return new HTTPProxyHTTPConnectionImpl(url, proxy);
            }
            case SOCKS4: 
            case SOCKS4A: {
                return new Socks4HTTPConnectionImpl(url, proxy);
            }
            case SOCKS5: {
                return new Socks5HTTPConnectionImpl(url, proxy);
            }
        }
        throw new RuntimeException("unsupported proxy type: " + proxy.getType());
    }
}

