/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils.net.httpconnection;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.appwork.utils.Exceptions;
import org.appwork.utils.JVMVersion;
import org.appwork.utils.JavaVersion;
import org.appwork.utils.StringUtils;
import org.appwork.utils.net.httpconnection.HTTPConnectionUtils;
import org.appwork.utils.net.httpconnection.SSLSocketStreamFactory;
import org.appwork.utils.net.httpconnection.SSLSocketStreamFactory18;
import org.appwork.utils.net.httpconnection.SSLSocketStreamInterface;
import org.appwork.utils.net.httpconnection.SSLSocketStreamOptions;
import org.appwork.utils.net.httpconnection.SocketStreamInterface;
import org.appwork.utils.net.httpconnection.X509TrustManagerBridge;

public class JavaSSLSocketStreamFactory
implements SSLSocketStreamFactory {
    private static final JavaSSLSocketStreamFactory INSTANCE = new JavaSSLSocketStreamFactory();
    private static final String TLS13_ENABLED = "JSSE_TLS1.3_ENABLED";
    private static final String TLS10_11_DISABLED = "JSSE_TLS10_11_DISABLED";

    public static final JavaSSLSocketStreamFactory getInstance() {
        return INSTANCE;
    }

    @Override
    public SSLSocketFactory getSSLSocketFactory(SSLSocketStreamOptions options, String sniHostName) throws IOException {
        boolean sniEnabled = !StringUtils.isEmpty(sniHostName) && (options == null || options.isSNIEnabled());
        return this.getSSLSocketFactory(this.getSSLContext(options), options, sniEnabled ? sniHostName : null);
    }

    public void isCipherSuiteSupported(String ... cipherSuites) throws SSLException {
        try {
            SSLContext context = this.getSSLContext(null);
            SSLParameters parameters = context.getSupportedSSLParameters();
            List<String> supportedCipherSuites = Arrays.asList(parameters.getCipherSuites());
            for (String cipherSuite : cipherSuites) {
                if (supportedCipherSuites.contains(cipherSuite)) continue;
                throw new SSLException(cipherSuite + " is unsupported!");
            }
        }
        catch (IOException e) {
            throw new SSLException(e);
        }
        catch (RuntimeException e) {
            throw new SSLException(e);
        }
    }

    protected X509TrustManager bridge(final X509TrustManagerBridge trustManagerBridge) throws SSLException {
        if (JVMVersion.isAtLeast(JavaVersion.JVM_1_8)) {
            return SSLSocketStreamFactory18.bridge(trustManagerBridge);
        }
        return new X509TrustManager(){

            @Override
            public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                trustManagerBridge.checkClientTrusted(chain, authType, null, null);
            }

            @Override
            public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                trustManagerBridge.checkServerTrusted(chain, authType, null, null);
            }

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return trustManagerBridge.getAcceptedIssuers();
            }
        };
    }

    protected TrustManager[] getTrustCerts(SSLSocketStreamOptions options) throws SSLException {
        if (options == null || options.isTrustAll()) {
            return new TrustManager[]{this.bridge(new X509TrustManagerBridge(){

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return new X509Certificate[0];
                }

                @Override
                public void checkServerTrusted(X509Certificate[] chain, String authType, Socket socket, SSLEngine engine) throws CertificateException {
                }

                @Override
                public void checkClientTrusted(X509Certificate[] chain, String authType, Socket socket, SSLEngine engine) throws CertificateException {
                }

                @Override
                public X509TrustManager getTrustManager() {
                    return null;
                }
            })};
        }
        return null;
    }

    protected SSLContext getSSLContext(SSLSocketStreamOptions options) throws IOException {
        ArrayList<String> protocols = new ArrayList<String>();
        if (options != null && options.getCustomFactorySettings().contains(TLS13_ENABLED)) {
            protocols.add(TLS.TLS_1_3.id);
        }
        if (options != null && options.getCustomFactorySettings().contains(TLS10_11_DISABLED)) {
            protocols.add(TLS.TLS_1_2.id);
        }
        protocols.add("TLS");
        protocols.add("SSL");
        SSLContext sslContext = null;
        NoSuchAlgorithmException nsae = null;
        for (String protocol : protocols) {
            try {
                sslContext = SSLContext.getInstance(protocol);
                break;
            }
            catch (NoSuchAlgorithmException e) {
                nsae = Exceptions.addSuppressed(e, nsae);
            }
        }
        if (sslContext != null) {
            try {
                sslContext.init(null, this.getTrustCerts(options), null);
                return sslContext;
            }
            catch (KeyManagementException e) {
                throw new SSLException(e);
            }
        }
        throw new SSLException(nsae);
    }

    protected String[] filterEnabledSupportedProtocols(SSLSocketStreamOptions options, SSLContext sslContext, String ... onlyEnabledProtocols) {
        List<String> supportedProtocols = Arrays.asList(sslContext.getSupportedSSLParameters().getProtocols());
        ArrayList<String> enabledProtocols = onlyEnabledProtocols.length == 0 ? new ArrayList<String>(supportedProtocols) : new ArrayList<String>(Arrays.asList(onlyEnabledProtocols));
        enabledProtocols.retainAll(supportedProtocols);
        if (options != null) {
            if (!options.getCustomFactorySettings().contains(TLS13_ENABLED)) {
                enabledProtocols.remove(TLS.TLS_1_3.id);
            }
            if (options.getCustomFactorySettings().contains(TLS10_11_DISABLED)) {
                enabledProtocols.remove(TLS.TLS_1_1.id);
                enabledProtocols.remove(TLS.TLS_1_0.id);
            }
        }
        return enabledProtocols.toArray(new String[0]);
    }

    protected SSLSocket modifyProtocols(SSLSocket sslSocket, SSLSocketFactory factory, SSLContext sslContext, SSLSocketStreamOptions options) {
        if (sslContext != null) {
            if (this.isTLSSupported(TLS.TLS_1_3, options, sslContext)) {
                sslSocket.setEnabledProtocols(this.filterEnabledSupportedProtocols(options, sslContext, TLS.TLS_1_0.id, TLS.TLS_1_1.id, TLS.TLS_1_2.id, TLS.TLS_1_3.id));
            } else if (JVMVersion.isMinimum(JVMVersion.JAVA_1_8)) {
                sslSocket.setEnabledProtocols(this.filterEnabledSupportedProtocols(options, sslContext, TLS.TLS_1_0.id, TLS.TLS_1_1.id, TLS.TLS_1_2.id));
            } else if (JVMVersion.isMinimum(JVMVersion.JAVA_1_7)) {
                sslSocket.setEnabledProtocols(this.filterEnabledSupportedProtocols(options, sslContext, TLS.TLS_1_0.id, TLS.TLS_1_1.id, TLS.TLS_1_2.id));
            } else if (JVMVersion.isMinimum(JVMVersion.JAVA_16 + 121000L)) {
                sslSocket.setEnabledProtocols(this.filterEnabledSupportedProtocols(options, sslContext, TLS.TLS_1_0.id, TLS.TLS_1_1.id, TLS.TLS_1_2.id));
            } else if (JVMVersion.isMinimum(JVMVersion.JAVA_16 + 111000L)) {
                sslSocket.setEnabledProtocols(this.filterEnabledSupportedProtocols(options, sslContext, TLS.TLS_1_0.id, TLS.TLS_1_1.id));
            } else {
                sslSocket.setEnabledProtocols(this.filterEnabledSupportedProtocols(options, sslContext, TLS.TLS_1_0.id));
            }
        }
        return sslSocket;
    }

    public boolean isTLSSupported(TLS tls, SSLSocketStreamOptions options, SSLContext sslContext) {
        try {
            if (sslContext == null) {
                sslContext = this.getSSLContext(options);
            }
            return tls != null && Arrays.asList(sslContext.getSupportedSSLParameters().getProtocols()).contains(tls.id);
        }
        catch (Exception e) {
            return false;
        }
    }

    protected SSLSocket modifyCipherSuites(SSLSocket sslSocket, SSLSocketStreamOptions options) {
        if (sslSocket != null) {
            sslSocket.setEnabledCipherSuites(this.modifyCipherSuites(sslSocket.getEnabledCipherSuites(), options));
            if (JVMVersion.isMinimum(JVMVersion.JAVA_1_8) && options != null && options.hasCipherSuitesPreferences()) {
                SSLParameters sslParams = sslSocket.getSSLParameters();
                sslParams.setUseCipherSuitesOrder(true);
                sslSocket.setSSLParameters(sslParams);
            }
        }
        return sslSocket;
    }

    protected String[] modifyCipherSuites(String[] cipherSuites, SSLSocketStreamOptions options) {
        if (cipherSuites != null && options != null) {
            String next;
            Iterator<String> it;
            ArrayList<String> avoided = new ArrayList<String>();
            ArrayList<String> preferred = new ArrayList<String>();
            ArrayList<String> disabled = new ArrayList<String>();
            ArrayList<String> list = new ArrayList<String>(Arrays.asList(cipherSuites));
            if (options.getDisabledCipherSuites().size() > 0) {
                for (String disabledEntry : options.getDisabledCipherSuites()) {
                    it = list.iterator();
                    block1: while (it.hasNext()) {
                        next = it.next();
                        if (!StringUtils.containsIgnoreCase(next, disabledEntry)) continue;
                        if (!disabledEntry.endsWith("_")) {
                            for (String enabledEntry : options.getEnabledCipherSuites()) {
                                if (!StringUtils.containsIgnoreCase(next, enabledEntry)) continue;
                                continue block1;
                            }
                        }
                        it.remove();
                        disabled.add(next);
                    }
                }
            }
            if (options.getAvoidedCipherSuites().size() > 0) {
                for (String avoidedEntry : options.getAvoidedCipherSuites()) {
                    it = list.iterator();
                    while (it.hasNext()) {
                        next = it.next();
                        if (!StringUtils.containsIgnoreCase(next, avoidedEntry)) continue;
                        it.remove();
                        avoided.add(next);
                    }
                }
            }
            if (options.getPreferredCipherSuites().size() > 0) {
                for (String preferredEntry : options.getPreferredCipherSuites()) {
                    it = list.iterator();
                    while (it.hasNext()) {
                        next = it.next();
                        if (!StringUtils.containsIgnoreCase(next, preferredEntry)) continue;
                        it.remove();
                        preferred.add(next);
                    }
                    it = avoided.iterator();
                    while (it.hasNext()) {
                        next = it.next();
                        if (!StringUtils.containsIgnoreCase(next, preferredEntry)) continue;
                        it.remove();
                        preferred.add(next);
                    }
                }
            }
            if (disabled.size() > 0 || preferred.size() > 0 || avoided.size() > 0) {
                if (preferred.size() > 0) {
                    list.addAll(0, preferred);
                }
                if (avoided.size() > 0) {
                    list.addAll(avoided);
                }
                cipherSuites = list.toArray(new String[0]);
            }
            return options.sortCipherSuites(cipherSuites);
        }
        return cipherSuites;
    }

    protected SSLSocket modify(SSLSocket sslSocket, SSLSocketFactory factory, SSLContext sslContext, SSLSocketStreamOptions options, String sniHostName) {
        sslSocket = this.modifyCipherSuites(this.modifyProtocols(sslSocket, factory, sslContext, options), options);
        if (JVMVersion.isAtLeast(JavaVersion.JVM_1_8) && options != null) {
            SSLSocketStreamFactory18.setSNIServerName(options, sslSocket, sniHostName);
        }
        return sslSocket;
    }

    protected SSLSocketFactory getSSLSocketFactory(final SSLContext sslContext, final SSLSocketStreamOptions options, final String sniHostName) throws IOException {
        final SSLSocketFactory factory = sslContext.getSocketFactory();
        return new SSLSocketFactory(){

            @Override
            public Socket createSocket(Socket arg0, String arg1, int arg2, boolean arg3) throws IOException {
                SSLSocket ret = (SSLSocket)factory.createSocket(arg0, arg1, arg2, arg3);
                return JavaSSLSocketStreamFactory.this.modify(ret, factory, sslContext, options, sniHostName);
            }

            @Override
            public String[] getDefaultCipherSuites() {
                return JavaSSLSocketStreamFactory.this.modifyCipherSuites(factory.getDefaultCipherSuites(), options);
            }

            @Override
            public String[] getSupportedCipherSuites() {
                return JavaSSLSocketStreamFactory.this.modifyCipherSuites(factory.getSupportedCipherSuites(), options);
            }

            @Override
            public Socket createSocket(String arg0, int arg1) throws IOException, UnknownHostException {
                SSLSocket ret = (SSLSocket)factory.createSocket(arg0, arg1);
                return JavaSSLSocketStreamFactory.this.modify(ret, factory, sslContext, options, sniHostName);
            }

            @Override
            public Socket createSocket(InetAddress arg0, int arg1) throws IOException {
                SSLSocket ret = (SSLSocket)factory.createSocket(arg0, arg1);
                return JavaSSLSocketStreamFactory.this.modify(ret, factory, sslContext, options, sniHostName);
            }

            @Override
            public Socket createSocket(String arg0, int arg1, InetAddress arg2, int arg3) throws IOException, UnknownHostException {
                SSLSocket ret = (SSLSocket)factory.createSocket(arg0, arg1, arg2, arg3);
                return JavaSSLSocketStreamFactory.this.modify(ret, factory, sslContext, options, sniHostName);
            }

            @Override
            public Socket createSocket(InetAddress arg0, int arg1, InetAddress arg2, int arg3) throws IOException {
                SSLSocket ret = (SSLSocket)factory.createSocket(arg0, arg1, arg2, arg3);
                return JavaSSLSocketStreamFactory.this.modify(ret, factory, sslContext, options, sniHostName);
            }
        };
    }

    protected Boolean verifySSLHostname(HostnameVerifier hostNameVerifier, SSLSession session, String host) throws IOException {
        return HTTPConnectionUtils.verifySSLHostname(hostNameVerifier, session, host);
    }

    @Override
    public SSLSocketStreamInterface create(final SocketStreamInterface socketStream, String host, int port, boolean autoClose, final SSLSocketStreamOptions options) throws IOException {
        boolean sniEnabled = !StringUtils.isEmpty(host) && (options == null || options.isSNIEnabled());
        final SSLContext sslContext = this.getSSLContext(options);
        final SSLSocketFactory sslFactory = this.getSSLSocketFactory(sslContext, options, sniEnabled ? host : null);
        final SSLSocket sslSocket = (SSLSocket)sslFactory.createSocket(socketStream.getSocket(), sniEnabled ? host : "", port, autoClose);
        if (options != null && !options.isTrustAll()) {
            this.verifySSLHostname(null, sslSocket.getSession(), host);
        }
        return new JSSESSLSocketStreamInterface(){

            @Override
            public SSLSocket getSocket() {
                return sslSocket;
            }

            @Override
            public OutputStream getOutputStream() throws IOException {
                return sslSocket.getOutputStream();
            }

            @Override
            public InputStream getInputStream() throws IOException {
                return sslSocket.getInputStream();
            }

            @Override
            public void close() throws IOException {
                sslSocket.close();
            }

            @Override
            public SocketStreamInterface getParentSocketStream() {
                return socketStream;
            }

            @Override
            public String getCipherSuite() {
                SSLSession session = sslSocket.getSession();
                return "JVM|Protocol:" + session.getProtocol() + "|CipherSuite:" + session.getCipherSuite();
            }

            @Override
            public SSLSocketStreamOptions getOptions() {
                return options;
            }

            @Override
            public SSLContext getSSLContext() {
                return sslContext;
            }

            @Override
            public SSLSocketFactory getSSLSocketFactory() {
                return sslFactory;
            }

            @Override
            public SSLSocketStreamFactory getSSLSocketStreamFactory() {
                return JavaSSLSocketStreamFactory.this;
            }

            @Override
            public SSLSession getSSLSession() {
                return sslSocket.getSession();
            }
        };
    }

    @Override
    public String retry(SSLSocketStreamOptions options, Exception e) {
        String jsseRetry;
        if (this.isTLSSupported(TLS.TLS_1_3, options, null) && options.isTLSConfigurationException(e)) {
            if (options.getCustomFactorySettings().add(TLS13_ENABLED)) {
                return options.addRetryReason("(TLS)enable TLS1.3");
            }
            jsseRetry = options.enableNextDisabledCipher("GCM");
            if (jsseRetry != null) {
                return options.addRetryReason("(TLS)enable " + jsseRetry + " for TLS1.3");
            }
        }
        if (options.isHandshakeException(e)) {
            jsseRetry = options.enableNextDisabledCipher("GCM");
            if (jsseRetry != null) {
                return options.addRetryReason("(Handshake)enable " + jsseRetry + " for TLS1.2/TLS1.3");
            }
            if (options.getCustomFactorySettings().add(TLS10_11_DISABLED)) {
                return options.addRetryReason("(Handshake)disable TLS1.0/TLS1.1");
            }
            if (this.isTLSSupported(TLS.TLS_1_3, options, null) && options.getCustomFactorySettings().add(TLS13_ENABLED)) {
                return options.addRetryReason("(Handshake)enable TLS1.3");
            }
        }
        if (options.isConnectionResetException(e)) {
            jsseRetry = options.enableNextDisabledCipher("GCM");
            if (jsseRetry != null) {
                return options.addRetryReason("(Reset)enable " + jsseRetry + " for TLS1.2/TLS1.3");
            }
            if (options.getCustomFactorySettings().add(TLS10_11_DISABLED)) {
                return options.addRetryReason("(Reset)disable TLS1.0/TLS1.1");
            }
            if (this.isTLSSupported(TLS.TLS_1_3, options, null) && options.getCustomFactorySettings().add(TLS13_ENABLED)) {
                return options.addRetryReason("(Reset)enable TLS1.3");
            }
        }
        if (this.isTLSSupported(TLS.TLS_1_3, options, null) && options.getCustomFactorySettings().add(TLS13_ENABLED)) {
            return options.addRetryReason("(Retry)Enable TLS1.3");
        }
        return null;
    }

    public static interface JSSESSLSocketStreamInterface
    extends SSLSocketStreamInterface {
        public SSLContext getSSLContext();

        public SSLSession getSSLSession();

        public SSLSocketFactory getSSLSocketFactory();
    }

    public static enum TLS {
        TLS_1_3("TLSv1.3"),
        TLS_1_2("TLSv1.2"),
        TLS_1_1("TLSv1.1"),
        TLS_1_0("TLSv1");

        protected final String id;

        private TLS(String id) {
            this.id = id;
        }
    }
}

