/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils.net.httpserver.session;

import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.appwork.remoteapi.ParseException;
import org.appwork.remoteapi.RemoteAPI;
import org.appwork.remoteapi.RemoteAPIRequest;
import org.appwork.remoteapi.RemoteAPIResponse;
import org.appwork.remoteapi.SessionRemoteAPIRequest;
import org.appwork.remoteapi.exceptions.ApiInterfaceNotAvailable;
import org.appwork.remoteapi.exceptions.AuthException;
import org.appwork.remoteapi.exceptions.BasicRemoteAPIException;
import org.appwork.remoteapi.exceptions.SessionException;
import org.appwork.storage.JSonStorage;
import org.appwork.utils.StringUtils;
import org.appwork.utils.net.httpserver.handler.HttpRequestHandler;
import org.appwork.utils.net.httpserver.requests.GetRequest;
import org.appwork.utils.net.httpserver.requests.HttpRequest;
import org.appwork.utils.net.httpserver.requests.KeyValuePair;
import org.appwork.utils.net.httpserver.requests.PostRequest;
import org.appwork.utils.net.httpserver.responses.HttpResponse;
import org.appwork.utils.net.httpserver.session.HttpSession;
import org.appwork.utils.net.httpserver.session.LoginAPIInterface;
import org.appwork.utils.reflection.Clazz;

public abstract class AbstractSessionRemoteAPI<T extends HttpSession>
extends RemoteAPI
implements HttpRequestHandler,
LoginAPIInterface {
    public AbstractSessionRemoteAPI() throws ParseException {
        this.register(this);
    }

    protected SessionRemoteAPIRequest<T> createSessionRemoteAPIRequest(T session, HttpRequest request, RemoteAPIRequest apiRequest) throws BasicRemoteAPIException {
        return new SessionRemoteAPIRequest<T>(request, apiRequest, session);
    }

    @Override
    public boolean disconnect(RemoteAPIRequest request) {
        SessionRemoteAPIRequest req = (SessionRemoteAPIRequest)request;
        Object session = req.getSession();
        if (session != null) {
            return this.removeSession(session);
        }
        return false;
    }

    private String extractSessionID(HttpRequest request) throws IOException {
        ArrayList<KeyValuePair> params = new ArrayList<KeyValuePair>();
        String token = null;
        List<KeyValuePair> get = request.getRequestedURLParameters();
        if (get != null) {
            for (KeyValuePair next : get) {
                if ("token".equalsIgnoreCase(next.key)) {
                    token = next.value;
                    continue;
                }
                params.add(next);
            }
            request.setRequestedURLParameters(params);
        }
        if (StringUtils.isEmpty(token) && request instanceof PostRequest) {
            List<KeyValuePair> post = ((PostRequest)request).getPostParameter();
            params = new ArrayList();
            for (KeyValuePair next : post) {
                if ("token".equalsIgnoreCase(next.key)) {
                    token = next.value;
                    continue;
                }
                params.add(next);
            }
            ((PostRequest)request).setPostParameter(params);
        }
        return token;
    }

    protected abstract T getSession(HttpRequest var1, String var2);

    @Override
    protected Object handleVoidMethods(Object responseData, Method method) {
        if (Clazz.isVoid(method.getReturnType())) {
            responseData = null;
        }
        return responseData;
    }

    @Override
    public String handshake(RemoteAPIRequest request, String user, String password) throws AuthException {
        T session = this.newSession(request, user, password);
        if (session == null) {
            throw new AuthException();
        }
        return session.getSessionID();
    }

    protected abstract T newSession(RemoteAPIRequest var1, String var2, String var3);

    @Override
    public boolean onGetRequest(GetRequest request, HttpResponse response) throws BasicRemoteAPIException {
        return this.onRequest(request, response);
    }

    @Override
    public boolean onPostRequest(PostRequest request, HttpResponse response) throws BasicRemoteAPIException {
        return this.onRequest(request, response);
    }

    private boolean onRequest(HttpRequest request, HttpResponse response) throws BasicRemoteAPIException {
        try {
            String token = this.extractSessionID(request);
            SessionRemoteAPIRequest<T> apiRequest = this.createRemoteAPIRequestObject(request);
            if (apiRequest == null) {
                throw new ApiInterfaceNotAvailable();
            }
            if (((RemoteAPIRequest)apiRequest).getMethod() == null) {
                throw new ApiInterfaceNotAvailable();
            }
            Class<?> declaringClass = ((RemoteAPIRequest)apiRequest).getMethod().getDeclaringClass();
            if (declaringClass != LoginAPIInterface.class && ((RemoteAPIRequest)apiRequest).getIface().isSessionRequired()) {
                T session = this.getSession(request, token);
                if (session == null || !session.isAlive()) {
                    throw new SessionException();
                }
                apiRequest = this.createSessionRemoteAPIRequest(session, request, apiRequest);
            }
            this._handleRemoteAPICall(apiRequest, this.createRemoteAPIResponseObject(apiRequest, response));
            return true;
        }
        catch (IOException e) {
            throw new BasicRemoteAPIException(e);
        }
    }

    protected abstract boolean removeSession(T var1);

    @Override
    public String toString(RemoteAPIRequest request, RemoteAPIResponse response, Object responseData) {
        return JSonStorage.serializeToJson(responseData);
    }
}

