/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils.os;

import java.awt.Desktop;
import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Pattern;
import org.appwork.exceptions.WTFException;
import org.appwork.loggingv3.LogV3;
import org.appwork.utils.Application;
import org.appwork.utils.Files;
import org.appwork.utils.IO;
import org.appwork.utils.Regex;
import org.appwork.utils.StringUtils;
import org.appwork.utils.logging2.LogInterface;
import org.appwork.utils.os.CrossSystem;
import org.appwork.utils.os.DesktopSupportJavaDesktop;
import org.appwork.utils.processes.ProcessBuilderFactory;
import org.appwork.utils.processes.ProcessOutput;

public class DesktopSupportWindows
extends DesktopSupportJavaDesktop {
    private final char SLASH = File.separatorChar;

    @Override
    public void browseURL(URL url) throws IOException, URISyntaxException {
        try {
            Desktop.getDesktop().browse(url.toURI());
        }
        catch (Throwable e) {
            ProcessBuilderFactory.create("rundll32.exe", "url.dll,FileProtocolHandler", url.toExternalForm()).start();
        }
    }

    @Override
    public boolean isBrowseURLSupported() {
        return true;
    }

    @Override
    public boolean isOpenFileSupported() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void openFile(final File file) throws IOException {
        if (!file.exists()) {
            throw new IOException("File does not exist " + file.getAbsolutePath());
        }
        try {
            final AtomicReference<Object> resultReference = new AtomicReference<Object>(null);
            Thread openThread = new Thread("openFile:" + file){
                {
                    super(x0);
                    this.setDaemon(true);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        Desktop.getDesktop().open(file);
                        AtomicReference atomicReference = resultReference;
                        synchronized (atomicReference) {
                            resultReference.set(Boolean.TRUE);
                            resultReference.notifyAll();
                        }
                    }
                    catch (IOException e) {
                        AtomicReference atomicReference = resultReference;
                        synchronized (atomicReference) {
                            resultReference.set(e);
                            resultReference.notifyAll();
                        }
                    }
                }
            };
            openThread.start();
            Object result = null;
            AtomicReference<Object> atomicReference = resultReference;
            synchronized (atomicReference) {
                result = resultReference.get();
                if (result == null) {
                    resultReference.wait(1000L);
                    result = resultReference.get();
                }
            }
            if (result instanceof Exception) {
                throw (Exception)result;
            }
            if (Boolean.TRUE.equals(result)) {
                return;
            }
            ProcessBuilderFactory.create("cmd", "/c", "start", "/B", " ", file.getCanonicalPath()).start();
        }
        catch (Exception e) {
            ProcessBuilderFactory.create("rundll32.exe", "url.dll,FileProtocolHandler", file.getCanonicalPath()).start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean reboot(boolean force, int waitms) throws InterruptedException {
        CrossSystem.OperatingSystem os = CrossSystem.OS;
        if (!CrossSystem.OSFamily.WINDOWS.equals((Object)os.getFamily())) {
            return false;
        }
        switch (os) {
            case WINDOWS_OTHERS: {
                if (force) {
                    try {
                        ProcessBuilderFactory.runCommand("RUNDLL32.EXE", "user,ExitWindowsExec");
                    }
                    catch (InterruptedException e) {
                        throw e;
                    }
                    catch (Exception e) {
                        LogV3.log(e);
                    }
                    try {
                        ProcessBuilderFactory.runCommand("RUNDLL32.EXE", "Shell32,SHExitWindowsEx", "4");
                    }
                    catch (InterruptedException e) {
                        throw e;
                    }
                    catch (Exception e) {
                        LogV3.log(e);
                    }
                    return true;
                }
                try {
                    ProcessBuilderFactory.runCommand("RUNDLL32.EXE", "user,ExitWindowsExec");
                }
                catch (InterruptedException e) {
                    throw e;
                }
                catch (Exception e) {
                    LogV3.log(e);
                }
                try {
                    ProcessBuilderFactory.runCommand("RUNDLL32.EXE", "Shell32,SHExitWindowsEx", "2");
                }
                catch (InterruptedException e) {
                    throw e;
                }
                catch (Exception e) {
                    LogV3.log(e);
                }
                return true;
            }
        }
        if (force) {
            try {
                ProcessBuilderFactory.runCommand("shutdown.exe", "-r", "-f", "-t", String.valueOf(waitms / 1000));
            }
            catch (InterruptedException e) {
                throw e;
            }
            catch (Exception e) {
                LogV3.log(e);
            }
            try {
                ProcessBuilderFactory.runCommand("%windir%\\system32\\shutdown.exe", "-r", "-f", "-t", String.valueOf(waitms / 1000));
            }
            catch (InterruptedException e) {
                throw e;
            }
            catch (Exception e) {
                LogV3.log(e);
            }
        } else {
            try {
                ProcessBuilderFactory.runCommand("shutdown.exe", "-r", "-t", String.valueOf(waitms / 1000));
            }
            catch (InterruptedException e) {
                throw e;
            }
            catch (Exception e) {
                LogV3.log(e);
            }
            try {
                ProcessBuilderFactory.runCommand("%windir%\\system32\\shutdown.exe", "-r", "-t", String.valueOf(waitms / 1000));
            }
            catch (InterruptedException e) {
                throw e;
            }
            catch (Exception e) {
                LogV3.log(e);
            }
        }
        if (os == CrossSystem.OperatingSystem.WINDOWS_2000 || os == CrossSystem.OperatingSystem.WINDOWS_NT) {
            try {
                File f = Application.getTempResource("shutdown.vbs");
                f.deleteOnExit();
                IO.writeStringToFile(f, "set WshShell = CreateObject(\"WScript.Shell\")\r\nWshShell.SendKeys \"^{ESC}^{ESC}^{ESC}{UP}{UP}{UP}{UP}{DOWN}{DOWN}{ENTER}{ENTER}\"\r\n");
                try {
                    ProcessBuilderFactory.runCommand("cmd", "/c", "start", "/min", "cscript", f.getAbsolutePath());
                }
                finally {
                    Files.deleteRecursive(f);
                }
            }
            catch (InterruptedException e) {
                throw e;
            }
            catch (Exception e) {
                LogV3.log(e);
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean shutdown(boolean force) throws InterruptedException {
        CrossSystem.OperatingSystem os = CrossSystem.OS;
        if (!CrossSystem.OSFamily.WINDOWS.equals((Object)os.getFamily())) {
            return false;
        }
        switch (os) {
            case WINDOWS_OTHERS: {
                try {
                    ProcessBuilderFactory.runCommand("RUNDLL32.EXE", "user,ExitWindows");
                }
                catch (InterruptedException e) {
                    throw e;
                }
                catch (Exception e) {
                    LogV3.log(e);
                }
                try {
                    ProcessBuilderFactory.runCommand("RUNDLL32.EXE", "Shell32,SHExitWindowsEx", "1");
                }
                catch (InterruptedException e) {
                    throw e;
                }
                catch (Exception e) {
                    LogV3.log(e);
                }
                return true;
            }
        }
        if (force) {
            try {
                ProcessBuilderFactory.runCommand("shutdown.exe", "-s", "-f", "-t", "01");
            }
            catch (InterruptedException e) {
                throw e;
            }
            catch (Exception e) {
                LogV3.log(e);
            }
            try {
                ProcessBuilderFactory.runCommand("%windir%\\system32\\shutdown.exe", "-s", "-f", "-t", "01");
            }
            catch (InterruptedException e) {
                throw e;
            }
            catch (Exception e) {
                LogV3.log(e);
            }
        } else {
            try {
                ProcessBuilderFactory.runCommand("shutdown.exe", "-s", "-t", "01");
            }
            catch (InterruptedException e) {
                throw e;
            }
            catch (Exception e) {
                LogV3.log(e);
            }
            try {
                ProcessBuilderFactory.runCommand("%windir%\\system32\\shutdown.exe", "-s", "-t", "01");
            }
            catch (InterruptedException e) {
                throw e;
            }
            catch (Exception e) {
                LogV3.log(e);
            }
        }
        if (os == CrossSystem.OperatingSystem.WINDOWS_2000 || os == CrossSystem.OperatingSystem.WINDOWS_NT) {
            try {
                File f = Application.getTempResource("shutdown.vbs");
                f.deleteOnExit();
                IO.writeStringToFile(f, "set WshShell = CreateObject(\"WScript.Shell\")\r\nWshShell.SendKeys \"^{ESC}^{ESC}^{ESC}{UP}{ENTER}{ENTER}\"\r\n");
                try {
                    ProcessBuilderFactory.runCommand("cmd", "/c", "start", "/min", "cscript", f.getAbsolutePath());
                }
                finally {
                    Files.deleteRecursiv(f);
                }
            }
            catch (InterruptedException e) {
                throw e;
            }
            catch (Exception e) {
                LogV3.log(e);
            }
        }
        return true;
    }

    @Override
    public boolean standby() throws InterruptedException {
        CrossSystem.OperatingSystem os = CrossSystem.OS;
        if (!CrossSystem.OSFamily.WINDOWS.equals((Object)os.getFamily())) {
            return false;
        }
        switch (os) {
            case WINDOWS_OTHERS: {
                LogV3.info("no standby support, use shutdown");
                return false;
            }
        }
        if (DesktopSupportWindows.isHibernateActivated()) {
            String path = CrossSystem.is64BitOperatingSystem() ? Application.getResource("tools\\Windows\\elevate\\Elevate64.exe").getAbsolutePath() : Application.getResource("tools\\Windows\\elevate\\Elevate32.exe").getAbsolutePath();
            try {
                ProcessBuilderFactory.runCommand(path, "powercfg", "-hibernate", "off");
            }
            catch (InterruptedException iEx) {
                throw iEx;
            }
            catch (Throwable e) {
                LogV3.log(e);
            }
        }
        try {
            ProcessBuilderFactory.runCommand("powercfg.exe", "hibernate off");
        }
        catch (InterruptedException iEx) {
            throw iEx;
        }
        catch (Exception e) {
            try {
                ProcessBuilderFactory.runCommand("%windir%\\system32\\powercfg.exe", "hibernate off");
            }
            catch (InterruptedException iEx) {
                throw iEx;
            }
            catch (Exception ex) {
                LogV3.log(ex);
            }
        }
        try {
            ProcessBuilderFactory.runCommand("RUNDLL32.EXE", "powrprof.dll,SetSuspendState");
        }
        catch (InterruptedException iEx) {
            throw iEx;
        }
        catch (Exception e) {
            try {
                ProcessBuilderFactory.runCommand("%windir%\\system32\\RUNDLL32.EXE", "powrprof.dll,SetSuspendState");
            }
            catch (InterruptedException iEx) {
                throw iEx;
            }
            catch (Exception e1) {
                LogV3.log(e);
            }
        }
        return true;
    }

    @Override
    public boolean hibernate() throws InterruptedException {
        CrossSystem.OperatingSystem os = CrossSystem.OS;
        if (!CrossSystem.OSFamily.WINDOWS.equals((Object)os.getFamily())) {
            return false;
        }
        switch (os) {
            case WINDOWS_OTHERS: {
                LogV3.info("no hibernate support, use shutdown");
                return false;
            }
        }
        if (!DesktopSupportWindows.isHibernateActivated()) {
            String path = CrossSystem.is64BitOperatingSystem() ? Application.getResource("tools\\Windows\\elevate\\Elevate64.exe").getAbsolutePath() : Application.getResource("tools\\Windows\\elevate\\Elevate32.exe").getAbsolutePath();
            try {
                ProcessBuilderFactory.runCommand(path, "powercfg", "-hibernate", "on");
            }
            catch (InterruptedException iEx) {
                throw iEx;
            }
            catch (Throwable e) {
                LogV3.log(e);
            }
        }
        try {
            ProcessBuilderFactory.runCommand("powercfg.exe", "hibernate on");
        }
        catch (InterruptedException iEx) {
            throw iEx;
        }
        catch (Exception e) {
            try {
                ProcessBuilderFactory.runCommand("%windir%\\system32\\powercfg.exe", "hibernate on");
            }
            catch (InterruptedException iEx) {
                throw iEx;
            }
            catch (Exception ex) {
                LogV3.log(ex);
            }
        }
        try {
            ProcessBuilderFactory.runCommand("RUNDLL32.EXE", "powrprof.dll,SetSuspendState");
        }
        catch (InterruptedException iEx) {
            throw iEx;
        }
        catch (Exception e) {
            LogV3.log(e);
            try {
                ProcessBuilderFactory.runCommand("%windir%\\system32\\RUNDLL32.EXE", "powrprof.dll,SetSuspendState");
            }
            catch (InterruptedException iEx) {
                throw iEx;
            }
            catch (Exception ex) {
                LogV3.log(ex);
            }
        }
        return true;
    }

    private static boolean isHibernateActivated() throws InterruptedException {
        try {
            ProcessOutput status = ProcessBuilderFactory.runCommand("powercfg", "-a");
            if (status.getStdOutString() != null) {
                if (status.getStdOutString().contains("Ruhezustand wurde nicht aktiviert")) {
                    return false;
                }
                if (status.getStdOutString().contains("Hibernation has not been enabled")) {
                    return false;
                }
                if (status.getStdOutString().contains("Hibernation")) {
                    return false;
                }
            }
        }
        catch (InterruptedException e) {
            throw e;
        }
        catch (Exception e) {
            LogV3.log(e);
        }
        return true;
    }

    @Override
    public String getProcessCommandlineByPID(long pid) throws InterruptedException {
        try {
            ProcessOutput result = ProcessBuilderFactory.runCommand("wmic", "process", "where", "ProcessID=" + pid, "get", "CommandLine");
            String str = result.getStdOutString().trim();
            return Regex.getLines(str)[2];
        }
        catch (InterruptedException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new WTFException(e);
        }
    }

    @Override
    public String getProcessExecutablePathByPID(long pid) throws InterruptedException {
        try {
            ProcessOutput result = ProcessBuilderFactory.runCommand("wmic", "process", "where", "ProcessID=" + pid, "get", "ExecutablePath");
            String str = result.getStdOutString().trim();
            return Regex.getLines(str)[2];
        }
        catch (InterruptedException e) {
            throw e;
        }
        catch (Throwable e) {
            return null;
        }
    }

    @Override
    public long[] killProcessesByExecutablePath(String path, int exitCode) throws InterruptedException {
        try {
            ProcessOutput result = ProcessBuilderFactory.runCommand("wmic", "process", "where", "ExecutablePath like '%" + path.replace("\\", "\\\\") + "%'", "Terminate", String.valueOf(exitCode));
            String str = result.getStdOutString().trim();
            LogV3.info(result.toString());
            String[] terminated = new Regex(str, "Win32_Process\\.Handle=\"(\\d+)\"\\)\\-\\>Terminate\\(\\)").getColumn(0);
            if (terminated == null) {
                return new long[0];
            }
            long[] ret = new long[terminated.length];
            int i = 0;
            for (String term : terminated) {
                ret[i++] = Long.parseLong(term);
            }
            return ret;
        }
        catch (InterruptedException e) {
            throw e;
        }
        catch (Throwable e) {
            return null;
        }
    }

    public String getProcessNameByPID(int pid) throws InterruptedException {
        try {
            ProcessOutput result = ProcessBuilderFactory.runCommand("cmd", "/c", "tasklist", "|", "findstr", String.valueOf(pid));
            String str = result.getStdOutString();
            for (String line : Regex.getLines(str)) {
                String name = new Regex(line = line.trim(), "^(\\S+)\\s+" + pid + "\\s+").getMatch(0);
                if (name == null) continue;
                return name;
            }
        }
        catch (InterruptedException e) {
            throw e;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    public int getPIDForRemoteAddress(SocketAddress adr) throws InterruptedException {
        try {
            ProcessOutput result = ProcessBuilderFactory.runCommand("cmd", "/c", "netstat", "-o", "-n", "-a", "|", "findstr", ((InetSocketAddress)adr).getAddress().getHostAddress() + ":" + ((InetSocketAddress)adr).getPort());
            String str = result.getStdOutString();
            for (String line : Regex.getLines(str)) {
                line = line.trim();
                String pid = new Regex(line, "^(?:TCP|UDP)\\s+" + Pattern.quote(((InetSocketAddress)adr).getAddress().getHostAddress()) + "\\:" + ((InetSocketAddress)adr).getPort() + "\\s+.*?(\\d+)$").getMatch(0);
                LogV3.fine("Get PID By socket(netstat): " + adr + " -> " + pid);
                if (pid == null) continue;
                return Integer.parseInt(pid);
            }
        }
        catch (InterruptedException iEx) {
            throw iEx;
        }
        catch (Throwable e) {
            throw new WTFException(e);
        }
        LogV3.fine("Get PID By socket(netstat): " + adr + " -> NONE");
        return -1;
    }

    public static String getProgramFiles(LogInterface logger) {
        int n;
        String ret;
        block8: {
            ret = null;
            try {
                String[] pathes;
                String[] stringArray = pathes = new String[]{"PROGRAMW6432", "ProgramFiles"};
                n = stringArray.length;
                for (int i = 0; i < n; ++i) {
                    String name = stringArray[i];
                    for (Map.Entry<String, String> es : System.getenv().entrySet()) {
                        File testProgramFiles;
                        if (!StringUtils.equalsIgnoreCase(es.getKey(), name) || !StringUtils.isNotEmpty(es.getValue()) || !(testProgramFiles = new File(es.getValue())).exists()) continue;
                        ret = es.getValue();
                        break block8;
                    }
                }
            }
            catch (Throwable e) {
                if (logger == null) break block8;
                logger.log(e);
            }
        }
        if (StringUtils.isEmpty(ret)) {
            File path;
            File[] fileArray = File.listRoots();
            int n2 = fileArray.length;
            for (n = 0; n < n2 && !new File(ret = new File(path = fileArray[n], "Program Files").getAbsolutePath()).exists(); ++n) {
                ret = null;
            }
        }
        if (ret != null) {
            while (ret.endsWith("/") || ret.endsWith("\\")) {
                ret = ret.substring(0, ret.length() - 1);
            }
        }
        return ret;
    }

    private boolean isDriveLetter(char c) {
        return c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z';
    }

    @Override
    public int getPrefixLength(String path) {
        char c1;
        char slash = this.SLASH;
        int n = path.length();
        if (n == 0) {
            return 0;
        }
        char c0 = path.charAt(0);
        char c = c1 = n > 1 ? path.charAt(1) : (char)'\u0000';
        if (c0 == slash) {
            if (c1 == slash) {
                return 2;
            }
            return 1;
        }
        if (this.isDriveLetter(c0) && c1 == ':') {
            if (n > 2 && path.charAt(2) == slash) {
                return 3;
            }
            return 2;
        }
        return 0;
    }

    public static String get32BitProgramFiles(LogInterface logger) {
        String ret;
        block8: {
            ret = null;
            try {
                String[] pathes;
                String[] stringArray = pathes = new String[]{"ProgramFiles(x86)", "ProgramFiles"};
                int n = stringArray.length;
                for (int i = 0; i < n; ++i) {
                    String name = stringArray[i];
                    for (Map.Entry<String, String> es : System.getenv().entrySet()) {
                        File testProgramFiles;
                        if (!StringUtils.equalsIgnoreCase(es.getKey(), name) || !StringUtils.isNotEmpty(es.getValue()) || !(testProgramFiles = new File(es.getValue())).exists()) continue;
                        ret = es.getValue();
                        break block8;
                    }
                }
            }
            catch (Throwable e) {
                if (logger == null) break block8;
                logger.log(e);
            }
        }
        if (StringUtils.isEmpty(ret)) {
            for (File path : File.listRoots()) {
                String string = ret = CrossSystem.is64BitOperatingSystem() ? new File(path, "Program Files (x86)").getAbsolutePath() : new File(path, "Program Files").getAbsolutePath();
                if (new File(ret).exists()) break;
                ret = null;
            }
        }
        if (ret != null) {
            while (ret.endsWith("/") || ret.endsWith("\\")) {
                ret = ret.substring(0, ret.length() - 1);
            }
        }
        return ret;
    }
}

