/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils.os.mime;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.appwork.loggingv3.LogV3;
import org.appwork.utils.os.mime.MimeDefault;

public class MimeLinux
extends MimeDefault {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getMimeDescription(String mimeType) {
        if (super.getMimeDescriptionCache(mimeType) != null) {
            return super.getMimeDescriptionCache(mimeType);
        }
        File file = new File("/usr/share/mime/" + mimeType + ".xml");
        if (!file.exists()) {
            return "Unknown";
        }
        String mime = "Unkown";
        FileInputStream fis = null;
        try {
            String line;
            fis = new FileInputStream(file);
            BufferedReader in = new BufferedReader(new InputStreamReader(fis));
            while ((line = in.readLine()) != null) {
                if (!line.contains("<comment>")) continue;
                Matcher m = Pattern.compile("<comment>(.*?)</comment>").matcher(line.trim());
                m.find();
                mime = m.group(1);
            }
        }
        catch (FileNotFoundException e) {
            LogV3.log(e);
        }
        catch (IOException e) {
            LogV3.log(e);
        }
        finally {
            try {
                if (fis != null) {
                    fis.close();
                }
            }
            catch (Throwable e) {}
        }
        super.saveMimeDescriptionCache(mimeType, mime);
        return mime;
    }
}

