/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils.swing.dimensor;

import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ComponentEvent;
import java.util.WeakHashMap;
import org.appwork.utils.os.CrossSystem;
import org.appwork.utils.swing.dimensor.AbstractDimensor;
import org.appwork.utils.swing.locationstore.LocationStorage;
import org.appwork.utils.swing.locationstore.LocationStorageManager;

public class RememberLastDimensor
extends AbstractDimensor {
    protected static final WeakHashMap<Window, Dimension> DIFFERENCE = new WeakHashMap();
    protected static final WeakHashMap<Window, Dimension> LAST = new WeakHashMap();

    public RememberLastDimensor(String id) {
        super(id);
    }

    @Override
    public Dimension getDimension(Window window) {
        LocationStorage cfg = LocationStorageManager.INSTANCE.get(window, this.getStorageID(window));
        Dimension ret = cfg.isValid() ? this.validate(new Dimension(cfg.getX(), cfg.getY()), window) : null;
        if (CrossSystem.isLinux() && ret != null) {
            LAST.put(window, ret);
        }
        return ret;
    }

    @Override
    public void onClose(Window window, ComponentEvent event) {
        if (window.isShowing()) {
            String storageID = this.getStorageID(window);
            LocationStorage cfg = LocationStorageManager.INSTANCE.get(window, storageID);
            if (CrossSystem.isLinux()) {
                Dimension difference;
                Dimension preferredSize = window.getPreferredSize();
                Dimension windowSize = new Dimension(window.getWidth(), window.getHeight());
                int differenceWidth = preferredSize.width - windowSize.width;
                int differenceWidthAbs = Math.abs(differenceWidth);
                int differenceHeight = preferredSize.height - windowSize.height;
                int differenceHeightAbs = Math.abs(differenceHeight);
                if (differenceWidthAbs > 0 && differenceWidthAbs <= 16 || differenceHeightAbs > 0 && differenceHeightAbs <= 16) {
                    difference = new Dimension(differenceWidth, differenceHeight);
                    if (!DIFFERENCE.containsKey(window)) {
                        DIFFERENCE.put(window, difference);
                    }
                }
                if ((difference = DIFFERENCE.get(window)) != null) {
                    Dimension correctedWindowSize = new Dimension(windowSize.width + difference.width, windowSize.height + difference.height);
                    LocationStorageManager.INSTANCE.onUpdate(window, null, correctedWindowSize, cfg, null);
                    return;
                }
            }
            LocationStorageManager.INSTANCE.onUpdate(window, null, null, cfg, null);
        }
    }
}

