/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils.swing.input;

import java.awt.Color;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class JInputTextField
extends JTextField
implements DocumentListener,
FocusListener {
    private static final long serialVersionUID = 1L;
    private final Color defaultColor;
    private Color infoColor = Color.GRAY;
    private boolean changed;
    private String infoText;

    public JInputTextField() {
        this.defaultColor = this.getForeground();
        this.getDocument().addDocumentListener(this);
        this.addFocusListener(this);
    }

    public JInputTextField(String helpText) {
        this();
        this.infoText = helpText;
        this.focusLost(null);
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.changed = true;
        this.setForeground(this.defaultColor);
    }

    @Override
    public void focusGained(FocusEvent e) {
        if (!this.changed) {
            this.setText("");
            this.setForeground(this.defaultColor);
        }
    }

    @Override
    public void focusLost(FocusEvent e) {
        if (this.getDocument().getLength() == 0 || this.getText().equals(this.getInfoText())) {
            this.setText(this.getInfoText());
            this.changed = false;
            this.setForeground(this.infoColor);
        }
    }

    public Color getInfoColor() {
        return this.infoColor;
    }

    protected String getInfoText() {
        return this.infoText;
    }

    @Override
    public String getText() {
        if (!this.changed) {
            return "";
        }
        return super.getText();
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.changed = true;
        this.setForeground(this.defaultColor);
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.changed = true;
        this.setForeground(this.defaultColor);
    }

    public void setInfoColor(Color infoColor) {
        this.infoColor = infoColor;
    }

    public void setInfoText(String infoText) {
        this.infoText = infoText;
    }
}

