/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils.swing.windowmanager;

import java.awt.Frame;
import java.awt.Window;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.Timer;
import java.util.TimerTask;
import java.util.WeakHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.SwingUtilities;
import org.appwork.utils.NullsafeAtomicReference;
import org.appwork.utils.swing.windowmanager.WindowManager;

public class LinuxWindowManager
extends WindowManager {
    private final Timer timer = new Timer("LinuxWindowManager", true);
    private boolean debugFlag = true;
    private final int toBackTimer = 100;
    private final int toFrontTimer = 100;
    private boolean useAlwaysOnTop = false;
    private final WeakHashMap<Window, LinuxWindowListenerMap> windowListeners = new WeakHashMap();

    public boolean isDebugFlag() {
        return this.debugFlag;
    }

    public boolean isUseAlwaysOnTop() {
        return this.useAlwaysOnTop;
    }

    public void setDebugFlag(boolean debugFlag) {
        this.debugFlag = debugFlag;
    }

    public void setUseAlwaysOnTop(boolean useAlwaysOnTop) {
        this.useAlwaysOnTop = useAlwaysOnTop;
    }

    @Override
    public void setVisible(Window w, boolean visible, WindowManager.FrameState state) {
        if (visible) {
            this.getMetaInfo(w).setShown(System.currentTimeMillis());
        }
        w.removeWindowFocusListener(this.windowFocusListener);
        w.addWindowFocusListener(this.windowFocusListener);
        if (!visible) {
            w.setVisible(false);
        } else {
            if (w instanceof Frame && WindowManager.WindowExtendedState.get(((Frame)w).getExtendedState()) == WindowManager.WindowExtendedState.ICONIFIED) {
                w.setVisible(true);
                return;
            }
            this.setZState(w, state, true);
        }
    }

    @Override
    public void setZState(Window w, WindowManager.FrameState state) {
        this.setZState(w, state, false);
    }

    public void setZState(final Window w, WindowManager.FrameState state, boolean makeVisible) {
        if (!makeVisible && !w.isVisible()) {
            return;
        }
        LinuxWindowListenerMap listenerMap = this.windowListeners.get(w);
        if (listenerMap == null) {
            listenerMap = new LinuxWindowListenerMap();
            this.windowListeners.put(w, listenerMap);
        }
        final LinuxWindowListenerMap finallistenerMap = listenerMap;
        LinuxWindowListener listener = null;
        final boolean requestFocus = state == WindowManager.FrameState.TO_FRONT_FOCUSED;
        switch (state) {
            case TO_BACK: {
                if (finallistenerMap.toBack.getAndSet(true)) break;
                listener = listenerMap.toFrontListener.getAndSet(null);
                if (listener != null && listener.remove(w, true) && this.isDebugFlag()) {
                    System.out.println("Remove previous toFront listener(undo): " + listener);
                }
                w.setVisible(false);
                w.setFocusable(false);
                w.setFocusableWindowState(false);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        w.toBack();
                        if (LinuxWindowManager.this.isDebugFlag()) {
                            System.out.println("Request toBack(use focusable false and invisible/visible workaround): " + w);
                        }
                        LinuxWindowManager.this.timer.schedule(new TimerTask(){

                            @Override
                            public void run() {
                                SwingUtilities.invokeLater(new Runnable(){

                                    @Override
                                    public void run() {
                                        try {
                                            if (LinuxWindowManager.this.isDebugFlag()) {
                                                System.out.println("Request toBack(timer,restore focusable true): " + w);
                                            }
                                            w.setFocusable(true);
                                            w.setFocusableWindowState(true);
                                        }
                                        finally {
                                            finallistenerMap.toBack.compareAndSet(true, false);
                                        }
                                    }
                                });
                            }
                        }, 100L);
                    }
                });
                w.setVisible(true);
                break;
            }
            case TO_FRONT: 
            case TO_FRONT_FOCUSED: {
                listener = listenerMap.toFrontListener.getAndSet(null);
                if (listener != null && listener.remove(w, false) && this.isDebugFlag()) {
                    System.out.println("Remove previous toFront listener(no undo): " + listener);
                }
                if (!w.isActive()) {
                    if (this.isUseAlwaysOnTop()) {
                        if (this.isDebugFlag()) {
                            System.out.println("Request toFront(use AlwaysOnTop workaround): " + w);
                        }
                        listener = new LinuxWindowListener(){

                            @Override
                            public void undo(Window w2) {
                                System.out.println("Request toFront(reset AlwaysOnTop workaround): " + w2);
                                w2.setAlwaysOnTop(false);
                            }

                            @Override
                            public void windowActivated(WindowEvent e) {
                                if (this.remove(e.getWindow(), true) && requestFocus) {
                                    SwingUtilities.invokeLater(new Runnable(){

                                        @Override
                                        public void run() {
                                            if (LinuxWindowManager.this.isDebugFlag()) {
                                                System.out.println("Request toFrontFocused(timer,toFront): " + w);
                                            }
                                            w.toFront();
                                            w.requestFocus();
                                        }
                                    });
                                }
                            }

                            @Override
                            public void windowIconified(WindowEvent e) {
                                if (this.remove(e.getWindow(), true) && requestFocus) {
                                    SwingUtilities.invokeLater(new Runnable(){

                                        @Override
                                        public void run() {
                                            if (LinuxWindowManager.this.isDebugFlag()) {
                                                System.out.println("Request toFrontFocused(timer,toFront): " + w);
                                            }
                                            w.toFront();
                                            w.requestFocus();
                                        }
                                    });
                                }
                            }
                        };
                        listenerMap.toFrontListener.set(listener);
                        w.addWindowListener(listener);
                        w.setAlwaysOnTop(true);
                        if (w.isVisible()) break;
                        w.setVisible(true);
                        break;
                    }
                    if (this.isDebugFlag()) {
                        System.out.println("Request toFront(use toFront): " + w);
                    }
                    w.setFocusable(false);
                    w.setFocusableWindowState(false);
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            LinuxWindowManager.this.timer.schedule(new TimerTask(){

                                @Override
                                public void run() {
                                    SwingUtilities.invokeLater(new Runnable(){

                                        @Override
                                        public void run() {
                                            w.toFront();
                                            if (LinuxWindowManager.this.isDebugFlag()) {
                                                System.out.println("Request toFront(timer,restore focusable true): " + w);
                                            }
                                            w.setFocusable(true);
                                            w.setFocusableWindowState(true);
                                            if (requestFocus) {
                                                if (LinuxWindowManager.this.isDebugFlag()) {
                                                    System.out.println("Request toFrontFocused(timer,toFront): " + w);
                                                }
                                                w.toFront();
                                                w.requestFocus();
                                            }
                                        }
                                    });
                                }
                            }, 100L);
                        }
                    });
                    if (w.isVisible()) break;
                    w.setVisible(true);
                    break;
                }
                if (this.isDebugFlag()) {
                    System.out.println("Request toFront(window is active): " + w);
                }
                if (!requestFocus) break;
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (LinuxWindowManager.this.isDebugFlag()) {
                            System.out.println("Request toFrontFocused(timer,toFront): " + w);
                        }
                        w.toFront();
                        w.requestFocus();
                    }
                });
                break;
            }
            case OS_DEFAULT: {
                if (w.isVisible()) break;
                w.setVisible(true);
                break;
            }
        }
    }

    private class LinuxWindowListenerMap {
        private final AtomicBoolean toFront = new AtomicBoolean(false);
        private final AtomicBoolean toFrontFocused = new AtomicBoolean(false);
        private final AtomicBoolean toBack = new AtomicBoolean(false);
        private final NullsafeAtomicReference<LinuxWindowListener> toFrontListener = new NullsafeAtomicReference<Object>(null);

        private LinuxWindowListenerMap() {
        }
    }

    private abstract class LinuxWindowListener
    implements WindowListener {
        private final AtomicBoolean removed = new AtomicBoolean(false);

        private LinuxWindowListener() {
        }

        public boolean remove(Window w, boolean undo) {
            if (!this.removed.getAndSet(true)) {
                w.removeWindowListener(this);
                if (undo) {
                    this.undo(w);
                }
                return true;
            }
            return false;
        }

        public abstract void undo(Window var1);

        @Override
        public void windowActivated(WindowEvent e) {
        }

        @Override
        public void windowClosed(WindowEvent e) {
        }

        @Override
        public void windowClosing(WindowEvent e) {
        }

        @Override
        public void windowDeactivated(WindowEvent e) {
        }

        @Override
        public void windowDeiconified(WindowEvent e) {
        }

        @Override
        public void windowIconified(WindowEvent e) {
        }

        @Override
        public void windowOpened(WindowEvent e) {
        }
    }
}

