/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.update;

import java.io.File;
import java.io.IOException;
import org.appwork.updatesys.client.DefaultPathBuilder;
import org.appwork.updatesys.client.UpdateClient;
import org.appwork.utils.Application;
import org.appwork.utils.Files;
import org.appwork.utils.IO;

public class PathBuilderImpl
extends DefaultPathBuilder {
    public static final String BASE = "update/versioninfo/";

    public PathBuilderImpl(UpdateClient client) {
        super(client);
        File old = Application.getResource("cfg/versioninfo");
        File newStorage = Application.getResource(this.getStorageBase());
        if (old.exists()) {
            newStorage.getParentFile().mkdirs();
            try {
                PathBuilderImpl.copyFolderAndDeleteRecursive(old, newStorage, true);
                old.delete();
            }
            catch (IOException e) {
                if (this.logger != null) {
                    this.logger.log(e);
                }
                e.printStackTrace();
            }
        }
    }

    public static void copyFolderAndDeleteRecursive(final File src, final File dest, final boolean overwriteFiles) throws IOException {
        Files.walkThroughStructure(new Files.AbstractHandler<IOException>(){

            @Override
            public void onFile(File f) throws IOException {
                String path = Files.getRelativePath(src, f);
                if (path == null) {
                    throw new IOException("No rel Path " + src + "-" + f);
                }
                if (f.isDirectory()) {
                    new File(dest, path).mkdirs();
                } else {
                    File dst = new File(dest, path);
                    if (overwriteFiles && dst.exists() && !dst.delete()) {
                        throw new IOException("Cannot overwrite " + dst);
                    }
                    IO.copyFile(f, dst);
                    f.delete();
                    f.getParentFile().delete();
                }
            }
        }, src);
    }

    @Override
    protected String getStorageBase() {
        return BASE;
    }
}

