/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.update.gui;

import java.awt.CheckboxMenuItem;
import java.awt.Image;
import java.awt.MenuItem;
import java.awt.PopupMenu;
import java.awt.SystemTray;
import java.awt.TrayIcon;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.ImageIcon;
import javax.swing.Timer;
import org.appwork.utils.swing.EDTHelper;
import org.appwork.utils.swing.EDTRunner;
import org.appwork.utils.swing.dialog.Dialog;
import org.appwork.utils.swing.windowmanager.WindowManager;
import org.jdownloader.update.UIInterface;
import org.jdownloader.update.UpdateManager;
import org.jdownloader.update.UpdaterIcon;
import org.jdownloader.update.gui.PollCallback;
import org.jdownloader.update.gui.bubble.UpdateNotifyWindow;
import org.jdownloader.update.locale.T;
import org.jdownloader.updatev2.UpdateCallbackInterface;

public class UpdateOnExitGuiWrapper
implements UIInterface {
    private UpdateManager manager;
    private Timer pollTimer;
    private double progress;
    private String text;
    private ImageIcon icon;
    private boolean init = false;
    private UpdateNotifyWindow gui;
    private String cancelText;
    protected long visibleTime;
    private TrayIcon trayIcon;
    private CheckboxMenuItem hide;

    public UpdateOnExitGuiWrapper(UpdateManager updateManager) {
        this.manager = updateManager;
    }

    @Override
    public void startPoll(final PollCallback pollCallback) {
        this.pollTimer = new Timer(1000, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                pollCallback.run();
            }
        });
        this.pollTimer.setRepeats(true);
        this.pollTimer.start();
    }

    @Override
    public void stopPoll() {
        if (this.pollTimer != null) {
            this.pollTimer.stop();
        }
        this.pollTimer = null;
    }

    @Override
    public void setIcon(ImageIcon icon) {
        if (this.manager.getHandler() != null) {
            this.manager.getHandler().updateGuiIcon(icon);
        }
        if (this.gui == null) {
            this.icon = icon;
            return;
        }
        this.getGui().setIcon(icon);
    }

    @Override
    public void setText(String text) {
        UpdateCallbackInterface handler = this.manager.getHandler();
        if (handler != null) {
            handler.updateGuiText(text);
        }
        if (this.gui == null) {
            this.text = text;
            return;
        }
        this.getGui().setText(text);
    }

    @Override
    public void setProgress(double d) {
        if (this.manager.getHandler() != null) {
            this.manager.getHandler().updateGuiProgress(d);
        }
        if (this.gui == null) {
            this.progress = d;
            return;
        }
        this.getGui().setProgress(d);
    }

    @Override
    public void onHead() {
        this.setCancelText(T.T.literally_close());
        this.setProgress(100.0);
    }

    @Override
    public boolean isVisible() {
        return (Boolean)new EDTHelper<Boolean>(){

            @Override
            public Boolean edtRun() {
                if (UpdateOnExitGuiWrapper.this.gui == null) {
                    return false;
                }
                return UpdateOnExitGuiWrapper.this.getGui().isVisible();
            }
        }.getReturnValue();
    }

    @Override
    public void setVisible(final boolean b) {
        new EDTRunner(){

            @Override
            protected void runInEDT() {
                UpdateOnExitGuiWrapper.this.setTrayEnabled(b);
                UpdateOnExitGuiWrapper.this.setPanelVisible(b);
            }
        }.getReturnValue();
    }

    protected void setPanelVisible(boolean b) {
        boolean bl = b = this.manager.getSettings().isInstallUpdatesOnExitPanelVisible() && b;
        if (!b && this.gui == null) {
            return;
        }
        if (b && !this.getGui().isVisible()) {
            this.visibleTime = System.currentTimeMillis();
        }
        this.getGui().setVisible(b);
        Window win = this.getWindow();
        if (win != null) {
            win.setAlwaysOnTop(this.manager.getSettings().isUpdateGuiAlwaysOnTop() || this.manager.isAlwaysOnTopExternal());
        }
        if (!b) {
            // empty if block
        }
    }

    private void setTrayEnabled(boolean b) {
        if (!SystemTray.isSupported()) {
            System.out.println("SystemTray is not supported");
            return;
        }
        try {
            if (b) {
                if (this.trayIcon != null) {
                    return;
                }
                SystemTray tray = SystemTray.getSystemTray();
                Image img = UpdaterIcon.updaterIcon100.image(Math.min((int)tray.getTrayIconSize().getWidth(), (int)tray.getTrayIconSize().getHeight()));
                this.trayIcon = new TrayIcon(img, T.T.installonexitframe_tray_tt(), null);
                this.trayIcon.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                    }
                });
                this.trayIcon.addMouseListener(new MouseListener(){

                    @Override
                    public void mouseReleased(MouseEvent e) {
                    }

                    @Override
                    public void mousePressed(MouseEvent e) {
                    }

                    @Override
                    public void mouseExited(MouseEvent e) {
                    }

                    @Override
                    public void mouseEntered(MouseEvent e) {
                    }

                    @Override
                    public void mouseClicked(MouseEvent e) {
                        boolean cur = UpdateOnExitGuiWrapper.this.manager.getSettings().isInstallUpdatesOnExitPanelVisible();
                        UpdateOnExitGuiWrapper.this.manager.getSettings().setInstallUpdatesOnExitPanelVisible(!cur);
                        UpdateOnExitGuiWrapper.this.setPanelVisible(UpdateOnExitGuiWrapper.this.manager.getSettings().isInstallUpdatesOnExitPanelVisible());
                    }
                });
                PopupMenu popup = new PopupMenu();
                this.hide = new CheckboxMenuItem(T.T.installonexitframe_panel_visible());
                this.hide.setState(this.manager.getSettings().isInstallUpdatesOnExitPanelVisible());
                MenuItem cancel = new MenuItem(T.T.installonexitframe_cancel());
                this.hide.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        UpdateOnExitGuiWrapper.this.manager.getSettings().setInstallUpdatesOnExitPanelVisible(!UpdateOnExitGuiWrapper.this.manager.getSettings().isInstallUpdatesOnExitPanelVisible());
                        UpdateOnExitGuiWrapper.this.setPanelVisible(UpdateOnExitGuiWrapper.this.manager.getSettings().isInstallUpdatesOnExitPanelVisible());
                    }
                });
                this.hide.addItemListener(new ItemListener(){

                    @Override
                    public void itemStateChanged(ItemEvent e) {
                        boolean state = UpdateOnExitGuiWrapper.this.hide.getState();
                        UpdateOnExitGuiWrapper.this.manager.getSettings().setInstallUpdatesOnExitPanelVisible(state);
                        UpdateOnExitGuiWrapper.this.setVisible(true);
                    }
                });
                cancel.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        UpdateOnExitGuiWrapper.this.cancelByUser();
                    }
                });
                popup.add(this.hide);
                popup.add(cancel);
                this.trayIcon.setPopupMenu(popup);
                tray.add(this.trayIcon);
            } else {
                if (this.trayIcon == null) {
                    return;
                }
                SystemTray tray = SystemTray.getSystemTray();
                tray.remove(this.trayIcon);
                this.trayIcon = null;
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    private UpdateNotifyWindow getGui() {
        if (this.gui != null) {
            return this.gui;
        }
        if (!this.init) {
            Dialog.getInstance().initLaf();
            this.init = true;
        }
        EDTHelper<UpdateNotifyWindow> helper = new EDTHelper<UpdateNotifyWindow>(){

            @Override
            public UpdateNotifyWindow edtRun() {
                if (UpdateOnExitGuiWrapper.this.gui != null) {
                    return UpdateOnExitGuiWrapper.this.gui;
                }
                UpdateNotifyWindow lgui = new UpdateNotifyWindow(){

                    @Override
                    public void onClose() {
                        super.onClose();
                        UpdateOnExitGuiWrapper.this.cancelByUser();
                    }

                    @Override
                    protected void onHide() {
                        super.onHide();
                        UpdateOnExitGuiWrapper.this.hideByUser();
                    }
                };
                lgui.setAlwaysOnTop(UpdateOnExitGuiWrapper.this.manager.getSettings().isUpdateGuiAlwaysOnTop() || UpdateOnExitGuiWrapper.this.manager.isAlwaysOnTopExternal());
                UpdateOnExitGuiWrapper.this.gui = lgui;
                return UpdateOnExitGuiWrapper.this.gui;
            }
        };
        return (UpdateNotifyWindow)helper.getReturnValue();
    }

    @Override
    public void setCancelText(String label) {
        this.cancelText = label;
        if (this.gui != null) {
            this.gui.setCancelText(this.cancelText);
        }
    }

    private void hideByUser() {
        new EDTRunner(){

            @Override
            protected void runInEDT() {
                UpdateOnExitGuiWrapper.this.manager.getSettings().setInstallUpdatesOnExitPanelVisible(false);
                UpdateOnExitGuiWrapper.this.hide.setState(UpdateOnExitGuiWrapper.this.manager.getSettings().isInstallUpdatesOnExitPanelVisible());
                UpdateOnExitGuiWrapper.this.setPanelVisible(false);
            }
        };
    }

    @Override
    public void toFront() {
        new EDTRunner(){

            @Override
            protected void runInEDT() {
                if (UpdateOnExitGuiWrapper.this.gui != null) {
                    WindowManager.getInstance().setZState(UpdateOnExitGuiWrapper.this.gui, WindowManager.FrameState.TO_FRONT);
                }
            }
        };
    }

    @Override
    public void setExtendedState(int state) {
        new EDTRunner(){

            @Override
            protected void runInEDT() {
                if (UpdateOnExitGuiWrapper.this.gui != null) {
                    // empty if block
                }
            }
        };
    }

    @Override
    public Window getWindow() {
        if (this.gui == null) {
            return null;
        }
        return this.gui;
    }

    protected void cancelByUser() {
        this.manager.onCanceledByUser();
        new EDTRunner(){

            @Override
            protected void runInEDT() {
                UpdateOnExitGuiWrapper.this.setPanelVisible(UpdateOnExitGuiWrapper.this.manager.getSettings().isInstallUpdatesOnExitPanelVisible());
            }
        };
    }

    @Override
    public void setAlwaysOnTop(boolean top) {
        new EDTRunner(){

            @Override
            protected void runInEDT() {
                Window win = UpdateOnExitGuiWrapper.this.getWindow();
                if (win != null) {
                    win.setAlwaysOnTop(UpdateOnExitGuiWrapper.this.manager.getSettings().isUpdateGuiAlwaysOnTop() || UpdateOnExitGuiWrapper.this.manager.isAlwaysOnTopExternal());
                }
            }
        };
    }
}

