/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.updatev2;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Locale;
import org.appwork.utils.Application;
import org.appwork.utils.IO;
import org.appwork.utils.JVMVersion;
import org.appwork.utils.Regex;

public class JDClassLoaderLauncher {
    public static void updateClassPath() throws IOException {
        ClassLoader cl = JDClassLoaderLauncher.class.getClassLoader();
        URL classPath = Application.getRessourceURL("classpath");
        if (classPath != null) {
            String sevenZipJBinding = Application.getResource("libs/sevenzipjbindingCustom.jar").isFile() ? "libs/sevenzipjbindingCustom" : null;
            ArrayList<URL> classPathJARs = new ArrayList<URL>();
            System.out.println("SevenZipJBinding: " + sevenZipJBinding);
            for (String classPathLine : Regex.getLines(IO.readURLToString(classPath))) {
                File classPathJAR;
                if (sevenZipJBinding != null && classPathLine.startsWith("libs/sevenzipjbinding")) {
                    String customclassPathLine = classPathLine.replace("libs/sevenzipjbinding", sevenZipJBinding);
                    classPathJAR = Application.getResource(customclassPathLine);
                    System.out.println("SevenZipJBinding: " + customclassPathLine + ":" + classPathJAR.isFile());
                } else {
                    classPathJAR = Application.getResource(classPathLine);
                }
                if (!classPathJAR.isFile()) continue;
                classPathJARs.add(classPathJAR.toURI().toURL());
            }
            if (classPathJARs.size() > 0) {
                for (URL classPathJAR : classPathJARs) {
                    if (cl instanceof JDCustomRootClassLoader) {
                        System.out.println("Add via JDLauncherClassLoader.addURL:" + classPathJAR);
                        ((JDCustomRootClassLoader)cl).addURL(classPathJAR);
                        continue;
                    }
                    System.out.println("Add via Application.addUrlToClassPath:" + classPathJAR);
                    Application.addUrlToClassPath(classPathJAR, cl);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void main(String[] args, String mainClass) {
        if (mainClass == null || mainClass.trim().length() == 0) {
            throw new RuntimeException("MainClass not set!");
        }
        if (JVMVersion.isMinimum(JVMVersion.JAVA_9)) {
            try {
                String rootClass = this.getClass().getName().replaceAll("\\.", "/") + ".class";
                URL caller = this.getClass().getClassLoader().getResource(rootClass);
                String url = caller.toString();
                url = url.replaceFirst("^jar:", "");
                url = url.replace("!/" + rootClass, "");
                URL classLoaderURL = new URL(url);
                if (classLoaderURL != null && url.toLowerCase(Locale.ENGLISH).endsWith(".jar")) {
                    JDCustomRootClassLoader classLoader = new JDCustomRootClassLoader(new URL[]{classLoaderURL});
                    ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
                    boolean restoreOldClassLoader = true;
                    try {
                        Thread.currentThread().setContextClassLoader(classLoader);
                        Class<?> loader = classLoader.loadClass(mainClass);
                        Method mainMethod = loader.getMethod("main", String[].class);
                        mainMethod.invoke(null, new Object[]{args});
                        restoreOldClassLoader = false;
                        return;
                    }
                    finally {
                        if (restoreOldClassLoader) {
                            Thread.currentThread().setContextClassLoader(oldClassLoader);
                        }
                    }
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
        try {
            Class<?> loader = this.getClass().getClassLoader().loadClass(mainClass);
            Method mainMethod = loader.getMethod("main", String[].class);
            mainMethod.invoke(null, new Object[]{args});
            return;
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    static {
        System.setProperty("BuildDecisions", "false");
    }

    public static class JDCustomRootClassLoader
    extends URLClassLoader {
        private JDCustomRootClassLoader(URL[] urls) {
            super(urls);
        }

        private final boolean preferParentClassLoader(String name) {
            return name.equals(this.getClass().getName());
        }

        @Override
        public Enumeration<URL> getResources(String name) throws IOException {
            if (JVMVersion.isMinimum(JVMVersion.JAVA_15) && "META-INF/services/javax.script.ScriptEngineFactory".equals(name)) {
                Enumeration<URL> resources = super.getResources(name);
                ArrayList<URL> ret = new ArrayList<URL>();
                while (resources != null && resources.hasMoreElements()) {
                    URL url = resources.nextElement();
                    ret.add(url);
                }
                URL scriptEngineHack = this.getResource("org/jdownloader/scripting/ScriptEngineFactoryService.html");
                if (scriptEngineHack != null) {
                    ret.add(scriptEngineHack);
                }
                return Collections.enumeration(ret);
            }
            return super.getResources(name);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
            Object object = this.getClassLoadingLock(name);
            synchronized (object) {
                Class<?> c = this.findLoadedClass(name);
                if (c == null) {
                    if (this.preferParentClassLoader(name) || this.findResource(name.replace(".", "/") + ".class") == null) {
                        return super.loadClass(name, resolve);
                    }
                    c = this.findClass(name);
                }
                if (resolve) {
                    this.resolveClass(c);
                }
                return c;
            }
        }

        @Override
        public void addURL(URL url) {
            super.addURL(url);
        }
    }
}

