/*
 * Decompiled with CFR 0.152.
 */
package com.btr.proxy.search.desktop.gnome;

import com.btr.proxy.search.ProxySearchStrategy;
import com.btr.proxy.selector.direct.NoProxySelector;
import com.btr.proxy.selector.fixed.FixedProxySelector;
import com.btr.proxy.selector.misc.ProtocolDispatchSelector;
import com.btr.proxy.selector.whitelist.ProxyBypassListSelector;
import com.btr.proxy.util.Logger;
import com.btr.proxy.util.ProxyException;
import com.btr.proxy.util.ProxyUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.ProxySelector;
import java.util.Properties;

public class GnomeDConfProxySearchStrategy
implements ProxySearchStrategy {
    @Override
    public ProxySelector getProxySelector() throws ProxyException {
        Logger.log(this.getClass(), Logger.LogLevel.TRACE, "Detecting Gnome proxy settings", new Object[0]);
        Properties settings = this.readSettings();
        String type = settings.getProperty("org.gnome.system.proxy mode");
        Logger.log(this.getClass(), Logger.LogLevel.TRACE, "Mode is :{0}", type);
        ProxySelector result = null;
        if (type == null) {
            String useProxy = settings.getProperty("org.gnome.system.proxy.http enabled");
            if (useProxy == null) {
                return null;
            }
            String string = type = Boolean.parseBoolean(useProxy) ? "manual" : "none";
        }
        if ("none".equals(type)) {
            Logger.log(this.getClass(), Logger.LogLevel.TRACE, "Gnome uses no proxy", new Object[0]);
            result = NoProxySelector.getInstance();
        }
        if ("manual".equals(type)) {
            Logger.log(this.getClass(), Logger.LogLevel.TRACE, "Gnome uses manual proxy settings", new Object[0]);
            result = this.setupFixedProxySelector(settings);
        }
        if ("auto".equals(type)) {
            String pacScriptUrl = settings.getProperty("org.gnome.system.proxy autoconfig-url", "");
            Logger.log(this.getClass(), Logger.LogLevel.TRACE, "Gnome uses autodetect script {0}", pacScriptUrl);
            result = ProxyUtil.buildPacSelectorForUrl(pacScriptUrl);
        }
        String noProxyList = settings.getProperty("org.gnome.system.proxy ignore-hosts", null);
        if (result != null && noProxyList != null && noProxyList.trim().length() > 0) {
            Logger.log(this.getClass(), Logger.LogLevel.TRACE, "Gnome uses proxy bypass list: {0}", noProxyList);
            result = new ProxyBypassListSelector(noProxyList, result);
        }
        return result;
    }

    public Properties readSettings() throws ProxyException {
        Properties settings = new Properties();
        try {
            this.parseSettings(settings);
        }
        catch (IOException e) {
            Logger.log(this.getClass(), Logger.LogLevel.ERROR, "Gnome settings read error.", e);
            throw new ProxyException(e);
        }
        return settings;
    }

    private ProxySelector setupFixedProxySelector(Properties settings) {
        if (!this.hasProxySettings(settings)) {
            return null;
        }
        ProtocolDispatchSelector ps = new ProtocolDispatchSelector();
        this.installHttpSelector(settings, ps);
        if (this.useForAllProtocols(settings)) {
            ps.setFallbackSelector(ps.getSelector("http"));
        } else {
            this.installSecureSelector(settings, ps);
            this.installFtpSelector(settings, ps);
            this.installSocksSelector(settings, ps);
        }
        return ps;
    }

    private boolean useForAllProtocols(Properties settings) {
        return Boolean.parseBoolean(settings.getProperty("org.gnome.system.proxy use-same-proxy", "false"));
    }

    private boolean hasProxySettings(Properties settings) {
        String proxyHost = settings.getProperty("org.gnome.system.proxy.http host", null);
        return proxyHost != null && proxyHost.length() > 0;
    }

    private void installHttpSelector(Properties settings, ProtocolDispatchSelector ps) throws NumberFormatException {
        String proxyHost = settings.getProperty("org.gnome.system.proxy.http host", null);
        int proxyPort = Integer.parseInt(settings.getProperty("org.gnome.system.proxy.http port", "0").trim());
        if (proxyHost != null && proxyHost.length() > 0 && proxyPort > 0) {
            Logger.log(this.getClass(), Logger.LogLevel.TRACE, "Gnome http proxy is {0}:{1}", proxyHost, proxyPort);
            ps.setSelector("http", new FixedProxySelector(proxyHost.trim(), proxyPort));
        }
    }

    private void installSocksSelector(Properties settings, ProtocolDispatchSelector ps) throws NumberFormatException {
        String proxyHost = settings.getProperty("org.gnome.system.proxy.socks host", null);
        int proxyPort = Integer.parseInt(settings.getProperty("org.gnome.system.proxy.socks port", "0").trim());
        if (proxyHost != null && proxyHost.length() > 0 && proxyPort > 0) {
            Logger.log(this.getClass(), Logger.LogLevel.TRACE, "Gnome socks proxy is {0}:{1}", proxyHost, proxyPort);
            ps.setSelector("socks", new FixedProxySelector(proxyHost.trim(), proxyPort));
        }
    }

    private void installFtpSelector(Properties settings, ProtocolDispatchSelector ps) throws NumberFormatException {
        String proxyHost = settings.getProperty("org.gnome.system.proxy.ftp host", null);
        int proxyPort = Integer.parseInt(settings.getProperty("org.gnome.system.proxy.ftp port", "0").trim());
        if (proxyHost != null && proxyHost.length() > 0 && proxyPort > 0) {
            Logger.log(this.getClass(), Logger.LogLevel.TRACE, "Gnome ftp proxy is {0}:{1}", proxyHost, proxyPort);
            ps.setSelector("ftp", new FixedProxySelector(proxyHost.trim(), proxyPort));
        }
    }

    private void installSecureSelector(Properties settings, ProtocolDispatchSelector ps) throws NumberFormatException {
        String proxyHost = settings.getProperty("org.gnome.system.proxy.https host", null);
        int proxyPort = Integer.parseInt(settings.getProperty("org.gnome.system.proxy.https port", "0").trim());
        if (proxyHost != null && proxyHost.length() > 0 && proxyPort > 0) {
            Logger.log(this.getClass(), Logger.LogLevel.TRACE, "Gnome secure proxy is {0}:{1}", proxyHost, proxyPort);
            ps.setSelector("https", new FixedProxySelector(proxyHost.trim(), proxyPort));
            ps.setSelector("sftp", new FixedProxySelector(proxyHost.trim(), proxyPort));
        }
    }

    private Properties parseSettings(Properties settings) throws IOException {
        String line;
        Logger.log(this.getClass(), Logger.LogLevel.TRACE, "exec gsettings list-recursively org.gnome.system.proxy", new Object[0]);
        Process p = Runtime.getRuntime().exec("gsettings list-recursively org.gnome.system.proxy");
        BufferedReader bri = new BufferedReader(new InputStreamReader(p.getInputStream()));
        while ((line = bri.readLine()) != null) {
            Logger.log(this.getClass(), Logger.LogLevel.TRACE, line, new Object[0]);
            int schemaSep = line.indexOf(" ");
            int keySep = line.indexOf(" ", schemaSep + 1);
            String entry = line.substring(0, keySep);
            String value = line.substring(keySep + 1).replaceAll("'", "");
            if (value.matches("\\[.*\\]")) {
                value = value.replaceAll("\\[|\\]| ", "");
            }
            Logger.log(this.getClass(), Logger.LogLevel.TRACE, "prop is: {0}|{1}", entry, value);
            settings.setProperty(entry, value);
        }
        try {
            p.waitFor();
        }
        catch (InterruptedException ex) {
            Logger.log(this.getClass(), Logger.LogLevel.ERROR, ex.getMessage(), new Object[0]);
        }
        return settings;
    }
}

