/*
 * Decompiled with CFR 0.152.
 */
package com.btr.proxy.search.desktop.osx;

import com.btr.proxy.search.ProxySearchStrategy;
import com.btr.proxy.search.browser.ie.IELocalByPassFilter;
import com.btr.proxy.search.wpad.WpadProxySearchStrategy;
import com.btr.proxy.selector.direct.NoProxySelector;
import com.btr.proxy.selector.fixed.FixedProxySelector;
import com.btr.proxy.selector.fixed.FixedSocksSelector;
import com.btr.proxy.selector.misc.ProtocolDispatchSelector;
import com.btr.proxy.selector.whitelist.ProxyBypassListSelector;
import com.btr.proxy.util.Logger;
import com.btr.proxy.util.PListParser;
import com.btr.proxy.util.ProxyException;
import com.btr.proxy.util.ProxyUtil;
import com.btr.proxy.util.UriFilter;
import java.io.File;
import java.io.IOException;
import java.net.NetworkInterface;
import java.net.ProxySelector;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;

public class OsxProxySearchStrategy
implements ProxySearchStrategy {
    public static final String OVERRIDE_SETTINGS_FILE = "com.btr.proxy.osx.settingsFile";
    public static final String OVERRIDE_ACCEPTED_DEVICES = "com.btr.proxy.osx.acceptedDevices";
    private static final String SETTINGS_FILE = "/Library/Preferences/SystemConfiguration/preferences.plist";

    @Override
    public ProxySelector getProxySelector() throws ProxyException {
        Logger.log(this.getClass(), Logger.LogLevel.TRACE, "Detecting OSX proxy settings", new Object[0]);
        try {
            List<String> acceptedInterfaces = this.getNetworkInterfaces();
            PListParser.Dict settings = PListParser.load(this.getSettingsFile());
            Object currentSet = settings.getAtPath("/CurrentSet");
            if (currentSet == null) {
                throw new ProxyException("CurrentSet not defined");
            }
            PListParser.Dict networkSet = (PListParser.Dict)settings.getAtPath(String.valueOf(currentSet));
            List serviceOrder = (List)networkSet.getAtPath("/Network/Global/IPv4/ServiceOrder");
            if (serviceOrder == null || serviceOrder.size() == 0) {
                throw new ProxyException("ServiceOrder not defined");
            }
            PListParser.Dict proxySettings = null;
            for (int i = 0; i < serviceOrder.size() && proxySettings == null; ++i) {
                Object candidateService = serviceOrder.get(i);
                Object networkService = networkSet.getAtPath("/Network/Service/" + candidateService + "/__LINK__");
                if (networkService == null) {
                    throw new ProxyException("NetworkService not defined.");
                }
                PListParser.Dict selectedServiceSettings = (PListParser.Dict)settings.getAtPath("" + networkService);
                String interfaceName = (String)selectedServiceSettings.getAtPath("/Interface/DeviceName");
                if (!acceptedInterfaces.contains(interfaceName)) continue;
                Logger.log(this.getClass(), Logger.LogLevel.TRACE, "Looking up proxies for device " + interfaceName, new Object[0]);
                proxySettings = (PListParser.Dict)selectedServiceSettings.getAtPath("/Proxies");
            }
            if (proxySettings == null) {
                return NoProxySelector.getInstance();
            }
            return this.buildSelector(proxySettings);
        }
        catch (PListParser.XmlParseException e) {
            throw new ProxyException(e);
        }
        catch (IOException e) {
            throw new ProxyException(e);
        }
    }

    private ProxySelector buildSelector(PListParser.Dict proxySettings) throws ProxyException {
        ProtocolDispatchSelector ps = new ProtocolDispatchSelector();
        this.installSelectorForProtocol(proxySettings, ps, "HTTP");
        this.installSelectorForProtocol(proxySettings, ps, "HTTPS");
        this.installSelectorForProtocol(proxySettings, ps, "FTP");
        this.installSelectorForProtocol(proxySettings, ps, "Gopher");
        this.installSelectorForProtocol(proxySettings, ps, "RTSP");
        this.installSocksProxy(proxySettings, ps);
        ProxySelector result = ps;
        result = this.installPacProxyIfAvailable(proxySettings, result);
        result = this.autodetectProxyIfAvailable(proxySettings, result);
        if (result != null) {
            result = this.installExceptionList(proxySettings, result);
            result = this.installSimpleHostFilter(proxySettings, result);
        }
        return result;
    }

    private List<String> getNetworkInterfaces() throws SocketException {
        String override = System.getProperty(OVERRIDE_ACCEPTED_DEVICES);
        if (override != null && override.length() > 0) {
            return Arrays.asList(override.split(";"));
        }
        ArrayList<String> acceptedInterfaces = new ArrayList<String>();
        Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
        while (interfaces.hasMoreElements()) {
            NetworkInterface ni = interfaces.nextElement();
            if (!this.isInterfaceAllowed(ni)) continue;
            acceptedInterfaces.add(ni.getName());
        }
        return acceptedInterfaces;
    }

    private boolean isInterfaceAllowed(NetworkInterface ni) throws SocketException {
        return !ni.isLoopback() && !ni.isPointToPoint() && !ni.isVirtual() && ni.isUp();
    }

    private File getSettingsFile() {
        File result = new File(SETTINGS_FILE);
        String overrideFile = System.getProperty(OVERRIDE_SETTINGS_FILE);
        if (overrideFile != null) {
            return new File(overrideFile);
        }
        return result;
    }

    private ProxySelector installSimpleHostFilter(PListParser.Dict proxySettings, ProxySelector result) {
        if (this.isActive(proxySettings.get("ExcludeSimpleHostnames"))) {
            ArrayList<UriFilter> localBypassFilter = new ArrayList<UriFilter>();
            localBypassFilter.add(new IELocalByPassFilter());
            result = new ProxyBypassListSelector(localBypassFilter, result);
        }
        return result;
    }

    private ProxySelector installExceptionList(PListParser.Dict proxySettings, ProxySelector result) {
        List proxyExceptions = (List)proxySettings.get("ExceptionsList");
        if (proxyExceptions != null && proxyExceptions.size() > 0) {
            Logger.log(this.getClass(), Logger.LogLevel.TRACE, "OSX uses proxy bypass list: {0}", proxyExceptions);
            String noProxyList = this.toCommaSeparatedString(proxyExceptions);
            result = new ProxyBypassListSelector(noProxyList, result);
        }
        return result;
    }

    private String toCommaSeparatedString(List<?> proxyExceptions) {
        StringBuilder result = new StringBuilder();
        for (Object object : proxyExceptions) {
            if (result.length() > 0) {
                result.append(",");
            }
            result.append(object);
        }
        return result.toString();
    }

    private ProxySelector autodetectProxyIfAvailable(PListParser.Dict proxySettings, ProxySelector result) throws ProxyException {
        ProxySelector wp;
        if (this.isActive(proxySettings.get("ProxyAutoDiscoveryEnable")) && (wp = new WpadProxySearchStrategy().getProxySelector()) != null) {
            result = wp;
        }
        return result;
    }

    private ProxySelector installPacProxyIfAvailable(PListParser.Dict proxySettings, ProxySelector result) {
        if (this.isActive(proxySettings.get("ProxyAutoConfigEnable"))) {
            String url = (String)proxySettings.get("ProxyAutoConfigURLString");
            result = ProxyUtil.buildPacSelectorForUrl(url);
        }
        return result;
    }

    private void installSocksProxy(PListParser.Dict proxySettings, ProtocolDispatchSelector ps) {
        if (this.isActive(proxySettings.get("SOCKSEnable"))) {
            String proxyHost = (String)proxySettings.get("SOCKSProxy");
            int proxyPort = (Integer)proxySettings.get("SOCKSPort");
            ps.setSelector("socks", new FixedSocksSelector(proxyHost, proxyPort));
            Logger.log(this.getClass(), Logger.LogLevel.TRACE, "OSX socks proxy is {0}:{1}", proxyHost, proxyPort);
        }
    }

    private void installSelectorForProtocol(PListParser.Dict proxySettings, ProtocolDispatchSelector ps, String protocol) {
        String prefix = protocol.trim();
        if (this.isActive(proxySettings.get(prefix + "Enable"))) {
            String proxyHost = (String)proxySettings.get(prefix + "Proxy");
            int proxyPort = (Integer)proxySettings.get(prefix + "Port");
            FixedProxySelector fp = new FixedProxySelector(proxyHost, proxyPort);
            ps.setSelector(protocol.toLowerCase(), fp);
            Logger.log(this.getClass(), Logger.LogLevel.TRACE, "OSX uses for {0} the proxy {1}:{2}", protocol, proxyHost, proxyPort);
        }
    }

    private boolean isActive(Object value) {
        return Integer.valueOf(1).equals(value);
    }
}

