/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.controlling;

import java.util.ArrayList;
import org.appwork.loggingv3.LogV3;
import org.appwork.utils.NullsafeAtomicReference;

public class SingleReachableState {
    private final NullsafeAtomicReference<ArrayList<Runnable>> stateMachine = new NullsafeAtomicReference(new ArrayList());
    private final String name;

    public SingleReachableState(String name) {
        this.name = name;
    }

    public void executeWhen(Runnable reached, Runnable notreached) {
        block3: {
            ArrayList<Runnable> newRunnables;
            ArrayList<Runnable> runnables;
            if (reached == null && notreached == null) {
                return;
            }
            do {
                if ((runnables = this.stateMachine.get()) == null) {
                    this.run(reached);
                    return;
                }
                if (reached == null) break block3;
                newRunnables = new ArrayList<Runnable>(runnables);
                newRunnables.add(reached);
            } while (!this.stateMachine.compareAndSet(runnables, newRunnables));
            this.run(notreached);
            return;
        }
        this.run(notreached);
    }

    public void executeWhenReached(Runnable run) {
        this.executeWhen(run, null);
    }

    public boolean isReached() {
        return this.stateMachine.get() == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForReached() throws InterruptedException {
        if (this.stateMachine.get() != null) {
            while (true) {
                NullsafeAtomicReference<ArrayList<Runnable>> nullsafeAtomicReference = this.stateMachine;
                synchronized (nullsafeAtomicReference) {
                    if (this.stateMachine.get() == null) {
                        break;
                    }
                    this.stateMachine.wait();
                }
            }
        }
    }

    private void run(Runnable run) {
        try {
            if (run != null) {
                run.run();
            }
        }
        catch (Throwable e) {
            LogV3.I().getDefaultLogger().log(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setReached() {
        ArrayList runnables;
        NullsafeAtomicReference<ArrayList<Runnable>> nullsafeAtomicReference = this.stateMachine;
        synchronized (nullsafeAtomicReference) {
            runnables = this.stateMachine.getAndSet(null);
            this.stateMachine.notifyAll();
        }
        if (runnables != null) {
            for (Runnable run : runnables) {
                this.run(run);
            }
        }
    }

    public String toString() {
        return "SingleReachableState: " + this.name + " reached: " + (this.stateMachine.get() != null);
    }
}

