/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.remoteapi;

import java.io.IOException;
import org.appwork.remoteapi.RemoteAPI;
import org.appwork.remoteapi.RemoteAPIRequest;
import org.appwork.remoteapi.SessionRemoteAPIRequest;
import org.appwork.remoteapi.exceptions.BasicRemoteAPIException;
import org.appwork.remoteapi.exceptions.SessionException;
import org.appwork.utils.net.httpserver.handler.HttpSessionRequestHandler;
import org.appwork.utils.net.httpserver.requests.GetRequest;
import org.appwork.utils.net.httpserver.requests.HttpRequest;
import org.appwork.utils.net.httpserver.requests.PostRequest;
import org.appwork.utils.net.httpserver.responses.HttpResponse;
import org.appwork.utils.net.httpserver.session.HttpSession;

public class SessionRemoteAPI<T extends HttpSession>
extends RemoteAPI
implements HttpSessionRequestHandler<T> {
    protected SessionRemoteAPIRequest<T> createSessionRemoteAPIRequest(T session, HttpRequest request, RemoteAPIRequest apiRequest) throws BasicRemoteAPIException {
        return new SessionRemoteAPIRequest<T>(request, apiRequest, session);
    }

    @Override
    public boolean onGetSessionRequest(T session, GetRequest request, HttpResponse response) throws BasicRemoteAPIException {
        SessionRemoteAPIRequest<T> apiRequest = this.createRemoteAPIRequestObject(request);
        if (apiRequest == null) {
            return this.onUnknownRequest(request, response);
        }
        if (((RemoteAPIRequest)(apiRequest = this.createSessionRemoteAPIRequest(session, request, apiRequest))).getIface().isSessionRequired() && (session == null || !session.isAlive())) {
            throw new SessionException();
        }
        try {
            this._handleRemoteAPICall(apiRequest, this.createRemoteAPIResponseObject(apiRequest, response));
        }
        catch (IOException e) {
            throw new BasicRemoteAPIException(e);
        }
        return true;
    }

    @Override
    public boolean onPostSessionRequest(T session, PostRequest request, HttpResponse response) throws BasicRemoteAPIException {
        SessionRemoteAPIRequest<T> apiRequest = this.createRemoteAPIRequestObject(request);
        if (apiRequest == null) {
            return this.onUnknownRequest(request, response);
        }
        if (((RemoteAPIRequest)(apiRequest = this.createSessionRemoteAPIRequest(session, request, apiRequest))).getIface().isSessionRequired() && (session == null || !session.isAlive())) {
            throw new SessionException();
        }
        try {
            this._handleRemoteAPICall(apiRequest, this.createRemoteAPIResponseObject(apiRequest, response));
        }
        catch (IOException e) {
            throw new BasicRemoteAPIException(e);
        }
        return true;
    }
}

