/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.serializer;

import java.io.InputStream;
import java.io.OutputStream;
import org.appwork.storage.TypeRef;
import org.appwork.storage.commonInterface.SerializerException;
import org.appwork.storage.commonInterface.SerializerInterface;
import org.appwork.utils.reflection.Clazz;

public class Deser {
    private static final String AWU_SERIALIZER_CLASS = "AWU_SERIALIZER_CLASS";
    private static SerializerInterface SERIALIZER = Deser.createDefaultSerializer();
    private static ThreadLocal<SerializerInterface> THREAD_SERIALIZER = new ThreadLocal();

    public static SerializerInterface createDefaultSerializer() {
        String cls = System.getProperty(AWU_SERIALIZER_CLASS, "org.appwork.storage.SimpleSerializer");
        try {
            return (SerializerInterface)Class.forName(cls).newInstance();
        }
        catch (InstantiationException e) {
            throw new RuntimeException("Could not instantiate the Appwork Default serializer: " + cls, e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Could not instantiate the Appwork Default serializer: " + cls, e);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Could not instantiate the Appwork Default serializer: " + cls, e);
        }
    }

    public static SerializerInterface setThreadDeser(SerializerInterface i) {
        SerializerInterface ret = THREAD_SERIALIZER.get();
        if (i == SERIALIZER) {
            THREAD_SERIALIZER.set(null);
        } else {
            THREAD_SERIALIZER.set(i);
        }
        return ret;
    }

    public static SerializerInterface get() {
        SerializerInterface ret = THREAD_SERIALIZER.get();
        if (ret != null) {
            return ret;
        }
        return SERIALIZER;
    }

    public static void set(SerializerInterface s) {
        if (s == null) {
            throw new IllegalArgumentException();
        }
        SERIALIZER = s;
    }

    public static SerializerInterface get(Object context) {
        return Deser.get();
    }

    public static <T extends SerializerInterface> T get(Class<T> expected) {
        SerializerInterface ret = Deser.get();
        if (!Clazz.isInstanceof(ret.getClass(), expected)) {
            throw new RuntimeException("We need a " + expected + " Serializer here!");
        }
        return (T)ret;
    }

    public static byte[] toByteArray(Object o, Object ... context) throws SerializerException {
        return Deser.get().toByteArray(o, context);
    }

    public static String toString(Object o, Object ... context) throws SerializerException {
        return Deser.get().toString(o, context);
    }

    public static <T> T fromString(String string, TypeRef<T> type) throws SerializerException {
        return Deser.get().fromString(string, type, new Object[0]);
    }

    public static <T> T fromStream(InputStream stream, TypeRef<T> type) throws SerializerException {
        return Deser.get().fromStream(stream, type, new Object[0]);
    }

    public static <T> T convert(Object o, TypeRef<T> type, Object ... context) throws SerializerException {
        return Deser.get().convert(o, type, context);
    }

    public static <T> T fromByteArray(byte[] byteArray, TypeRef<T> type) throws SerializerException {
        return Deser.get().fromByteArray(byteArray, type, new Object[0]);
    }

    public static void toStream(Object o, OutputStream os, boolean closeOutputStream, Object ... context) throws SerializerException {
        Deser.get().toStream(o, os, closeOutputStream, context);
    }
}

