/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.storage;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Array;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import org.appwork.exceptions.WTFException;
import org.appwork.loggingv3.LogV3;
import org.appwork.shutdown.ShutdownController;
import org.appwork.storage.JSonStorage;
import org.appwork.storage.SimpleMapper;
import org.appwork.storage.Storage;
import org.appwork.storage.StorageException;
import org.appwork.storage.TypeRef;
import org.appwork.storage.config.handler.StorageHandler;
import org.appwork.utils.Application;
import org.appwork.utils.IO;
import org.appwork.utils.ModifyLock;
import org.appwork.utils.logging2.LogInterface;

public class JsonKeyValueStorage
extends Storage {
    private final Map<String, Object> internalMap;
    private final String name;
    private final File file;
    private final boolean plain;
    private final byte[] key;
    private boolean autoPutValues = true;
    private volatile boolean closed = false;
    private final AtomicLong setMark = new AtomicLong(0L);
    private final AtomicLong writeMark = new AtomicLong(0L);
    private boolean enumCacheEnabled;
    private final ModifyLock modifyLock = new ModifyLock();
    private IO.SYNC storageSyncMode = IO.SYNC.NONE;
    private static final SimpleMapper MAPPER = new SimpleMapper();
    private static final Set<Class<?>> WRAPPER_TYPES = JsonKeyValueStorage.getWrapperTypes();

    @Override
    public IO.SYNC getStorageSyncMode() {
        return this.storageSyncMode;
    }

    @Override
    public void setStorageSyncMode(IO.SYNC storageSyncMode) {
        this.storageSyncMode = storageSyncMode == null ? IO.SYNC.NONE : storageSyncMode;
    }

    private final Map<String, Object> getMap() {
        return this.internalMap;
    }

    private final ModifyLock getLock() {
        return this.modifyLock;
    }

    public JsonKeyValueStorage(File file) throws StorageException {
        this(file, false);
    }

    public JsonKeyValueStorage(File file, boolean plain) throws StorageException {
        this(file, plain, JSonStorage.KEY);
    }

    public JsonKeyValueStorage(File file, boolean plain, byte[] key) throws StorageException {
        this(file, null, plain, key);
    }

    public List<String> getKeys() {
        boolean readL = this.getLock().readLock();
        try {
            ArrayList<String> arrayList = new ArrayList<String>(this.getMap().keySet());
            return arrayList;
        }
        finally {
            this.getLock().readUnlock(readL);
        }
    }

    public JsonKeyValueStorage(File file, URL resource, boolean plain, byte[] key) {
        HashMap<String, Object> load;
        MAPPER.setPrettyPrintEnabled(false);
        this.internalMap = new HashMap<String, Object>();
        this.plain = plain;
        this.file = file;
        this.name = file.getName();
        this.key = key;
        if (resource != null) {
            this.getDefaultLogger().info("Load JSon Storage from Classpath url: " + resource);
            try {
                load = JSonStorage.restoreFromByteArray(IO.readURL(resource), plain, key, TypeRef.HASHMAP, new HashMap());
                this.putAll(load);
            }
            catch (IOException e) {
                throw new WTFException(e);
            }
        }
        if (file.exists()) {
            this.getDefaultLogger().info("Prefer (merged) JSon Storage from File: " + file);
            load = JSonStorage.restoreFrom(file, plain, key, TypeRef.HASHMAP, new HashMap());
            this.putAll(load);
        } else {
            this.getDefaultLogger().info("CFG File does not exist: " + file);
        }
    }

    protected LogInterface getDefaultLogger() {
        return LogV3.I().getDefaultLogger();
    }

    public JsonKeyValueStorage(String name) throws StorageException {
        this(name, false);
    }

    public JsonKeyValueStorage(String name, boolean plain) throws StorageException {
        this(name, plain, JSonStorage.KEY);
    }

    public JsonKeyValueStorage(String name, boolean plain, byte[] key) throws StorageException {
        MAPPER.setPrettyPrintEnabled(false);
        this.internalMap = new HashMap<String, Object>();
        this.name = name;
        this.plain = plain;
        this.file = Application.getResource("cfg/" + name + (plain ? ".json" : ".ejs"));
        this.getDefaultLogger().finer("Read Config: " + this.file.getAbsolutePath());
        this.key = key;
        HashMap<String, Object> load = JSonStorage.restoreFrom(this.file, plain, key, TypeRef.HASHMAP, new HashMap());
        this.putAll(load);
    }

    @Override
    public void clear() throws StorageException {
        this.getLock().writeLock();
        try {
            this.getMap().clear();
        }
        finally {
            this.getLock().writeUnlock();
            this.requestSave();
        }
    }

    @Override
    public void close() {
        this.closed = true;
    }

    @Override
    public <E> E get(String key, E def) throws StorageException {
        return this.get(key, def, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <E> E get(String key, E def, Boolean autoPutValue) throws StorageException {
        boolean contains;
        boolean autoPutDefaultValue = autoPutValue == null ? this.isAutoPutValues() : Boolean.TRUE.equals(autoPutValue);
        Object ret = null;
        boolean readL = this.getLock().readLock();
        try {
            ret = this.getMap().get(key);
            contains = ret == null ? this.getMap().containsKey(key) : true;
        }
        finally {
            this.getLock().readUnlock(readL);
        }
        if (ret != null && def != null && ret.getClass() != def.getClass()) {
            if (def instanceof Byte) {
                if (ret instanceof Number) {
                    ret = ((Number)ret).byteValue();
                } else if (ret instanceof String) {
                    ret = Byte.parseByte((String)ret);
                }
            } else if (def instanceof Short) {
                if (ret instanceof Number) {
                    ret = ((Number)ret).shortValue();
                } else if (ret instanceof String) {
                    ret = Short.parseShort((String)ret);
                }
            } else if (def instanceof Long) {
                if (ret instanceof Number) {
                    ret = ((Number)ret).longValue();
                } else if (ret instanceof String) {
                    ret = Long.parseLong((String)ret);
                }
            } else if (def instanceof Integer) {
                if (ret instanceof Number) {
                    ret = ((Number)ret).intValue();
                } else if (ret instanceof String) {
                    ret = Integer.parseInt((String)ret);
                }
            } else if (def instanceof Double) {
                if (ret instanceof Number) {
                    ret = ((Number)ret).doubleValue();
                } else if (ret instanceof String) {
                    ret = Double.parseDouble((String)ret);
                }
            } else if (def instanceof Float) {
                if (ret instanceof Number) {
                    ret = Float.valueOf(((Number)ret).floatValue());
                } else if (ret instanceof String) {
                    ret = Float.valueOf(Float.parseFloat((String)ret));
                }
            }
        }
        if (!contains) {
            ret = def;
            if (autoPutDefaultValue) {
                if (def instanceof Byte) {
                    this.put(key, (Byte)def);
                } else if (def instanceof Short) {
                    this.put(key, (Short)def);
                } else if (def instanceof Long) {
                    this.put(key, (Long)def);
                } else if (def instanceof Integer) {
                    this.put(key, (Integer)def);
                } else if (def instanceof Double) {
                    this.put(key, (Double)def);
                } else if (def instanceof Float) {
                    this.put(key, (Float)def);
                } else if (def instanceof Boolean) {
                    this.put(key, (Boolean)def);
                } else if (def instanceof String || def == null) {
                    this.put(key, (String)def);
                } else if (def instanceof Enum) {
                    this.put(key, (Enum)def);
                } else {
                    throw new StorageException("Invalid datatype: " + (def != null ? def.getClass() : "null"));
                }
            }
        }
        if (def instanceof Enum && ret instanceof String) {
            try {
                ret = Enum.valueOf(((Enum)def).getDeclaringClass(), (String)ret);
                if (autoPutDefaultValue && this.isEnumCacheEnabled()) {
                    this.put(key, (Enum)ret);
                }
            }
            catch (Throwable e) {
                if (e instanceof IllegalArgumentException) {
                    this.getDefaultLogger().exception("Could not restore the enum. There is no value for " + ret + " in " + ((Enum)def).getDeclaringClass(), e);
                    if (autoPutDefaultValue) {
                        this.remove(key);
                    }
                } else {
                    this.getDefaultLogger().log(e);
                }
                if (autoPutDefaultValue && this.isEnumCacheEnabled()) {
                    this.put(key, (Enum)def);
                }
                ret = def;
            }
        }
        return (E)ret;
    }

    @Override
    public byte[] getCryptKey() {
        return this.key;
    }

    public File getFile() {
        return this.file;
    }

    @Override
    public String getID() {
        return this.file.getAbsolutePath();
    }

    public String getName() {
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasProperty(String key) {
        boolean readL = this.getLock().readLock();
        try {
            boolean bl = this.getMap().containsKey(key);
            return bl;
        }
        finally {
            this.getLock().readUnlock(readL);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object internal_put(String key, Object value) {
        if (key == null) {
            throw new WTFException("key == null is forbidden!");
        }
        boolean requestSave = true;
        this.getLock().writeLock();
        try {
            Object ret = this.getMap().put(key, value);
            requestSave = !this.equals(ret, value);
            Object object = ret;
            return object;
        }
        finally {
            this.getLock().writeUnlock();
            if (requestSave) {
                this.requestSave();
            }
        }
    }

    public static boolean isWrapperType(Class<?> clazz) {
        return WRAPPER_TYPES.contains(clazz);
    }

    private static Set<Class<?>> getWrapperTypes() {
        HashSet ret = new HashSet();
        ret.add(Boolean.class);
        ret.add(Character.class);
        ret.add(Byte.class);
        ret.add(Short.class);
        ret.add(Integer.class);
        ret.add(Long.class);
        ret.add(Float.class);
        ret.add(Double.class);
        ret.add(Void.class);
        ret.add(String.class);
        return ret;
    }

    protected boolean equals(Object x, Object y) {
        try {
            if (x == null && y == null) {
                return true;
            }
            if (x != null && y != null) {
                Class<?> xC = x.getClass();
                Class<?> yC = y.getClass();
                if (xC.isPrimitive() && yC.isPrimitive()) {
                    return x.equals(y);
                }
                if (JsonKeyValueStorage.isWrapperType(xC) && JsonKeyValueStorage.isWrapperType(yC)) {
                    return x.equals(y);
                }
                if (xC.isEnum() && yC.isEnum()) {
                    return x.equals(y);
                }
                boolean xCList = List.class.isAssignableFrom(xC);
                boolean yCList = List.class.isAssignableFrom(yC);
                if (xCList && yCList) {
                    int yLL;
                    List xL = (List)x;
                    List yL = (List)y;
                    int xLL = xL.size();
                    if (xLL == (yLL = yL.size())) {
                        for (int index = 0; index < xLL; ++index) {
                            Object yE;
                            Object xE = xL.get(index);
                            if (this.equals(xE, yE = yL.get(index))) continue;
                            return false;
                        }
                        return true;
                    }
                    return false;
                }
                boolean xCArray = xC.isArray();
                boolean yCArray = yC.isArray();
                if (xCArray && yCArray) {
                    int yL;
                    int xL = Array.getLength(x);
                    if (xL == (yL = Array.getLength(y))) {
                        for (int index = 0; index < xL; ++index) {
                            Object yE;
                            Object xE = Array.get(x, index);
                            if (this.equals(xE, yE = Array.get(y, index))) continue;
                            return false;
                        }
                        return true;
                    }
                    return false;
                }
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        return false;
    }

    @Override
    public boolean isAutoPutValues() {
        return this.autoPutValues;
    }

    private boolean isEnumCacheEnabled() {
        return this.enumCacheEnabled;
    }

    public boolean isPlain() {
        return this.plain;
    }

    public void put(String key, boolean value) throws StorageException {
        this.internal_put(key, value);
    }

    @Override
    public void put(String key, Boolean value) throws StorageException {
        this.internal_put(key, value);
    }

    @Override
    public void put(String key, Byte value) throws StorageException {
        this.internal_put(key, value);
    }

    @Override
    public void put(String key, Double value) throws StorageException {
        this.internal_put(key, value);
    }

    @Override
    public void put(String key, Enum<?> value) throws StorageException {
        if (value == null) {
            this.internal_put(key, null);
        } else if (this.isEnumCacheEnabled()) {
            this.internal_put(key, value);
        } else {
            this.internal_put(key, value.name());
        }
    }

    @Override
    public void put(String key, Float value) throws StorageException {
        this.internal_put(key, value);
    }

    public void put(String key, int value) throws StorageException {
        this.internal_put(key, value);
    }

    @Override
    public void put(String key, Integer value) throws StorageException {
        this.internal_put(key, value);
    }

    public void put(String key, long value) throws StorageException {
        this.internal_put(key, value);
    }

    @Override
    public void put(String key, Long value) throws StorageException {
        this.internal_put(key, value);
    }

    @Override
    public void put(String key, Short value) throws StorageException {
        this.internal_put(key, value);
    }

    public void put(String key, short value) throws StorageException {
        this.internal_put(key, value);
    }

    @Override
    public void put(String key, String value) throws StorageException {
        this.internal_put(key, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void putAll(Map<String, Object> map) {
        if (map != null) {
            this.getLock().writeLock();
            try {
                for (Map.Entry<String, Object> next : map.entrySet()) {
                    if (next.getKey() == null) continue;
                    this.getMap().put(next.getKey(), next.getValue());
                }
            }
            finally {
                this.getLock().writeUnlock();
            }
        }
    }

    @Override
    public Object remove(String key) {
        if (key == null) {
            throw new WTFException("key ==null is forbidden!");
        }
        if (this.hasProperty(key)) {
            this.getLock().writeLock();
            try {
                Object object = this.getMap().remove(key);
                return object;
            }
            finally {
                this.getLock().writeUnlock();
                this.requestSave();
            }
        }
        return null;
    }

    public void requestSave() {
        long mark = this.setMark.incrementAndGet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void save() throws StorageException {
        if (this.closed) {
            throw new StorageException("StorageChest already closed!");
        }
        long lastSetMark = this.setMark.get();
        if (this.writeMark.getAndSet(lastSetMark) != lastSetMark) {
            byte[] jsonBytes;
            boolean readL = this.getLock().readLock();
            try {
                jsonBytes = MAPPER.objectToByteArray(this.getMap());
                this.writeMark.set(this.setMark.get());
            }
            finally {
                this.getLock().readUnlock(readL);
            }
            Runnable run = new Runnable(){

                @Override
                public void run() {
                    IO.SYNC sync = ShutdownController.getInstance().isShuttingDown() ? IO.SYNC.META_AND_DATA : JsonKeyValueStorage.this.getStorageSyncMode();
                    JSonStorage.saveTo(JsonKeyValueStorage.this.file, JsonKeyValueStorage.this.plain, JsonKeyValueStorage.this.key, jsonBytes, sync);
                }
            };
            StorageHandler.enqueueWrite(run, this.file.getAbsolutePath(), true);
        }
    }

    @Override
    public void setAutoPutValues(boolean autoPutValues) {
        this.autoPutValues = autoPutValues;
    }

    public void setEnumCacheEnabled(boolean enumCacheEnabled) {
        this.enumCacheEnabled = enumCacheEnabled;
    }

    @Override
    public int size() {
        boolean readL = this.getLock().readLock();
        try {
            int n = this.getMap().size();
            return n;
        }
        finally {
            this.getLock().readUnlock(readL);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        boolean readL = this.getLock().readLock();
        try {
            String string = MAPPER.objectToString(this.getMap());
            return string;
        }
        catch (Throwable e) {
            String string = this.getMap().toString();
            return string;
        }
        finally {
            this.getLock().readUnlock(readL);
        }
    }
}

