/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.storage;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import org.appwork.storage.JSonStorage;
import org.appwork.utils.GetterSetter;

public abstract class NonDefaultsOnlySerializer {
    private static final HashMap<Class<?>, Collection<GetterSetter>> GETTER_SETTER_CACHE = new HashMap();

    public static boolean isBoolean(Type type) {
        return type == Boolean.class || type == Boolean.TYPE;
    }

    public static boolean isNotEmpty(String ip) {
        return ip != null && ip.trim().length() != 0;
    }

    public static String createKey(String key) {
        StringBuilder sb = new StringBuilder();
        char[] ca = key.toCharArray();
        boolean starter = true;
        for (char element : ca) {
            if (starter && Character.isUpperCase(element)) {
                sb.append(Character.toLowerCase(element));
                continue;
            }
            starter = false;
            sb.append(element);
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Collection<GetterSetter> getGettersSetteres(Class<?> clazz) {
        Collection<GetterSetter> ret = GETTER_SETTER_CACHE.get(clazz);
        if (ret != null) {
            return ret;
        }
        Class<?> org = clazz;
        HashMap<Class<?>, Collection<GetterSetter>> hashMap = GETTER_SETTER_CACHE;
        synchronized (hashMap) {
            ret = GETTER_SETTER_CACHE.get(clazz);
            if (ret != null) {
                return ret;
            }
            HashMap<String, GetterSetter> map = new HashMap<String, GetterSetter>();
            while (clazz != null) {
                for (Method m : clazz.getDeclaredMethods()) {
                    String key = null;
                    boolean getter = false;
                    if (m.getName().startsWith("is") && NonDefaultsOnlySerializer.isBoolean(m.getReturnType()) && m.getParameterTypes().length == 0) {
                        key = m.getName().substring(2);
                        getter = true;
                    } else if (m.getName().startsWith("get") && m.getParameterTypes().length == 0) {
                        key = m.getName().substring(3);
                        getter = true;
                    } else if (m.getName().startsWith("set") && m.getParameterTypes().length == 1) {
                        key = m.getName().substring(3);
                        getter = false;
                    }
                    if (!NonDefaultsOnlySerializer.isNotEmpty(key)) continue;
                    String unmodifiedKey = key;
                    GetterSetter v = (GetterSetter)map.get(key = NonDefaultsOnlySerializer.createKey(key));
                    if (v == null) {
                        v = new GetterSetter(key);
                        map.put(key, v);
                    }
                    if (getter) {
                        v.setGetter(m);
                    } else {
                        v.setSetter(m);
                    }
                    try {
                        Field field = clazz.getField(unmodifiedKey.substring(0, 1).toLowerCase(Locale.ENGLISH) + unmodifiedKey.substring(1));
                        v.setField(field);
                    }
                    catch (NoSuchFieldException noSuchFieldException) {
                        // empty catch block
                    }
                }
                clazz = clazz.getSuperclass();
            }
            GETTER_SETTER_CACHE.put(org, map.values());
            return GETTER_SETTER_CACHE.get(org);
        }
    }

    public static boolean equals(Object pass, Object pass2) {
        if (pass == pass2) {
            return true;
        }
        if (pass == null && pass2 != null) {
            return false;
        }
        return pass.equals(pass2);
    }

    public static String toJsonString(NoDefaultSerializerInterface object) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Object obj = null;
        try {
            Constructor<?> c = object.getClass().getDeclaredConstructor(new Class[0]);
            c.setAccessible(true);
            Object empty = c.newInstance(new Object[0]);
            for (GetterSetter gs : NonDefaultsOnlySerializer.getGettersSetteres(object.getClass())) {
                obj = gs.get(object);
                if (NonDefaultsOnlySerializer.equals(obj, gs.get(empty))) continue;
                map.put(Character.toLowerCase(gs.getKey().charAt(0)) + gs.getKey().substring(1), obj);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return JSonStorage.serializeToJson(map);
    }

    public static interface NoDefaultSerializerInterface {
    }
}

