/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.storage.config.handler;

import java.lang.annotation.Annotation;
import org.appwork.storage.Storage;
import org.appwork.storage.config.ValidationException;
import org.appwork.storage.config.annotations.DefaultShortValue;
import org.appwork.storage.config.annotations.LookUpKeys;
import org.appwork.storage.config.annotations.SpinnerValidator;
import org.appwork.storage.config.handler.KeyHandler;
import org.appwork.storage.config.handler.StorageHandler;
import org.appwork.utils.StringUtils;

public class ShortKeyHandler
extends KeyHandler<Short> {
    private SpinnerValidator validator;
    private int min;
    private int max;

    public ShortKeyHandler(StorageHandler<?> storageHandler, String key) {
        super(storageHandler, key);
    }

    @Override
    protected Class<? extends Annotation>[] getAllowedAnnotations() {
        return new Class[]{LookUpKeys.class, SpinnerValidator.class};
    }

    @Override
    protected Class<? extends Annotation> getDefaultAnnotation() {
        return DefaultShortValue.class;
    }

    @Override
    protected void initDefaults() throws Throwable {
        this.setDefaultValue((short)0);
    }

    @Override
    protected void initHandler() {
        this.validator = this.getAnnotation(SpinnerValidator.class);
        this.setStorageSyncMode(this.getDefaultStorageSyncMode());
    }

    @Override
    protected boolean equals(Object x, Object y) {
        if (x == y) {
            return true;
        }
        if (x instanceof Short && y instanceof Short) {
            return x.equals(y);
        }
        return false;
    }

    @Override
    protected Short getValueStorage() {
        Object rawValue = this.getRawValueStorage();
        if (rawValue instanceof Number) {
            return ((Number)rawValue).shortValue();
        }
        if (rawValue instanceof String) {
            String stringValue = (String)rawValue;
            if (StringUtils.equalsIgnoreCase("null", stringValue)) {
                if (this.isRealPrimitive()) {
                    return (short)0;
                }
                return null;
            }
            return Short.valueOf(stringValue);
        }
        return (Short)rawValue;
    }

    @Override
    protected void putValue(Short object) {
        Storage storage = this.storageHandler.getPrimitiveStorage(this);
        if (storage != null) {
            storage.put(this.getKey(), object);
        }
    }

    @Override
    protected void validateValue(Short object) throws Throwable {
        if (this.validator != null) {
            short v = object;
            long min = this.validator.min();
            long max = this.validator.max();
            if ((long)v < min) {
                throw new ValidationException("value=" + v + " < min=" + min);
            }
            if ((long)v > max) {
                throw new ValidationException("value=" + v + " > max=" + max);
            }
        }
    }
}

