/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.storage.config.handler;

import java.io.File;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.appwork.exceptions.WTFException;
import org.appwork.loggingv3.LogV3;
import org.appwork.scheduler.DelayedRunnable;
import org.appwork.shutdown.ShutdownController;
import org.appwork.shutdown.ShutdownEvent;
import org.appwork.shutdown.ShutdownRequest;
import org.appwork.storage.JSonStorage;
import org.appwork.storage.JsonKeyValueStorage;
import org.appwork.storage.SimpleMapper;
import org.appwork.storage.Storage;
import org.appwork.storage.StorageException;
import org.appwork.storage.config.ConfigInterface;
import org.appwork.storage.config.InterfaceParseException;
import org.appwork.storage.config.annotations.CryptedStorage;
import org.appwork.storage.config.annotations.DefaultBooleanArrayValue;
import org.appwork.storage.config.annotations.DefaultByteArrayValue;
import org.appwork.storage.config.annotations.DefaultDoubleArrayValue;
import org.appwork.storage.config.annotations.DefaultFloatArrayValue;
import org.appwork.storage.config.annotations.DefaultIntArrayValue;
import org.appwork.storage.config.annotations.DefaultLongArrayValue;
import org.appwork.storage.config.annotations.DefaultShortArrayValue;
import org.appwork.storage.config.annotations.DefaultStorageSyncMode;
import org.appwork.storage.config.events.ConfigEvent;
import org.appwork.storage.config.events.ConfigEventSender;
import org.appwork.storage.config.handler.BooleanKeyHandler;
import org.appwork.storage.config.handler.ByteKeyHandler;
import org.appwork.storage.config.handler.DefaultFactoryInterface;
import org.appwork.storage.config.handler.DoubleKeyHandler;
import org.appwork.storage.config.handler.EnumKeyHandler;
import org.appwork.storage.config.handler.EnumListHandler;
import org.appwork.storage.config.handler.EnumSetKeyHandler;
import org.appwork.storage.config.handler.FloatKeyHandler;
import org.appwork.storage.config.handler.IntegerKeyHandler;
import org.appwork.storage.config.handler.KeyHandler;
import org.appwork.storage.config.handler.ListHandler;
import org.appwork.storage.config.handler.LongKeyHandler;
import org.appwork.storage.config.handler.ObjectKeyHandler;
import org.appwork.storage.config.handler.ShortKeyHandler;
import org.appwork.storage.config.handler.StringKeyHandler;
import org.appwork.storage.config.handler.StringListHandler;
import org.appwork.storage.config.handler.WriteStrategy;
import org.appwork.utils.Application;
import org.appwork.utils.DebugMode;
import org.appwork.utils.Files;
import org.appwork.utils.ReflectionUtils;
import org.appwork.utils.StringUtils;
import org.appwork.utils.logging2.LogInterface;
import org.appwork.utils.reflection.Clazz;

public class StorageHandler<T extends ConfigInterface>
implements InvocationHandler {
    private static final LinkedHashMap<String, Runnable> DELAYEDWRITES = new LinkedHashMap();
    protected static final DelayedRunnable SAVEDELAYER = new DelayedRunnable(5000L, 30000L){

        @Override
        public void delayedrun() {
            StorageHandler.saveAll();
        }
    };
    private static final HashMap<StorageHandler<?>, String> STORAGEMAP;
    public static final AtomicBoolean WRITE_ON_SHUTDOWN;
    private static final AtomicBoolean DELAYED_WRITES;
    private final Class<T> configInterface;
    protected final HashMap<Method, KeyHandler<?>> method2KeyHandlerMap = new HashMap();
    protected final HashMap<String, KeyHandler<?>> key2KeyHandlerMap = new HashMap();
    protected final Storage primitiveStorage;
    private final File path;
    private ConfigEventSender<Object> eventSender = null;
    private String relativCPPath;
    public static HashMap<String, Long> PROFILER_MAP;
    public static HashMap<String, Long> PROFILER_CALLNUM_MAP;
    private volatile WriteStrategy writeStrategy = null;
    private boolean objectCacheEnabled = true;
    private final String storageID;
    boolean saveInShutdownHookEnabled = true;
    private DefaultFactoryInterface defaultFactory;
    private static final SimpleMapper MAPPER;

    public static JsonKeyValueStorage createPrimitiveStorage(File filePath, String classPath, Class<? extends ConfigInterface> configInterface) {
        JsonKeyValueStorage ret;
        CryptedStorage crypted = configInterface.getAnnotation(CryptedStorage.class);
        if (crypted != null) {
            byte[] key = JSonStorage.KEY;
            if (crypted.key() != null) {
                key = crypted.key();
            }
            URL urlClassPath = classPath != null ? Application.class.getClassLoader().getResource(classPath + ".ejs") : null;
            ret = new JsonKeyValueStorage(new File(filePath.getAbsolutePath() + ".ejs"), urlClassPath, false, key);
        } else {
            URL urlClassPath = classPath != null ? Application.class.getClassLoader().getResource(classPath + ".json") : null;
            ret = new JsonKeyValueStorage(new File(filePath.getAbsolutePath() + ".json"), urlClassPath, true, null);
        }
        DefaultStorageSyncMode defaultStorageSyncMode = configInterface.getAnnotation(DefaultStorageSyncMode.class);
        if (defaultStorageSyncMode != null) {
            ret.setStorageSyncMode(defaultStorageSyncMode.value());
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void flushWrites() {
        LogInterface logger = LogV3.I().getDefaultLogger();
        while (true) {
            LinkedHashMap<String, Runnable> linkedHashMap = DELAYEDWRITES;
            synchronized (linkedHashMap) {
                Iterator<Runnable> it = DELAYEDWRITES.values().iterator();
                if (it.hasNext()) {
                    Runnable next = it.next();
                    try {
                        next.run();
                    }
                    catch (Throwable th) {
                        logger.log(th);
                    }
                    finally {
                        it.remove();
                    }
                } else {
                    return;
                }
            }
        }
    }

    public static void setDelayedWritesEnabled(boolean enabled) {
        if (DELAYED_WRITES.compareAndSet(!enabled, enabled) && !enabled) {
            StorageHandler.flushWrites();
        }
    }

    public static boolean isDelayedWritesEnabled() {
        return DELAYED_WRITES.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void enqueueWrite(Runnable run, String ID2, boolean delayWriteAllowed) {
        boolean write;
        LinkedHashMap<String, Runnable> linkedHashMap = DELAYEDWRITES;
        synchronized (linkedHashMap) {
            boolean isShuttingDown = ShutdownController.getInstance().isShuttingDown();
            boolean isDelayedWritesEnabled = StorageHandler.isDelayedWritesEnabled();
            if (isShuttingDown || !delayWriteAllowed || !isDelayedWritesEnabled) {
                if (DELAYEDWRITES.size() > 0) {
                    DELAYEDWRITES.remove(ID2);
                }
                write = true;
            } else {
                DELAYEDWRITES.put(ID2, run);
                write = false;
            }
        }
        if (write) {
            run.run();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static StorageHandler<?> getStorageHandler(String interfaceName, String storage) {
        HashMap<StorageHandler<?>, String> hashMap = STORAGEMAP;
        synchronized (hashMap) {
            String ID2 = interfaceName + "." + storage;
            Iterator<Map.Entry<StorageHandler<?>, String>> it = STORAGEMAP.entrySet().iterator();
            StorageHandler<?> ret = null;
            while (it.hasNext()) {
                Map.Entry<StorageHandler<?>, String> next = it.next();
                if (!ID2.equals(next.getValue()) || (ret = next.getKey()) == null) continue;
                return ret;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveAll() {
        HashMap<StorageHandler<?>, String> hashMap = STORAGEMAP;
        synchronized (hashMap) {
            for (StorageHandler<?> storageHandler : STORAGEMAP.keySet()) {
                try {
                    if (!storageHandler.isSaveInShutdownHookEnabled()) continue;
                    storageHandler.write();
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public DefaultFactoryInterface getDefaultFactory() {
        return this.defaultFactory;
    }

    public void setDefaultFactory(DefaultFactoryInterface defaultFactory) {
        this.defaultFactory = defaultFactory;
    }

    public StorageHandler() {
        MAPPER.setPrettyPrintEnabled(false);
        this.configInterface = null;
        this.path = null;
        this.storageID = null;
        this.primitiveStorage = null;
    }

    public StorageHandler(File filePath, Class<T> configInterface) {
        MAPPER.setPrettyPrintEnabled(false);
        this.configInterface = configInterface;
        this.path = filePath;
        this.preInit(this.path, configInterface);
        if (filePath.getName().endsWith(".json") || filePath.getName().endsWith(".ejs")) {
            LogV3.warning(filePath + " should not have an extension!!");
        }
        File expected = Application.getResource("cfg/" + configInterface.getName());
        String storageID = null;
        if (!this.path.equals(expected) && StringUtils.isEmpty(storageID = Files.getRelativePath(expected.getParentFile().getParentFile(), this.path))) {
            storageID = this.path.getAbsolutePath();
        }
        this.storageID = storageID;
        String relativePath = null;
        try {
            this.relativCPPath = relativePath = Files.getRelativePath(Application.getResource(""), filePath);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        this.primitiveStorage = StorageHandler.createPrimitiveStorage(this.path, relativePath, configInterface);
        CryptedStorage cryptedStorage = configInterface.getAnnotation(CryptedStorage.class);
        if (cryptedStorage != null) {
            this.validateKeys(cryptedStorage);
        }
        try {
            this.parseInterface();
        }
        catch (InterfaceParseException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new InterfaceParseException(e);
        }
        this.addStorageHandler(this, configInterface.getName(), this.getStorageID());
    }

    protected void preInit(File path, Class<T> configInterfac) {
    }

    public StorageHandler(Storage storage, Class<T> configInterface) {
        MAPPER.setPrettyPrintEnabled(false);
        String storagePath = storage.getID();
        if (storagePath.endsWith(".json")) {
            storagePath = storagePath.replaceFirst("\\.json$", "");
        } else if (storagePath.endsWith(".ejs")) {
            storagePath = storagePath.replaceFirst("\\.ejs$", "");
        }
        this.primitiveStorage = storage;
        this.path = new File(storagePath);
        this.configInterface = configInterface;
        this.preInit(this.path, configInterface);
        File expected = Application.getResource("cfg/" + configInterface.getName());
        String storageID = null;
        if (!this.path.equals(expected) && StringUtils.isEmpty(storageID = Files.getRelativePath(expected.getParentFile().getParentFile(), this.path))) {
            storageID = this.path.getAbsolutePath();
        }
        this.storageID = storageID;
        CryptedStorage cryptedStorage = configInterface.getAnnotation(CryptedStorage.class);
        if (cryptedStorage != null) {
            this.validateKeys(cryptedStorage);
        }
        try {
            LogV3.finer("Init StorageHandler for Interface:" + configInterface.getName() + "|Path:" + this.path);
            this.parseInterface();
        }
        catch (Throwable e) {
            throw new InterfaceParseException(e);
        }
        this.addStorageHandler(this, configInterface.getName(), this.getStorageID());
    }

    protected StorageHandler(Class<T> configInterface) {
        MAPPER.setPrettyPrintEnabled(false);
        this.primitiveStorage = null;
        this.path = null;
        this.configInterface = configInterface;
        this.storageID = null;
        CryptedStorage cryptedStorage = configInterface.getAnnotation(CryptedStorage.class);
        if (cryptedStorage != null) {
            this.validateKeys(cryptedStorage);
        }
        try {
            LogV3.finer("Init StorageHandler for Interface:" + configInterface.getName() + "|Path:" + this.path);
            this.parseInterface();
        }
        catch (Throwable e) {
            throw new InterfaceParseException(e);
        }
        this.addStorageHandler(this, configInterface.getName(), this.getStorageID());
    }

    protected void requestSave() {
        SAVEDELAYER.resetAndStart();
    }

    public StorageHandler(String classPath, Class<T> configInterface) throws URISyntaxException {
        MAPPER.setPrettyPrintEnabled(false);
        this.configInterface = configInterface;
        this.relativCPPath = classPath;
        if (classPath.endsWith(".json") || classPath.endsWith(".ejs")) {
            LogV3.warning(classPath + " should not have an extension!!");
        }
        this.path = Application.getResource(classPath);
        this.preInit(this.path, configInterface);
        File expected = Application.getResource("cfg/" + configInterface.getName());
        String storageID = null;
        if (!this.path.equals(expected) && StringUtils.isEmpty(storageID = Files.getRelativePath(expected.getParentFile().getParentFile(), this.path))) {
            storageID = this.path.getAbsolutePath();
        }
        this.storageID = storageID;
        this.primitiveStorage = StorageHandler.createPrimitiveStorage(Application.getResource(classPath), classPath, configInterface);
        CryptedStorage cryptedStorage = configInterface.getAnnotation(CryptedStorage.class);
        if (cryptedStorage != null) {
            this.validateKeys(cryptedStorage);
        }
        try {
            LogV3.finer("Init StorageHandler for Interface:" + configInterface.getName() + "|Path:" + this.path);
            this.parseInterface();
        }
        catch (Throwable e) {
            throw new InterfaceParseException(e);
        }
        this.addStorageHandler(this, configInterface.getName(), this.getStorageID());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addStorageHandler(StorageHandler<? extends ConfigInterface> storageHandler, String interfaceName, String storage) {
        HashMap<StorageHandler<?>, String> hashMap = STORAGEMAP;
        synchronized (hashMap) {
            StorageHandler<?> existing = StorageHandler.getStorageHandler(interfaceName, storage);
            if (existing != null && existing != storageHandler) {
                throw new IllegalStateException("You cannot init the configinterface " + this.getConfigInterface() + " twice");
            }
            String ID2 = interfaceName + "." + storage;
            STORAGEMAP.put(storageHandler, ID2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearFromCache(StorageHandler<?> handler) {
        HashMap<StorageHandler<?>, String> hashMap = STORAGEMAP;
        synchronized (hashMap) {
            String ID2 = handler.getConfigInterface().getName() + "." + handler.getStorageID();
            Iterator<Map.Entry<StorageHandler<?>, String>> it = STORAGEMAP.entrySet().iterator();
            while (it.hasNext()) {
                StorageHandler<?> ret;
                Map.Entry<StorageHandler<?>, String> next = it.next();
                if (!ID2.equals(next.getValue()) || (ret = next.getKey()) == null) continue;
                it.remove();
            }
        }
    }

    public Object runDefaultValueFactory(KeyHandler<?> handler, Object o) {
        DefaultFactoryInterface df = this.defaultFactory;
        if (df == null) {
            return o;
        }
        return df.getDefaultValue(handler, o);
    }

    protected KeyHandler<?> createKeyHandler(String key, Type type) {
        if (Clazz.isBoolean(type)) {
            return new BooleanKeyHandler(this, key);
        }
        if (Clazz.isByte(type)) {
            return new ByteKeyHandler(this, key);
        }
        if (Clazz.isDouble(type)) {
            return new DoubleKeyHandler(this, key);
        }
        if (Clazz.isFloat(type)) {
            return new FloatKeyHandler(this, key);
        }
        if (Clazz.isInteger(type)) {
            return new IntegerKeyHandler(this, key);
        }
        if (Clazz.isShort(type)) {
            return new ShortKeyHandler(this, key);
        }
        if (type instanceof Class && ((Class)type).isEnum()) {
            return new EnumKeyHandler(this, key);
        }
        if (type == String.class) {
            return new StringKeyHandler(this, key);
        }
        if (Clazz.isLong(type)) {
            return new LongKeyHandler(this, key);
        }
        if (type instanceof Class && ((Class)type).isArray()) {
            Class<?> ct = ((Class)type).getComponentType();
            boolean p = ct.isPrimitive();
            if (Clazz.isNumberType(ct)) {
                if (Clazz.isFloatingPointNumber(ct)) {
                    if (Clazz.isDouble(ct)) {
                        if (p) {
                            return new ListHandler(this, key, type, DefaultDoubleArrayValue.class);
                        }
                        return new ListHandler(this, key, type, DefaultDoubleArrayValue.class);
                    }
                    if (Clazz.isFloat(ct)) {
                        if (p) {
                            return new ListHandler(this, key, type, DefaultFloatArrayValue.class);
                        }
                        return new ListHandler(this, key, type, DefaultFloatArrayValue.class);
                    }
                } else {
                    if (Clazz.isByte(ct)) {
                        if (p) {
                            return new ListHandler(this, key, type, DefaultByteArrayValue.class);
                        }
                        return new ListHandler(this, key, type, DefaultByteArrayValue.class);
                    }
                    if (Clazz.isShort(ct)) {
                        if (p) {
                            return new ListHandler(this, key, type, DefaultShortArrayValue.class);
                        }
                        return new ListHandler(this, key, type, DefaultShortArrayValue.class);
                    }
                    if (Clazz.isInteger(ct)) {
                        if (p) {
                            return new ListHandler(this, key, type, DefaultIntArrayValue.class);
                        }
                        return new ListHandler(this, key, type, DefaultIntArrayValue.class);
                    }
                    if (Clazz.isLong(ct)) {
                        if (p) {
                            return new ListHandler(this, key, type, DefaultLongArrayValue.class);
                        }
                        return new ListHandler(this, key, type, DefaultLongArrayValue.class);
                    }
                }
                return new ObjectKeyHandler(this, key, type);
            }
            if (Clazz.isBoolean(ct)) {
                if (p) {
                    return new ListHandler(this, key, type, DefaultBooleanArrayValue.class);
                }
                return new ListHandler(this, key, type, DefaultBooleanArrayValue.class);
            }
            if (Clazz.isString(ct)) {
                return new StringListHandler(this, key, type);
            }
            if (Clazz.isEnum(ct)) {
                return new EnumListHandler(this, key, type);
            }
            return new ObjectKeyHandler(this, key, type);
        }
        if (StorageHandler.isEnumSet(type)) {
            return new EnumSetKeyHandler(this, key, type);
        }
        return new ObjectKeyHandler(this, key, type);
    }

    private static boolean isEnumSet(Type type) {
        ParameterizedType pType;
        return type instanceof ParameterizedType && (pType = (ParameterizedType)type).getRawType() == Set.class && pType.getActualTypeArguments().length == 1 && Clazz.isEnum(pType.getActualTypeArguments()[0]);
    }

    protected void error(Throwable e) {
        LogV3.defaultLogger().log(e);
    }

    protected void fireEvent(ConfigEvent.Types type, KeyHandler<?> keyHandler, Object parameter) {
        if (this.hasEventListener()) {
            this.getEventSender().fireEvent(new ConfigEvent(type, keyHandler, parameter));
        }
    }

    public Class<T> getConfigInterface() {
        return this.configInterface;
    }

    public synchronized ConfigEventSender<Object> getEventSender() {
        if (this.eventSender == null) {
            this.eventSender = new ConfigEventSender();
        }
        return this.eventSender;
    }

    public KeyHandler<Object> getKeyHandler(String key) {
        return this.getKeyHandler(key, KeyHandler.class);
    }

    public <E extends KeyHandler<?>> E getKeyHandler(String key, Class<E> class1) {
        String keyHandlerKey = key.toLowerCase(Locale.ENGLISH);
        KeyHandler<?> ret = this.key2KeyHandlerMap.get(keyHandlerKey);
        if (ret != null) {
            return (E)ret;
        }
        try {
            throw new NullPointerException("No KeyHandler: " + key + " in " + this.getConfigInterface());
        }
        catch (NullPointerException e) {
            if (DebugMode.throwInIDEElse(e)) {
                LogV3.log(e);
            }
            return null;
        }
    }

    public File getPath() {
        return this.path;
    }

    public Object getPrimitive(KeyHandler<?> keyHandler) {
        Storage storage = this.getPrimitiveStorage(keyHandler);
        if (storage != null && storage.hasProperty(keyHandler.getKey())) {
            if (Clazz.isBoolean(keyHandler.getRawClass())) {
                return this.getPrimitive(keyHandler, false);
            }
            if (Clazz.isLong(keyHandler.getRawClass())) {
                return this.getPrimitive(keyHandler, 0L);
            }
            if (Clazz.isInteger(keyHandler.getRawClass())) {
                return this.getPrimitive(keyHandler, 0);
            }
            if (Clazz.isShort(keyHandler.getRawClass())) {
                return this.getPrimitive(keyHandler, 0);
            }
            if (Clazz.isFloat(keyHandler.getRawClass())) {
                return this.getPrimitive(keyHandler, Float.valueOf(0.0f));
            }
            if (Clazz.isDouble(keyHandler.getRawClass())) {
                return this.getPrimitive(keyHandler, 0.0);
            }
            if (Clazz.isByte(keyHandler.getRawClass())) {
                return this.getPrimitive(keyHandler, (byte)0);
            }
            if (keyHandler.getRawClass() == String.class) {
                return this.getPrimitive(keyHandler, null);
            }
            if (keyHandler.getRawClass().isEnum()) {
                return this.getPrimitive(keyHandler, keyHandler.getDefaultValue());
            }
            throw new StorageException("Invalid datatype: " + keyHandler.getRawClass());
        }
        if (Clazz.isBoolean(keyHandler.getRawClass())) {
            return this.getPrimitive(keyHandler, keyHandler.getDefaultValue());
        }
        if (Clazz.isLong(keyHandler.getRawClass())) {
            return this.getPrimitive(keyHandler, keyHandler.getDefaultValue());
        }
        if (Clazz.isInteger(keyHandler.getRawClass())) {
            return this.getPrimitive(keyHandler, keyHandler.getDefaultValue());
        }
        if (Clazz.isShort(keyHandler.getRawClass())) {
            return this.getPrimitive(keyHandler, keyHandler.getDefaultValue());
        }
        if (Clazz.isFloat(keyHandler.getRawClass())) {
            return this.getPrimitive(keyHandler, keyHandler.getDefaultValue());
        }
        if (Clazz.isDouble(keyHandler.getRawClass())) {
            return this.getPrimitive(keyHandler, keyHandler.getDefaultValue());
        }
        if (Clazz.isByte(keyHandler.getRawClass())) {
            return this.getPrimitive(keyHandler, keyHandler.getDefaultValue());
        }
        if (keyHandler.getRawClass() == String.class) {
            return this.getPrimitive(keyHandler, keyHandler.getDefaultValue());
        }
        if (keyHandler.getRawClass().isEnum()) {
            return this.getPrimitive(keyHandler, keyHandler.getDefaultValue());
        }
        throw new StorageException("Invalid datatype: " + keyHandler.getRawClass());
    }

    protected byte[] toJson(ListHandler<?> keyHandler, Object object) {
        return MAPPER.objectToByteArray(object);
    }

    protected void writeObject(final ListHandler<?> keyHandler, Object object) {
        final byte[] jsonBytes = this.toJson(keyHandler, object);
        final byte[] cryptKey = keyHandler.getCryptKey();
        final File path = keyHandler.getPath();
        Runnable run = new Runnable(){

            @Override
            public void run() {
                JSonStorage.saveTo(path, cryptKey == null, cryptKey, jsonBytes, keyHandler.getStorageSyncMode());
            }
        };
        StorageHandler.enqueueWrite(run, path.getAbsolutePath(), this.isDelayedWriteAllowed(keyHandler));
    }

    protected Object readObject(ListHandler<?> keyHandler, AtomicBoolean readFlag) {
        return null;
    }

    protected boolean isDelayedWriteAllowed(KeyHandler<?> keyHandler) {
        return keyHandler.isDelayedWriteAllowed();
    }

    public <E> E getPrimitive(KeyHandler<?> keyHandler, E def) {
        Storage storage = this.getPrimitiveStorage(keyHandler);
        return storage != null ? storage.get(keyHandler.getKey(), def) : def;
    }

    public Storage getPrimitiveStorage(KeyHandler<?> keyHandler) {
        return this.getPrimitiveStorage();
    }

    public Storage getPrimitiveStorage() {
        return this.primitiveStorage;
    }

    public String getRelativCPPath() {
        return this.relativCPPath;
    }

    public String getStorageID() {
        return this.storageID;
    }

    public Object getValue(String key) {
        return this.getKeyHandler(key).getValue();
    }

    public WriteStrategy getWriteStrategy() {
        return this.writeStrategy;
    }

    public synchronized boolean hasEventListener() {
        return this.eventSender != null && this.eventSender.hasListener();
    }

    @Override
    public Object invoke(Object instance, Method m, Object[] parameter) throws Throwable {
        if (m != null) {
            block35: {
                Object object;
                block36: {
                    long t;
                    block33: {
                        StorageHandler storageHandler;
                        block34: {
                            block31: {
                                String string;
                                block32: {
                                    block25: {
                                        Object var8_13;
                                        block30: {
                                            KeyHandler<?> handler;
                                            block26: {
                                                Object obj;
                                                block29: {
                                                    Object ret;
                                                    block27: {
                                                        Number number;
                                                        block28: {
                                                            t = PROFILER_MAP == null ? 0L : System.nanoTime();
                                                            try {
                                                                handler = this.method2KeyHandlerMap.get(m);
                                                                if (handler == null) break block25;
                                                                if (!handler.isGetter(m)) break block26;
                                                                ret = handler.getValue();
                                                                if (!(ret instanceof Number)) break block27;
                                                                number = ReflectionUtils.castNumber((Number)ret, handler.getRawClass());
                                                                if (PROFILER_MAP == null || m == null) break block28;
                                                            }
                                                            catch (Throwable throwable) {
                                                                if (PROFILER_MAP != null && m != null) {
                                                                    long dur = System.nanoTime() - t;
                                                                    String id = m.toString();
                                                                    Long g = PROFILER_MAP.get(id);
                                                                    if (g == null) {
                                                                        g = 0L;
                                                                    }
                                                                    PROFILER_MAP.put(id, g + dur);
                                                                }
                                                                if (PROFILER_CALLNUM_MAP != null && m != null) {
                                                                    String id;
                                                                    Long g = PROFILER_CALLNUM_MAP.get(id = m.toString());
                                                                    PROFILER_CALLNUM_MAP.put(id, g == null ? 1L : g + 1L);
                                                                }
                                                                throw throwable;
                                                            }
                                                            long dur = System.nanoTime() - t;
                                                            String id = m.toString();
                                                            Long g = PROFILER_MAP.get(id);
                                                            if (g == null) {
                                                                g = 0L;
                                                            }
                                                            PROFILER_MAP.put(id, g + dur);
                                                        }
                                                        if (PROFILER_CALLNUM_MAP != null && m != null) {
                                                            String id;
                                                            Long g = PROFILER_CALLNUM_MAP.get(id = m.toString());
                                                            PROFILER_CALLNUM_MAP.put(id, g == null ? 1L : g + 1L);
                                                        }
                                                        return number;
                                                    }
                                                    obj = ret;
                                                    if (PROFILER_MAP == null || m == null) break block29;
                                                    long dur = System.nanoTime() - t;
                                                    String id = m.toString();
                                                    Long g = PROFILER_MAP.get(id);
                                                    if (g == null) {
                                                        g = 0L;
                                                    }
                                                    PROFILER_MAP.put(id, g + dur);
                                                }
                                                if (PROFILER_CALLNUM_MAP != null && m != null) {
                                                    String id;
                                                    Long g = PROFILER_CALLNUM_MAP.get(id = m.toString());
                                                    PROFILER_CALLNUM_MAP.put(id, g == null ? 1L : g + 1L);
                                                }
                                                return obj;
                                            }
                                            handler.setValue(parameter[0]);
                                            WriteStrategy writeStrategy = this.getWriteStrategy();
                                            if (writeStrategy != null) {
                                                writeStrategy.write(this, handler);
                                            }
                                            var8_13 = null;
                                            if (PROFILER_MAP == null || m == null) break block30;
                                            long dur = System.nanoTime() - t;
                                            String id = m.toString();
                                            Long g = PROFILER_MAP.get(id);
                                            if (g == null) {
                                                g = 0L;
                                            }
                                            PROFILER_MAP.put(id, g + dur);
                                        }
                                        if (PROFILER_CALLNUM_MAP != null && m != null) {
                                            String id;
                                            Long g = PROFILER_CALLNUM_MAP.get(id = m.toString());
                                            PROFILER_CALLNUM_MAP.put(id, g == null ? 1L : g + 1L);
                                        }
                                        return var8_13;
                                    }
                                    if (!m.getName().equals("toString")) break block31;
                                    string = this.toString();
                                    if (PROFILER_MAP == null || m == null) break block32;
                                    long dur = System.nanoTime() - t;
                                    String id = m.toString();
                                    Long g = PROFILER_MAP.get(id);
                                    if (g == null) {
                                        g = 0L;
                                    }
                                    PROFILER_MAP.put(id, g + dur);
                                }
                                if (PROFILER_CALLNUM_MAP != null && m != null) {
                                    String id;
                                    Long g = PROFILER_CALLNUM_MAP.get(id = m.toString());
                                    PROFILER_CALLNUM_MAP.put(id, g == null ? 1L : g + 1L);
                                }
                                return string;
                            }
                            if (!m.getName().equals("_getStorageHandler")) break block33;
                            storageHandler = this;
                            if (PROFILER_MAP == null || m == null) break block34;
                            long dur = System.nanoTime() - t;
                            String id = m.toString();
                            Long g = PROFILER_MAP.get(id);
                            if (g == null) {
                                g = 0L;
                            }
                            PROFILER_MAP.put(id, g + dur);
                        }
                        if (PROFILER_CALLNUM_MAP != null && m != null) {
                            String id;
                            Long g = PROFILER_CALLNUM_MAP.get(id = m.toString());
                            PROFILER_CALLNUM_MAP.put(id, g == null ? 1L : g + 1L);
                        }
                        return storageHandler;
                    }
                    if (m.getDeclaringClass() != Object.class) break block35;
                    object = m.invoke((Object)this, parameter);
                    if (PROFILER_MAP == null || m == null) break block36;
                    long dur = System.nanoTime() - t;
                    String id = m.toString();
                    Long g = PROFILER_MAP.get(id);
                    if (g == null) {
                        g = 0L;
                    }
                    PROFILER_MAP.put(id, g + dur);
                }
                if (PROFILER_CALLNUM_MAP != null && m != null) {
                    String id;
                    Long g = PROFILER_CALLNUM_MAP.get(id = m.toString());
                    PROFILER_CALLNUM_MAP.put(id, g == null ? 1L : g + 1L);
                }
                return object;
            }
            throw new WTFException(m + " ??? no keyhandler. This is not possible!");
        }
        return this;
    }

    public boolean isObjectCacheEnabled() {
        return this.objectCacheEnabled;
    }

    public boolean isSaveInShutdownHookEnabled() {
        return this.saveInShutdownHookEnabled;
    }

    protected int getParameterCount(Method method) {
        if (method != null) {
            return method.getParameterTypes().length;
        }
        return 0;
    }

    protected void parseInterface() throws Throwable {
        HashMap<String, Method> keyGetterMap = new HashMap<String, Method>();
        HashMap<String, Method> keySetterMap = new HashMap<String, Method>();
        HashMap parseMap = new HashMap();
        HashSet dupes = new HashSet();
        ArrayList<Class<T>> classes = this.findInterfaces(this.getConfigInterface(), dupes);
        for (Class<T> clazz : classes) {
            for (Method m : clazz.getDeclaredMethods()) {
                KeyHandler kh;
                String key;
                String methodName = m.getName().toLowerCase(Locale.ENGLISH);
                if (methodName.startsWith("get")) {
                    key = methodName.substring(3);
                    if (keyGetterMap.containsKey(key)) {
                        if (m.getName().equals(((Method)keyGetterMap.get(key)).getName()) && this.getParameterCount(m) == this.getParameterCount((Method)keyGetterMap.get(key))) {
                            LogV3.info("Overridden Config Key found " + keyGetterMap.get(key) + "<-->" + m);
                            continue;
                        }
                        this.error(new InterfaceParseException("Key " + key + " Dupe found! " + keyGetterMap.get(key) + "<-->" + m));
                        continue;
                    }
                    keyGetterMap.put(key, m);
                    if (this.getParameterCount(m) > 0) {
                        this.error(new InterfaceParseException("Getter " + m + " has parameters."));
                        keyGetterMap.remove(key);
                        continue;
                    }
                    kh = (KeyHandler)parseMap.get(key);
                    if (kh == null) {
                        kh = this.createKeyHandler(key, m.getGenericReturnType());
                        parseMap.put(key, kh);
                    }
                    kh.setGetMethod(m);
                    this.addKeyHandler(kh);
                    continue;
                }
                if (methodName.startsWith("is")) {
                    key = methodName.substring(2);
                    if (keyGetterMap.containsKey(key)) {
                        if (m.getName().equals(((Method)keyGetterMap.get(key)).getName()) && this.getParameterCount(m) == this.getParameterCount((Method)keyGetterMap.get(key))) {
                            LogV3.info("Overridden Config Key found " + keyGetterMap.get(key) + "<-->" + m);
                            continue;
                        }
                        this.error(new InterfaceParseException("Key " + key + " Dupe found! " + keyGetterMap.get(key) + "<-->" + m));
                        continue;
                    }
                    keyGetterMap.put(key, m);
                    if (this.getParameterCount(m) > 0) {
                        this.error(new InterfaceParseException("Getter " + m + " has parameters."));
                        keyGetterMap.remove(key);
                        continue;
                    }
                    kh = (KeyHandler)parseMap.get(key);
                    if (kh == null) {
                        kh = this.createKeyHandler(key, m.getGenericReturnType());
                        parseMap.put(key, kh);
                    }
                    kh.setGetMethod(m);
                    this.addKeyHandler(kh);
                    continue;
                }
                if (methodName.startsWith("set")) {
                    key = methodName.substring(3);
                    if (keySetterMap.containsKey(key)) {
                        Method other = (Method)keySetterMap.get(key);
                        if (m.getName().equals(((Method)keySetterMap.get(key)).getName()) && this.getParameterCount(m) == this.getParameterCount((Method)keySetterMap.get(key))) {
                            LogV3.info("Overridden Config Key found " + keySetterMap.get(key) + "<-->" + m);
                            continue;
                        }
                        this.error(new InterfaceParseException("Key " + key + " Dupe found! " + keySetterMap.get(key) + "<-->" + m));
                        continue;
                    }
                    keySetterMap.put(key, m);
                    if (this.getParameterCount(m) != 1) {
                        this.error(new InterfaceParseException("Setter " + m + " has !=1 parameters."));
                        keySetterMap.remove(key);
                        continue;
                    }
                    if (m.getReturnType() != Void.TYPE) {
                        this.error(new InterfaceParseException("Setter " + m + " has a returntype != void"));
                        keySetterMap.remove(key);
                        continue;
                    }
                    kh = (KeyHandler)parseMap.get(key);
                    if (kh == null) {
                        kh = this.createKeyHandler(key, m.getGenericParameterTypes()[0]);
                        parseMap.put(key, kh);
                    }
                    kh.setSetMethod(m);
                    this.addKeyHandler(kh);
                    continue;
                }
                this.error(new InterfaceParseException("Only getter and setter allowed:" + m));
            }
        }
        ArrayList keyHandlerToRemove = new ArrayList();
        for (KeyHandler<Object> kh : this.key2KeyHandlerMap.values()) {
            try {
                kh.init();
            }
            catch (Throwable e) {
                this.error(e);
                keyHandlerToRemove.add(kh);
            }
        }
        for (KeyHandler<Object> kh : keyHandlerToRemove) {
            this.removeKeyHandler(kh);
        }
    }

    protected ArrayList<Class<?>> findInterfaces(Class<?> clazz, HashSet<Class<?>> dupes) {
        ArrayList ret = new ArrayList();
        if (clazz == ConfigInterface.class) {
            return ret;
        }
        if (!dupes.add(clazz)) {
            return ret;
        }
        ret.add(clazz);
        Class<?>[] interfaces = clazz.getInterfaces();
        if (interfaces != null) {
            for (Class<?> i : interfaces) {
                ret.addAll(this.findInterfaces(i, dupes));
            }
        }
        return ret;
    }

    public List<KeyHandler<?>> getKeyHandler() {
        return new ArrayList(this.key2KeyHandlerMap.values());
    }

    private void removeKeyHandler(KeyHandler<?> keyHandler) {
        if (this.key2KeyHandlerMap.remove(keyHandler.getKey()) != null) {
            Method setMethod;
            Method getMethod = keyHandler.getGetMethod();
            if (getMethod != null) {
                this.method2KeyHandlerMap.remove(getMethod);
            }
            if ((setMethod = keyHandler.getSetMethod()) != null) {
                this.method2KeyHandlerMap.remove(setMethod);
            }
        }
    }

    private void addKeyHandler(KeyHandler<?> keyHandler) {
        Method setMethod;
        Method getMethod = keyHandler.getGetMethod();
        if (getMethod != null) {
            this.method2KeyHandlerMap.put(getMethod, keyHandler);
        }
        if ((setMethod = keyHandler.getSetMethod()) != null) {
            this.method2KeyHandlerMap.put(setMethod, keyHandler);
        }
        this.key2KeyHandlerMap.put(keyHandler.getKey(), keyHandler);
    }

    public void setObjectCacheEnabled(boolean objectCacheEnabled) {
        this.objectCacheEnabled = objectCacheEnabled;
    }

    public void setSaveInShutdownHookEnabled(boolean saveInShutdownHookEnabled) {
        this.saveInShutdownHookEnabled = saveInShutdownHookEnabled;
    }

    public void setWriteStrategy(WriteStrategy writeStrategy) {
        this.writeStrategy = writeStrategy;
    }

    public String toString() {
        HashMap<String, Object> ret = new HashMap<String, Object>();
        for (KeyHandler<?> h : this.key2KeyHandlerMap.values()) {
            try {
                ret.put(h.getKey(), this.invoke(null, h.getGetMethod(), new Object[0]));
            }
            catch (Throwable e) {
                e.printStackTrace();
                ret.put(h.getKey(), e.getMessage());
            }
        }
        return JSonStorage.toString(ret);
    }

    protected void validateKeys(CryptedStorage crypted) {
    }

    public void write() {
        Storage storage = this.getPrimitiveStorage();
        if (storage != null) {
            storage.save();
        }
    }

    public void setAllowWriteDefaultObjects(boolean b) {
        for (KeyHandler<?> kh : this.getKeyHandler()) {
            kh.setAllowWriteDefaultObjects(b);
        }
    }

    static {
        WRITE_ON_SHUTDOWN = new AtomicBoolean(true);
        STORAGEMAP = new HashMap();
        ShutdownController.getInstance().addShutdownEvent(new ShutdownEvent(){

            @Override
            public long getMaxDuration() {
                return 0L;
            }

            @Override
            public int getHookPriority() {
                return 0;
            }

            @Override
            public void onShutdown(ShutdownRequest shutdownRequest) {
                if (WRITE_ON_SHUTDOWN.get()) {
                    StorageHandler.flushWrites();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String toString() {
                LinkedHashMap linkedHashMap = DELAYEDWRITES;
                synchronized (linkedHashMap) {
                    return "ShutdownEvent: ProcessDelayedWrites num=" + DELAYEDWRITES.size();
                }
            }
        });
        ShutdownController.getInstance().addShutdownEvent(new ShutdownEvent(){

            @Override
            public long getMaxDuration() {
                return 0L;
            }

            @Override
            public int getHookPriority() {
                return 0;
            }

            @Override
            public void onShutdown(ShutdownRequest shutdownRequest) {
                if (WRITE_ON_SHUTDOWN.get()) {
                    StorageHandler.saveAll();
                }
            }

            @Override
            public String toString() {
                return "ShutdownEvent: SaveAllStorageHandler";
            }
        });
        DELAYED_WRITES = new AtomicBoolean(false);
        PROFILER_MAP = null;
        PROFILER_CALLNUM_MAP = null;
        MAPPER = new SimpleMapper();
    }
}

