/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.storage.flexijson;

import java.io.StringReader;
import java.util.Map;
import java.util.Properties;
import org.appwork.exceptions.WTFException;
import org.appwork.storage.flexijson.FlexiJSONParser;
import org.appwork.storage.flexijson.FlexiJSonArray;
import org.appwork.storage.flexijson.FlexiJSonNode;
import org.appwork.storage.flexijson.FlexiJSonObject;
import org.appwork.storage.flexijson.FlexiJSonValue;
import org.appwork.storage.flexijson.FlexiParserException;
import org.appwork.storage.flexijson.KeyValueElement;
import org.appwork.storage.flexijson.ParsingError;
import org.appwork.utils.StringUtils;

public class FlexiJSonFromProperties {
    public static FlexiJSonNode convert(Properties p) throws FlexiParserException {
        try {
            FlexiJSonNode root = null;
            root = FlexiJSonFromProperties.merge(p, root);
            return root;
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw new WTFException(e);
        }
    }

    public static FlexiJSonNode merge(Properties p, FlexiJSonNode root) throws FlexiParserException {
        for (Map.Entry<Object, Object> e : p.entrySet()) {
            String key = e.getKey().toString();
            String valueString = StringUtils.valueOfOrNull(e.getValue());
            root = FlexiJSonFromProperties.merge(root, key, valueString);
        }
        return root;
    }

    public static FlexiJSonNode merge(FlexiJSonNode root, String key, String valueString) throws FlexiParserException {
        block24: {
            FlexiJSonNode container = null;
            String[] parts = key.split("(\\.|(?=\\[))");
            block4: for (int i = 0; i < parts.length; ++i) {
                FlexiJSonNode newContainer;
                if (i == 0 && root != null) {
                    container = root;
                    continue;
                }
                if (container != null) {
                    if (container instanceof FlexiJSonObject) {
                        for (KeyValueElement el : ((FlexiJSonObject)container).getElements()) {
                            if (!el.getKey().equals(parts[i - 1])) continue;
                            container = el.getValue();
                            continue block4;
                        }
                    } else {
                        FlexiJSonNode ele;
                        int index = Integer.parseInt(parts[i - 1].substring(1, parts[i - 1].length() - 1));
                        if (((FlexiJSonArray)container).size() > index && !((ele = (FlexiJSonNode)((FlexiJSonArray)container).get(index)) instanceof FlexiJSonValue)) {
                            container = ele;
                            continue;
                        }
                    }
                }
                if (parts[i].startsWith("[")) {
                    try {
                        Integer.parseInt(parts[i].substring(1, parts[i].length() - 1));
                        newContainer = new FlexiJSonArray();
                    }
                    catch (NumberFormatException ex) {
                        newContainer = new FlexiJSonObject();
                    }
                } else {
                    newContainer = new FlexiJSonObject();
                }
                if (root == null) {
                    root = newContainer;
                }
                if (container != null) {
                    if (container instanceof FlexiJSonObject) {
                        ((FlexiJSonObject)container).add(new KeyValueElement((FlexiJSonObject)container, parts[i - 1], newContainer));
                    } else {
                        int index = Integer.parseInt(parts[i - 1].substring(1, parts[i - 1].length() - 1));
                        while (((FlexiJSonArray)container).size() < index) {
                            ((FlexiJSonArray)container).add(new FlexiJSonValue());
                        }
                        if (((FlexiJSonArray)container).size() == index) {
                            ((FlexiJSonArray)container).add(newContainer);
                        } else {
                            ((FlexiJSonArray)container).set(index, newContainer);
                        }
                    }
                }
                container = newContainer;
            }
            FlexiJSonNode value = new FlexiJSONParser(new StringReader(valueString)){

                @Override
                protected void throwParserException(ParsingError error, Object path, Throwable cause, FlexiJSonNode parent, FlexiJSonNode value) throws FlexiParserException {
                }
            }.parse();
            if (parts[parts.length - 1].startsWith("[")) {
                try {
                    int index = Integer.parseInt(parts[parts.length - 1].substring(1, parts[parts.length - 1].length() - 1));
                    while (((FlexiJSonArray)container).size() < index) {
                        ((FlexiJSonArray)container).add(new FlexiJSonValue());
                    }
                    if (((FlexiJSonArray)container).size() == index) {
                        ((FlexiJSonArray)container).add(value);
                        break block24;
                    }
                    ((FlexiJSonArray)container).set(index, value);
                }
                catch (NumberFormatException ex) {
                    ((FlexiJSonObject)container).add(new KeyValueElement((FlexiJSonObject)container, parts[parts.length - 1], value));
                }
            } else {
                ((FlexiJSonObject)container).add(new KeyValueElement((FlexiJSonObject)container, parts[parts.length - 1], value));
            }
        }
        return root;
    }
}

