/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.storage.flexijson;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Proxy;
import java.util.HashSet;
import java.util.LinkedList;
import org.appwork.exceptions.WTFException;
import org.appwork.storage.SimpleTypeRef;
import org.appwork.storage.TypeRef;
import org.appwork.storage.flexijson.FlexiCommentJsonNode;
import org.appwork.storage.flexijson.FlexiJSONParser;
import org.appwork.storage.flexijson.FlexiJSonArray;
import org.appwork.storage.flexijson.FlexiJSonComments;
import org.appwork.storage.flexijson.FlexiJSonNode;
import org.appwork.storage.flexijson.FlexiJSonObject;
import org.appwork.storage.flexijson.FlexiJSonValue;
import org.appwork.storage.flexijson.FlexiJsonMapperForConfig;
import org.appwork.storage.flexijson.FlexiParserException;
import org.appwork.storage.flexijson.FlexiValueFilter;
import org.appwork.storage.flexijson.FlexiVisitor;
import org.appwork.storage.flexijson.JSPath;
import org.appwork.storage.flexijson.KeyValueElement;
import org.appwork.storage.flexijson.NodeFilter;
import org.appwork.storage.flexijson.ParsingError;
import org.appwork.storage.flexijson.mapper.FlexiJSonMapper;
import org.appwork.storage.flexijson.mapper.FlexiMapperException;
import org.appwork.storage.flexijson.mapper.interfacestorage.InterfaceStorage;
import org.appwork.storage.flexijson.mapper.mod.FlexiModifier;
import org.appwork.storage.flexijson.mapper.mod.JsonModification;
import org.appwork.storage.flexijson.mapper.mod.MergeException;
import org.appwork.storage.flexijson.stringify.FlexiJSonPrettyPrinterForConfig;
import org.appwork.storage.flexijson.stringify.FlexiJSonPrettyStringify;
import org.appwork.storage.flexijson.stringify.FlexiJSonStringBuilder;
import org.appwork.storage.flexijson.stringify.PropertyJSonPrettyStringify;
import org.appwork.utils.IO;
import org.appwork.utils.ReflectionUtils;
import org.appwork.utils.StringUtils;
import org.appwork.utils.reflection.Clazz;
import org.appwork.utils.reflection.CompiledType;

public class FlexiUtils {
    public static <T> T jsonToObject(String json, TypeRef<T> type) throws FlexiParserException, FlexiMapperException {
        return FlexiUtils.jsonToObject(json, FlexiJSONParser.IGNORE_LIST_ENSURE_CORRECT_VALUES, type);
    }

    public static <T> T jsonToObject(String json, HashSet<ParsingError> acceptableErrors, TypeRef<T> type) throws FlexiParserException, FlexiMapperException {
        FlexiJSONParser parser = new FlexiJSONParser(json);
        parser.setIgnoreIssues(acceptableErrors);
        return new FlexiJSonMapper().jsonToObject(parser.parse(), type);
    }

    public static <T> T jsonToObject(File resource, HashSet<ParsingError> ignoreListEnsureCorrectValues, Class<T> class1) throws FlexiParserException, FlexiMapperException, IOException {
        return FlexiUtils.jsonToObject(resource, ignoreListEnsureCorrectValues, new SimpleTypeRef(class1));
    }

    public static <T> T jsonToObject(File resource, HashSet<ParsingError> ignoreListEnsureCorrectValues, TypeRef<T> type) throws FlexiParserException, FlexiMapperException, IOException {
        if (!resource.isFile()) {
            return null;
        }
        return new FlexiJSonMapper().jsonToObject(new FlexiJSONParser(IO.readFileToString(resource)).ignoreIssues(ignoreListEnsureCorrectValues).parse(), type);
    }

    public static String serializeToPrettyJson(Object object) throws FlexiMapperException {
        FlexiJSonPrettyStringify toString = new FlexiJSonPrettyStringify();
        if (object instanceof FlexiJSonNode) {
            return toString.toJSONString((FlexiJSonNode)object);
        }
        FlexiJSonMapper mapper = new FlexiJSonMapper();
        mapper.setIgnoreDefaultValuesEnabled(false);
        FlexiJSonNode node = mapper.objectToJsonNode(object);
        String newJson = toString.toJSONString(node);
        return newJson;
    }

    public static String serializeConfigStorable(Object object) throws FlexiMapperException {
        return FlexiUtils.serializeConfigStorable(object, null);
    }

    public static String serializeConfigStorable(Object object, NodeFilter filter) throws FlexiMapperException {
        FlexiJSonPrettyPrinterForConfig toString = new FlexiJSonPrettyPrinterForConfig(filter);
        FlexiJsonMapperForConfig mapper = new FlexiJsonMapperForConfig();
        FlexiJSonNode node = mapper.objectToJsonNode(object);
        String newJson = toString.toJSONString(node);
        return newJson;
    }

    public static byte[] serializePrettyToBytes(Object data) throws FlexiMapperException {
        if (data instanceof FlexiJSonNode) {
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            new FlexiJSonPrettyStringify().toJSONString((FlexiJSonNode)data, bout, null);
            return bout.toByteArray();
        }
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        new FlexiJSonPrettyStringify().toJSONString(new FlexiJSonMapper().objectToJsonNode(data), bout, null);
        return bout.toByteArray();
    }

    public static String getPathString(FlexiJSonNode json) {
        return JSPath.fromFlexiNode(json).toPathString(true);
    }

    public static FlexiJSonNode copyOf(FlexiJSonNode node) throws FlexiParserException {
        return new FlexiJSONParser(new FlexiJSonStringBuilder().toJSONString(node)).parse();
    }

    public static String serializeMinimized(Object instance) throws FlexiMapperException {
        FlexiJSonStringBuilder toString = new FlexiJSonStringBuilder();
        if (instance instanceof FlexiJSonNode) {
            return toString.toJSONString((FlexiJSonNode)instance);
        }
        FlexiJSonMapper mapper = new FlexiJSonMapper();
        mapper.setIgnoreDefaultValuesEnabled(false);
        FlexiJSonNode node = mapper.objectToJsonNode(instance);
        String newJson = toString.toJSONString(node);
        return newJson;
    }

    public static Object jsonToObject(String json, CompiledType t) throws FlexiParserException, FlexiMapperException {
        return FlexiUtils.jsonToObject(json, FlexiJSONParser.IGNORE_LIST_ENSURE_CORRECT_VALUES, t);
    }

    private static Object jsonToObject(String json, HashSet<ParsingError> acceptableErrors, CompiledType t) throws FlexiParserException, FlexiMapperException {
        FlexiJSONParser parser = new FlexiJSONParser(json);
        parser.setIgnoreIssues(acceptableErrors);
        return new FlexiJSonMapper().jsonToObject(parser.parse(), t);
    }

    public static FlexiJSonNode getRoot(FlexiJSonNode target) {
        FlexiJSonNode pa = target.getParent();
        while (pa != null) {
            target = pa;
            pa = target.getParent();
        }
        return target;
    }

    public static String prettyPrint(String json) throws FlexiParserException, FlexiMapperException {
        return FlexiUtils.serializeToPrettyJson(FlexiUtils.jsonToObject(json, CompiledType.OBJECT));
    }

    public static Object getValue(String json, JSPath path) throws FlexiParserException {
        return FlexiUtils.getValueNE(new FlexiJSONParser(json).parse(), path, Object.class);
    }

    public static <T> T getValue(String json, JSPath path, Class<T> type) throws FlexiParserException {
        return FlexiUtils.getValueNE(new FlexiJSONParser(json).parse(), path, type);
    }

    public static String serializeToProperties(Object obj, String deliminator) {
        try {
            String ret = new PropertyJSonPrettyStringify().toJSONString(new FlexiJSonMapper().objectToJsonNode(obj));
            if (StringUtils.isNotEmpty(deliminator)) {
                ret = ret.replace("\r\n", deliminator);
            }
            return ret;
        }
        catch (FlexiMapperException e) {
            throw new WTFException(e);
        }
    }

    public static <T> T getValueNE(FlexiJSonNode node, JSPath path, Class<T> type) {
        return FlexiUtils.getValueNE(node, path, new SimpleTypeRef(type));
    }

    public static <T> T getValueNE(FlexiJSonNode node, JSPath path, TypeRef<T> type) {
        try {
            return FlexiUtils.getValue(node, path, type);
        }
        catch (FlexiMapperException e) {
            throw new WTFException(e);
        }
    }

    public static <T> T getValue(FlexiJSonNode node, JSPath path, TypeRef<T> type) throws FlexiMapperException {
        if (path == null || path.isEmpty()) {
            return new FlexiJSonMapper().jsonToObject(node, type);
        }
        if (node instanceof FlexiJSonObject) {
            FlexiJSonNode element = ((FlexiJSonObject)node).resolvePath(path);
            if (element == null) {
                return (T)ReflectionUtils.cast(null, type.getType());
            }
            if (CompiledType.create(type).isInstanceOf(element.getClass())) {
                return (T)element;
            }
            return new FlexiJSonMapper().jsonToObject(element, type);
        }
        if (node instanceof FlexiJSonArray) {
            FlexiJSonNode element = ((FlexiJSonArray)node).resolvePath(path);
            if (element == null) {
                return (T)ReflectionUtils.cast(null, type.getType());
            }
            if (CompiledType.create(type).isInstanceOf(element.getClass())) {
                return (T)element;
            }
            return new FlexiJSonMapper().jsonToObject(element, type);
        }
        return null;
    }

    public static String serializeToPrettyJsonWithWTF(Object o) {
        try {
            return FlexiUtils.serializeToPrettyJson(o);
        }
        catch (FlexiMapperException e) {
            throw new WTFException(e);
        }
    }

    public static <T extends FlexiJSonNode> T objectToNodeWithWTF(Object object, Class<T> class1) {
        try {
            return (T)new FlexiJSonMapper().objectToJsonNode(object);
        }
        catch (FlexiMapperException e) {
            throw new WTFException(e);
        }
    }

    public static <T> T nodeToObjectWithWTF(FlexiJSonNode node, TypeRef<T> typRef) {
        try {
            return new FlexiJSonMapper().jsonToObject(node, typRef);
        }
        catch (FlexiMapperException e) {
            throw new WTFException(e);
        }
    }

    public static String serializeMinimizedWithWTF(Object obj) {
        try {
            return FlexiUtils.serializeMinimized(obj);
        }
        catch (FlexiMapperException e) {
            throw new WTFException(e);
        }
    }

    public static <T extends FlexiJSonNode> T filterValues(T node, final FlexiValueFilter filter) {
        FlexiUtils.walk(node, new FlexiVisitor(){

            @Override
            public void onComment(FlexiCommentJsonNode comment, JSPath path) {
                if (!filter.keepComment(comment) && !comment.getParent().remove(comment)) {
                    throw new IllegalStateException();
                }
            }

            @Override
            public void onValue(FlexiJSonValue value, JSPath path) {
                if (!filter.keepValue(value) && !value.getParent().remove(value)) {
                    throw new IllegalStateException();
                }
            }

            @Override
            public void openObject(FlexiJSonObject obj, JSPath path) {
                if (!filter.keepObject(obj) && !obj.getParent().remove(obj)) {
                    throw new IllegalStateException();
                }
            }

            @Override
            public void closeObject(FlexiJSonObject obj, JSPath path) {
            }

            @Override
            public void openArray(FlexiJSonArray array, JSPath path) {
                if (!filter.keepArray(array) && !array.getParent().remove(array)) {
                    throw new IllegalStateException();
                }
            }

            @Override
            public void closeArray(FlexiJSonArray array, JSPath path) {
            }
        });
        return node;
    }

    private static void walk(FlexiJSonNode node, FlexiVisitor flexiVisitor, JSPath path) {
        if (node == null) {
            return;
        }
        if (node instanceof FlexiJSonObject) {
            FlexiJSonObject obj = (FlexiJSonObject)node;
            flexiVisitor.openObject(obj, path);
            int comments = FlexiUtils.walkComments(obj.getCommentsBefore(), 0, flexiVisitor, path);
            comments = FlexiUtils.walkComments(obj.getCommentsInside(), comments, flexiVisitor, path);
            for (KeyValueElement e : new LinkedList<KeyValueElement>(obj.getElements())) {
                JSPath newPath = path.derive(e.getKey());
                FlexiUtils.walk(e.getCommentsBeforeKey(), flexiVisitor, newPath);
                FlexiUtils.walk(e.getValue(), flexiVisitor, newPath);
                FlexiUtils.walk(e.getCommentsAfterKey(), flexiVisitor, newPath);
            }
            comments = FlexiUtils.walkComments(obj.getCommentsAfter(), comments, flexiVisitor, path);
            flexiVisitor.closeObject(obj, path);
        } else if (node instanceof FlexiJSonArray) {
            FlexiJSonArray array = (FlexiJSonArray)node;
            flexiVisitor.openArray(array, path);
            int comments = FlexiUtils.walkComments(array.getCommentsBefore(), 0, flexiVisitor, path);
            comments = FlexiUtils.walkComments(array.getCommentsInside(), comments, flexiVisitor, path);
            int i = 0;
            for (FlexiJSonNode e : new LinkedList<FlexiJSonNode>(array)) {
                FlexiUtils.walk(e, flexiVisitor, path.derive(i++));
            }
            comments = FlexiUtils.walkComments(array.getCommentsAfter(), comments, flexiVisitor, path);
            flexiVisitor.closeArray(array, path);
        } else if (node instanceof FlexiJSonComments) {
            FlexiUtils.walkComments((FlexiJSonComments)node, 0, flexiVisitor, path);
        } else if (node instanceof FlexiCommentJsonNode) {
            flexiVisitor.onComment((FlexiCommentJsonNode)node, path);
        } else {
            FlexiJSonValue value = (FlexiJSonValue)node;
            int comments = FlexiUtils.walkComments(value.getCommentsBefore(), 0, flexiVisitor, path);
            flexiVisitor.onValue(value, path);
            comments = FlexiUtils.walkComments(value.getCommentsAfter(), comments, flexiVisitor, path);
        }
    }

    private static int walkComments(FlexiJSonComments comments, int i, FlexiVisitor flexiVisitor, JSPath path) {
        if (comments == null || comments.size() == 0) {
            return i;
        }
        for (FlexiCommentJsonNode c : new LinkedList<FlexiCommentJsonNode>(comments)) {
            FlexiUtils.walk(c, flexiVisitor, path.derive("//#" + i));
            ++i;
        }
        return i;
    }

    public static void walk(FlexiJSonNode node, FlexiVisitor flexiVisitor) {
        FlexiUtils.walk(node, flexiVisitor, new JSPath());
    }

    public static <T> T getValueNE(FlexiJSonObject node, String path, Class<T> class1) {
        return FlexiUtils.getValueNE((FlexiJSonNode)node, JSPath.getNE(path), class1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T readObject(File f, TypeRef<T> type) throws FlexiParserException, FlexiMapperException, IOException {
        IO.BOM.BOMInputStream is = IO.BOM.wrap(new BufferedInputStream(new FileInputStream(f)));
        try {
            T t = FlexiUtils.readObject(is, type);
            return t;
        }
        finally {
            try {
                ((InputStream)is).close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static <T> T readObject(InputStream is, TypeRef<T> type) throws FlexiParserException, FlexiMapperException {
        FlexiJSonNode node = new FlexiJSONParser(is).setDebug(new StringBuilder()).parse();
        if (type.getType() instanceof Class && Clazz.isInstanceof(node.getClass(), (Class)type.getType())) {
            return (T)node;
        }
        return new FlexiJSonMapper().jsonToObject(node, type);
    }

    public static <T> T readObject(File f, Class<T> type) throws FlexiParserException, FlexiMapperException, IOException {
        return FlexiUtils.readObject(f, new SimpleTypeRef(type));
    }

    public static <T> T readObjectNE(File f, Class<T> c) {
        try {
            return FlexiUtils.readObject(f, c);
        }
        catch (FlexiParserException e) {
            throw new WTFException(e);
        }
        catch (FlexiMapperException e) {
            throw new WTFException(e);
        }
        catch (IOException e) {
            throw new WTFException(e);
        }
    }

    public static <T> T readObjectNE(File file, TypeRef<T> type) {
        try {
            return FlexiUtils.readObject(file, type);
        }
        catch (FlexiParserException e) {
            throw new WTFException(e);
        }
        catch (FlexiMapperException e) {
            throw new WTFException(e);
        }
        catch (IOException e) {
            throw new WTFException(e);
        }
    }

    public static <T> T clone(T input) throws FlexiMapperException, FlexiParserException {
        InterfaceStorage<T> uis;
        FlexiJSonMapper mapper = new FlexiJSonMapper();
        if (input instanceof FlexiJSonNode) {
            return (T)new FlexiJSONParser(FlexiUtils.serializeMinimized(input)).parse();
        }
        FlexiJSonNode node = mapper.objectToJsonNode(input);
        if (Proxy.isProxyClass(input.getClass()) && (uis = InterfaceStorage.get(input)) != null) {
            return (T)mapper.jsonToObject(node, uis.cType);
        }
        return (T)mapper.jsonToObject(node, CompiledType.create(input.getClass()));
    }

    public static <T> T cloneNE(T input) throws WTFException {
        try {
            return FlexiUtils.clone(input);
        }
        catch (FlexiMapperException e) {
            throw new WTFException(e);
        }
        catch (FlexiParserException e) {
            throw new WTFException(e);
        }
    }

    public static FlexiJSonObject overwrite(File file, FlexiJSonObject add) throws FlexiParserException, FlexiMapperException, IOException, MergeException {
        try {
            if (file.isFile()) {
                FlexiJSonObject node = FlexiUtils.readObject(file, FlexiJSonObject.class);
                JsonModification mod = new JsonModification();
                mod.setSet(add);
                new FlexiModifier(node).merge(mod);
                IO.secureWrite(file, FlexiUtils.serializeToPrettyJson(node), IO.SYNC.META_AND_DATA);
                return node;
            }
            IO.secureWrite(file, FlexiUtils.serializeToPrettyJson(add), IO.SYNC.META_AND_DATA);
            return add;
        }
        catch (IOException e) {
            e.printStackTrace();
            throw e;
        }
    }
}

