/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.storage.flexijson.tests;

import java.io.File;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.nio.CharBuffer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.appwork.exceptions.WTFException;
import org.appwork.loggingv3.LogV3;
import org.appwork.storage.JSonStorage;
import org.appwork.storage.flexijson.FlexiJSONParser;
import org.appwork.storage.flexijson.FlexiJSonNode;
import org.appwork.storage.flexijson.FlexiJSonObject;
import org.appwork.storage.flexijson.FlexiJSonValue;
import org.appwork.storage.flexijson.FlexiParserException;
import org.appwork.storage.flexijson.FlexiUtils;
import org.appwork.storage.flexijson.KeyValueElement;
import org.appwork.storage.flexijson.ParsingError;
import org.appwork.storage.flexijson.parserextension.TimeSpanParserExtension;
import org.appwork.storage.flexijson.stringify.FlexiJSonPrettyStringify;
import org.appwork.storage.flexijson.stringify.FlexiJSonStringBuilder;
import org.appwork.storage.flexijson.stringify.PropertyJSonPrettyStringify;
import org.appwork.storage.flexijson.tests.CharSequenceReader;
import org.appwork.storage.simplejson.mapper.test.TestClass;
import org.appwork.testframework.AWTest;
import org.appwork.testframework.IDETestRunner;

public class ParserTest
extends AWTest {
    private static final ParsingError SVWQ = ParsingError.ERROR_STRING_VALUE_WITHOUT_QUOTES;
    private static final ParsingError STWQ = ParsingError.ERROR_STRING_TOKEN_WITHOUT_QUOTES;
    private static final ParsingError KWQ = ParsingError.ERROR_KEY_WITHOUT_QUOTES;
    private static final ParsingError STWSQ = ParsingError.ERROR_STRING_TOKEN_WITH_SINGLE_QUOTES;

    @Override
    public void runTest() throws Exception {
        LogV3.info("Run parsing, serializer and pretty printer Tests");
        FlexiJSONParser parser = new FlexiJSONParser("1W2D3h4m5s");
        parser.addExtension(new TimeSpanParserExtension());
        ParserTest.assertThat(((FlexiJSonValue)parser.parse()).getValue()).is("1W2D3h4m5s");
        ParserTest.expectError(" /* comment start */ {/*leading*/,start:true,/* my comment */\r\n// my single line comment\r\nend:true,/*end*/} /* comment end*/", "/*comment start*/{/*leading*/,\"start\":true,/*my comment*///my single line comment\r\n\"end\":true,/*end*/}/*comment end*/", "/* comment start */\r\n{\r\n  /* leading */,\r\n  \"start\":true,\r\n  /* my comment */// my single line comment\r\n  \"end\":true,\r\n  /* end */\r\n}\r\n/* comment end */", ParsingError.ERROR_TRAILING_COMMA_IN_OBJECT, ParsingError.ERROR_LEADING_COMMA_IN_OBJECT, KWQ, STWQ, ParsingError.ERROR_LINE_COMMENT, ParsingError.ERROR_INLINE_COMMENT);
        ParserTest.expectError("{},[],{/*comment*/},{/*comment\r\nnewline*/}  ", "[{},[],{/*comment*/},{/*comment\r\nnewline*/}]", "[\r\n  {},\r\n  [],\r\n  {\r\n    /* comment */\r\n  },\r\n  {\r\n    /*\r\n     * comment\r\n     * newline\r\n     */\r\n  }\r\n]", ParsingError.ERROR_MULTIPLE_ELEMENTS_IN_JSON_STRING, ParsingError.ERROR_UNEXPECTED_CONTENT_AFTER_END_OF_JSON, ParsingError.ERROR_INLINE_COMMENT);
        ParserTest.expectError("{a:b,}", "{\"a\":\"b\",}", "{\"a\":\"b\",}", ParsingError.ERROR_TRAILING_COMMA_IN_OBJECT, KWQ, SVWQ, STWQ);
        ParserTest.expectError("{a:b ,  ,  }", "{\"a\":\"b\",,}", "{\"a\":\"b\",,}", ParsingError.ERROR_MULTIPLE_SUBSEQUENT_COMMAS_IN_OBJECT, ParsingError.ERROR_MULTIPLE_TRAILING_COMMA_IN_OBJECT, ParsingError.ERROR_TRAILING_COMMA_IN_OBJECT, KWQ, SVWQ, STWQ);
        ParserTest.assertThat(((FlexiJSonObject)new FlexiJSONParser("{}").parse()).getElements().size()).is(0);
        FlexiJSonObject obj = (FlexiJSonObject)new FlexiJSONParser("{/*testcomment*/\"key\":true}").enableComments().parse();
        ParserTest.assertThat(FlexiUtils.serializeMinimized(obj)).is("{/*testcomment*/\"key\":true}");
        obj = (FlexiJSonObject)new FlexiJSONParser("{/*testcomment*/}").enableComments().parse();
        obj.add(new KeyValueElement(obj, "key", new FlexiJSonValue(true)));
        ParserTest.assertThat(FlexiUtils.serializeMinimized(obj)).is("{/*testcomment*/\"key\":true}");
        ParserTest.expectError("\"^\\\\.\\\\%\\\\S+$\"", "\"^\\\\.\\\\%\\\\S+$\"", "\"^\\\\.\\\\%\\\\S+$\"", new ParsingError[0]);
        ParserTest.expectError("\"\"", "\"\"", "\"\"", new ParsingError[0]);
        ParserTest.expectError("{key}", "{\"key\":undefined}", "{\"key\":undefined}", ParsingError.EXPECTED_COLON, ParsingError.ERROR_STRING_TOKEN_WITHOUT_QUOTES, ParsingError.ERROR_VALUE_INSTEAD_OF_UNDEFINED_EXPECTED, ParsingError.ERROR_KEY_WITHOUT_QUOTES);
        ParserTest.expectError("{key\\}:0}", "{\"key}\":0}", "{\"key}\":0}", ParsingError.ERROR_STRING_TOKEN_WITHOUT_QUOTES, ParsingError.ERROR_KEY_WITHOUT_QUOTES);
        ParserTest.expectError("{\"key\"}", "{\"key\":undefined}", "{\"key\":undefined}", ParsingError.EXPECTED_COLON, ParsingError.ERROR_VALUE_INSTEAD_OF_UNDEFINED_EXPECTED);
        ParserTest.expectError("{key:}", "{\"key\":undefined}", "{\"key\":undefined}", ParsingError.ERROR_STRING_TOKEN_WITHOUT_QUOTES, ParsingError.ERROR_VALUE_INSTEAD_OF_UNDEFINED_EXPECTED, ParsingError.ERROR_KEY_WITHOUT_QUOTES);
        ParserTest.expectError("{[]}", "{\"[]\":undefined}", "{\"[]\":undefined}", ParsingError.ERROR_STRING_TOKEN_WITHOUT_QUOTES, ParsingError.EXPECTED_COLON, ParsingError.ERROR_VALUE_INSTEAD_OF_UNDEFINED_EXPECTED, ParsingError.ERROR_KEY_WITHOUT_QUOTES);
        ParserTest.expectError("'MeinText", "\"MeinText\"", "\"MeinText\"", ParsingError.ERROR_STRING_TOKEN_WITH_SINGLE_QUOTES, ParsingError.EXPECTED_STRING_OR_SINGLE_QUOTE, ParsingError.ERROR_STRING_VALUE_WITH_SINGLE_QUOTES);
        ParserTest.expectError("\"MeinText", "\"MeinText\"", "\"MeinText\"", ParsingError.EXPECTED_STRING_OR_DOUBLE_QUOTE);
        ParserTest.expectError("\"MeinText\"", "\"MeinText\"", "\"MeinText\"", new ParsingError[0]);
        ParserTest.expectError("\"'MeinText'\"", "\"'MeinText'\"", "\"'MeinText'\"", new ParsingError[0]);
        ParserTest.expectError("'\"MeinText\"'", "\"\\\"MeinText\\\"\"", "\"\\\"MeinText\\\"\"", ParsingError.ERROR_STRING_TOKEN_WITH_SINGLE_QUOTES, ParsingError.ERROR_STRING_VALUE_WITH_SINGLE_QUOTES);
        ParserTest.expectError("'MeinText'", "\"MeinText\"", "\"MeinText\"", ParsingError.ERROR_STRING_TOKEN_WITH_SINGLE_QUOTES, ParsingError.ERROR_STRING_VALUE_WITH_SINGLE_QUOTES);
        ParserTest.expectError("\"\\\\'\"", "\"\\\\'\"", "\"\\\\'\"", new ParsingError[0]);
        ParserTest.expectError("'\\\\\\'", "\"\\\\'\"", "\"\\\\'\"", ParsingError.ERROR_STRING_TOKEN_WITH_SINGLE_QUOTES, ParsingError.EXPECTED_STRING_OR_SINGLE_QUOTE, ParsingError.ERROR_STRING_VALUE_WITH_SINGLE_QUOTES);
        ParserTest.expectError("\\\"ab\\\"c\\\"", "\"\\\"ab\\\"c\\\"\"", "\"\\\"ab\\\"c\\\"\"", ParsingError.ERROR_STRING_TOKEN_WITHOUT_QUOTES, ParsingError.ERROR_STRING_VALUE_WITHOUT_QUOTES);
        ParserTest.expectError("\\\"ab\"c\\\"", "\"\\\"ab\\\"c\\\"\"", "\"\\\"ab\\\"c\\\"\"", ParsingError.ERROR_STRING_TOKEN_WITHOUT_QUOTES, ParsingError.ERROR_STRING_VALUE_WITHOUT_QUOTES);
        ParserTest.expectError("\"ab\\\"c\"", "\"ab\\\"c\"", "\"ab\\\"c\"", new ParsingError[0]);
        ParserTest.expectError("'\\'", "\"'\"", "\"'\"", ParsingError.ERROR_STRING_TOKEN_WITH_SINGLE_QUOTES, ParsingError.EXPECTED_STRING_OR_SINGLE_QUOTE, ParsingError.ERROR_STRING_VALUE_WITH_SINGLE_QUOTES);
        ParserTest.expectError("\\\\\\", "\"\\\\\\\\\"", "\"\\\\\\\\\"", STWQ, SVWQ, ParsingError.EXPECTED_VALID_ESCAPE_CHARACTER);
        ParserTest.expectError("Z:\\meinpfad", "\"Z:\\\\meinpfad\"", "\"Z:\\\\meinpfad\"", SVWQ, STWQ, ParsingError.EXPECTED_VALID_ESCAPE_CHARACTER);
        ParserTest.expectError("{key\r\nunescaped newline: 0}", "{\"key\\r\\nunescaped newline\":0}", "{\"key\\r\\nunescaped newline\":0}", KWQ, STWQ);
        ParserTest.expectError("{,a:b,,,de\\:f2:\\\"abc\r\nwith new\rlines with escaped \\,\\}\\] etc,c:d,def:abc\r\nwith new\rlines}", "{,\"a\":\"b\",,,\"de:f2\":\"\\\"abc\\r\\nwith new\\rlines with escaped ,}] etc\",\"c\":\"d\",\"def\":\"abc\\r\\nwith new\\rlines\"}", "{\r\n  ,\r\n  \"a\":\"b\",,,\r\n  \"de:f2\":\"\\\"abc\\r\\nwith new\\rlines with escaped ,}] etc\",\r\n  \"c\":\"d\",\r\n  \"def\":\"abc\\r\\nwith new\\rlines\"\r\n}", SVWQ, STWQ, KWQ, ParsingError.ERROR_LEADING_COMMA_IN_OBJECT, ParsingError.ERROR_MULTIPLE_SUBSEQUENT_COMMAS_IN_OBJECT);
        ParserTest.expectError("{\"key with space\": 0}", "{\"key with space\":0}", "{\"key with space\":0}", new ParsingError[0]);
        ParserTest.expectError("{\"key\r\nunescaped newlineandquotes\": 0}", "{\"key\\r\\nunescaped newlineandquotes\":0}", "{\"key\\r\\nunescaped newlineandquotes\":0}", ParsingError.ERROR_NEWLINE_IN_TOKEN);
        ParserTest.expectError("{\"key\\r\\nunescaped newlineandquotes\": 0}", "{\"key\\r\\nunescaped newlineandquotes\":0}", "{\"key\\r\\nunescaped newlineandquotes\":0}", new ParsingError[0]);
        ParserTest.expectError("{\r\n\"dec\": 0\r\n\r\n\t\t\t}", "{\"dec\":0}", "{\"dec\":0}", new ParsingError[0]);
        ParserTest.expectError("{\r\n\"dec\": 01\r\n\r\n\t\t\t}", "{\"dec\":1}", "{\"dec\":1}", ParsingError.ERROR_NUMBERFORMAT_OCTAL);
        ParserTest.expectError("{\r\n\"dec\": 010\r\n\r\n\t\t\t}", "{\"dec\":8}", "{\"dec\":8}", ParsingError.ERROR_NUMBERFORMAT_OCTAL);
        ParserTest.expectError(" /* comment start */ [1,2,3] /* comment end*/", "/*comment start*/[1,2,3]/*comment end*/", "/* comment start */\r\n[\r\n  1,\r\n  2,\r\n  3\r\n]\r\n/* comment end */", ParsingError.ERROR_INLINE_COMMENT);
        ParserTest.expectError("{\"a\":1}/*com*/\u0000", "[{\"a\":1}/*com*/,\"\\u0000\"]", "[\r\n  {\"a\":1}\r\n  /* com */,\r\n  \"\\u0000\"\r\n]", ParsingError.ERROR_INLINE_COMMENT, ParsingError.ERROR_UNEXPECTED_CONTENT_AFTER_END_OF_JSON, ParsingError.ERROR_STRING_VALUE_WITHOUT_QUOTES, ParsingError.ERROR_STRING_TOKEN_WITHOUT_QUOTES, ParsingError.ERROR_MULTIPLE_ELEMENTS_IN_JSON_STRING);
        ParserTest.expectError("{\"a\":1}\u0000", "[{\"a\":1},\"\\u0000\"]", "[\r\n  {\"a\":1},\r\n  \"\\u0000\"\r\n]", ParsingError.ERROR_UNEXPECTED_CONTENT_AFTER_END_OF_JSON, ParsingError.ERROR_STRING_VALUE_WITHOUT_QUOTES, ParsingError.ERROR_STRING_TOKEN_WITHOUT_QUOTES, ParsingError.ERROR_MULTIPLE_ELEMENTS_IN_JSON_STRING);
        ParserTest.expectError("{,a:b,,c:d,def:abc\r\nwith new\rlines}", "{,\"a\":\"b\",,\"c\":\"d\",\"def\":\"abc\\r\\nwith new\\rlines\"}", "{\r\n  ,\r\n  \"a\":\"b\",,\r\n  \"c\":\"d\",\r\n  \"def\":\"abc\\r\\nwith new\\rlines\"\r\n}", SVWQ, STWQ, KWQ, ParsingError.ERROR_LEADING_COMMA_IN_OBJECT, ParsingError.ERROR_MULTIPLE_SUBSEQUENT_COMMAS_IN_OBJECT);
        ParserTest.expectError("\u7570\u9ad4\u5b57\u5b57", "\"\u7570\u9ad4\u5b57\u5b57\"", "\"\u7570\u9ad4\u5b57\u5b57\"", STWQ, SVWQ);
        ParserTest.expectError("\ud867\ude3d", "\"\ud867\ude3d\"", "\"\ud867\ude3d\"", STWQ, SVWQ);
        ParserTest.expectError("\ud867\ude3d and \u9ad4", "\"\ud867\ude3d and \u9ad4\"", "\"\ud867\ude3d and \u9ad4\"", STWQ, SVWQ);
        ParserTest.expectError("\\\\", "\"\\\\\"", "\"\\\\\"", STWQ, SVWQ);
        ParserTest.expectError("{\"test\"://huhu\r\ntrue}", "{\"test\"://huhu\r\ntrue}", "{\r\n  \"test\":// huhu\r\n  true\r\n}", ParsingError.ERROR_LINE_COMMENT);
        ParserTest.expectError("{\"test\"://\"huhu\"\r\ntrue}", "{\"test\"://\"huhu\"\r\ntrue}", "{\r\n  \"test\":// \"huhu\"\r\n  true\r\n}", ParsingError.ERROR_LINE_COMMENT);
        ParserTest.expectError("/*comment*\\/ start*/[]/*comment end*/", "/*comment*\\/ start*/[]/*comment end*/", "/* comment*\\/ start */\r\n[]\r\n/* comment end */", ParsingError.ERROR_INLINE_COMMENT);
        ParserTest.expectError("{\"defaultdownloadfolder\":\"C:\\\\Users\\\\thomas\\\\down\\rloads\"}", "{\"defaultdownloadfolder\":\"C:\\\\Users\\\\thomas\\\\down\\rloads\"}", "{\"defaultdownloadfolder\":\"C:\\\\Users\\\\thomas\\\\down\\rloads\"}", new ParsingError[0]);
        ParserTest.expectError("[1,2,\"23\",4,5,[true,false]]", "[1,2,\"23\",4,5,[true,false]]", "[\r\n  1,\r\n  2,\r\n  \"23\",\r\n  4,\r\n  5,\r\n  [true, false]\r\n]", new ParsingError[0]);
        ParserTest.expectError("{[1]:[2]}", "{\"[1]\":[2]}", "{\r\n  \"[1]\":[2]\r\n}", STWQ, KWQ);
        ParserTest.expectError("{  }", "{}", "{}", new ParsingError[0]);
        ParserTest.expectError("[\r\n {\r\n  \"map\"              : {\r\n                        \"2\" : {\r\n                               \"map\"              : {},\r\n                               \"string\"           : \"affe232\",\r\n                               \"genericClass\"     : {\r\n                                                     \"key\"   : \"mykey\",\r\n                                                     \"value\" : \"myValue\"\r", "[{\"map\":{\"2\":{\"map\":{},\"string\":\"affe232\",\"genericClass\":{\"key\":\"mykey\",\"value\":\"myValue\"}}}}]", "[{\r\n  \"map\":{\r\n    \"2\":{\r\n      \"map\":{},\r\n      \"string\":\"affe232\",\r\n      \"genericClass\":{\r\n        \"key\":\"mykey\",\r\n        \"value\":\"myValue\"\r\n      }\r\n    }\r\n  }\r\n}]", ParsingError.EXPECTED_COMMA_OR_OBJECT_END_TAG, ParsingError.EXPECTED_COMMA_OR_ARRAY_END_TAG);
        ParserTest.expectError("[/*first*/1,/*second*/2]", "[/*first*/1,/*second*/2]", "[/* first */1, /* second */2]", ParsingError.ERROR_INLINE_COMMENT);
        ParserTest.expectError(" /* comment start */ [/*inside*/ ,,] /* comment end*/", "/*comment start*/[/*inside*/undefined,undefined]/*comment end*/", "/* comment start */\r\n[\r\n  /* inside */\r\n  undefined,\r\n  undefined\r\n]\r\n/* comment end */", ParsingError.ERROR_MULTIPLE_LEADING_COMMA_IN_ARRAY, ParsingError.ERROR_LEADING_COMMA_IN_ARRAY, ParsingError.ERROR_TRAILING_COMMA_IN_ARRAY, ParsingError.ERROR_MULTIPLE_TRAILING_COMMA_IN_ARRAY, ParsingError.ERROR_INLINE_COMMENT, ParsingError.ERROR_MULTIPLE_SUBSEQUENT_COMMAS_IN_ARRAY);
        ParserTest.expectError(" {  a/*comment*/:b,c:d}", "{\"a\"/*comment*/:\"b\",\"c\":\"d\"}", "{\r\n  \"a\"/* comment */:\"b\",\r\n  \"c\":\"d\"\r\n}", ParsingError.ERROR_INLINE_COMMENT, SVWQ, STWQ, KWQ);
        ParserTest.expectError("  //comment ", "undefined//comment", "undefined// comment", ParsingError.ERROR_LINE_COMMENT, ParsingError.ERROR_NO_CONTENT);
        ParserTest.expectError(" {b:{a:/* comment start\r\n with newline */ [] /* comment end*/}}", "{\"b\":{\"a\":/*comment start\r\nwith newline*/[]/*comment end*/}}", "{\r\n  \"b\":{\r\n    \"a\":\r\n    /*\r\n     * comment start\r\n     * with newline\r\n     */\r\n    []\r\n    /* comment end */\r\n  }\r\n}", ParsingError.ERROR_INLINE_COMMENT, ParsingError.ERROR_STRING_TOKEN_WITHOUT_QUOTES, ParsingError.ERROR_KEY_WITHOUT_QUOTES);
        ParserTest.expectError("///* i1 /*\r\n1", "///* i1 /*\r\n1", "// /* i1 /*\r\n1", ParsingError.ERROR_LINE_COMMENT);
        ParserTest.expectError(" /* comment start */ [/*1*/ ,,/*2*/] /* comment end*/", "/*comment start*/[/*1*/undefined,undefined,/*2*/]/*comment end*/", "/* comment start */\r\n[\r\n  /* 1 */\r\n  undefined,\r\n  undefined, \r\n  /* 2 */\r\n]\r\n/* comment end */", ParsingError.ERROR_MULTIPLE_TRAILING_COMMA_IN_ARRAY, ParsingError.ERROR_TRAILING_COMMA_IN_ARRAY, ParsingError.ERROR_MULTIPLE_SUBSEQUENT_COMMAS_IN_ARRAY, ParsingError.ERROR_LEADING_COMMA_IN_ARRAY, ParsingError.ERROR_MULTIPLE_LEADING_COMMA_IN_ARRAY, ParsingError.ERROR_INLINE_COMMENT);
        ParserTest.expectError("{,,}", "{,,}", "{\r\n  ,,\r\n}", ParsingError.ERROR_LEADING_COMMA_IN_OBJECT, ParsingError.ERROR_MULTIPLE_LEADING_COMMA_IN_OBJECT, ParsingError.ERROR_MULTIPLE_SUBSEQUENT_COMMAS_IN_OBJECT, ParsingError.ERROR_MULTIPLE_TRAILING_COMMA_IN_OBJECT, ParsingError.ERROR_TRAILING_COMMA_IN_OBJECT);
        ParserTest.expectError("'Unicode pattern testblabla\\u1", "\"Unicode pattern testblabla\\u0001\"", "\"Unicode pattern testblabla\\u0001\"", ParsingError.EXPECTED_UNICODE_SEQUENCE, ParsingError.ERROR_STRING_VALUE_WITH_SINGLE_QUOTES, ParsingError.ERROR_STRING_TOKEN_WITH_SINGLE_QUOTES, ParsingError.EXPECTED_STRING_OR_SINGLE_QUOTE, ParsingError.ERROR_STRING_TOKEN_WITH_SINGLE_QUOTES);
        ParserTest.expectError("{_a:{\"_\\\"b2\":{_c:{_d342:{\"test\":},s:1,loooooong:2}}}}", "{\"_a\":{\"_\\\"b2\":{\"_c\":{\"_d342\":{\"test\":undefined},\"s\":1,\"loooooong\":2}}}}", "{\r\n  \"_a\":{\r\n    \"_\\\"b2\":{\r\n      \"_c\":{\r\n        \"_d342\":{\"test\":undefined},\r\n        \"s\":1,\r\n        \"loooooong\":2\r\n      }\r\n    }\r\n  }\r\n}", STWQ, KWQ, ParsingError.ERROR_VALUE_INSTEAD_OF_UNDEFINED_EXPECTED);
        ParserTest.expectError(" {b:{a:/* comment start\r\n with newline */ [1,'Array with a long string that exeeds the 40 chars limit for compact mode',3,'second long string with \r\n newline'] /* comment end*/}}", "{\"b\":{\"a\":/*comment start\r\nwith newline*/[1,\"Array with a long string that exeeds the 40 chars limit for compact mode\",3,\"second long string with \\r\\n newline\"]/*comment end*/}}", "{\r\n  \"b\":{\r\n    \"a\":\r\n    /*\r\n     * comment start\r\n     * with newline\r\n     */\r\n    [\r\n      1,\r\n      \"Array with a long string that exeeds the 40 chars limit for compact mode\",\r\n      3,\r\n      \"second long string with \\r\\n newline\"\r\n    ]\r\n    /* comment end */\r\n  }\r\n}", ParsingError.ERROR_STRING_VALUE_WITH_SINGLE_QUOTES, ParsingError.ERROR_STRING_TOKEN_WITHOUT_QUOTES, ParsingError.ERROR_KEY_WITHOUT_QUOTES, ParsingError.ERROR_INLINE_COMMENT, ParsingError.ERROR_STRING_TOKEN_WITH_SINGLE_QUOTES, ParsingError.ERROR_NEWLINE_IN_TOKEN);
        ParserTest.expectError(" {b:{a:/* comment start\r\n with newline\r\nArraywith object */ [1,{a:b,c:[true,false]},3] /* comment end*/}}", "{\"b\":{\"a\":/*comment start\r\nwith newline\r\nArraywith object*/[1,{\"a\":\"b\",\"c\":[true,false]},3]/*comment end*/}}", "{\r\n  \"b\":{\r\n    \"a\":\r\n    /*\r\n     * comment start\r\n     * with newline\r\n     * Arraywith object\r\n     */\r\n    [\r\n      1,\r\n      {\r\n        \"a\":\"b\",\r\n        \"c\":[true, false]\r\n      },\r\n      3\r\n    ]\r\n    /* comment end */\r\n  }\r\n}", ParsingError.ERROR_INLINE_COMMENT, ParsingError.ERROR_STRING_TOKEN_WITHOUT_QUOTES, ParsingError.ERROR_KEY_WITHOUT_QUOTES, ParsingError.ERROR_STRING_VALUE_WITHOUT_QUOTES);
        ParserTest.expectError(" {b:{a:/* comment start\r\n with newline */ [1,2,3] /* comment end*/}}", "{\"b\":{\"a\":/*comment start\r\nwith newline*/[1,2,3]/*comment end*/}}", "{\r\n  \"b\":{\r\n    \"a\":\r\n    /*\r\n     * comment start\r\n     * with newline\r\n     */\r\n    [\r\n      1,\r\n      2,\r\n      3\r\n    ]\r\n    /* comment end */\r\n  }\r\n}", ParsingError.ERROR_INLINE_COMMENT, ParsingError.ERROR_STRING_TOKEN_WITHOUT_QUOTES, ParsingError.ERROR_KEY_WITHOUT_QUOTES);
        ParserTest.expectError(" /* comment start */ [] /* comment end*/", "/*comment start*/[]/*comment end*/", "/* comment start */[]/* comment end */", ParsingError.ERROR_INLINE_COMMENT);
        ParserTest.expectError("///* i1 /*\r\n1", "///* i1 /*\r\n1", "// /* i1 /*\r\n1", ParsingError.ERROR_LINE_COMMENT);
        ParserTest.expectError("{,a:b,,c:d,def:abc}", "{,\"a\":\"b\",,\"c\":\"d\",\"def\":\"abc\"}", "{\r\n  ,\r\n  \"a\":\"b\",,\r\n  \"c\":\"d\",\r\n  \"def\":\"abc\"\r\n}", SVWQ, STWQ, KWQ, ParsingError.ERROR_LEADING_COMMA_IN_OBJECT, ParsingError.ERROR_MULTIPLE_SUBSEQUENT_COMMAS_IN_OBJECT);
        ParserTest.expectError("{_a:{_b2:{_c:{_d342:{\"test\":},s:1,loooooong:2}}}}", "{\"_a\":{\"_b2\":{\"_c\":{\"_d342\":{\"test\":undefined},\"s\":1,\"loooooong\":2}}}}", "{\r\n  \"_a\":{\r\n    \"_b2\":{\r\n      \"_c\":{\r\n        \"_d342\":{\"test\":undefined},\r\n        \"s\":1,\r\n        \"loooooong\":2\r\n      }\r\n    }\r\n  }\r\n}", STWQ, KWQ, ParsingError.ERROR_VALUE_INSTEAD_OF_UNDEFINED_EXPECTED);
        ParserTest.expectError("\"{ich bin ein key mit space:ich bin ein value mit space}", "\"{ich bin ein key mit space:ich bin ein value mit space}\"", "\"{ich bin ein key mit space:ich bin ein value mit space}\"", ParsingError.EXPECTED_STRING_OR_DOUBLE_QUOTE);
        ParserTest.expectError("{ich bin ein key mit space:ich bin ein value mit space}", "{\"ich bin ein key mit space\":\"ich bin ein value mit space\"}", "{\"ich bin ein key mit space\":\"ich bin ein value mit space\"}", SVWQ, STWQ, KWQ);
        ParserTest.expectError("/* i1 /* i2 */", "undefined/*i1 /* i2*/", "undefined/* i1 /* i2 */", ParsingError.ERROR_INLINE_COMMENT, ParsingError.ERROR_NO_CONTENT);
        ParserTest.expectError(" /* comment start */ [/*1*/ ,,/*2*/] /* comment end*/", "\"/* comment start */ [/*1*/ ,,/*2*/] /* comment end*/\"", "\"/* comment start */ [/*1*/ ,,/*2*/] /* comment end*/\"", ParsingError.ERROR_STRING_TOKEN_WITHOUT_QUOTES, ParsingError.ERROR_STRING_VALUE_WITHOUT_QUOTES);
        ParserTest.expectError("123 //int", "\"123 //int\"", "\"123 //int\"", ParsingError.ERROR_STRING_TOKEN_WITHOUT_QUOTES, ParsingError.ERROR_STRING_VALUE_WITHOUT_QUOTES);
        ParserTest.expectError(" /* comment start */ [] /* comment end*/", "/*comment start*/[]/*comment end*/", "/* comment start */[]/* comment end */", ParsingError.ERROR_INLINE_COMMENT);
        ParserTest.expectError(" /* comment start */ {start:true,/* my comment */\r\n// my single line comment\r\nend:true} /* comment end*/", "/*comment start*/{\"start\":true,/*my comment*///my single line comment\r\n\"end\":true}/*comment end*/", "/* comment start */\r\n{\r\n  \"start\":true,\r\n  /* my comment */// my single line comment\r\n  \"end\":true\r\n}\r\n/* comment end */", KWQ, STWQ, ParsingError.ERROR_LINE_COMMENT, ParsingError.ERROR_INLINE_COMMENT);
        ParserTest.expectError(" /* comment start */ {start:true,/* my comment */\r\n// my single line comment\r\nend:true,/*end*/} /* comment end*/", "/*comment start*/{\"start\":true,/*my comment*///my single line comment\r\n\"end\":true,/*end*/}/*comment end*/", "/* comment start */\r\n{\r\n  \"start\":true,\r\n  /* my comment */// my single line comment\r\n  \"end\":true,\r\n  /* end */\r\n}\r\n/* comment end */", ParsingError.ERROR_TRAILING_COMMA_IN_OBJECT, KWQ, STWQ, ParsingError.ERROR_LINE_COMMENT, ParsingError.ERROR_INLINE_COMMENT);
        ParserTest.expectError("/**/  ", "undefined/**/", "undefined/*  */", ParsingError.ERROR_INLINE_COMMENT, ParsingError.ERROR_NO_CONTENT);
        ParserTest.expectError("//", "undefined//", "undefined// ", ParsingError.ERROR_LINE_COMMENT, ParsingError.ERROR_NO_CONTENT);
        ParserTest.expectError("  /*comment*  ", "undefined/*comment**/", "undefined/* comment* */", ParsingError.ERROR_INLINE_COMMENT, ParsingError.ERROR_NO_CONTENT, ParsingError.EXPECTED_ANY_CHARACTER_OR_COMMENT_CLOSE_TAGS);
        ParserTest.expectError(" \"string\" //comment ", "\"string\"//comment", "\"string\"// comment", ParsingError.ERROR_LINE_COMMENT);
        ParserTest.expectError(" /* comment*/ string", "/*comment*/\"string\"", "/* comment */\"string\"", SVWQ, ParsingError.ERROR_INLINE_COMMENT, STWQ);
        ParserTest.expectError(" /* before value*/ 1", "/*before value*/1", "/* before value */1", ParsingError.ERROR_INLINE_COMMENT);
        ParserTest.expectError("  1 /* after value*/", "1/*after value*/", "1/* after value */", ParsingError.ERROR_INLINE_COMMENT);
        ParserTest.expectError("/*comment*/ {  a:b,c:d}", "/*comment*/{\"a\":\"b\",\"c\":\"d\"}", "/* comment */\r\n{\r\n  \"a\":\"b\",\r\n  \"c\":\"d\"\r\n}", ParsingError.ERROR_INLINE_COMMENT, SVWQ, STWQ, KWQ);
        ParserTest.expectError(" { /*comment*/ a:b,c:d}", "{/*comment*/\"a\":\"b\",\"c\":\"d\"}", "{\r\n  /* comment */\r\n  \"a\":\"b\",\r\n  \"c\":\"d\"\r\n}", ParsingError.ERROR_INLINE_COMMENT, SVWQ, STWQ, KWQ);
        ParserTest.expectError(" {  a/*comment*/:b,c:d}", "{\"a\"/*comment*/:\"b\",\"c\":\"d\"}", "{\r\n  \"a\"/* comment */:\"b\",\r\n  \"c\":\"d\"\r\n}", ParsingError.ERROR_INLINE_COMMENT, SVWQ, STWQ, KWQ);
        ParserTest.expectError(" {  a:/*comment*/b,c:d}", "{\"a\":/*comment*/\"b\",\"c\":\"d\"}", "{\r\n  \"a\":/* comment */\"b\",\r\n  \"c\":\"d\"\r\n}", ParsingError.ERROR_INLINE_COMMENT, SVWQ, STWQ, KWQ);
        ParserTest.expectError(" {  a:b/*comment*/,c:d}", "{\"a\":\"b\"/*comment*/,\"c\":\"d\"}", "{\r\n  \"a\":\"b\"/* comment */,\r\n  \"c\":\"d\"\r\n}", ParsingError.ERROR_INLINE_COMMENT, SVWQ, STWQ, KWQ);
        ParserTest.expectError(" {  a:b,/*comment*/c:d}", "{\"a\":\"b\",/*comment*/\"c\":\"d\"}", "{\r\n  \"a\":\"b\",\r\n  /* comment */\r\n  \"c\":\"d\"\r\n}", ParsingError.ERROR_INLINE_COMMENT, SVWQ, STWQ, KWQ);
        ParserTest.expectError(" {  a:b,c:d/*comment*/}", "{\"a\":\"b\",\"c\":\"d\"/*comment*/}", "{\r\n  \"a\":\"b\",\r\n  \"c\":\"d\"/* comment */\r\n}", ParsingError.ERROR_INLINE_COMMENT, SVWQ, STWQ, KWQ);
        ParserTest.expectError(" {  a:b,c:d} /*comment*/ ", "{\"a\":\"b\",\"c\":\"d\"}/*comment*/", "{\r\n  \"a\":\"b\",\r\n  \"c\":\"d\"\r\n}\r\n/* comment */", ParsingError.ERROR_INLINE_COMMENT, SVWQ, STWQ, KWQ);
        ParserTest.expectError("/*com1*/  /* com2 */  /*comm3*/ string//comment ", "/*com1*//*com2*//*comm3*/\"string\"//comment", "/* com1 *//* com2 *//* comm3 */\"string\"// comment", SVWQ, ParsingError.ERROR_LINE_COMMENT, STWQ, ParsingError.ERROR_INLINE_COMMENT);
        ParserTest.expectError("0", "0", "0", new ParsingError[0]);
        ParserTest.expectError("  '1','2'  ", "[\"1\",\"2\"]", "[\"1\", \"2\"]", ParsingError.ERROR_STRING_VALUE_WITH_SINGLE_QUOTES, ParsingError.ERROR_MULTIPLE_ELEMENTS_IN_JSON_STRING, ParsingError.ERROR_UNEXPECTED_CONTENT_AFTER_END_OF_JSON, ParsingError.ERROR_STRING_TOKEN_WITH_SINGLE_QUOTES);
        ParserTest.expectError("{},[],{}  ", "[{},[],{}]", "[\r\n  {},\r\n  [],\r\n  {}\r\n]", ParsingError.ERROR_MULTIPLE_ELEMENTS_IN_JSON_STRING, ParsingError.ERROR_UNEXPECTED_CONTENT_AFTER_END_OF_JSON);
        ParserTest.expectError("{a:1,'b':'1''c':2}", "{\"a\":1,\"b\":\"1\",\"c\":2}", "{\r\n  \"a\":1,\r\n  \"b\":\"1\",\r\n  \"c\":2\r\n}", ParsingError.ERROR_STRING_TOKEN_WITH_SINGLE_QUOTES, ParsingError.ERROR_KEY_WITH_SINGLE_QUOTES, ParsingError.ERROR_STRING_TOKEN_WITHOUT_QUOTES, ParsingError.ERROR_KEY_WITHOUT_QUOTES, ParsingError.EXPECTED_COMMA_OR_OBJECT_END_TAG, ParsingError.ERROR_STRING_VALUE_WITH_SINGLE_QUOTES);
        ParserTest.expectError("{342.187124E-3:true}", "{\"0.342187124\":true}", "{\"0.342187124\":true}", KWQ, ParsingError.ERROR_KEY_IS_NUMBER);
        ParserTest.expectError("{true:\"^\\\\.\\\\%\\\\S+$\"}", "{\"true\":\"^\\\\.\\\\%\\\\S+$\"}", "{\"true\":\"^\\\\.\\\\%\\\\S+$\"}", KWQ, ParsingError.ERROR_KEY_IS_BOOLEAN);
        ParserTest.expectError("{true:^\\\\.\\\\%\\\\S+$}", "{\"true\":\"^\\\\.\\\\%\\\\S+$\"}", "{\"true\":\"^\\\\.\\\\%\\\\S+$\"}", STWQ, KWQ, SVWQ, ParsingError.ERROR_KEY_IS_BOOLEAN);
        ParserTest.expectError("{\"true\":^\\\\.\\\\%\\\\S+$}", "{\"true\":\"^\\\\.\\\\%\\\\S+$\"}", "{\"true\":\"^\\\\.\\\\%\\\\S+$\"}", ParsingError.ERROR_STRING_TOKEN_WITHOUT_QUOTES, ParsingError.ERROR_STRING_VALUE_WITHOUT_QUOTES);
        ParserTest.expectError("{true:\"^\\\\.\\\\%\\\\S+$\"}", "{\"true\":\"^\\\\.\\\\%\\\\S+$\"}", "{\"true\":\"^\\\\.\\\\%\\\\S+$\"}", KWQ, ParsingError.ERROR_KEY_IS_BOOLEAN);
        ParserTest.expectError("['Z:\\\\']", "[\"Z:\\\\\"]", "[\"Z:\\\\\"]", ParsingError.ERROR_STRING_VALUE_WITH_SINGLE_QUOTES, ParsingError.ERROR_STRING_TOKEN_WITH_SINGLE_QUOTES);
        ParserTest.expectError("string'", "\"string'\"", "\"string'\"", ParsingError.ERROR_STRING_TOKEN_WITHOUT_QUOTES, ParsingError.ERROR_STRING_VALUE_WITHOUT_QUOTES);
        ParserTest.expectError("'string", "\"string\"", "\"string\"", ParsingError.ERROR_STRING_VALUE_WITH_SINGLE_QUOTES, ParsingError.ERROR_STRING_TOKEN_WITH_SINGLE_QUOTES, ParsingError.EXPECTED_STRING_OR_SINGLE_QUOTE);
        ParserTest.expectError("'string'", "\"string\"", "\"string\"", STWSQ, ParsingError.ERROR_STRING_VALUE_WITH_SINGLE_QUOTES);
        ParserTest.expectError("{leadingCOmmaInArray: [,,1,,,]}", "{\"leadingCOmmaInArray\":[undefined,undefined,1,undefined,undefined]}", "{\r\n  \"leadingCOmmaInArray\":[\r\n    undefined,\r\n    undefined,\r\n    1,\r\n    undefined,\r\n    undefined\r\n  ]\r\n}", STWQ, KWQ, ParsingError.ERROR_MULTIPLE_LEADING_COMMA_IN_ARRAY, ParsingError.ERROR_TRAILING_COMMA_IN_ARRAY, ParsingError.ERROR_LEADING_COMMA_IN_ARRAY, ParsingError.ERROR_MULTIPLE_SUBSEQUENT_COMMAS_IN_ARRAY, ParsingError.ERROR_MULTIPLE_TRAILING_COMMA_IN_ARRAY);
        ParserTest.expectError("{trailingCOmmaInArray: [1,,,]}", "{\"trailingCOmmaInArray\":[1,undefined,undefined]}", "{\r\n  \"trailingCOmmaInArray\":[1, undefined, undefined]\r\n}", STWQ, KWQ, ParsingError.ERROR_TRAILING_COMMA_IN_ARRAY, ParsingError.ERROR_MULTIPLE_SUBSEQUENT_COMMAS_IN_ARRAY, ParsingError.ERROR_MULTIPLE_TRAILING_COMMA_IN_ARRAY);
        ParserTest.expectError("{trailingCOmmaInArray: [1,,,2]}", "{\"trailingCOmmaInArray\":[1,undefined,undefined,2]}", "{\r\n  \"trailingCOmmaInArray\":[1, undefined, undefined, 2]\r\n}", STWQ, KWQ, ParsingError.ERROR_MULTIPLE_SUBSEQUENT_COMMAS_IN_ARRAY);
        ParserTest.expectError("{onlyEmptys: [,,,]}", "{\"onlyEmptys\":[undefined,undefined,undefined]}", "{\r\n  \"onlyEmptys\":[undefined, undefined, undefined]\r\n}", STWQ, KWQ, ParsingError.ERROR_TRAILING_COMMA_IN_ARRAY, ParsingError.ERROR_LEADING_COMMA_IN_ARRAY, ParsingError.ERROR_MULTIPLE_LEADING_COMMA_IN_ARRAY, ParsingError.ERROR_MULTIPLE_SUBSEQUENT_COMMAS_IN_ARRAY, ParsingError.ERROR_MULTIPLE_TRAILING_COMMA_IN_ARRAY);
        ParserTest.expectError("{a:{}}", "{\"a\":{}}", "{\r\n  \"a\":{}\r\n}", KWQ, STWQ);
        ParserTest.expectError("{,,}", "{,,}", "{\r\n  ,,\r\n}", ParsingError.ERROR_LEADING_COMMA_IN_OBJECT, ParsingError.ERROR_MULTIPLE_LEADING_COMMA_IN_OBJECT, ParsingError.ERROR_MULTIPLE_SUBSEQUENT_COMMAS_IN_OBJECT, ParsingError.ERROR_MULTIPLE_TRAILING_COMMA_IN_OBJECT, ParsingError.ERROR_TRAILING_COMMA_IN_OBJECT);
        ParserTest.expectError("{a:b,,}", "{\"a\":\"b\",,}", "{\"a\":\"b\",,}", ParsingError.ERROR_MULTIPLE_SUBSEQUENT_COMMAS_IN_OBJECT, ParsingError.ERROR_MULTIPLE_TRAILING_COMMA_IN_OBJECT, ParsingError.ERROR_TRAILING_COMMA_IN_OBJECT, KWQ, SVWQ, STWQ);
        ParserTest.expectError("{a:b ,  ,  c:d}", "{\"a\":\"b\",,\"c\":\"d\"}", "{\r\n  \"a\":\"b\",,\r\n  \"c\":\"d\"\r\n}", ParsingError.ERROR_MULTIPLE_SUBSEQUENT_COMMAS_IN_OBJECT, KWQ, SVWQ, STWQ);
        ParserTest.expectError("{,a:b}", "{,\"a\":\"b\"}", "{\r\n  ,\r\n  \"a\":\"b\"\r\n}", SVWQ, STWQ, KWQ, ParsingError.ERROR_LEADING_COMMA_IN_OBJECT);
        ParserTest.expectError("{,,a:b}", "{,,\"a\":\"b\"}", "{\r\n  ,,\r\n  \"a\":\"b\"\r\n}", SVWQ, STWQ, KWQ, ParsingError.ERROR_LEADING_COMMA_IN_OBJECT, ParsingError.ERROR_MULTIPLE_LEADING_COMMA_IN_OBJECT, ParsingError.ERROR_MULTIPLE_SUBSEQUENT_COMMAS_IN_OBJECT);
        ParserTest.expectError("{  ,  ,a:b}", "{,,\"a\":\"b\"}", "{\r\n  ,,\r\n  \"a\":\"b\"\r\n}", SVWQ, STWQ, KWQ, ParsingError.ERROR_LEADING_COMMA_IN_OBJECT, ParsingError.ERROR_MULTIPLE_LEADING_COMMA_IN_OBJECT, ParsingError.ERROR_MULTIPLE_SUBSEQUENT_COMMAS_IN_OBJECT);
        ParserTest.expectError("{, , a:b}", "{,,\"a\":\"b\"}", "{\r\n  ,,\r\n  \"a\":\"b\"\r\n}", SVWQ, STWQ, KWQ, ParsingError.ERROR_LEADING_COMMA_IN_OBJECT, ParsingError.ERROR_MULTIPLE_LEADING_COMMA_IN_OBJECT, ParsingError.ERROR_MULTIPLE_SUBSEQUENT_COMMAS_IN_OBJECT);
        ParserTest.expectError("{,a:b}", "{,\"a\":\"b\"}", "{\r\n  ,\r\n  \"a\":\"b\"\r\n}", SVWQ, STWQ, KWQ, ParsingError.ERROR_LEADING_COMMA_IN_OBJECT);
        ParserTest.expectError("{a: -  NaN }", "{\"a\":NaN}", "{\"a\":NaN}", KWQ, STWQ, ParsingError.ERROR_NUMBER_NAN);
        ParserTest.expectError("string/* comment */ ", "\"string\"/*comment*/", "\"string\"/* comment */", SVWQ, ParsingError.ERROR_INLINE_COMMENT, STWQ);
        ParserTest.expectError("string//comment ", "\"string\"//comment", "\"string\"// comment", SVWQ, ParsingError.ERROR_LINE_COMMENT, STWQ);
        ParserTest.expectError("'string'/* comment */ ", "\"string\"/*comment*/", "\"string\"/* comment */", ParsingError.ERROR_STRING_VALUE_WITH_SINGLE_QUOTES, STWSQ, ParsingError.ERROR_INLINE_COMMENT);
        ParserTest.expectError("  .1  ", "0.1", "0.1", ParsingError.ERROR_LEADING_DECIMAL_POINT);
        ParserTest.expectError("  1.  ", "1.0", "1.0", ParsingError.ERROR_TRAILING_DECIMAL_POINT);
        ParserTest.expectError("{a: -  Infinity }", "{\"a\":-Infinity}", "{\"a\":-Infinity}", ParsingError.ERROR_NUMBER_INFINITY, KWQ, STWQ);
        ParserTest.expectError("{a: -Infinity }", "{\"a\":-Infinity}", "{\"a\":-Infinity}", ParsingError.ERROR_NUMBER_INFINITY, KWQ, STWQ);
        ParserTest.expectError("{a:b , }", "{\"a\":\"b\",}", "{\"a\":\"b\",}", ParsingError.ERROR_TRAILING_COMMA_IN_OBJECT, KWQ, SVWQ, STWQ);
        ParserTest.expectError("[ 1 ,   2  ,   3         ]", "[1,2,3]", "[1, 2, 3]", new ParsingError[0]);
        ParserTest.expectError("[ string with space,   2   , 2 number with string of space     ]", "[\"string with space\",2,\"2 number with string of space\"]", "[\r\n  \"string with space\",\r\n  2,\r\n  \"2 number with string of space\"\r\n]", SVWQ, STWQ);
        ParserTest.expectError("[ true ,   false  ,   NaN , null         ]", "[true,false,NaN,null]", "[true, false, NaN, null]", ParsingError.ERROR_NUMBER_NAN);
        ParserTest.expectError("[true,false,NaN,null,true false,null true,0 1 2 3]", "[true,false,NaN,null,\"true false\",\"null true\",\"0 1 2 3\"]", "[\r\n  true,\r\n  false,\r\n  NaN,\r\n  null,\r\n  \"true false\",\r\n  \"null true\",\r\n  \"0 1 2 3\"\r\n]", SVWQ, STWQ, ParsingError.ERROR_NUMBER_NAN);
        ParserTest.expectError("[Z:\\pfad]", "[\"Z:\\\\pfad\"]", "[\"Z:\\\\pfad\"]", SVWQ, STWQ, ParsingError.EXPECTED_VALID_ESCAPE_CHARACTER);
        ParserTest.expectError("{\"pByte\":20}", "{\"pByte\":20}", "{\"pByte\":20}", new ParsingError[0]);
        ParserTest.expectError("\\\\u7570\\\\u9AD4\\\\u5B57\\\\u5B57", "\"\\\\u7570\\\\u9AD4\\\\u5B57\\\\u5B57\"", "\"\\\\u7570\\\\u9AD4\\\\u5B57\\\\u5B57\"", STWQ, SVWQ);
        ParserTest.expectError("\"\\\\u7570\\\\u9AD4\\\\u5B57\\\\u5B57\"", "\"\\\\u7570\\\\u9AD4\\\\u5B57\\\\u5B57\"", "\"\\\\u7570\\\\u9AD4\\\\u5B57\\\\u5B57\"", new ParsingError[0]);
        ParserTest.expectError("\u7570\u9ad4\u5b57\u5b57", "\"\u7570\u9ad4\u5b57\u5b57\"", "\"\u7570\u9ad4\u5b57\u5b57\"", STWQ, SVWQ);
        ParserTest.expectError("\\\\", "\"\\\\\"", "\"\\\\\"", STWQ, SVWQ);
        ParserTest.expectError("\"\\\\\"", "\"\\\\\"", "\"\\\\\"", new ParsingError[0]);
        ParserTest.expectError("'\\\\'", "\"\\\\\"", "\"\\\\\"", STWSQ, ParsingError.ERROR_STRING_VALUE_WITH_SINGLE_QUOTES);
        ParserTest.expectError("\\\\", "\"\\\\\"", "\"\\\\\"", STWQ, SVWQ);
        ParserTest.expectError("'\\\\\\\\'", "\"\\\\\\\\\"", "\"\\\\\\\\\"", ParsingError.ERROR_STRING_TOKEN_WITH_SINGLE_QUOTES, ParsingError.ERROR_STRING_VALUE_WITH_SINGLE_QUOTES);
        ParserTest.expectError("'\\\\\\\\\\\\'", "\"\\\\\\\\\\\\\"", "\"\\\\\\\\\\\\\"", ParsingError.ERROR_STRING_TOKEN_WITH_SINGLE_QUOTES, ParsingError.ERROR_STRING_VALUE_WITH_SINGLE_QUOTES);
        ParserTest.expectError("1,2,3", "\"1,2,3\"", "\"1,2,3\"", STWQ, SVWQ);
        ParserTest.expectError("{trailingCOmmaInObject: true,}", "{\"trailingCOmmaInObject\":true,}", "{\"trailingCOmmaInObject\":true,}", STWQ, KWQ, ParsingError.ERROR_TRAILING_COMMA_IN_OBJECT);
        ParserTest.expectError("[\"Z:\\\\\"]", "[\"Z:\\\\\"]", "[\"Z:\\\\\"]", new ParsingError[0]);
        ParserTest.expectError("['Z\\\\']", "[\"Z\\\\\"]", "[\"Z\\\\\"]", STWSQ, ParsingError.ERROR_STRING_VALUE_WITH_SINGLE_QUOTES);
        ParserTest.expectError("[Z\\\\]", "[\"Z\\\\\"]", "[\"Z\\\\\"]", ParsingError.ERROR_STRING_TOKEN_WITHOUT_QUOTES, ParsingError.ERROR_STRING_VALUE_WITHOUT_QUOTES);
        ParserTest.expectError("[1,2,3]", "[1,2,3]", "[1, 2, 3]", new ParsingError[0]);
        ParserTest.expectError("{leadingPoint:.01}", "{\"leadingPoint\":0.01}", "{\"leadingPoint\":0.01}", STWQ, KWQ, ParsingError.ERROR_LEADING_DECIMAL_POINT);
        ParserTest.expectError("{dec:2070}", "{\"dec\":2070}", "{\"dec\":2070}", STWQ, KWQ);
        ParserTest.expectError("{dec:-164730}", "{\"dec\":-164730}", "{\"dec\":-164730}", STWQ, KWQ);
        ParserTest.expectError("{dec:-164730at}", "{\"dec\":\"-164730at\"}", "{\"dec\":\"-164730at\"}", SVWQ, STWQ, KWQ);
        ParserTest.expectError("{dec:28.12}", "{\"dec\":28.12}", "{\"dec\":28.12}", STWQ, KWQ);
        ParserTest.expectError("{hex:0x816}", "{\"hex\":2070}", "{\"hex\":2070}", STWQ, KWQ, ParsingError.ERROR_NUMBERFORMAT_HEXADECIMAL);
        ParserTest.expectError("{hex:-0x2837a}", "{\"hex\":-164730}", "{\"hex\":-164730}", STWQ, KWQ, ParsingError.ERROR_NUMBERFORMAT_HEXADECIMAL);
        ParserTest.expectError("{hex:-0x2837at}", "{\"hex\":\"-0x2837at\"}", "{\"hex\":\"-0x2837at\"}", SVWQ, STWQ, KWQ);
        ParserTest.expectError("{hex:0x28.12}", "{\"hex\":\"0x28.12\"}", "{\"hex\":\"0x28.12\"}", STWQ, KWQ, ParsingError.ERROR_STRING_VALUE_WITHOUT_QUOTES);
        ParserTest.expectError("{hex:+   0x03}", "{\"hex\":3}", "{\"hex\":3}", STWQ, KWQ, ParsingError.ERROR_NUMBERFORMAT_HEXADECIMAL, ParsingError.ERROR_NUMBERFORMAT_LEADING_PLUS);
        ParserTest.expectError("{hex:-   0x03}", "{\"hex\":-3}", "{\"hex\":-3}", STWQ, KWQ, ParsingError.ERROR_NUMBERFORMAT_HEXADECIMAL);
        ParserTest.expectError("{bin:0b0101}", "{\"bin\":5}", "{\"bin\":5}", STWQ, KWQ, ParsingError.ERROR_NUMBERFORMAT_BINARY);
        ParserTest.expectError("{bin:+0b0101}", "{\"bin\":5}", "{\"bin\":5}", STWQ, KWQ, ParsingError.ERROR_NUMBERFORMAT_BINARY, ParsingError.ERROR_NUMBERFORMAT_LEADING_PLUS);
        ParserTest.expectError("{bin:-0b1101}", "{\"bin\":-13}", "{\"bin\":-13}", STWQ, KWQ, ParsingError.ERROR_NUMBERFORMAT_BINARY);
        ParserTest.expectError("{bin:+   0b3101}", "{\"bin\":\"+   0b3101\"}", "{\"bin\":\"+   0b3101\"}", STWQ, KWQ, SVWQ);
        ParserTest.expectError("{oct:071}", "{\"oct\":57}", "{\"oct\":57}", STWQ, KWQ, ParsingError.ERROR_NUMBERFORMAT_OCTAL);
        ParserTest.expectError("{oct:-001}", "{\"oct\":-1}", "{\"oct\":-1}", STWQ, KWQ, ParsingError.ERROR_NUMBERFORMAT_OCTAL);
        ParserTest.expectError("{oct:+   0201}", "{\"oct\":129}", "{\"oct\":129}", STWQ, KWQ, ParsingError.ERROR_NUMBERFORMAT_OCTAL, ParsingError.ERROR_NUMBERFORMAT_LEADING_PLUS);
        ParserTest.expectError("{trailingCOmmaInArray: [1,2,]}", "{\"trailingCOmmaInArray\":[1,2]}", "{\r\n  \"trailingCOmmaInArray\":[1, 2]\r\n}", STWQ, KWQ, ParsingError.ERROR_TRAILING_COMMA_IN_ARRAY);
        ParserTest.expectError("{singleQuotes: 'I can use \"double quotes\" here'}", "{\"singleQuotes\":\"I can use \\\"double quotes\\\" here\"}", "{\"singleQuotes\":\"I can use \\\"double quotes\\\" here\"}", STWQ, KWQ, ParsingError.ERROR_STRING_VALUE_WITH_SINGLE_QUOTES, ParsingError.ERROR_STRING_TOKEN_WITH_SINGLE_QUOTES);
        ParserTest.expectError("{oct:001}", "{\"oct\":1}", "{\"oct\":1}", STWQ, KWQ, ParsingError.ERROR_NUMBERFORMAT_OCTAL);
        ParserTest.expectError("{plus:+1}", "{\"plus\":1}", "{\"plus\":1}", STWQ, KWQ, ParsingError.ERROR_NUMBERFORMAT_LEADING_PLUS);
        ParserTest.expectError("{trailingPoint:1.}", "{\"trailingPoint\":1.0}", "{\"trailingPoint\":1.0}", STWQ, KWQ, ParsingError.ERROR_TRAILING_DECIMAL_POINT);
        ParserTest.expectError("{1:^\\.\\%\\S+$}", "{\"1\":\"^\\\\.\\\\%\\\\S+$\"}", "{\"1\":\"^\\\\.\\\\%\\\\S+$\"}", ParsingError.EXPECTED_VALID_ESCAPE_CHARACTER, ParsingError.ERROR_KEY_IS_NUMBER, STWQ, KWQ, ParsingError.ERROR_STRING_VALUE_WITHOUT_QUOTES);
        ParserTest.expectError("{\u00a7regex:^\\\\.\\\\%\\\\S+$}", "{\"\u00a7regex\":\"^\\\\.\\\\%\\\\S+$\"}", "{\"\u00a7regex\":\"^\\\\.\\\\%\\\\S+$\"}", STWQ, KWQ, ParsingError.ERROR_STRING_VALUE_WITHOUT_QUOTES);
        ParserTest.expectError("Unicode pattern testblabla\\\\u003ebl\r\na", "\"Unicode pattern testblabla\\\\u003ebl\\r\\na\"", "\"Unicode pattern testblabla\\\\u003ebl\\r\\na\"", STWQ, SVWQ);
        ParserTest.expectError("\"Unicode pattern testblabla\\u003ebl\\r\\na\"", "\"Unicode pattern testblabla>bl\\r\\na\"", "\"Unicode pattern testblabla>bl\\r\\na\"", new ParsingError[0]);
        ParserTest.expectError("Unicode pattern testblabla>bl\r\na", "\"Unicode pattern testblabla>bl\\r\\na\"", "\"Unicode pattern testblabla>bl\\r\\na\"", STWQ, SVWQ);
        ParserTest.expectError("{\"OBoolean\" :     false, \"pChar\" : 19, \"pDouble\" : 0.3, \"oByte\" : 68, \"pFloat\" : 0.4230000078678131, \"oFloat\" : 0.4122999906539917, \"oLong\" : 5435443543, \"pInt\" : 2435253, \"list\" : [1,2,3], \"pBoolean\" : false, \"oChar\" : 16, \"num\" : \"BLUMM\", \"oDouble\" : 0.52, \"oInt\" : 45343253, \"pLong\" : 4355543543, \"string\" : \"affe232\", \"intArray\" : [3,2,1], \"map\" : {\"3\" : {\"oBoolean\" : false, \"pChar\" : 19, \"pDouble\" : 0.3, \"oByte\" : 68, \"pFloat\" : 0.4230000078678131, \"oFloat\" : 0.4122999906539917, \"oLong\" : 5435443543, \"pInt\" : 2435253, \"list\" : [], \"pBoolean\" : false, \"oChar\" : 16, \"num\" : \"BLUMM\", \"oDouble\" : 0.52, \"oInt\" : 45343253, \"pLong\" : 4355543543, \"string\" : \"affe232\", \"intArray\" : [3,2,1], \"map\" : {}, \"objArray\" : [{\"oBoolean\" : true, \"pChar\" : 18, \"pDouble\" : 0.5, \"oByte\" : 36, \"pFloat\" : 0.4000000059604645, \"oFloat\" : 0.4000000059604645, \"oLong\" : 43543, \"pInt\" : 43253, \"list\" : [], \"pBoolean\" : true, \"oChar\" : 18, \"num\" : \"TEST\", \"oDouble\" : 0.5, \"oInt\" : 43253, \"pLong\" : 43543, \"string\" : \"affe\", \"intArray\" : [1,2], \"map\" : {}, \"objArray\" : null, \"pByte\" : 36, \"obj\" : null},{\"oBoolean\" : true, \"pChar\" : 18, \"pDouble\" : 0.5, \"oByte\" : 36, \"pFloat\" : 0.4000000059604645, \"oFloat\" : 0.4000000059604645, \"oLong\" : 43543, \"pInt\" : 43253, \"list\" : [], \"pBoolean\" : true, \"oChar\" : 18, \"num\" : \"TEST\", \"oDouble\" : 0.5, \"oInt\" : 43253, \"pLong\" : 43543, \"string\" : \"affe\", \"intArray\" : [1,2], \"map\" : {}, \"objArray\" : null, \"pByte\" : 36, \"obj\" : null},{\"oBoolean\" : true, \"pChar\" : 18, \"pDouble\" : 0.5, \"oByte\" : 36, \"pFloat\" : 0.4000000059604645, \"oFloat\" : 0.4000000059604645, \"oLong\" : 43543, \"pInt\" : 43253, \"list\" : [], \"pBoolean\" : true, \"oChar\" : 18, \"num\" : \"TEST\", \"oDouble\" : 0.5, \"oInt\" : 43253, \"pLong\" : 43543, \"string\" : \"affe\", \"intArray\" : [1,2], \"map\" : {}, \"objArray\" : null, \"pByte\" : 36, \"obj\" : null}], \"pByte\" : 20, \"obj\" : null}, \"2\" : {\"oBoolean\" : false, \"pChar\" : 19, \"pDouble\" : 0.3, \"oByte\" : 68, \"pFloat\" : 0.4230000078678131, \"oFloat\" : 0.4122999906539917, \"oLong\" : 5435443543, \"pInt\" : 2435253, \"list\" : [], \"pBoolean\" : false, \"oChar\" : 16, \"num\" : \"BLUMM\", \"oDouble\" : 0.52, \"oInt\" : 45343253, \"pLong\" : 4355543543, \"string\" : \"affe232\", \"intArray\" : [3,2,1], \"map\" : {}, \"objArray\" : [{\"oBoolean\" : true, \"pChar\" : 18, \"pDouble\" : 0.5, \"oByte\" : 36, \"pFloat\" : 0.4000000059604645, \"oFloat\" : 0.4000000059604645, \"oLong\" : 43543, \"pInt\" : 43253, \"list\" : [], \"pBoolean\" : true, \"oChar\" : 18, \"num\" : \"TEST\", \"oDouble\" : 0.5, \"oInt\" : 43253, \"pLong\" : 43543, \"string\" : \"affe\", \"intArray\" : [1,2], \"map\" : {}, \"objArray\" : null, \"pByte\" : 36, \"obj\" : null},{\"oBoolean\" : true, \"pChar\" : 18, \"pDouble\" : 0.5, \"oByte\" : 36, \"pFloat\" : 0.4000000059604645, \"oFloat\" : 0.4000000059604645, \"oLong\" : 43543, \"pInt\" : 43253, \"list\" : [], \"pBoolean\" : true, \"oChar\" : 18, \"num\" : \"TEST\", \"oDouble\" : 0.5, \"oInt\" : 43253, \"pLong\" : 43543, \"string\" : \"affe\", \"intArray\" : [1,2], \"map\" : {}, \"objArray\" : null, \"pByte\" : 36, \"obj\" : null},{\"oBoolean\" : true, \"pChar\" : 18, \"pDouble\" : 0.5, \"oByte\" : 36, \"pFloat\" : 0.4000000059604645, \"oFloat\" : 0.4000000059604645, \"oLong\" : 43543, \"pInt\" : 43253, \"list\" : [], \"pBoolean\" : true, \"oChar\" : 18, \"num\" : \"TEST\", \"oDouble\" : 0.5, \"oInt\" : 43253, \"pLong\" : 43543, \"string\" : \"affe\", \"intArray\" : [1,2], \"map\" : {}, \"objArray\" : null, \"pByte\" : 36, \"obj\" : null}], \"pByte\" : 20, \"obj\" : null}, \"5\" : {\"oBoolean\" : false, \"pChar\" : 19, \"pDouble\" : 0.3, \"oByte\" : 68, \"pFloat\" : 0.4230000078678131, \"oFloat\" : 0.4122999906539917, \"oLong\" : 5435443543, \"pInt\" : 2435253, \"list\" : [], \"pBoolean\" : false, \"oChar\" : 16, \"num\" : \"BLUMM\", \"oDouble\" : 0.52, \"oInt\" : 45343253, \"pLong\" : 4355543543, \"string\" : \"affe232\", \"intArray\" : [3,2,1], \"map\" : {}, \"objArray\" : [{\"oBoolean\" : true, \"pChar\" : 18, \"pDouble\" : 0.5, \"oByte\" : 36, \"pFloat\" : 0.4000000059604645, \"oFloat\" : 0.4000000059604645, \"oLong\" : 43543, \"pInt\" : 43253, \"list\" : [], \"pBoolean\" : true, \"oChar\" : 18, \"num\" : \"TEST\", \"oDouble\" : 0.5, \"oInt\" : 43253, \"pLong\" : 43543, \"string\" : \"affe\", \"intArray\" : [1,2], \"map\" : {}, \"objArray\" : null, \"pByte\" : 36, \"obj\" : null},{\"oBoolean\" : true, \"pChar\" : 18, \"pDouble\" : 0.5, \"oByte\" : 36, \"pFloat\" : 0.4000000059604645, \"oFloat\" : 0.4000000059604645, \"oLong\" : 43543, \"pInt\" : 43253, \"list\" : [], \"pBoolean\" : true, \"oChar\" : 18, \"num\" : \"TEST\", \"oDouble\" : 0.5, \"oInt\" : 43253, \"pLong\" : 43543, \"string\" : \"affe\", \"intArray\" : [1,2], \"map\" : {}, \"objArray\" : null, \"pByte\" : 36, \"obj\" : null},{\"oBoolean\" : true, \"pChar\" : 18, \"pDouble\" : 0.5, \"oByte\" : 36, \"pFloat\" : 0.4000000059604645, \"oFloat\" : 0.4000000059604645, \"oLong\" : 43543, \"pInt\" : 43253, \"list\" : [], \"pBoolean\" : true, \"oChar\" : 18, \"num\" : \"TEST\", \"oDouble\" : 0.5, \"oInt\" : 43253, \"pLong\" : 43543, \"string\" : \"affe\", \"intArray\" : [1,2], \"map\" : {}, \"objArray\" : null, \"pByte\" : 36, \"obj\" : null}], \"pByte\" : 20, \"obj\" : null}, \"4\" : {\"oBoolean\" : false, \"pChar\" : 19, \"pDouble\" : 0.3, \"oByte\" : 68, \"pFloat\" : 0.4230000078678131, \"oFloat\" : 0.4122999906539917, \"oLong\" : 5435443543, \"pInt\" : 2435253, \"list\" : [], \"pBoolean\" : false, \"oChar\" : 16, \"num\" : \"BLUMM\", \"oDouble\" : 0.52, \"oInt\" : 45343253, \"pLong\" : 4355543543, \"string\" : \"affe232\", \"intArray\" : [3,2,1], \"map\" : {}, \"objArray\" : [{\"oBoolean\" : true, \"pChar\" : 18, \"pDouble\" : 0.5, \"oByte\" : 36, \"pFloat\" : 0.4000000059604645, \"oFloat\" : 0.4000000059604645, \"oLong\" : 43543, \"pInt\" : 43253, \"list\" : [], \"pBoolean\" : true, \"oChar\" : 18, \"num\" : \"TEST\", \"oDouble\" : 0.5, \"oInt\" : 43253, \"pLong\" : 43543, \"string\" : \"affe\", \"intArray\" : [1,2], \"map\" : {}, \"objArray\" : null, \"pByte\" : 36, \"obj\" : null},{\"oBoolean\" : true, \"pChar\" : 18, \"pDouble\" : 0.5, \"oByte\" : 36, \"pFloat\" : 0.4000000059604645, \"oFloat\" : 0.4000000059604645, \"oLong\" : 43543, \"pInt\" : 43253, \"list\" : [], \"pBoolean\" : true, \"oChar\" : 18, \"num\" : \"TEST\", \"oDouble\" : 0.5, \"oInt\" : 43253, \"pLong\" : 43543, \"string\" : \"affe\", \"intArray\" : [1,2], \"map\" : {}, \"objArray\" : null, \"pByte\" : 36, \"obj\" : null},{\"oBoolean\" : true, \"pChar\" : 18, \"pDouble\" : 0.5, \"oByte\" : 36, \"pFloat\" : 0.4000000059604645, \"oFloat\" : 0.4000000059604645, \"oLong\" : 43543, \"pInt\" : 43253, \"list\" : [], \"pBoolean\" : true, \"oChar\" : 18, \"num\" : \"TEST\", \"oDouble\" : 0.5, \"oInt\" : 43253, \"pLong\" : 43543, \"string\" : \"affe\", \"intArray\" : [1,2], \"map\" : {}, \"objArray\" : null, \"pByte\" : 36, \"obj\" : null}], \"pByte\" : 20, \"obj\" : null}}, \"objArray\" : [{\"oBoolean\" : true, \"pChar\" : 18, \"pDouble\" : 0.5, \"oByte\" : 36, \"pFloat\" : 0.4000000059604645, \"oFloat\" : 0.4000000059604645, \"oLong\" : 43543, \"pInt\" : 43253, \"list\" : [], \"pBoolean\" : true, \"oChar\" : 18, \"num\" : \"TEST\", \"oDouble\" : 0.5, \"oInt\" : 43253, \"pLong\" : 43543, \"string\" : \"affe\", \"intArray\" : [1,2], \"map\" : {}, \"objArray\" : null, \"pByte\" : 36, \"obj\" : null},{\"oBoolean\" : true, \"pChar\" : 18, \"pDouble\" : 0.5, \"oByte\" : 36, \"pFloat\" : 0.4000000059604645, \"oFloat\" : 0.4000000059604645, \"oLong\" : 43543, \"pInt\" : 43253, \"list\" : [], \"pBoolean\" : true, \"oChar\" : 18, \"num\" : \"TEST\", \"oDouble\" : 0.5, \"oInt\" : 43253, \"pLong\" : 43543, \"string\" : \"affe\", \"intArray\" : [1,2], \"map\" : {}, \"objArray\" : null, \"pByte\" : 36, \"obj\" : null},{\"oBoolean\" : true, \"pChar\" : 18, \"pDouble\" : 0.5, \"oByte\" : 36, \"pFloat\" : 0.4000000059604645, \"oFloat\" : 0.4000000059604645, \"oLong\" : 43543, \"pInt\" : 43253, \"list\" : [], \"pBoolean\" : true, \"oChar\" : 18, \"num\" : \"TEST\", \"oDouble\" : 0.5, \"oInt\" : 43253, \"pLong\" : 43543, \"string\" : \"affe\", \"intArray\" : [1,2], \"map\" : {}, \"objArray\" : null, \"pByte\" : 36, \"obj\" : null}], \"pByte\" : 20, \"obj\" : null}", "{\"OBoolean\":false,\"pChar\":19,\"pDouble\":0.3,\"oByte\":68,\"pFloat\":0.4230000078678131,\"oFloat\":0.4122999906539917,\"oLong\":5435443543,\"pInt\":2435253,\"list\":[1,2,3],\"pBoolean\":false,\"oChar\":16,\"num\":\"BLUMM\",\"oDouble\":0.52,\"oInt\":45343253,\"pLong\":4355543543,\"string\":\"affe232\",\"intArray\":[3,2,1],\"map\":{\"3\":{\"oBoolean\":false,\"pChar\":19,\"pDouble\":0.3,\"oByte\":68,\"pFloat\":0.4230000078678131,\"oFloat\":0.4122999906539917,\"oLong\":5435443543,\"pInt\":2435253,\"list\":[],\"pBoolean\":false,\"oChar\":16,\"num\":\"BLUMM\",\"oDouble\":0.52,\"oInt\":45343253,\"pLong\":4355543543,\"string\":\"affe232\",\"intArray\":[3,2,1],\"map\":{},\"objArray\":[{\"oBoolean\":true,\"pChar\":18,\"pDouble\":0.5,\"oByte\":36,\"pFloat\":0.4000000059604645,\"oFloat\":0.4000000059604645,\"oLong\":43543,\"pInt\":43253,\"list\":[],\"pBoolean\":true,\"oChar\":18,\"num\":\"TEST\",\"oDouble\":0.5,\"oInt\":43253,\"pLong\":43543,\"string\":\"affe\",\"intArray\":[1,2],\"map\":{},\"objArray\":null,\"pByte\":36,\"obj\":null},{\"oBoolean\":true,\"pChar\":18,\"pDouble\":0.5,\"oByte\":36,\"pFloat\":0.4000000059604645,\"oFloat\":0.4000000059604645,\"oLong\":43543,\"pInt\":43253,\"list\":[],\"pBoolean\":true,\"oChar\":18,\"num\":\"TEST\",\"oDouble\":0.5,\"oInt\":43253,\"pLong\":43543,\"string\":\"affe\",\"intArray\":[1,2],\"map\":{},\"objArray\":null,\"pByte\":36,\"obj\":null},{\"oBoolean\":true,\"pChar\":18,\"pDouble\":0.5,\"oByte\":36,\"pFloat\":0.4000000059604645,\"oFloat\":0.4000000059604645,\"oLong\":43543,\"pInt\":43253,\"list\":[],\"pBoolean\":true,\"oChar\":18,\"num\":\"TEST\",\"oDouble\":0.5,\"oInt\":43253,\"pLong\":43543,\"string\":\"affe\",\"intArray\":[1,2],\"map\":{},\"objArray\":null,\"pByte\":36,\"obj\":null}],\"pByte\":20,\"obj\":null},\"2\":{\"oBoolean\":false,\"pChar\":19,\"pDouble\":0.3,\"oByte\":68,\"pFloat\":0.4230000078678131,\"oFloat\":0.4122999906539917,\"oLong\":5435443543,\"pInt\":2435253,\"list\":[],\"pBoolean\":false,\"oChar\":16,\"num\":\"BLUMM\",\"oDouble\":0.52,\"oInt\":45343253,\"pLong\":4355543543,\"string\":\"affe232\",\"intArray\":[3,2,1],\"map\":{},\"objArray\":[{\"oBoolean\":true,\"pChar\":18,\"pDouble\":0.5,\"oByte\":36,\"pFloat\":0.4000000059604645,\"oFloat\":0.4000000059604645,\"oLong\":43543,\"pInt\":43253,\"list\":[],\"pBoolean\":true,\"oChar\":18,\"num\":\"TEST\",\"oDouble\":0.5,\"oInt\":43253,\"pLong\":43543,\"string\":\"affe\",\"intArray\":[1,2],\"map\":{},\"objArray\":null,\"pByte\":36,\"obj\":null},{\"oBoolean\":true,\"pChar\":18,\"pDouble\":0.5,\"oByte\":36,\"pFloat\":0.4000000059604645,\"oFloat\":0.4000000059604645,\"oLong\":43543,\"pInt\":43253,\"list\":[],\"pBoolean\":true,\"oChar\":18,\"num\":\"TEST\",\"oDouble\":0.5,\"oInt\":43253,\"pLong\":43543,\"string\":\"affe\",\"intArray\":[1,2],\"map\":{},\"objArray\":null,\"pByte\":36,\"obj\":null},{\"oBoolean\":true,\"pChar\":18,\"pDouble\":0.5,\"oByte\":36,\"pFloat\":0.4000000059604645,\"oFloat\":0.4000000059604645,\"oLong\":43543,\"pInt\":43253,\"list\":[],\"pBoolean\":true,\"oChar\":18,\"num\":\"TEST\",\"oDouble\":0.5,\"oInt\":43253,\"pLong\":43543,\"string\":\"affe\",\"intArray\":[1,2],\"map\":{},\"objArray\":null,\"pByte\":36,\"obj\":null}],\"pByte\":20,\"obj\":null},\"5\":{\"oBoolean\":false,\"pChar\":19,\"pDouble\":0.3,\"oByte\":68,\"pFloat\":0.4230000078678131,\"oFloat\":0.4122999906539917,\"oLong\":5435443543,\"pInt\":2435253,\"list\":[],\"pBoolean\":false,\"oChar\":16,\"num\":\"BLUMM\",\"oDouble\":0.52,\"oInt\":45343253,\"pLong\":4355543543,\"string\":\"affe232\",\"intArray\":[3,2,1],\"map\":{},\"objArray\":[{\"oBoolean\":true,\"pChar\":18,\"pDouble\":0.5,\"oByte\":36,\"pFloat\":0.4000000059604645,\"oFloat\":0.4000000059604645,\"oLong\":43543,\"pInt\":43253,\"list\":[],\"pBoolean\":true,\"oChar\":18,\"num\":\"TEST\",\"oDouble\":0.5,\"oInt\":43253,\"pLong\":43543,\"string\":\"affe\",\"intArray\":[1,2],\"map\":{},\"objArray\":null,\"pByte\":36,\"obj\":null},{\"oBoolean\":true,\"pChar\":18,\"pDouble\":0.5,\"oByte\":36,\"pFloat\":0.4000000059604645,\"oFloat\":0.4000000059604645,\"oLong\":43543,\"pInt\":43253,\"list\":[],\"pBoolean\":true,\"oChar\":18,\"num\":\"TEST\",\"oDouble\":0.5,\"oInt\":43253,\"pLong\":43543,\"string\":\"affe\",\"intArray\":[1,2],\"map\":{},\"objArray\":null,\"pByte\":36,\"obj\":null},{\"oBoolean\":true,\"pChar\":18,\"pDouble\":0.5,\"oByte\":36,\"pFloat\":0.4000000059604645,\"oFloat\":0.4000000059604645,\"oLong\":43543,\"pInt\":43253,\"list\":[],\"pBoolean\":true,\"oChar\":18,\"num\":\"TEST\",\"oDouble\":0.5,\"oInt\":43253,\"pLong\":43543,\"string\":\"affe\",\"intArray\":[1,2],\"map\":{},\"objArray\":null,\"pByte\":36,\"obj\":null}],\"pByte\":20,\"obj\":null},\"4\":{\"oBoolean\":false,\"pChar\":19,\"pDouble\":0.3,\"oByte\":68,\"pFloat\":0.4230000078678131,\"oFloat\":0.4122999906539917,\"oLong\":5435443543,\"pInt\":2435253,\"list\":[],\"pBoolean\":false,\"oChar\":16,\"num\":\"BLUMM\",\"oDouble\":0.52,\"oInt\":45343253,\"pLong\":4355543543,\"string\":\"affe232\",\"intArray\":[3,2,1],\"map\":{},\"objArray\":[{\"oBoolean\":true,\"pChar\":18,\"pDouble\":0.5,\"oByte\":36,\"pFloat\":0.4000000059604645,\"oFloat\":0.4000000059604645,\"oLong\":43543,\"pInt\":43253,\"list\":[],\"pBoolean\":true,\"oChar\":18,\"num\":\"TEST\",\"oDouble\":0.5,\"oInt\":43253,\"pLong\":43543,\"string\":\"affe\",\"intArray\":[1,2],\"map\":{},\"objArray\":null,\"pByte\":36,\"obj\":null},{\"oBoolean\":true,\"pChar\":18,\"pDouble\":0.5,\"oByte\":36,\"pFloat\":0.4000000059604645,\"oFloat\":0.4000000059604645,\"oLong\":43543,\"pInt\":43253,\"list\":[],\"pBoolean\":true,\"oChar\":18,\"num\":\"TEST\",\"oDouble\":0.5,\"oInt\":43253,\"pLong\":43543,\"string\":\"affe\",\"intArray\":[1,2],\"map\":{},\"objArray\":null,\"pByte\":36,\"obj\":null},{\"oBoolean\":true,\"pChar\":18,\"pDouble\":0.5,\"oByte\":36,\"pFloat\":0.4000000059604645,\"oFloat\":0.4000000059604645,\"oLong\":43543,\"pInt\":43253,\"list\":[],\"pBoolean\":true,\"oChar\":18,\"num\":\"TEST\",\"oDouble\":0.5,\"oInt\":43253,\"pLong\":43543,\"string\":\"affe\",\"intArray\":[1,2],\"map\":{},\"objArray\":null,\"pByte\":36,\"obj\":null}],\"pByte\":20,\"obj\":null}},\"objArray\":[{\"oBoolean\":true,\"pChar\":18,\"pDouble\":0.5,\"oByte\":36,\"pFloat\":0.4000000059604645,\"oFloat\":0.4000000059604645,\"oLong\":43543,\"pInt\":43253,\"list\":[],\"pBoolean\":true,\"oChar\":18,\"num\":\"TEST\",\"oDouble\":0.5,\"oInt\":43253,\"pLong\":43543,\"string\":\"affe\",\"intArray\":[1,2],\"map\":{},\"objArray\":null,\"pByte\":36,\"obj\":null},{\"oBoolean\":true,\"pChar\":18,\"pDouble\":0.5,\"oByte\":36,\"pFloat\":0.4000000059604645,\"oFloat\":0.4000000059604645,\"oLong\":43543,\"pInt\":43253,\"list\":[],\"pBoolean\":true,\"oChar\":18,\"num\":\"TEST\",\"oDouble\":0.5,\"oInt\":43253,\"pLong\":43543,\"string\":\"affe\",\"intArray\":[1,2],\"map\":{},\"objArray\":null,\"pByte\":36,\"obj\":null},{\"oBoolean\":true,\"pChar\":18,\"pDouble\":0.5,\"oByte\":36,\"pFloat\":0.4000000059604645,\"oFloat\":0.4000000059604645,\"oLong\":43543,\"pInt\":43253,\"list\":[],\"pBoolean\":true,\"oChar\":18,\"num\":\"TEST\",\"oDouble\":0.5,\"oInt\":43253,\"pLong\":43543,\"string\":\"affe\",\"intArray\":[1,2],\"map\":{},\"objArray\":null,\"pByte\":36,\"obj\":null}],\"pByte\":20,\"obj\":null}", "{\r\n  \"OBoolean\":false,\r\n  \"pChar\":19,\r\n  \"pDouble\":0.3,\r\n  \"oByte\":68,\r\n  \"pFloat\":0.4230000078678131,\r\n  \"oFloat\":0.4122999906539917,\r\n  \"oLong\":5435443543,\r\n  \"pInt\":2435253,\r\n  \"list\":[1, 2, 3],\r\n  \"pBoolean\":false,\r\n  \"oChar\":16,\r\n  \"num\":\"BLUMM\",\r\n  \"oDouble\":0.52,\r\n  \"oInt\":45343253,\r\n  \"pLong\":4355543543,\r\n  \"string\":\"affe232\",\r\n  \"intArray\":[3, 2, 1],\r\n  \"map\":{\r\n    \"3\":{\r\n      \"oBoolean\":false,\r\n      \"pChar\":19,\r\n      \"pDouble\":0.3,\r\n      \"oByte\":68,\r\n      \"pFloat\":0.4230000078678131,\r\n      \"oFloat\":0.4122999906539917,\r\n      \"oLong\":5435443543,\r\n      \"pInt\":2435253,\r\n      \"list\":[],\r\n      \"pBoolean\":false,\r\n      \"oChar\":16,\r\n      \"num\":\"BLUMM\",\r\n      \"oDouble\":0.52,\r\n      \"oInt\":45343253,\r\n      \"pLong\":4355543543,\r\n      \"string\":\"affe232\",\r\n      \"intArray\":[3, 2, 1],\r\n      \"map\":{},\r\n      \"objArray\":[\r\n        {\r\n          \"oBoolean\":true,\r\n          \"pChar\":18,\r\n          \"pDouble\":0.5,\r\n          \"oByte\":36,\r\n          \"pFloat\":0.4000000059604645,\r\n          \"oFloat\":0.4000000059604645,\r\n          \"oLong\":43543,\r\n          \"pInt\":43253,\r\n          \"list\":[],\r\n          \"pBoolean\":true,\r\n          \"oChar\":18,\r\n          \"num\":\"TEST\",\r\n          \"oDouble\":0.5,\r\n          \"oInt\":43253,\r\n          \"pLong\":43543,\r\n          \"string\":\"affe\",\r\n          \"intArray\":[1, 2],\r\n          \"map\":{},\r\n          \"objArray\":null,\r\n          \"pByte\":36,\r\n          \"obj\":null\r\n        },\r\n        {\r\n          \"oBoolean\":true,\r\n          \"pChar\":18,\r\n          \"pDouble\":0.5,\r\n          \"oByte\":36,\r\n          \"pFloat\":0.4000000059604645,\r\n          \"oFloat\":0.4000000059604645,\r\n          \"oLong\":43543,\r\n          \"pInt\":43253,\r\n          \"list\":[],\r\n          \"pBoolean\":true,\r\n          \"oChar\":18,\r\n          \"num\":\"TEST\",\r\n          \"oDouble\":0.5,\r\n          \"oInt\":43253,\r\n          \"pLong\":43543,\r\n          \"string\":\"affe\",\r\n          \"intArray\":[1, 2],\r\n          \"map\":{},\r\n          \"objArray\":null,\r\n          \"pByte\":36,\r\n          \"obj\":null\r\n        },\r\n        {\r\n          \"oBoolean\":true,\r\n          \"pChar\":18,\r\n          \"pDouble\":0.5,\r\n          \"oByte\":36,\r\n          \"pFloat\":0.4000000059604645,\r\n          \"oFloat\":0.4000000059604645,\r\n          \"oLong\":43543,\r\n          \"pInt\":43253,\r\n          \"list\":[],\r\n          \"pBoolean\":true,\r\n          \"oChar\":18,\r\n          \"num\":\"TEST\",\r\n          \"oDouble\":0.5,\r\n          \"oInt\":43253,\r\n          \"pLong\":43543,\r\n          \"string\":\"affe\",\r\n          \"intArray\":[1, 2],\r\n          \"map\":{},\r\n          \"objArray\":null,\r\n          \"pByte\":36,\r\n          \"obj\":null\r\n        }\r\n      ],\r\n      \"pByte\":20,\r\n      \"obj\":null\r\n    },\r\n    \"2\":{\r\n      \"oBoolean\":false,\r\n      \"pChar\":19,\r\n      \"pDouble\":0.3,\r\n      \"oByte\":68,\r\n      \"pFloat\":0.4230000078678131,\r\n      \"oFloat\":0.4122999906539917,\r\n      \"oLong\":5435443543,\r\n      \"pInt\":2435253,\r\n      \"list\":[],\r\n      \"pBoolean\":false,\r\n      \"oChar\":16,\r\n      \"num\":\"BLUMM\",\r\n      \"oDouble\":0.52,\r\n      \"oInt\":45343253,\r\n      \"pLong\":4355543543,\r\n      \"string\":\"affe232\",\r\n      \"intArray\":[3, 2, 1],\r\n      \"map\":{},\r\n      \"objArray\":[\r\n        {\r\n          \"oBoolean\":true,\r\n          \"pChar\":18,\r\n          \"pDouble\":0.5,\r\n          \"oByte\":36,\r\n          \"pFloat\":0.4000000059604645,\r\n          \"oFloat\":0.4000000059604645,\r\n          \"oLong\":43543,\r\n          \"pInt\":43253,\r\n          \"list\":[],\r\n          \"pBoolean\":true,\r\n          \"oChar\":18,\r\n          \"num\":\"TEST\",\r\n          \"oDouble\":0.5,\r\n          \"oInt\":43253,\r\n          \"pLong\":43543,\r\n          \"string\":\"affe\",\r\n          \"intArray\":[1, 2],\r\n          \"map\":{},\r\n          \"objArray\":null,\r\n          \"pByte\":36,\r\n          \"obj\":null\r\n        },\r\n        {\r\n          \"oBoolean\":true,\r\n          \"pChar\":18,\r\n          \"pDouble\":0.5,\r\n          \"oByte\":36,\r\n          \"pFloat\":0.4000000059604645,\r\n          \"oFloat\":0.4000000059604645,\r\n          \"oLong\":43543,\r\n          \"pInt\":43253,\r\n          \"list\":[],\r\n          \"pBoolean\":true,\r\n          \"oChar\":18,\r\n          \"num\":\"TEST\",\r\n          \"oDouble\":0.5,\r\n          \"oInt\":43253,\r\n          \"pLong\":43543,\r\n          \"string\":\"affe\",\r\n          \"intArray\":[1, 2],\r\n          \"map\":{},\r\n          \"objArray\":null,\r\n          \"pByte\":36,\r\n          \"obj\":null\r\n        },\r\n        {\r\n          \"oBoolean\":true,\r\n          \"pChar\":18,\r\n          \"pDouble\":0.5,\r\n          \"oByte\":36,\r\n          \"pFloat\":0.4000000059604645,\r\n          \"oFloat\":0.4000000059604645,\r\n          \"oLong\":43543,\r\n          \"pInt\":43253,\r\n          \"list\":[],\r\n          \"pBoolean\":true,\r\n          \"oChar\":18,\r\n          \"num\":\"TEST\",\r\n          \"oDouble\":0.5,\r\n          \"oInt\":43253,\r\n          \"pLong\":43543,\r\n          \"string\":\"affe\",\r\n          \"intArray\":[1, 2],\r\n          \"map\":{},\r\n          \"objArray\":null,\r\n          \"pByte\":36,\r\n          \"obj\":null\r\n        }\r\n      ],\r\n      \"pByte\":20,\r\n      \"obj\":null\r\n    },\r\n    \"5\":{\r\n      \"oBoolean\":false,\r\n      \"pChar\":19,\r\n      \"pDouble\":0.3,\r\n      \"oByte\":68,\r\n      \"pFloat\":0.4230000078678131,\r\n      \"oFloat\":0.4122999906539917,\r\n      \"oLong\":5435443543,\r\n      \"pInt\":2435253,\r\n      \"list\":[],\r\n      \"pBoolean\":false,\r\n      \"oChar\":16,\r\n      \"num\":\"BLUMM\",\r\n      \"oDouble\":0.52,\r\n      \"oInt\":45343253,\r\n      \"pLong\":4355543543,\r\n      \"string\":\"affe232\",\r\n      \"intArray\":[3, 2, 1],\r\n      \"map\":{},\r\n      \"objArray\":[\r\n        {\r\n          \"oBoolean\":true,\r\n          \"pChar\":18,\r\n          \"pDouble\":0.5,\r\n          \"oByte\":36,\r\n          \"pFloat\":0.4000000059604645,\r\n          \"oFloat\":0.4000000059604645,\r\n          \"oLong\":43543,\r\n          \"pInt\":43253,\r\n          \"list\":[],\r\n          \"pBoolean\":true,\r\n          \"oChar\":18,\r\n          \"num\":\"TEST\",\r\n          \"oDouble\":0.5,\r\n          \"oInt\":43253,\r\n          \"pLong\":43543,\r\n          \"string\":\"affe\",\r\n          \"intArray\":[1, 2],\r\n          \"map\":{},\r\n          \"objArray\":null,\r\n          \"pByte\":36,\r\n          \"obj\":null\r\n        },\r\n        {\r\n          \"oBoolean\":true,\r\n          \"pChar\":18,\r\n          \"pDouble\":0.5,\r\n          \"oByte\":36,\r\n          \"pFloat\":0.4000000059604645,\r\n          \"oFloat\":0.4000000059604645,\r\n          \"oLong\":43543,\r\n          \"pInt\":43253,\r\n          \"list\":[],\r\n          \"pBoolean\":true,\r\n          \"oChar\":18,\r\n          \"num\":\"TEST\",\r\n          \"oDouble\":0.5,\r\n          \"oInt\":43253,\r\n          \"pLong\":43543,\r\n          \"string\":\"affe\",\r\n          \"intArray\":[1, 2],\r\n          \"map\":{},\r\n          \"objArray\":null,\r\n          \"pByte\":36,\r\n          \"obj\":null\r\n        },\r\n        {\r\n          \"oBoolean\":true,\r\n          \"pChar\":18,\r\n          \"pDouble\":0.5,\r\n          \"oByte\":36,\r\n          \"pFloat\":0.4000000059604645,\r\n          \"oFloat\":0.4000000059604645,\r\n          \"oLong\":43543,\r\n          \"pInt\":43253,\r\n          \"list\":[],\r\n          \"pBoolean\":true,\r\n          \"oChar\":18,\r\n          \"num\":\"TEST\",\r\n          \"oDouble\":0.5,\r\n          \"oInt\":43253,\r\n          \"pLong\":43543,\r\n          \"string\":\"affe\",\r\n          \"intArray\":[1, 2],\r\n          \"map\":{},\r\n          \"objArray\":null,\r\n          \"pByte\":36,\r\n          \"obj\":null\r\n        }\r\n      ],\r\n      \"pByte\":20,\r\n      \"obj\":null\r\n    },\r\n    \"4\":{\r\n      \"oBoolean\":false,\r\n      \"pChar\":19,\r\n      \"pDouble\":0.3,\r\n      \"oByte\":68,\r\n      \"pFloat\":0.4230000078678131,\r\n      \"oFloat\":0.4122999906539917,\r\n      \"oLong\":5435443543,\r\n      \"pInt\":2435253,\r\n      \"list\":[],\r\n      \"pBoolean\":false,\r\n      \"oChar\":16,\r\n      \"num\":\"BLUMM\",\r\n      \"oDouble\":0.52,\r\n      \"oInt\":45343253,\r\n      \"pLong\":4355543543,\r\n      \"string\":\"affe232\",\r\n      \"intArray\":[3, 2, 1],\r\n      \"map\":{},\r\n      \"objArray\":[\r\n        {\r\n          \"oBoolean\":true,\r\n          \"pChar\":18,\r\n          \"pDouble\":0.5,\r\n          \"oByte\":36,\r\n          \"pFloat\":0.4000000059604645,\r\n          \"oFloat\":0.4000000059604645,\r\n          \"oLong\":43543,\r\n          \"pInt\":43253,\r\n          \"list\":[],\r\n          \"pBoolean\":true,\r\n          \"oChar\":18,\r\n          \"num\":\"TEST\",\r\n          \"oDouble\":0.5,\r\n          \"oInt\":43253,\r\n          \"pLong\":43543,\r\n          \"string\":\"affe\",\r\n          \"intArray\":[1, 2],\r\n          \"map\":{},\r\n          \"objArray\":null,\r\n          \"pByte\":36,\r\n          \"obj\":null\r\n        },\r\n        {\r\n          \"oBoolean\":true,\r\n          \"pChar\":18,\r\n          \"pDouble\":0.5,\r\n          \"oByte\":36,\r\n          \"pFloat\":0.4000000059604645,\r\n          \"oFloat\":0.4000000059604645,\r\n          \"oLong\":43543,\r\n          \"pInt\":43253,\r\n          \"list\":[],\r\n          \"pBoolean\":true,\r\n          \"oChar\":18,\r\n          \"num\":\"TEST\",\r\n          \"oDouble\":0.5,\r\n          \"oInt\":43253,\r\n          \"pLong\":43543,\r\n          \"string\":\"affe\",\r\n          \"intArray\":[1, 2],\r\n          \"map\":{},\r\n          \"objArray\":null,\r\n          \"pByte\":36,\r\n          \"obj\":null\r\n        },\r\n        {\r\n          \"oBoolean\":true,\r\n          \"pChar\":18,\r\n          \"pDouble\":0.5,\r\n          \"oByte\":36,\r\n          \"pFloat\":0.4000000059604645,\r\n          \"oFloat\":0.4000000059604645,\r\n          \"oLong\":43543,\r\n          \"pInt\":43253,\r\n          \"list\":[],\r\n          \"pBoolean\":true,\r\n          \"oChar\":18,\r\n          \"num\":\"TEST\",\r\n          \"oDouble\":0.5,\r\n          \"oInt\":43253,\r\n          \"pLong\":43543,\r\n          \"string\":\"affe\",\r\n          \"intArray\":[1, 2],\r\n          \"map\":{},\r\n          \"objArray\":null,\r\n          \"pByte\":36,\r\n          \"obj\":null\r\n        }\r\n      ],\r\n      \"pByte\":20,\r\n      \"obj\":null\r\n    }\r\n  },\r\n  \"objArray\":[\r\n    {\r\n      \"oBoolean\":true,\r\n      \"pChar\":18,\r\n      \"pDouble\":0.5,\r\n      \"oByte\":36,\r\n      \"pFloat\":0.4000000059604645,\r\n      \"oFloat\":0.4000000059604645,\r\n      \"oLong\":43543,\r\n      \"pInt\":43253,\r\n      \"list\":[],\r\n      \"pBoolean\":true,\r\n      \"oChar\":18,\r\n      \"num\":\"TEST\",\r\n      \"oDouble\":0.5,\r\n      \"oInt\":43253,\r\n      \"pLong\":43543,\r\n      \"string\":\"affe\",\r\n      \"intArray\":[1, 2],\r\n      \"map\":{},\r\n      \"objArray\":null,\r\n      \"pByte\":36,\r\n      \"obj\":null\r\n    },\r\n    {\r\n      \"oBoolean\":true,\r\n      \"pChar\":18,\r\n      \"pDouble\":0.5,\r\n      \"oByte\":36,\r\n      \"pFloat\":0.4000000059604645,\r\n      \"oFloat\":0.4000000059604645,\r\n      \"oLong\":43543,\r\n      \"pInt\":43253,\r\n      \"list\":[],\r\n      \"pBoolean\":true,\r\n      \"oChar\":18,\r\n      \"num\":\"TEST\",\r\n      \"oDouble\":0.5,\r\n      \"oInt\":43253,\r\n      \"pLong\":43543,\r\n      \"string\":\"affe\",\r\n      \"intArray\":[1, 2],\r\n      \"map\":{},\r\n      \"objArray\":null,\r\n      \"pByte\":36,\r\n      \"obj\":null\r\n    },\r\n    {\r\n      \"oBoolean\":true,\r\n      \"pChar\":18,\r\n      \"pDouble\":0.5,\r\n      \"oByte\":36,\r\n      \"pFloat\":0.4000000059604645,\r\n      \"oFloat\":0.4000000059604645,\r\n      \"oLong\":43543,\r\n      \"pInt\":43253,\r\n      \"list\":[],\r\n      \"pBoolean\":true,\r\n      \"oChar\":18,\r\n      \"num\":\"TEST\",\r\n      \"oDouble\":0.5,\r\n      \"oInt\":43253,\r\n      \"pLong\":43543,\r\n      \"string\":\"affe\",\r\n      \"intArray\":[1, 2],\r\n      \"map\":{},\r\n      \"objArray\":null,\r\n      \"pByte\":36,\r\n      \"obj\":null\r\n    }\r\n  ],\r\n  \"pByte\":20,\r\n  \"obj\":null\r\n}", new ParsingError[0]);
        ParserTest.expectError("-    23.432e-4", "-0.0023432", "-0.0023432", new ParsingError[0]);
        ParserTest.expectError("+    23.432e-4", "0.0023432", "0.0023432", ParsingError.ERROR_NUMBERFORMAT_LEADING_PLUS);
        ParserTest.expectError("23.432e-4", "0.0023432", "0.0023432", new ParsingError[0]);
        ParserTest.expectError("[23.432e-4]", "[0.0023432]", "[0.0023432]", new ParsingError[0]);
        ParserTest.expectError("{}", "{}", "{}", new ParsingError[0]);
        ParserTest.expectError("{key:\"inner \\\" Object {} test\"}", "{\"key\":\"inner \\\" Object {} test\"}", "{\"key\":\"inner \\\" Object {} test\"}", STWQ, KWQ);
        ParserTest.expectError("{key:with\r\nunescapednewline}", "{\"key\":\"with\\r\\nunescapednewline\"}", "{\"key\":\"with\\r\\nunescapednewline\"}", STWQ, KWQ, SVWQ);
        ParserTest.expectError("{key:with\\r\\nescapednewline}", "{\"key\":\"with\\\\r\\\\nescapednewline\"}", "{\"key\":\"with\\\\r\\\\nescapednewline\"}", STWQ, KWQ, SVWQ, ParsingError.EXPECTED_VALID_ESCAPE_CHARACTER);
        ParserTest.expectError("{key:with\"quotes}", "{\"key\":\"with\\\"quotes\"}", "{\"key\":\"with\\\"quotes\"}", STWQ, KWQ, SVWQ);
        ParserTest.expectError("{key:spaces in pseudo String,key2:newvalue}", "{\"key\":\"spaces in pseudo String\",\"key2\":\"newvalue\"}", "{\r\n  \"key\":\"spaces in pseudo String\",\r\n  \"key2\":\"newvalue\"\r\n}", STWQ, KWQ, SVWQ);
        ParserTest.expectError("{key:\"value\"}", "{\"key\":\"value\"}", "{\"key\":\"value\"}", STWQ, KWQ);
        ParserTest.expectError("{key:value}", "{\"key\":\"value\"}", "{\"key\":\"value\"}", STWQ, KWQ, SVWQ);
        ParserTest.expectError("{key:true}", "{\"key\":true}", "{\"key\":true}", STWQ, KWQ);
        ParserTest.expectError("[true,false,null,1,affenbaum]", "[true,false,null,1,\"affenbaum\"]", "[true, false, null, 1, \"affenbaum\"]", STWQ, SVWQ);
        ParserTest.expectError("[true,false,{},1,affenbaum]", "[true,false,{},1,\"affenbaum\"]", "[\r\n  true,\r\n  false,\r\n  {},\r\n  1,\r\n  \"affenbaum\"\r\n]", STWQ, SVWQ);
        ParserTest.expectError("[true,false,{},-  1,affenbaum]", "[true,false,{},-1,\"affenbaum\"]", "[\r\n  true,\r\n  false,\r\n  {},\r\n  -1,\r\n  \"affenbaum\"\r\n]", STWQ, SVWQ);
        ParserTest.expectError("[true,false,{},23.432e-4,affenbaum]", "[true,false,{},0.0023432,\"affenbaum\"]", "[\r\n  true,\r\n  false,\r\n  {},\r\n  0.0023432,\r\n  \"affenbaum\"\r\n]", STWQ, SVWQ);
        ParserTest.expectError("[true,false,{},[-    23.432e-4],affenbaum]", "[true,false,{},[-0.0023432],\"affenbaum\"]", "[\r\n  true,\r\n  false,\r\n  {},\r\n  [-0.0023432],\r\n  \"affenbaum\"\r\n]", STWQ, SVWQ);
        ParserTest.expectError("{1:true}", "{\"1\":true}", "{\"1\":true}", KWQ, ParsingError.ERROR_KEY_IS_NUMBER);
        ParserTest.expectError("{true:true}", "{\"true\":true}", "{\"true\":true}", KWQ, ParsingError.ERROR_KEY_IS_BOOLEAN);
        ParserTest.expectError("342.187124E-3", "0.342187124", "0.342187124", new ParsingError[0]);
        ParserTest.expectError("value", "\"value\"", "\"value\"", ParsingError.ERROR_STRING_TOKEN_WITHOUT_QUOTES, ParsingError.ERROR_STRING_VALUE_WITHOUT_QUOTES);
        ParserTest.expectError("true", "true", "true", new ParsingError[0]);
        ParserTest.expectError("false", "false", "false", new ParsingError[0]);
        ParserTest.expectError("null", "null", "null", new ParsingError[0]);
        ParserTest.expectError("\"true\"", "\"true\"", "\"true\"", new ParsingError[0]);
        ParserTest.expectError("12", "12", "12", new ParsingError[0]);
        ParserTest.expectError("[\r", "[]", "[]", ParsingError.EXPECTED_ARRAY_VALUE_COMMA_OR_ARRAY_CLOSE_TAG);
        ParserTest.expectError("{value : 2", "{\"value\":2}", "{\"value\":2}", ParsingError.ERROR_STRING_TOKEN_WITHOUT_QUOTES, ParsingError.ERROR_KEY_WITHOUT_QUOTES, ParsingError.EXPECTED_COMMA_OR_OBJECT_END_TAG);
        ParserTest.expectError("[\r\n {\r\n  \"map\"              : {\r\n                        \"2\" : {\r\n                               \"map\"              : {},\r\n                               \"string\"           : \"affe232\",\r\n                               \"genericLongClass\" : {\r\n                                                     \"key\"   : 1,\r\n                                                     \"value\" : 2", "[{\"map\":{\"2\":{\"map\":{},\"string\":\"affe232\",\"genericLongClass\":{\"key\":1,\"value\":2}}}}]", "[{\r\n  \"map\":{\r\n    \"2\":{\r\n      \"map\":{},\r\n      \"string\":\"affe232\",\r\n      \"genericLongClass\":{\r\n        \"key\":1,\r\n        \"value\":2\r\n      }\r\n    }\r\n  }\r\n}]", ParsingError.EXPECTED_COMMA_OR_OBJECT_END_TAG, ParsingError.EXPECTED_COMMA_OR_ARRAY_END_TAG);
        ParserTest.expectError("[\r\n {\r\n  \"map\"              : {\r\n                        \"2\" : {\r\n                               \"map\"              : {},\r\n                               \"string\"           : \"affe232\"", "[{\"map\":{\"2\":{\"map\":{},\"string\":\"affe232\"}}}]", "[{\r\n  \"map\":{\r\n    \"2\":{\r\n      \"map\":{},\r\n      \"string\":\"affe232\"\r\n    }\r\n  }\r\n}]", ParsingError.EXPECTED_COMMA_OR_OBJECT_END_TAG, ParsingError.EXPECTED_COMMA_OR_ARRAY_END_TAG);
        ParserTest.expectError("[   ", "[]", "[]", ParsingError.EXPECTED_ARRAY_VALUE_COMMA_OR_ARRAY_CLOSE_TAG);
        ParserTest.expectError("[[1],[2]", "[[1],[2]]", "[\r\n  [1],\r\n  [2]\r\n]", ParsingError.EXPECTED_COMMA_OR_ARRAY_END_TAG);
        ParserTest.expectError("'1''2'", "[\"1\",\"2\"]", "[\"1\", \"2\"]", ParsingError.ERROR_STRING_VALUE_WITH_SINGLE_QUOTES, ParsingError.ERROR_MULTIPLE_ELEMENTS_IN_JSON_STRING, ParsingError.ERROR_UNEXPECTED_CONTENT_AFTER_END_OF_JSON, ParsingError.ERROR_STRING_TOKEN_WITH_SINGLE_QUOTES);
        ParserTest.expectError("[1][2]", "[[1],[2]]", "[\r\n  [1],\r\n  [2]\r\n]", ParsingError.ERROR_MULTIPLE_ELEMENTS_IN_JSON_STRING, ParsingError.ERROR_UNEXPECTED_CONTENT_AFTER_END_OF_JSON);
        ParserTest.expectError("{a:1}{b:1}", "[{\"a\":1},{\"b\":1}]", "[\r\n  {\"a\":1},\r\n  {\"b\":1}\r\n]", ParsingError.ERROR_STRING_TOKEN_WITHOUT_QUOTES, ParsingError.ERROR_MULTIPLE_ELEMENTS_IN_JSON_STRING, ParsingError.ERROR_UNEXPECTED_CONTENT_AFTER_END_OF_JSON, ParsingError.ERROR_KEY_WITHOUT_QUOTES, ParsingError.ERROR_MULTIPLE_ELEMENTS_IN_JSON_STRING, ParsingError.ERROR_UNEXPECTED_CONTENT_AFTER_END_OF_JSON);
        ParserTest.expectError("{in1:{in2:{}}", "{\"in1\":{\"in2\":{}}}", "{\r\n  \"in1\":{\r\n    \"in2\":{}\r\n  }\r\n}", ParsingError.ERROR_STRING_TOKEN_WITHOUT_QUOTES, ParsingError.EXPECTED_COMMA_OR_OBJECT_END_TAG, ParsingError.ERROR_KEY_WITHOUT_QUOTES);
        ParserTest.expectError("{in1:{in2:{ar1:[[]}}", "{\"in1\":{\"in2\":{\"ar1\":[[],\"}}\"]}}}", "{\r\n  \"in1\":{\r\n    \"in2\":{\r\n      \"ar1\":[\r\n        [],\r\n        \"}}\"\r\n      ]\r\n    }\r\n  }\r\n}", ParsingError.ERROR_STRING_VALUE_WITHOUT_QUOTES, ParsingError.EXPECTED_COMMA_OR_ARRAY_END_TAG, ParsingError.ERROR_STRING_TOKEN_WITHOUT_QUOTES, ParsingError.EXPECTED_COMMA_OR_OBJECT_END_TAG, ParsingError.ERROR_KEY_WITHOUT_QUOTES);
        ParserTest.expectError("'Unicode pattern testblabla\\u1 anythign else", "\"Unicode pattern testblabla\\u0001anythign else\"", "\"Unicode pattern testblabla\\u0001anythign else\"", ParsingError.EXPECTED_UNICODE_SEQUENCE, ParsingError.ERROR_STRING_VALUE_WITH_SINGLE_QUOTES, ParsingError.EXPECTED_STRING_OR_SINGLE_QUOTE, ParsingError.ERROR_STRING_TOKEN_WITH_SINGLE_QUOTES);
        ParserTest.expectError("'this is an error", "\"this is an error\"", "\"this is an error\"", ParsingError.ERROR_STRING_VALUE_WITH_SINGLE_QUOTES, ParsingError.EXPECTED_STRING_OR_SINGLE_QUOTE, ParsingError.ERROR_STRING_TOKEN_WITH_SINGLE_QUOTES);
        ParserTest.expectError("[", "[]", "[]", ParsingError.EXPECTED_ARRAY_VALUE_COMMA_OR_ARRAY_CLOSE_TAG);
        ParserTest.expectError("[,1,\"2\" \"2\"]", "[undefined,1,\"2\",\"2\"]", "[undefined, 1, \"2\", \"2\"]", ParsingError.ERROR_LEADING_COMMA_IN_ARRAY, ParsingError.EXPECTED_COMMA_OR_ARRAY_END_TAG);
        ParserTest.expectError("[,1,\"2\" 2]", "[undefined,1,\"2\",2]", "[undefined, 1, \"2\", 2]", ParsingError.ERROR_LEADING_COMMA_IN_ARRAY, ParsingError.EXPECTED_COMMA_OR_ARRAY_END_TAG);
        ParserTest.expectError("[,1,2,", "[undefined,1,2]", "[undefined, 1, 2]", ParsingError.ERROR_LEADING_COMMA_IN_ARRAY, ParsingError.EXPECTED_ARRAY_VALUE_COMMA_OR_ARRAY_CLOSE_TAG);
        ParserTest.expectError("{", "{}", "{}", ParsingError.EXPECTED_KEY_VALUE_PAIR_COMMA_OR_OBJECT_END_TAG);
        ParserTest.expectError("{key:", "{\"key\":undefined}", "{\"key\":undefined}", ParsingError.ERROR_STRING_TOKEN_WITHOUT_QUOTES, ParsingError.EXPECTED_COMMA_OR_OBJECT_END_TAG, ParsingError.ERROR_KEY_WITHOUT_QUOTES, ParsingError.EXPECTED_ANY_VALUE);
        ParserTest.expectError("{key:1", "{\"key\":1}", "{\"key\":1}", ParsingError.ERROR_STRING_TOKEN_WITHOUT_QUOTES, ParsingError.EXPECTED_COMMA_OR_OBJECT_END_TAG, ParsingError.ERROR_KEY_WITHOUT_QUOTES);
        ParserTest.expectError("{key}", "{\"key\":undefined}", "{\"key\":undefined}", ParsingError.ERROR_STRING_TOKEN_WITHOUT_QUOTES, ParsingError.EXPECTED_COLON, ParsingError.ERROR_VALUE_INSTEAD_OF_UNDEFINED_EXPECTED, ParsingError.ERROR_KEY_WITHOUT_QUOTES);
        LogV3.info("SUCCESS: Run parsing, serializer and pretty printer Tests");
    }

    public static void main(String[] args) throws FlexiParserException, UnsupportedEncodingException, InterruptedException {
        IDETestRunner.run(ParserTest.class);
        LogV3.disableSysout();
    }

    private static void expectError(String json, String expectedStringify, String expectedPrettyPrint, final ParsingError ... errors) throws Exception {
        FlexiJSONParser parser = new FlexiJSONParser(expectedStringify).enableComments().enableExtraCommas().enableUndefinedValues().enableNaNValues().enableInfinityValues();
        FlexiJSonNode node = parser.parse();
        HashSet<ParsingError> allowSet = parser.getIgnoreIssues();
        String checkit = new FlexiJSonStringBuilder().toJSONString(node);
        ParserTest.assertEquals(checkit, expectedStringify);
        FlexiJSonNode node2 = new FlexiJSONParser(expectedPrettyPrint).setIgnoreIssues(allowSet).parse();
        String checkit2 = new FlexiJSonPrettyStringify().toJSONString(node2);
        ParserTest.assertEquals(checkit2, expectedPrettyPrint);
        FlexiJSonNode parsed = null;
        final HashSet<ParsingError> expectedErrors = new HashSet<ParsingError>(Arrays.asList(errors));
        final HashMap foundErrors = new HashMap();
        try {
            String b;
            parsed = new FlexiJSONParser(new StringReader(json)){

                @Override
                public boolean isParseInlineCommentEnabled() {
                    return Arrays.asList(errors).contains((Object)ParsingError.ERROR_INLINE_COMMENT);
                }

                @Override
                public boolean isParseLineCommentEnabled() {
                    return Arrays.asList(errors).contains((Object)ParsingError.ERROR_LINE_COMMENT);
                }

                @Override
                protected void throwParserException(ParsingError string, Object path, Throwable cause, FlexiJSonNode parent, FlexiJSonNode value) throws FlexiParserException {
                    if (!expectedErrors.contains((Object)string)) {
                        System.out.println("Unexpected Exception: " + (Object)((Object)string));
                    }
                    foundErrors.put(string, cause == null ? new Exception() : cause);
                }
            }.setDebug(new StringBuilder()).parse();
            LogV3.info("Test on " + JSonStorage.serializeToJson(json));
            for (ParsingError s : foundErrors.keySet()) {
                if (expectedErrors.contains((Object)s)) continue;
                throw new Exception(json + " Unexpected Error: " + JSonStorage.serializeToJson((Object)s), (Throwable)foundErrors.get((Object)s));
            }
            for (ParsingError s : expectedErrors) {
                if (foundErrors.containsKey((Object)s)) continue;
                throw new Exception(json + " Expected Error did not happen: " + JSonStorage.serializeToJson((Object)s));
            }
            FlexiJSonStringBuilder serializer = new FlexiJSonStringBuilder();
            String shortV = serializer.toJSONString(parsed);
            String pretty = new FlexiJSonPrettyStringify().toJSONString(parsed);
            String property = new PropertyJSonPrettyStringify().toJSONString(parsed);
            boolean contentCorrect = false;
            FlexiJSonNode reparsedStringify = new FlexiJSONParser(pretty){

                @Override
                public boolean isParseInlineCommentEnabled() {
                    return expectedErrors.contains((Object)ParsingError.ERROR_INLINE_COMMENT);
                }

                @Override
                public boolean isParseLineCommentEnabled() {
                    return expectedErrors.contains((Object)ParsingError.ERROR_LINE_COMMENT);
                }

                @Override
                protected void throwParserException(ParsingError error, Object path, Throwable cause, FlexiJSonNode parent, FlexiJSonNode value) throws FlexiParserException {
                    if (expectedErrors.contains((Object)error)) {
                        return;
                    }
                    LogV3.info((Object)((Object)error) + "");
                }
            }.setDebug(new StringBuilder()).parse();
            FlexiJSonNode reparsedPretty = new FlexiJSONParser(shortV){

                @Override
                public boolean isParseInlineCommentEnabled() {
                    return expectedErrors.contains((Object)ParsingError.ERROR_INLINE_COMMENT);
                }

                @Override
                public boolean isParseLineCommentEnabled() {
                    return expectedErrors.contains((Object)ParsingError.ERROR_LINE_COMMENT);
                }

                @Override
                protected void throwParserException(ParsingError error, Object path, Throwable cause, FlexiJSonNode parent, FlexiJSonNode value) throws FlexiParserException {
                    if (expectedErrors.contains((Object)error)) {
                        return;
                    }
                    LogV3.info((Object)((Object)error) + "");
                }
            }.setDebug(new StringBuilder()).parse();
            String a = new FlexiJSonStringBuilder().toJSONString(reparsedStringify);
            contentCorrect = a.equals(b = new FlexiJSonStringBuilder().toJSONString(reparsedPretty));
            if (contentCorrect && expectedStringify.equals(shortV) && pretty.equals(expectedPrettyPrint)) {
                LogV3.info("Pretty:\r\n" + pretty);
                LogV3.info("Stringify: " + shortV);
                LogV3.info((expectedStringify.equals(shortV) ? "SUCCESS" : "FAIL") + " Stringify Result: " + JSonStorage.serializeToJson(serializer.toJSONString(parsed)));
                LogV3.info((expectedPrettyPrint != null && pretty.equals(expectedPrettyPrint) ? "SUCCESS" : "FAIL") + " PrettyPrint Result: " + JSonStorage.serializeToJson(pretty));
                if (!expectedStringify.equals(shortV)) {
                    throw new Exception("Test Failed");
                }
                if (expectedPrettyPrint == null || !pretty.equals(expectedPrettyPrint)) {
                    throw new Exception("Test Failed");
                }
            } else {
                LogV3.info("Pretty:\r\n" + pretty + "\r\n" + pretty.replace("\r\n", "\\r\\n").replace("\"", "\\\""));
                LogV3.info("Stringify: " + shortV + "\r\n" + shortV.replace("\r\n", "\\r\\n").replace("\"", "\\\""));
                LogV3.info("Content Compare: " + (contentCorrect ? "SUCCESS" : "FAIL \r\n" + a + " \r\n" + b));
                LogV3.info((expectedStringify.equals(shortV) ? "SUCCESS" : "FAIL") + " Stringify Result: \r\n" + JSonStorage.serializeToJson(serializer.toJSONString(parsed)) + " - Expected: \r\n" + JSonStorage.serializeToJson(expectedStringify));
                LogV3.info((expectedPrettyPrint != null && pretty.equals(expectedPrettyPrint) ? "SUCCESS" : "FAIL") + " PrettyPrint Result: \r\n" + JSonStorage.serializeToJson(pretty) + " - Expected: \r\n" + JSonStorage.serializeToJson(expectedPrettyPrint));
                if (!expectedStringify.equals(shortV)) {
                    throw new Exception("Test Failed");
                }
                if (expectedPrettyPrint == null || !pretty.equals(expectedPrettyPrint)) {
                    throw new Exception("Test Failed");
                }
            }
        }
        catch (FlexiParserException e) {
            throw new Exception("FAILED no exception should happen here", e);
        }
        if (expectedErrors.size() > 0) {
            try {
                new FlexiJSONParser(new StringReader(json)).setDebug(new StringBuilder()).parse();
                throw new WTFException("Exception expected");
            }
            catch (FlexiParserException flexiParserException) {
                // empty catch block
            }
        }
        ParserTest.clearLoggerCache();
    }

    protected static void runWayToExtensiveWhateverTest() throws InterruptedException {
        LogV3.info("Run parsing invalid/incomplete JSON Tests");
        final String longJson = JSonStorage.serializeToJson(TestClass.createList());
        final ThreadPoolExecutor queue = new ThreadPoolExecutor(8, 8, 10000L, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(10000));
        final CharBuffer longJsonCharBuffer = CharBuffer.wrap(longJson);
        block4: for (int i = 1; i <= longJson.length(); ++i) {
            final int finalI = i;
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    final AtomicBoolean exception = new AtomicBoolean();
                    try {
                        CharBuffer sub = longJsonCharBuffer.subSequence(0, finalI);
                        if (finalI % 1000 == 0) {
                            LogV3.info(finalI + "/" + longJson.length() + "|" + queue.getQueue().size());
                        }
                        final HashSet exceptions = new HashSet();
                        FlexiJSonNode parsed = new FlexiJSONParser(new CharSequenceReader(sub)){

                            @Override
                            protected void throwParserException(ParsingError expected, Object path, Throwable e, FlexiJSonNode parent, FlexiJSonNode value) throws FlexiParserException {
                                exceptions.add(expected);
                                exception.set(true);
                                throw new WTFException();
                            }
                        }.setDebug(new StringBuilder()).parse();
                        if (exceptions.size() == 0 && finalI != longJson.length()) {
                            LogV3.info(JSonStorage.serializeToJson(sub));
                            LogV3.info("ERROR: Exceptions expected");
                            System.exit(1);
                        }
                    }
                    catch (WTFException e) {
                        if (!exception.get()) {
                            e.printStackTrace();
                            System.exit(1);
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        System.exit(1);
                    }
                }
            };
            while (true) {
                try {
                    queue.submit(r);
                    continue block4;
                }
                catch (RejectedExecutionException e) {
                    Thread.sleep(10L);
                    continue;
                }
                break;
            }
        }
        while (true) {
            try {
                while (queue.getQueue().size() > 0) {
                    LogV3.info("Waiting for:" + queue.getQueue().size());
                    Thread.sleep(1000L);
                }
                LogV3.info("Finished");
                Thread.sleep(1000L);
                System.exit(0);
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
        LogV3.info("SUCCESS: Run parsing invalid/incomplete JSON Tests");
    }

    @Override
    public void runPostBuildTest(String[] args, File workingDirectory) throws Exception {
        this.runTest();
    }
}

