/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.storage.tests;

import java.lang.annotation.Annotation;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.appwork.exceptions.WTFException;
import org.appwork.loggingv3.LogV3;
import org.appwork.remoteapi.annotations.AllowNonStorableObjects;
import org.appwork.remoteapi.annotations.ApiDoc;
import org.appwork.remoteapi.annotations.ApiDocExample;
import org.appwork.storage.InvalidTypeException;
import org.appwork.storage.SimpleTypeRef;
import org.appwork.storage.Storable;
import org.appwork.storage.StorableAllowPrivateAccessModifier;
import org.appwork.storage.StorableAllowProtectedAccessModifier;
import org.appwork.storage.StorableDoc;
import org.appwork.storage.StorableExample;
import org.appwork.storage.StorableHidden;
import org.appwork.storage.StorableLink;
import org.appwork.storage.StorableSee;
import org.appwork.storage.StorableValidateCondition;
import org.appwork.storage.StorableValidateMandatoryInJson;
import org.appwork.storage.StorableValidateNotNull;
import org.appwork.storage.StorableValidator;
import org.appwork.storage.StorableValidatorIgnoresMissingGetter;
import org.appwork.storage.StorableValidatorIgnoresMissingSetter;
import org.appwork.storage.flexijson.FlexiJSONParser;
import org.appwork.storage.flexijson.FlexiJSonNode;
import org.appwork.storage.flexijson.mapper.FlexiJSonMapper;
import org.appwork.storage.flexijson.mapper.FlexiJsonProperty;
import org.appwork.storage.flexijson.mapper.FlexiTypeMapper;
import org.appwork.storage.flexijson.mapper.interfacestorage.FlexiInterfaceDefault;
import org.appwork.storage.flexijson.mapper.interfacestorage.FlexiInterfaceDefaultFactory;
import org.appwork.storage.flexijson.mapper.interfacestorage.FlexiStorableInterface;
import org.appwork.storage.flexijson.mapper.typemapper.DateMapper;
import org.appwork.storage.flexijson.mapper.typemapper.TimeSpanMapper;
import org.appwork.storage.flexijson.mapper.typemapper.URLMapper;
import org.appwork.storage.simplejson.mapper.ClassCache;
import org.appwork.storage.simplejson.mapper.Getter;
import org.appwork.storage.simplejson.mapper.Setter;
import org.appwork.storage.tests.ClassPathScanner;
import org.appwork.storage.validator.classvalidator.StorableClassValidator1;
import org.appwork.storage.validator.classvalidator.StorableClassValidator2;
import org.appwork.storage.validator.classvalidator.StorableClassValidator3;
import org.appwork.testframework.AWTest;
import org.appwork.testframework.IgnoreInAWTest;
import org.appwork.utils.ReflectionUtils;
import org.appwork.utils.StringUtils;
import org.appwork.utils.duration.TimeSpan;
import org.appwork.utils.reflection.Clazz;
import org.appwork.utils.reflection.CompiledType;

public class FlexiStorageInterfaceValidatorTest
extends AWTest {
    public static void main(String[] args) {
        FlexiStorageInterfaceValidatorTest.run();
    }

    @Override
    public void runTest() throws Exception {
        new ClassPathScanner<Exception>(){

            @Override
            public void handle(Class<?> cls) throws Exception {
                if (FlexiStorableInterface.class.isAssignableFrom(cls) && FlexiStorableInterface.class != cls) {
                    FlexiStorageInterfaceValidatorTest.this.validateClass(cls);
                }
            }
        }.run();
    }

    protected boolean skipValidation(Class<?> cls) throws Exception {
        if (cls.getAnnotation(IgnoreInAWTest.class) != null) {
            return true;
        }
        return !cls.isInterface();
    }

    protected ClassCache createClassCache(Class<?> cls) throws Exception {
        return ClassCache.create(cls, new ClassCache.Rules().ignoreMissingConstructor(true));
    }

    protected void checkNoGetterSetter(ClassCache classCache, Class<?> cls) throws Exception {
        if (classCache.getKeys().size() == 0) {
            throw new Exception("The Storable " + this.link(cls) + " has no getters or setters!");
        }
    }

    protected void checkAnnotations(ClassCache classCache, Class<?> cls, Method method) throws Exception {
        Class<?> retClazz;
        Type rawType = method.getReturnType();
        if (Void.TYPE.equals(rawType)) {
            rawType = method.getGenericParameterTypes()[0];
        }
        if ((retClazz = ReflectionUtils.getRaw(rawType)) == null) {
            return;
        }
        FlexiJSonNode defaultNode = null;
        HashSet<Class<StorableHidden>> allowed = new HashSet<Class<StorableHidden>>();
        allowed.add(StorableValidateCondition.class);
        allowed.add(StorableDoc.class);
        allowed.add(StorableExample.class);
        allowed.add(ApiDocExample.class);
        allowed.add(ApiDoc.class);
        allowed.add(StorableClassValidator1.class);
        allowed.add(StorableClassValidator2.class);
        allowed.add(StorableClassValidator3.class);
        allowed.add(StorableValidateMandatoryInJson.class);
        allowed.add(StorableValidateNotNull.class);
        allowed.add(StorableHidden.class);
        for (Annotation anno : method.getAnnotations()) {
            if (allowed.contains(anno.annotationType())) continue;
            String clsName = anno.annotationType().getName();
            if (clsName.startsWith("org.appwork.storage.config.annotations")) {
                throw new Exception("here:" + cls + "|method:" + method + ": " + clsName + " is not allowed for FlexiStorableInterface. This annotation is for ConfigInterface only");
            }
            if (anno instanceof FlexiInterfaceDefault) {
                if (!((FlexiInterfaceDefault)anno).validateInTests()) continue;
                try {
                    defaultNode = new FlexiJSONParser(((FlexiInterfaceDefault)anno).value()).setIgnoreIssues(FlexiJSONParser.IGNORE_LIST_ENSURE_CORRECT_VALUES).parse();
                    continue;
                }
                catch (Exception e) {
                    throw new Exception("here:" + cls + "|method:" + method, e);
                }
            }
            if (anno instanceof FlexiInterfaceDefaultFactory) continue;
            if (anno instanceof FlexiJsonProperty) {
                if (!StringUtils.isEmpty(((FlexiJsonProperty)anno).value())) continue;
                throw new Exception("Empty JSONProperty name");
            }
            if (anno instanceof Deprecated || anno instanceof StorableValidatorIgnoresMissingGetter || anno instanceof StorableValidatorIgnoresMissingSetter || anno instanceof StorableValidateNotNull || anno instanceof StorableValidateMandatoryInJson || anno instanceof StorableLink || anno instanceof StorableSee || anno instanceof AllowNonStorableObjects) continue;
            throw new WTFException("Unexpected Annotation: " + clsName);
        }
        if (defaultNode != null) {
            FlexiJSonMapper mapper = new FlexiJSonMapper();
            mapper.setIgnoreIllegalEnumMappings(false);
            mapper.setIgnoreIllegalArgumentMappings(false);
            mapper.setIgnorePrimitiveNullMapping(false);
            if (Clazz.isPrimitive(retClazz)) {
                mapper.jsonToObject(defaultNode, new SimpleTypeRef(retClazz));
            } else if (Clazz.isEnum(retClazz)) {
                mapper.jsonToObject(defaultNode, new SimpleTypeRef(retClazz));
            } else if (Clazz.isString(retClazz)) {
                mapper.jsonToObject(defaultNode, new SimpleTypeRef(retClazz));
            } else {
                List<StorableValidator.ValidatorException> issues = new StorableValidator(defaultNode, new SimpleTypeRef(retClazz)).validate();
                if (issues.size() > 0) {
                    throw new Exception("here:" + cls + "|method:" + method + " - Storable Validation Issue: " + issues);
                }
                mapper.jsonToObject(defaultNode, new SimpleTypeRef(retClazz));
            }
        }
    }

    public void validateClass(Class<?> cls) throws Exception {
        if (this.skipValidation(cls)) {
            return;
        }
        ClassCache classCache = this.createClassCache(cls);
        if (Map.class.isAssignableFrom(cls)) {
            throw new Exception("Not Supported");
        }
        if (List.class.isAssignableFrom(cls)) {
            throw new Exception("Not Supported");
        }
        if (Set.class.isAssignableFrom(cls)) {
            throw new Exception("Not Supported");
        }
        this.checkNoGetterSetter(classCache, cls);
        for (Method m : CompiledType.create(cls).listMethods()) {
            if (!m.getName().startsWith("get") && !m.getName().startsWith("is") && !m.getName().startsWith("set")) continue;
            if (Modifier.isPrivate(m.getModifiers()) && m.getAnnotation(StorableAllowPrivateAccessModifier.class) == null) {
                throw new Exception("Found private getter or stetter without @StorableAllowPrivateAccessModifier Annotation " + m);
            }
            if (Modifier.isPrivate(m.getModifiers()) || Modifier.isPublic(m.getModifiers()) || m.getAnnotation(StorableAllowProtectedAccessModifier.class) != null) continue;
            throw new Exception("Found protected private getter or stetter without  @StorableAllowProtectedAccessModifier Annotation " + m);
        }
        for (String key : classCache.getKeys()) {
            Getter g = classCache.getGetter(key);
            Setter s = classCache.getSetter(key);
            if (g != null && g.getMethod() != null && g.getMethod().getDeclaringClass().getAnnotation(IgnoreInAWTest.class) != null || s != null && s.getMethod() != null && s.getMethod().getDeclaringClass().getAnnotation(IgnoreInAWTest.class) != null) continue;
            boolean i = false;
            for (Class<?> layer = cls; layer != null; layer = layer.getSuperclass()) {
                if (layer.getAnnotation(IgnoreInAWTest.class) != null) continue;
                for (Method m : cls.getDeclaredMethods()) {
                    if (Modifier.isStatic(m.getModifiers()) || !key.equals(ClassCache.createKey(m)) || g != null && g.getMethod().equals(m) || s != null && s.getMethod().equals(m)) continue;
                    throw new Exception("Method with name " + m + " exists multiple times with different parameters! " + cls);
                }
            }
            if (s == null && !this.hasAnnotation(classCache, key, StorableValidatorIgnoresMissingSetter.class)) {
                throw new Exception("setter " + cls.getName() + "." + key + " is missing - (" + g.getMethod().getDeclaringClass().getSimpleName() + ".java:1)");
            }
            if (g == null && !this.hasAnnotation(classCache, key, StorableValidatorIgnoresMissingGetter.class)) {
                throw new Exception("getter " + cls.getName() + "." + key + " is missing - (" + s.getMethod().getDeclaringClass().getSimpleName() + ".java:1)");
            }
            if (g != null) {
                if (g.getMethod() == null) {
                    throw new Exception("Missing public getter " + cls + "." + key + " method. public field?");
                }
                if (!Modifier.isPublic(g.getMethod().getModifiers())) {
                    throw new Exception("getter (" + g.getMethod().getDeclaringClass().getSimpleName() + ".java:1)." + g.key + " is not public " + cls);
                }
                this.checkAnnotations(classCache, cls, g.getMethod());
                try {
                    this.canStore(classCache, cls, g.getMethod(), g.getMethod().getGenericReturnType());
                }
                catch (InvalidTypeException e) {
                    LogV3.log(e);
                    throw new Exception("getter (" + g.getMethod().getDeclaringClass().getSimpleName() + ".java:1)." + g.key + " returns a non-storable object " + cls);
                }
            }
            if (s != null) {
                if (s.getMethod() == null) {
                    throw new Exception("Missing public getter " + cls + "." + g.key + " method. public field?");
                }
                if (!Modifier.isPublic(s.getMethod().getModifiers())) {
                    throw new Exception("setter " + g.getMethod().getDeclaringClass().getName() + "." + g.key + " is not public " + cls);
                }
                this.checkAnnotations(classCache, cls, s.getMethod());
                try {
                    this.canStore(classCache, cls, s.getMethod(), s.getMethod().getGenericParameterTypes()[0]);
                }
                catch (InvalidTypeException e) {
                    LogV3.log(e);
                    throw new Exception("setter " + g.getMethod().getDeclaringClass().getName() + "." + g.key + " has a non-storable parameter " + cls);
                }
            }
            if (g == null || s == null) continue;
            try {
                if (!Clazz.equalsIgnorePrimitive(g.type, s.type)) {
                    throw new Exception("setter and getter is different file types " + g.getMethod().getDeclaringClass().getName() + "." + g.key + " " + cls);
                }
                if (g.getMethod().getGenericReturnType().equals(s.getMethod().getGenericParameterTypes()[0])) continue;
                FlexiStorageInterfaceValidatorTest.logInfoAnyway("[WARNING] Primitive/Wrapper missmatch in " + s.getMethod() + "/" + g.getMethod());
            }
            catch (NullPointerException e) {
                e.printStackTrace();
            }
        }
    }

    private String link(Class<?> cls) {
        return cls.getPackage().toString() + "(" + cls.getSimpleName() + ".java:1)";
    }

    private void canStore(ClassCache classCache, final Class<?> cls, Method method, Type type) throws InvalidTypeException {
        FlexiStorageInterfaceValidatorTest.canStoreIntern(type, "", new CanStoreRules(){

            @Override
            public boolean isFollowSuperClass(Type sc) {
                return false;
            }

            @Override
            public boolean isTypeWithlisted(Type gType, Method method) {
                CompiledType ct = CompiledType.create(gType, method.getDeclaringClass());
                if (ReflectionUtils.getAnnotation(gType, IgnoreInAWTest.class) != null) {
                    return true;
                }
                AllowNonStorableObjects allowNonStorable = ReflectionUtils.getAnnotation(gType, AllowNonStorableObjects.class);
                if (ct.raw != null && allowNonStorable != null && Arrays.asList(allowNonStorable.value()).contains(ct.raw)) {
                    return true;
                }
                if (method.getDeclaringClass().getAnnotation(IgnoreInAWTest.class) != null) {
                    // empty if block
                }
                for (Class layer = cls; layer != null; layer = layer.getSuperclass()) {
                    try {
                        ClassCache layerCC = ClassCache.getClassCache(layer);
                        if (ReflectionUtils.getAnnotation(layer, IgnoreInAWTest.class) != null) {
                            return true;
                        }
                        allowNonStorable = ReflectionUtils.getAnnotation(layer, AllowNonStorableObjects.class);
                        if (ct.raw != null && allowNonStorable != null && Arrays.asList(allowNonStorable.value()).contains(ct.raw)) {
                            return true;
                        }
                        if (layerCC.getAnnotations(ClassCache.createKey(method), IgnoreInAWTest.class).size() > 0) {
                            return true;
                        }
                        for (AllowNonStorableObjects anno : layerCC.getAnnotations(ClassCache.createKey(method), AllowNonStorableObjects.class)) {
                            if (ct.raw == null || anno == null || !Arrays.asList(anno.value()).contains(ct.raw)) continue;
                            return true;
                        }
                        continue;
                    }
                    catch (NoSuchMethodException layerCC) {
                        continue;
                    }
                    catch (SecurityException layerCC) {
                        // empty catch block
                    }
                }
                if (method != null) {
                    try {
                        ClassCache cc = ClassCache.getClassCache(method.getDeclaringClass());
                        if (cc.getAnnotations(ClassCache.createKey(method), IgnoreInAWTest.class).size() > 0) {
                            return true;
                        }
                        if (cc.getAnnotations(null, IgnoreInAWTest.class).size() > 0) {
                            return true;
                        }
                        for (AllowNonStorableObjects anno : cc.getAnnotations(ClassCache.createKey(method), AllowNonStorableObjects.class)) {
                            if (!Arrays.asList(anno.value()).contains(ct.raw)) continue;
                            return true;
                        }
                        for (AllowNonStorableObjects anno : cc.getAnnotations(null, AllowNonStorableObjects.class)) {
                            if (!Arrays.asList(anno.value()).contains(ct.raw)) continue;
                            return true;
                        }
                    }
                    catch (SecurityException securityException) {
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        // empty catch block
                    }
                    if (method.getAnnotation(IgnoreInAWTest.class) != null) {
                        return true;
                    }
                    allowNonStorable = method.getAnnotation(AllowNonStorableObjects.class);
                    if (allowNonStorable != null && Arrays.asList(allowNonStorable.value()).contains(ct.raw)) {
                        return true;
                    }
                }
                return false;
            }
        }, new HashSet<Object>(), method);
    }

    private boolean hasAnnotation(ClassCache classCache, String key, Class<? extends Annotation> class1) {
        if (classCache.getAnnotations(key, StorableValidatorIgnoresMissingSetter.class).size() > 0) {
            return true;
        }
        return classCache.getAnnotations(null, StorableValidatorIgnoresMissingSetter.class).size() > 0;
    }

    public static String sourceMethodToString(Method method) {
        if (method == null) {
            return "Unknown Source";
        }
        return method.getDeclaringClass().getSimpleName() + "." + method.getName();
    }

    public static void canStoreIntern(Type gType, String path, CanStoreRules rules, HashSet<Object> dupeID, Method method) throws InvalidTypeException {
        if (!dupeID.add(gType)) {
            return;
        }
        if (rules.isTypeWithlisted(gType, method)) {
            return;
        }
        if (gType == Object.class) {
            if (rules.isTypeWithlisted(gType, method)) {
                return;
            }
            throw new InvalidTypeException(gType, "Cannot store Object: " + path + "/" + gType + " " + FlexiStorageInterfaceValidatorTest.sourceMethodToString(method));
        }
        if (gType instanceof Class) {
            Class type = (Class)gType;
            if (type == Void.TYPE) {
                throw new InvalidTypeException(gType, "Void is not accepted: " + path + "/" + gType + " " + FlexiStorageInterfaceValidatorTest.sourceMethodToString(method));
            }
            if (type.isPrimitive()) {
                return;
            }
            if (type == Boolean.class || type == Long.class || type == Integer.class || type == Byte.class || type == Double.class || type == Float.class || type == String.class || type == Short.class) {
                return;
            }
            if (type.isEnum()) {
                return;
            }
            if (type.isArray()) {
                Class<?> arrayType = type.getComponentType();
                FlexiStorageInterfaceValidatorTest.canStoreIntern(arrayType, path + "[" + arrayType + "]", rules, dupeID, method);
                return;
            }
            if (List.class.isAssignableFrom(type)) {
                return;
            }
            if (Map.class.isAssignableFrom(type)) {
                return;
            }
            if (Set.class.isAssignableFrom(type)) {
                return;
            }
            if (FlexiStorableInterface.class.isAssignableFrom(type) || Storable.class.isAssignableFrom(type)) {
                try {
                    if (!FlexiStorableInterface.class.isAssignableFrom(type)) {
                        type.getDeclaredConstructor(new Class[0]);
                    }
                    for (Class layer = type; layer != null && layer != Object.class; layer = layer.getSuperclass()) {
                        for (Method m : layer.getDeclaredMethods()) {
                            if (Modifier.isStatic(m.getModifiers())) continue;
                            if (m.getName().startsWith("get")) {
                                if (m.getParameterTypes().length > 0) {
                                    throw new InvalidTypeException(gType, "Getter " + path + "." + m + " has parameters. " + FlexiStorageInterfaceValidatorTest.sourceMethodToString(method));
                                }
                                FlexiStorageInterfaceValidatorTest.canStoreIntern(m.getGenericReturnType(), path + "->" + m.getGenericReturnType(), rules, dupeID, m);
                                continue;
                            }
                            if (m.getName().startsWith("set")) {
                                if (m.getParameterTypes().length != 1) {
                                    throw new InvalidTypeException(gType, "Setter " + path + "." + m + " has != 1 Parameters. " + FlexiStorageInterfaceValidatorTest.sourceMethodToString(method));
                                }
                                FlexiStorageInterfaceValidatorTest.canStoreIntern(m.getGenericParameterTypes()[0], path + "->" + m.getGenericParameterTypes()[0], rules, dupeID, m);
                                continue;
                            }
                            if (!m.getName().startsWith("is")) continue;
                            if (m.getParameterTypes().length > 0) {
                                throw new InvalidTypeException(gType, "Getter " + path + "." + m + " has parameters. " + FlexiStorageInterfaceValidatorTest.sourceMethodToString(method));
                            }
                            FlexiStorageInterfaceValidatorTest.canStoreIntern(m.getGenericReturnType(), path + "->" + m.getGenericReturnType(), rules, dupeID, m);
                        }
                    }
                    Type sc = type.getGenericSuperclass();
                    if (sc != null && rules.isFollowSuperClass(sc)) {
                        FlexiStorageInterfaceValidatorTest.canStoreIntern(sc, path + "<<<" + sc, rules, dupeID, method);
                    }
                    return;
                }
                catch (NoSuchMethodException e) {
                    throw new InvalidTypeException(gType, "FlexiStorableInterface " + path + " has no empty Constructor " + FlexiStorageInterfaceValidatorTest.sourceMethodToString(method));
                }
            }
        } else {
            if (gType instanceof ParameterizedType) {
                ParameterizedType ptype = (ParameterizedType)gType;
                Type raw = ptype.getRawType();
                FlexiStorageInterfaceValidatorTest.canStoreIntern(raw, path, rules, dupeID, method);
                for (Type t : ptype.getActualTypeArguments()) {
                    FlexiStorageInterfaceValidatorTest.canStoreIntern(t, path + "(" + t + ")", rules, dupeID, method);
                }
                return;
            }
            if (gType instanceof GenericArrayType) {
                GenericArrayType atype = (GenericArrayType)gType;
                Type t = atype.getGenericComponentType();
                FlexiStorageInterfaceValidatorTest.canStoreIntern(t, path + "[" + t + "]", rules, dupeID, method);
                return;
            }
            if (gType instanceof TypeVariable) {
                return;
            }
            throw new InvalidTypeException(gType, "Generic Type Structure not implemented: " + gType.getClass() + " in " + path + " " + FlexiStorageInterfaceValidatorTest.sourceMethodToString(method));
        }
        for (FlexiTypeMapper m : new FlexiJSonMapper().getTypeMapper()) {
            if (!(m instanceof DateMapper ? gType == Date.class : (m instanceof TimeSpanMapper ? gType == TimeSpan.class : m instanceof URLMapper && gType == URL.class))) continue;
            return;
        }
        ArrayList<FlexiTypeMapper> mappers = FlexiJSonMapper.getThreadMappers();
        if (mappers != null) {
            for (FlexiTypeMapper m : mappers) {
                if (!(m instanceof DateMapper ? gType == Date.class : (m instanceof TimeSpanMapper ? gType == TimeSpan.class : m instanceof URLMapper && gType == URL.class))) continue;
                return;
            }
        }
        throw new InvalidTypeException(gType, "Type " + path + "/" + gType + " is not supported. " + FlexiStorageInterfaceValidatorTest.sourceMethodToString(method));
    }

    public static interface CanStoreRules {
        public boolean isTypeWithlisted(Type var1, Method var2);

        public boolean isFollowSuperClass(Type var1);
    }
}

