/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.swing.exttable;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.plaf.UIResource;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import org.appwork.loggingv3.LogV3;
import org.appwork.sunwrapper.sun.swing.DefaultLookupWrapper;
import org.appwork.swing.exttable.ExtColumn;
import org.appwork.swing.exttable.ExtTableIcon;

public class ExtTableHeaderRenderer
extends DefaultTableCellRenderer
implements UIResource {
    private static final long serialVersionUID = 1L;
    private final ExtColumn<?> column;
    private boolean paintIcon;
    private Color focusForeground;
    private Color focusBackground;
    private Color foregroundC;
    private Color backgroundC;
    private Border focusBorder;
    private Border cellBorder;
    private final Icon lockedWidth;

    public Color getFocusForeground() {
        return this.focusForeground;
    }

    public void setFocusForeground(Color focusForeground) {
        this.focusForeground = focusForeground;
    }

    public Color getForegroundC() {
        return this.foregroundC;
    }

    public void setForegroundC(Color foregroundC) {
        this.foregroundC = foregroundC;
    }

    public Color getFocusBackground() {
        return this.focusBackground;
    }

    public void setFocusBackground(Color focusBackground) {
        this.focusBackground = focusBackground;
    }

    public Color getBackgroundC() {
        return this.backgroundC;
    }

    public void setBackgroundC(Color backgroundC) {
        this.backgroundC = backgroundC;
    }

    public Border getFocusBorder() {
        return this.focusBorder;
    }

    public void setFocusBorder(Border focusBorder) {
        this.focusBorder = focusBorder;
    }

    public Border getCellBorder() {
        return this.cellBorder;
    }

    public void setCellBorder(Border cellBorder) {
        this.cellBorder = cellBorder;
    }

    public ExtTableHeaderRenderer(ExtColumn<?> extColumn, JTableHeader header) {
        this.column = extColumn;
        this.lockedWidth = ExtTableIcon.TABLE_WIDTH_LOCKED.get(14);
        try {
            this.focusForeground = DefaultLookupWrapper.getColor(this, this.ui, "TableHeader.focusCellForeground");
            this.focusBackground = DefaultLookupWrapper.getColor(this, this.ui, "TableHeader.focusCellBackground");
        }
        catch (Throwable e) {
            LogV3.log(e);
        }
        if (this.focusForeground == null) {
            this.focusForeground = header.getForeground();
        }
        if (this.focusBackground == null) {
            this.focusBackground = header.getBackground();
        }
        this.foregroundC = header.getForeground();
        this.backgroundC = header.getBackground();
        try {
            this.focusBorder = DefaultLookupWrapper.getBorder(this, this.ui, "TableHeader.focusCellBorder");
            this.cellBorder = DefaultLookupWrapper.getBorder(this, this.ui, "TableHeader.cellBorder");
        }
        catch (Throwable e) {
            LogV3.log(e);
        }
        if (this.focusBorder == null) {
            this.focusBorder = BorderFactory.createEmptyBorder(0, 10, 0, 10);
        }
        if (this.cellBorder == null) {
            this.cellBorder = BorderFactory.createEmptyBorder(0, 10, 0, 10);
        }
        this.setFont(header.getFont());
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        this.setForeground(hasFocus ? this.focusForeground : this.foregroundC);
        this.setBackground(hasFocus ? this.focusBackground : this.backgroundC);
        this.paintIcon = this.column.isPaintSortIcon() && this.column.getModel().getSortColumn() != null && this.column.getModel().getSortColumn() == this.column;
        this.setText(value == null ? "" : value.toString());
        this.configureBorder(value, hasFocus, row, column);
        return this;
    }

    protected void configureBorder(Object value, boolean hasFocus, int row, int column) {
        this.setBorder(hasFocus ? this.getFocusBorder() : this.getCellBorder());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paintComponent(Graphics g) {
        boolean paintLock = false;
        if (!this.column.isResizable() && this.column.isPaintWidthLockIcon() && this.column.getModel().getTable().isColumnLockingFeatureEnabled()) {
            paintLock = true;
        }
        Border orgBorder = this.getBorder();
        int widthDif = this.column.getWidth() - this.getPreferredSize().width;
        boolean smallLockIcon = widthDif < this.lockedWidth.getIconWidth();
        Icon icon = this.column.getModel().getSortColumn() == null ? null : this.column.getModel().getSortColumn().getSortIcon();
        try {
            if (paintLock && !smallLockIcon) {
                this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(0, 0, 0, this.lockedWidth.getIconWidth()), orgBorder));
            }
            if (this.paintIcon && icon != null) {
                this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(0, icon.getIconWidth(), 0, 0), this.getBorder()));
            }
            super.paintComponent(g);
        }
        finally {
            this.setBorder(orgBorder);
        }
        try {
            if (this.paintIcon) {
                int left = 2;
                if (icon != null) {
                    Graphics2D g2 = (Graphics2D)g;
                    icon.paintIcon(this, g2, 2, (this.getHeight() - icon.getIconHeight()) / 2);
                }
            }
            if (paintLock) {
                Graphics2D g2 = (Graphics2D)g;
                if (smallLockIcon) {
                    g2.setColor(this.getBackground().darker());
                    int size = 6;
                    g2.fillPolygon(new int[]{this.getWidth(), this.getWidth() - 6, this.getWidth(), this.getWidth()}, new int[]{this.getHeight(), this.getHeight(), this.getHeight() - 6, this.getHeight()}, 4);
                } else {
                    this.lockedWidth.paintIcon(this, g2, this.getWidth() - this.lockedWidth.getIconWidth() - 2, (this.getHeight() - this.lockedWidth.getIconHeight()) / 2);
                }
            }
        }
        catch (RuntimeException e) {
            LogV3.log(e);
        }
    }
}

